/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.query.AwsEc2ProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ec2.internal.Ec2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ec2.model.AcceptAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.AcceptAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.AcceptCapacityReservationBillingOwnershipRequest;
import software.amazon.awssdk.services.ec2.model.AcceptCapacityReservationBillingOwnershipResponse;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.AcceptVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AllocateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;
import software.amazon.awssdk.services.ec2.model.AllocateHostsResponse;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.AllocateIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateCapacityReservationBillingOwnerRequest;
import software.amazon.awssdk.services.ec2.model.AssociateCapacityReservationBillingOwnerResponse;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.AssociateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.AssociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.AssociateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.AssociateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.AssociateRouteServerRequest;
import software.amazon.awssdk.services.ec2.model.AssociateRouteServerResponse;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSecurityGroupVpcRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSecurityGroupVpcResponse;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AssociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.AssociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.AttachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.BundleInstanceRequest;
import software.amazon.awssdk.services.ec2.model.BundleInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelBundleTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CancelCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelDeclarativePoliciesReportRequest;
import software.amazon.awssdk.services.ec2.model.CancelDeclarativePoliciesReportResponse;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest;
import software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionResponse;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CancelReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CopyImageRequest;
import software.amazon.awssdk.services.ec2.model.CopyImageResponse;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CopySnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationBySplittingRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationBySplittingResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.CreateCoipPoolRequest;
import software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateDelegateMacVolumeOwnershipTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateDelegateMacVolumeOwnershipTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateFleetRequest;
import software.amazon.awssdk.services.ec2.model.CreateFleetResponse;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateImageRequest;
import software.amazon.awssdk.services.ec2.model.CreateImageResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceConnectEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamExternalResourceVerificationTokenRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamExternalResourceVerificationTokenResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamResponse;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest;
import software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayVirtualInterfaceGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayVirtualInterfaceGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayVirtualInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.CreateLocalGatewayVirtualInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.CreateMacSystemIntegrityProtectionModificationTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateMacSystemIntegrityProtectionModificationTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.CreateManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.CreatePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateReplaceRootVolumeTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingResponse;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteServerEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteServerEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteServerPeerRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteServerPeerResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteServerRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteServerResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.CreateSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.CreateSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest;
import software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumeResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcBlockPublicAccessExclusionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcBlockPublicAccessExclusionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteClientVpnRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCoipPoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceConnectEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamExternalResourceVerificationTokenRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamExternalResourceVerificationTokenResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamResponse;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayVirtualInterfaceGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayVirtualInterfaceGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayVirtualInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayVirtualInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.DeleteManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkAclResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfacePermissionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeletePlacementGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolRequest;
import software.amazon.awssdk.services.ec2.model.DeletePublicIpv4PoolResponse;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DeleteQueuedReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteServerEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteServerEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteServerPeerRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteServerPeerResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteServerRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteServerResponse;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetCidrReservationResponse;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectPeerResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcBlockPublicAccessExclusionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcBlockPublicAccessExclusionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteResponse;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.DeprovisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterImageRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterImageResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeByoipCidrsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnAuthorizationRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDeclarativePoliciesReportsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDeclarativePoliciesReportsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeEgressOnlyInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceConnectEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceImageMetadataResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTopologyResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamExternalResourceVerificationTokensRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamExternalResourceVerificationTokensResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveriesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplatesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeLockedSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLockedSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMacHostsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMacModificationTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMacModificationTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsPathsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeOutpostLagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeOutpostLagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePlacementGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsResponse;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServerPeersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupVpcAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeServiceLinkVirtualInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeServiceLinkVirtualInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotDatafeedSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFilterRulesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFilterRulesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorFiltersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorTargetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectPeersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayConnectsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTableAnnouncementsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTrunkInterfaceAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessExclusionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessExclusionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcBlockPublicAccessOptionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcResponse;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DetachVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.DetachVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.DetachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.DetachVolumeResponse;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DetachVpnGatewayResponse;
import software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.DisableAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.DisableAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.DisableAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.DisableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageDeregistrationProtectionRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageDeregistrationProtectionResponse;
import software.amazon.awssdk.services.ec2.model.DisableImageRequest;
import software.amazon.awssdk.services.ec2.model.DisableImageResponse;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.DisableRouteServerPropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableRouteServerPropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableSnapshotBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.DisableSnapshotBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.DisableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateCapacityReservationBillingOwnerRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateCapacityReservationBillingOwnerResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteServerRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteServerResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSecurityGroupVpcRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSecurityGroupVpcResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateSubnetCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayMulticastDomainResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateTrunkInterfaceResponse;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateVpcCidrBlockResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest;
import software.amazon.awssdk.services.ec2.model.EnableAddressTransferResponse;
import software.amazon.awssdk.services.ec2.model.EnableAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.EnableAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionRequest;
import software.amazon.awssdk.services.ec2.model.EnableAwsNetworkPerformanceMetricSubscriptionResponse;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.EnableEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastLaunchResponse;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest;
import software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageDeregistrationProtectionRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageDeregistrationProtectionResponse;
import software.amazon.awssdk.services.ec2.model.EnableImageRequest;
import software.amazon.awssdk.services.ec2.model.EnableImageResponse;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.ec2.model.EnableIpamOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.ec2.model.EnableReachabilityAnalyzerOrganizationSharingRequest;
import software.amazon.awssdk.services.ec2.model.EnableReachabilityAnalyzerOrganizationSharingResponse;
import software.amazon.awssdk.services.ec2.model.EnableRouteServerPropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableRouteServerPropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableSerialConsoleAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableSnapshotBlockPublicAccessRequest;
import software.amazon.awssdk.services.ec2.model.EnableSnapshotBlockPublicAccessResponse;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableTransitGatewayRouteTablePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationRequest;
import software.amazon.awssdk.services.ec2.model.EnableVgwRoutePropagationResponse;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkDnsSupportResponse;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest;
import software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ExportImageRequest;
import software.amazon.awssdk.services.ec2.model.ExportImageResponse;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.ExportVerifiedAccessInstanceClientConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ExportVerifiedAccessInstanceClientConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.GetAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.GetAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataRequest;
import software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest;
import software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse;
import software.amazon.awssdk.services.ec2.model.GetDeclarativePoliciesReportSummaryRequest;
import software.amazon.awssdk.services.ec2.model.GetDeclarativePoliciesReportSummaryResponse;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.GetDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultRequest;
import software.amazon.awssdk.services.ec2.model.GetEbsEncryptionByDefaultResponse;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateRequest;
import software.amazon.awssdk.services.ec2.model.GetFlowLogsIntegrationTemplateResponse;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest;
import software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewResponse;
import software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateRequest;
import software.amazon.awssdk.services.ec2.model.GetImageBlockPublicAccessStateResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceMetadataDefaultsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceMetadataDefaultsResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceTpmEkPubRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTpmEkPubResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse;
import software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataRequest;
import software.amazon.awssdk.services.ec2.model.GetInstanceUefiDataResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredAccountsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredPublicAddressesRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredPublicAddressesResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamDiscoveredResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataRequest;
import software.amazon.awssdk.services.ec2.model.GetLaunchTemplateDataResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentRequest;
import software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeContentResponse;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteRequest;
import software.amazon.awssdk.services.ec2.model.GetReservedInstancesExchangeQuoteResponse;
import software.amazon.awssdk.services.ec2.model.GetRouteServerAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetRouteServerAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetRouteServerPropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetRouteServerPropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetRouteServerRoutingDatabaseRequest;
import software.amazon.awssdk.services.ec2.model.GetRouteServerRoutingDatabaseResponse;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcRequest;
import software.amazon.awssdk.services.ec2.model.GetSecurityGroupsForVpcResponse;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusRequest;
import software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse;
import software.amazon.awssdk.services.ec2.model.GetSnapshotBlockPublicAccessStateRequest;
import software.amazon.awssdk.services.ec2.model.GetSnapshotBlockPublicAccessStateResponse;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresRequest;
import software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest;
import software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableEntriesResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTableAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayRouteTablePropagationsResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointTargetsRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointTargetsResponse;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest;
import software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse;
import software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusRequest;
import software.amazon.awssdk.services.ec2.model.GetVpnTunnelReplacementStatusResponse;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListRequest;
import software.amazon.awssdk.services.ec2.model.ImportClientVpnClientCertificateRevocationListResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageRequest;
import software.amazon.awssdk.services.ec2.model.ImportImageResponse;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ImportInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ImportVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ImportVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListSnapshotsInRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.LockSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.LockSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyAvailabilityZoneGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFleetResponse;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyHostsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyHostsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatResponse;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCapacityReservationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCpuOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCpuOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventStartTimeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceEventWindowResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMaintenanceOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataDefaultsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataDefaultsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceMetadataOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceNetworkPerformanceOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceNetworkPerformanceOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamPoolResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceDiscoveryRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResourceDiscoveryResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamResponse;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ModifyLocalGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest;
import software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyReservedInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyRouteServerRequest;
import software.amazon.awssdk.services.ec2.model.ModifyRouteServerResponse;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesRequest;
import software.amazon.awssdk.services.ec2.model.ModifySecurityGroupRulesResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestResponse;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifySubnetAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorFilterRuleResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointPolicyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVolumeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessExclusionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessExclusionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcBlockPublicAccessOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServiceConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePayerResponsibilityResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcPeeringConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateResponse;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsResponse;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcRequest;
import software.amazon.awssdk.services.ec2.model.MoveAddressToVpcResponse;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamRequest;
import software.amazon.awssdk.services.ec2.model.MoveByoipCidrToIpamResponse;
import software.amazon.awssdk.services.ec2.model.MoveCapacityReservationInstancesRequest;
import software.amazon.awssdk.services.ec2.model.MoveCapacityReservationInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamByoasnRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamByoasnResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionIpamPoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrRequest;
import software.amazon.awssdk.services.ec2.model.ProvisionPublicIpv4PoolCidrResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockExtensionRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockExtensionResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseCapacityBlockResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingResponse;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RebootInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterImageRequest;
import software.amazon.awssdk.services.ec2.model.RegisterImageResponse;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest;
import software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse;
import software.amazon.awssdk.services.ec2.model.RejectCapacityReservationBillingOwnershipRequest;
import software.amazon.awssdk.services.ec2.model.RejectCapacityReservationBillingOwnershipResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentRequest;
import software.amazon.awssdk.services.ec2.model.RejectTransitGatewayVpcAttachmentResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcEndpointConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.ec2.model.RejectVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsResponse;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationRequest;
import software.amazon.awssdk.services.ec2.model.ReleaseIpamPoolAllocationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceImageCriteriaInAllowedImagesSettingsRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceImageCriteriaInAllowedImagesSettingsResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclEntryResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteResponse;
import software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelRequest;
import software.amazon.awssdk.services.ec2.model.ReplaceVpnTunnelResponse;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetAddressAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdRequest;
import software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetFpgaImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetInstanceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetNetworkInterfaceAttributeResponse;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeResponse;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest;
import software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicResponse;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreImageFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionRequest;
import software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest;
import software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierResponse;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeClientVpnIngressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressResponse;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchLocalGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayMulticastGroupsResponse;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest;
import software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptResponse;
import software.amazon.awssdk.services.ec2.model.StartDeclarativePoliciesReportRequest;
import software.amazon.awssdk.services.ec2.model.StartDeclarativePoliciesReportResponse;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisRequest;
import software.amazon.awssdk.services.ec2.model.StartNetworkInsightsAnalysisResponse;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest;
import software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesResponse;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.TerminateClientVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateIpAddressesResponse;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressRequest;
import software.amazon.awssdk.services.ec2.model.UnassignPrivateNatGatewayAddressResponse;
import software.amazon.awssdk.services.ec2.model.UnlockSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.UnlockSnapshotResponse;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesRequest;
import software.amazon.awssdk.services.ec2.model.UnmonitorInstancesResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest;
import software.amazon.awssdk.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.ec2.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.ec2.transform.AcceptAddressTransferRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptCapacityReservationBillingOwnershipRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayMulticastDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AcceptVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AllocateIpamPoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssignPrivateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateCapacityReservationBillingOwnerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateEnclaveCertificateIamRoleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateRouteServerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateSecurityGroupVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateTrunkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AssociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AttachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeClientVpnIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.AuthorizeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.BundleInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelBundleTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelCapacityReservationFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelConversionTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelDeclarativePoliciesReportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelImageLaunchPermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelImportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CancelSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ConfirmProductInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopyImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCapacityReservationBySplittingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCapacityReservationFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCarrierGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateClientVpnRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCoipPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDefaultVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDelegateMacVolumeOwnershipTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceConnectEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInstanceExportTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamExternalResourceVerificationTokenRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateIpamScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLaunchTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayRouteTableVpcAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayVirtualInterfaceGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateLocalGatewayVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateMacSystemIntegrityProtectionModificationTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateManagedPrefixListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInsightsAccessScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInsightsPathRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreatePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreatePublicIpv4PoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateReplaceRootVolumeTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateReservedInstancesListingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRestoreImageTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteServerEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteServerPeerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteServerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateStoreImageTaskRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSubnetCidrReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorFilterRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTrafficMirrorTargetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayConnectPeerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayConnectRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayPrefixListReferenceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteTableAnnouncementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcBlockPublicAccessExclusionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointConnectionNotificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcEndpointServiceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.CreateVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCarrierGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteClientVpnRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCoipPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteCustomerGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteEgressOnlyInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteFpgaImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInstanceConnectEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamExternalResourceVerificationTokenRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteIpamScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLaunchTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayRouteTableVpcAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayVirtualInterfaceGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteLocalGatewayVirtualInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteManagedPrefixListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNatGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkAclRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsAccessScopeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsAccessScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInsightsPathRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfacePermissionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeletePlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeletePublicIpv4PoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteQueuedReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteServerEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteServerPeerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteServerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSubnetCidrReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteSubnetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorFilterRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTrafficMirrorTargetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayConnectPeerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayConnectRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayPrefixListReferenceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteTableAnnouncementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcBlockPublicAccessExclusionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointConnectionNotificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointServiceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnConnectionRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeleteVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionIpamPoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeprovisionPublicIpv4PoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterTransitGatewayMulticastGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DeregisterTransitGatewayMulticastGroupSourcesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressTransfersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressesAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAggregateIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAvailabilityZonesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeAwsNetworkPerformanceMetricSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeBundleTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityBlockExtensionHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityBlockExtensionOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityBlockOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityReservationBillingRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityReservationFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCapacityReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCarrierGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClassicLinkInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnAuthorizationRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeClientVpnTargetNetworksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCoipPoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeConversionTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeCustomerGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeDeclarativePoliciesReportsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeDhcpOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeEgressOnlyInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeElasticGpusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFastLaunchImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFleetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFlowLogsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeFpgaImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIamInstanceProfileAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeImportSnapshotTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceConnectEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceCreditSpecificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceEventWindowsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceImageMetadataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTopologyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTypeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeInternetGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamExternalResourceVerificationTokensRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamPoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamResourceDiscoveriesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamResourceDiscoveryAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamScopesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpamsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeIpv6PoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLaunchTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLaunchTemplatesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTableVpcAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayVirtualInterfaceGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewayVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLocalGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeLockedSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMacHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMacModificationTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeManagedPrefixListsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeMovingAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNatGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkAclsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsAccessScopeAnalysesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsAccessScopesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsAnalysesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInsightsPathsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeOutpostLagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePlacementGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrefixListsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePrincipalIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribePublicIpv4PoolsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReplaceRootVolumeTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesListingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesOfferingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteServerEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteServerPeersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteServersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstanceAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupReferencesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupVpcAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeServiceLinkVirtualInterfacesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotTierStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotDatafeedSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotFleetRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotInstanceRequestsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSpotPriceHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeStaleSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeStoreImageTasksRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeSubnetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorFilterRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorFiltersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorSessionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrafficMirrorTargetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayConnectPeersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayConnectsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayMulticastDomainsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayPeeringAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayPolicyTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayRouteTableAnnouncementsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayRouteTablesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewayVpcAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTransitGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeTrunkInterfaceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessInstanceLoggingConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVerifiedAccessTrustProvidersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumeStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesModificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVolumesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcBlockPublicAccessExclusionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcBlockPublicAccessOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointConnectionNotificationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServiceConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointServicesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpcsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DescribeVpnGatewaysRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachClassicLinkVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachInternetGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DetachVpnGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableAddressTransferRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableAllowedImagesSettingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableAwsNetworkPerformanceMetricSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableFastLaunchRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableImageBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableImageDeprecationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableImageDeregistrationProtectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableIpamOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableRouteServerPropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableSerialConsoleAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableSnapshotBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableTransitGatewayRouteTablePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateCapacityReservationBillingOwnerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateClientVpnTargetNetworkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateEnclaveCertificateIamRoleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIamInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateRouteServerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateSecurityGroupVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateSubnetCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayMulticastDomainRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayPolicyTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTransitGatewayRouteTableRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateTrunkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.DisassociateVpcCidrBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableAddressTransferRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableAllowedImagesSettingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableAwsNetworkPerformanceMetricSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableFastLaunchRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableFastSnapshotRestoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableImageBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableImageDeprecationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableImageDeregistrationProtectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableIpamOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableReachabilityAnalyzerOrganizationSharingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableRouteServerPropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableSerialConsoleAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableSnapshotBlockPublicAccessRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableTransitGatewayRouteTablePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVgwRoutePropagationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVolumeIoRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkDnsSupportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.EnableVpcClassicLinkRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportClientVpnClientCertificateRevocationListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportClientVpnClientConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportTransitGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ExportVerifiedAccessInstanceClientConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAllowedImagesSettingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAssociatedEnclaveCertificateIamRolesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAssociatedIpv6PoolCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetAwsNetworkPerformanceDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetCapacityReservationUsageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetCoipPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleOutputRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetConsoleScreenshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetDeclarativePoliciesReportSummaryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetDefaultCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetEbsEncryptionByDefaultRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetFlowLogsIntegrationTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetGroupsForCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetHostReservationPurchasePreviewRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetImageBlockPublicAccessStateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetInstanceMetadataDefaultsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetInstanceTpmEkPubRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetInstanceTypesFromInstanceRequirementsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetInstanceUefiDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamAddressHistoryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamDiscoveredAccountsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamDiscoveredPublicAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamDiscoveredResourceCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamPoolAllocationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamPoolCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetIpamResourceCidrsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetLaunchTemplateDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetManagedPrefixListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetManagedPrefixListEntriesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetNetworkInsightsAccessScopeAnalysisFindingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetNetworkInsightsAccessScopeContentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetPasswordDataRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetReservedInstancesExchangeQuoteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetRouteServerAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetRouteServerPropagationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetRouteServerRoutingDatabaseRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSecurityGroupsForVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSerialConsoleAccessStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSnapshotBlockPublicAccessStateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSpotPlacementScoresRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetSubnetCidrReservationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayAttachmentPropagationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayMulticastDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayPolicyTableAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayPolicyTableEntriesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayPrefixListReferencesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayRouteTableAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetTransitGatewayRouteTablePropagationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVerifiedAccessEndpointPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVerifiedAccessEndpointTargetsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVerifiedAccessGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVpnConnectionDeviceSampleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVpnConnectionDeviceTypesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.GetVpnTunnelReplacementStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportClientVpnClientCertificateRevocationListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ListImagesInRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ListSnapshotsInRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.LockSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyAddressAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyAvailabilityZoneGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyCapacityReservationFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyClientVpnEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyDefaultCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIdentityIdFormatRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceCapacityReservationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceCpuOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceCreditSpecificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceEventStartTimeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceEventWindowRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceMaintenanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceMetadataDefaultsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceMetadataOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstanceNetworkPerformanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyInstancePlacementRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamPoolRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamResourceCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamResourceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyIpamScopeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyLaunchTemplateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyLocalGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyManagedPrefixListRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyPrivateDnsNameOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyReservedInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyRouteServerRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySecurityGroupRulesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySnapshotTierRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySpotFleetRequestRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifySubnetAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorFilterNetworkServicesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorFilterRuleRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTrafficMirrorSessionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTransitGatewayPrefixListReferenceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTransitGatewayRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessEndpointPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessGroupRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessInstanceLoggingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessInstanceRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVerifiedAccessTrustProviderRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVolumeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcBlockPublicAccessExclusionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcBlockPublicAccessOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointConnectionNotificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServiceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServicePayerResponsibilityRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcEndpointServicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcPeeringConnectionOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpcTenancyRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnConnectionOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnTunnelCertificateRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ModifyVpnTunnelOptionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveAddressToVpcRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveByoipCidrToIpamRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.MoveCapacityReservationInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionIpamByoasnRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionIpamPoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionPublicIpv4PoolCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseCapacityBlockExtensionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseCapacityBlockRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseHostReservationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseReservedInstancesOfferingRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.PurchaseScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RebootInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterImageRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterInstanceEventNotificationAttributesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterTransitGatewayMulticastGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RegisterTransitGatewayMulticastGroupSourcesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectCapacityReservationBillingOwnershipRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayMulticastDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayPeeringAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectTransitGatewayVpcAttachmentRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RejectVpcPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseHostsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReleaseIpamPoolAllocationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceIamInstanceProfileAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceImageCriteriaInAllowedImagesSettingsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceNetworkAclEntryRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceRouteTableAssociationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceTransitGatewayRouteRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReplaceVpnTunnelRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ReportInstanceStatusRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotFleetRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RequestSpotInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetAddressAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetEbsDefaultKmsKeyIdRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetFpgaImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetImageAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetNetworkInterfaceAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.ResetSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreAddressToClassicRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreImageFromRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreManagedPrefixListVersionRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreSnapshotFromRecycleBinRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RestoreSnapshotTierRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeClientVpnIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RevokeSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.RunScheduledInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchLocalGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchTransitGatewayMulticastGroupsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SearchTransitGatewayRoutesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.SendDiagnosticInterruptRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartDeclarativePoliciesReportRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartNetworkInsightsAccessScopeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartNetworkInsightsAnalysisRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StartVpcEndpointServicePrivateDnsVerificationRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.StopInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateClientVpnConnectionsRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.TerminateInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignIpv6AddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignPrivateIpAddressesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnassignPrivateNatGatewayAddressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnlockSnapshotRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UnmonitorInstancesRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.UpdateSecurityGroupRuleDescriptionsIngressRequestMarshaller;
import software.amazon.awssdk.services.ec2.transform.WithdrawByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.ec2.waiters.Ec2Waiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link Ec2Client}.
 *
 * @see Ec2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultEc2Client implements Ec2Client {
    private static final Logger log = Logger.loggerFor(DefaultEc2Client.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.EC2).build();

    private final SyncClientHandler clientHandler;

    private final AwsEc2ProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEc2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Accepts an Elastic IP address transfer. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept"
     * >Accept a transferred Elastic IP address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param acceptAddressTransferRequest
     * @return Result of the AcceptAddressTransfer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptAddressTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AcceptAddressTransferResponse acceptAddressTransfer(AcceptAddressTransferRequest acceptAddressTransferRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AcceptAddressTransferResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptAddressTransferResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptAddressTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptAddressTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptAddressTransfer");

            return clientHandler.execute(new ClientExecutionParams<AcceptAddressTransferRequest, AcceptAddressTransferResponse>()
                    .withOperationName("AcceptAddressTransfer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(acceptAddressTransferRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AcceptAddressTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a request to assign billing of the available capacity of a shared Capacity Reservation to your account.
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html">
     * Billing assignment for shared Amazon EC2 Capacity Reservations</a>.
     * </p>
     *
     * @param acceptCapacityReservationBillingOwnershipRequest
     * @return Result of the AcceptCapacityReservationBillingOwnership operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptCapacityReservationBillingOwnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptCapacityReservationBillingOwnership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptCapacityReservationBillingOwnershipResponse acceptCapacityReservationBillingOwnership(
            AcceptCapacityReservationBillingOwnershipRequest acceptCapacityReservationBillingOwnershipRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AcceptCapacityReservationBillingOwnershipResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptCapacityReservationBillingOwnershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                acceptCapacityReservationBillingOwnershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptCapacityReservationBillingOwnershipRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptCapacityReservationBillingOwnership");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptCapacityReservationBillingOwnershipRequest, AcceptCapacityReservationBillingOwnershipResponse>()
                            .withOperationName("AcceptCapacityReservationBillingOwnership")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(acceptCapacityReservationBillingOwnershipRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptCapacityReservationBillingOwnershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     *
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @return Result of the AcceptReservedInstancesExchangeQuote operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptReservedInstancesExchangeQuote
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptReservedInstancesExchangeQuoteResponse acceptReservedInstancesExchangeQuote(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AcceptReservedInstancesExchangeQuoteResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptReservedInstancesExchangeQuoteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptReservedInstancesExchangeQuoteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptReservedInstancesExchangeQuoteRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptReservedInstancesExchangeQuote");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptReservedInstancesExchangeQuoteRequest, AcceptReservedInstancesExchangeQuoteResponse>()
                            .withOperationName("AcceptReservedInstancesExchangeQuote").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptReservedInstancesExchangeQuoteRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptReservedInstancesExchangeQuoteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     *
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     * @return Result of the AcceptTransitGatewayMulticastDomainAssociations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptTransitGatewayMulticastDomainAssociationsResponse acceptTransitGatewayMulticastDomainAssociations(
            AcceptTransitGatewayMulticastDomainAssociationsRequest acceptTransitGatewayMulticastDomainAssociationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AcceptTransitGatewayMulticastDomainAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptTransitGatewayMulticastDomainAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                acceptTransitGatewayMulticastDomainAssociationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptTransitGatewayMulticastDomainAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptTransitGatewayMulticastDomainAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayMulticastDomainAssociationsRequest, AcceptTransitGatewayMulticastDomainAssociationsResponse>()
                            .withOperationName("AcceptTransitGatewayMulticastDomainAssociations")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(acceptTransitGatewayMulticastDomainAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptTransitGatewayMulticastDomainAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     *
     * @param acceptTransitGatewayPeeringAttachmentRequest
     * @return Result of the AcceptTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptTransitGatewayPeeringAttachmentResponse acceptTransitGatewayPeeringAttachment(
            AcceptTransitGatewayPeeringAttachmentRequest acceptTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AcceptTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptTransitGatewayPeeringAttachmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptTransitGatewayPeeringAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptTransitGatewayPeeringAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptTransitGatewayPeeringAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayPeeringAttachmentRequest, AcceptTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("AcceptTransitGatewayPeeringAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(acceptTransitGatewayPeeringAttachmentRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     *
     * @param acceptTransitGatewayVpcAttachmentRequest
     * @return Result of the AcceptTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptTransitGatewayVpcAttachmentResponse acceptTransitGatewayVpcAttachment(
            AcceptTransitGatewayVpcAttachmentRequest acceptTransitGatewayVpcAttachmentRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AcceptTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptTransitGatewayVpcAttachmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptTransitGatewayVpcAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptTransitGatewayVpcAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptTransitGatewayVpcAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptTransitGatewayVpcAttachmentRequest, AcceptTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("AcceptTransitGatewayVpcAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptTransitGatewayVpcAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accepts connection requests to your VPC endpoint service.
     * </p>
     *
     * @param acceptVpcEndpointConnectionsRequest
     * @return Result of the AcceptVpcEndpointConnections operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptVpcEndpointConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptVpcEndpointConnectionsResponse acceptVpcEndpointConnections(
            AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AcceptVpcEndpointConnectionsResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptVpcEndpointConnectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptVpcEndpointConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptVpcEndpointConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptVpcEndpointConnections");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptVpcEndpointConnectionsRequest, AcceptVpcEndpointConnectionsResponse>()
                            .withOperationName("AcceptVpcEndpointConnections").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptVpcEndpointConnectionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptVpcEndpointConnectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     *
     * @param acceptVpcPeeringConnectionRequest
     * @return Result of the AcceptVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AcceptVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptVpcPeeringConnectionResponse acceptVpcPeeringConnection(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<AcceptVpcPeeringConnectionResponse> responseHandler = protocolFactory
                .createResponseHandler(AcceptVpcPeeringConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptVpcPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptVpcPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptVpcPeeringConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResponse>()
                            .withOperationName("AcceptVpcPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptVpcPeeringConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptVpcPeeringConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return Result of the AdvertiseByoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AdvertiseByoipCidrResponse advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AdvertiseByoipCidrResponse> responseHandler = protocolFactory
                .createResponseHandler(AdvertiseByoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(advertiseByoipCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, advertiseByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdvertiseByoipCidr");

            return clientHandler.execute(new ClientExecutionParams<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse>()
                    .withOperationName("AdvertiseByoipCidr").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(advertiseByoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdvertiseByoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address
     * that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic
     * IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     *
     * @param allocateAddressRequest
     * @return Result of the AllocateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AllocateAddressResponse allocateAddress(AllocateAddressRequest allocateAddressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AllocateAddressResponse> responseHandler = protocolFactory
                .createResponseHandler(AllocateAddressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateAddress");

            return clientHandler.execute(new ClientExecutionParams<AllocateAddressRequest, AllocateAddressResponse>()
                    .withOperationName("AllocateAddress").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(allocateAddressRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AllocateAddressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     *
     * @param allocateHostsRequest
     * @return Result of the AllocateHosts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateHosts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AllocateHostsResponse allocateHosts(AllocateHostsRequest allocateHostsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AllocateHostsResponse> responseHandler = protocolFactory
                .createResponseHandler(AllocateHostsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateHostsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateHostsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateHosts");

            return clientHandler.execute(new ClientExecutionParams<AllocateHostsRequest, AllocateHostsResponse>()
                    .withOperationName("AllocateHosts").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(allocateHostsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AllocateHostsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon
     * Web Services Region where this IPAM pool is available for allocations.
     * </p>
     * <p>
     * In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action creates an allocation with strong consistency. The returned CIDR will not overlap with any other
     * allocations from the same pool.
     * </p>
     * </note>
     *
     * @param allocateIpamPoolCidrRequest
     * @return Result of the AllocateIpamPoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AllocateIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AllocateIpamPoolCidrResponse allocateIpamPoolCidr(AllocateIpamPoolCidrRequest allocateIpamPoolCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AllocateIpamPoolCidrResponse> responseHandler = protocolFactory
                .createResponseHandler(AllocateIpamPoolCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(allocateIpamPoolCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateIpamPoolCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateIpamPoolCidr");

            return clientHandler.execute(new ClientExecutionParams<AllocateIpamPoolCidrRequest, AllocateIpamPoolCidrResponse>()
                    .withOperationName("AllocateIpamPoolCidr").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(allocateIpamPoolCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AllocateIpamPoolCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     *
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     * @return Result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ApplySecurityGroupsToClientVpnTargetNetworkResponse applySecurityGroupsToClientVpnTargetNetwork(
            ApplySecurityGroupsToClientVpnTargetNetworkRequest applySecurityGroupsToClientVpnTargetNetworkRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<ApplySecurityGroupsToClientVpnTargetNetworkResponse> responseHandler = protocolFactory
                .createResponseHandler(ApplySecurityGroupsToClientVpnTargetNetworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                applySecurityGroupsToClientVpnTargetNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                applySecurityGroupsToClientVpnTargetNetworkRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplySecurityGroupsToClientVpnTargetNetwork");

            return clientHandler
                    .execute(new ClientExecutionParams<ApplySecurityGroupsToClientVpnTargetNetworkRequest, ApplySecurityGroupsToClientVpnTargetNetworkResponse>()
                            .withOperationName("ApplySecurityGroupsToClientVpnTargetNetwork")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(applySecurityGroupsToClientVpnTargetNetworkRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ApplySecurityGroupsToClientVpnTargetNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns the specified IPv6 addresses to the specified network interface. You can specify specific IPv6 addresses,
     * or you can specify the number of IPv6 addresses to be automatically assigned from the subnet's IPv6 CIDR block
     * range. You can assign as many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and
     * the limit varies by instance type.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network
     * interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param assignIpv6AddressesRequest
     * @return Result of the AssignIpv6Addresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignIpv6Addresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssignIpv6AddressesResponse assignIpv6Addresses(AssignIpv6AddressesRequest assignIpv6AddressesRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssignIpv6AddressesResponse> responseHandler = protocolFactory
                .createResponseHandler(AssignIpv6AddressesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignIpv6AddressesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assignIpv6AddressesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignIpv6Addresses");

            return clientHandler.execute(new ClientExecutionParams<AssignIpv6AddressesRequest, AssignIpv6AddressesResponse>()
                    .withOperationName("AssignIpv6Addresses").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(assignIpv6AddressesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssignIpv6AddressesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns the specified secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify specific secondary IP addresses, or you can specify the number of secondary IP addresses to be
     * automatically assigned from the subnet's CIDR block range. The number of secondary IP addresses that you can
     * assign to an instance varies by instance type. For more information about Elastic IP addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to network
     * interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @return Result of the AssignPrivateIpAddresses operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignPrivateIpAddresses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssignPrivateIpAddressesResponse assignPrivateIpAddresses(
            AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<AssignPrivateIpAddressesResponse> responseHandler = protocolFactory
                .createResponseHandler(AssignPrivateIpAddressesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignPrivateIpAddressesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assignPrivateIpAddressesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignPrivateIpAddresses");

            return clientHandler
                    .execute(new ClientExecutionParams<AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResponse>()
                            .withOperationName("AssignPrivateIpAddresses").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(assignPrivateIpAddressesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssignPrivateIpAddressesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns private IPv4 addresses to a private NAT gateway. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Work with NAT gateways</a>
     * in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param assignPrivateNatGatewayAddressRequest
     * @return Result of the AssignPrivateNatGatewayAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssignPrivateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssignPrivateNatGatewayAddressResponse assignPrivateNatGatewayAddress(
            AssignPrivateNatGatewayAddressRequest assignPrivateNatGatewayAddressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssignPrivateNatGatewayAddressResponse> responseHandler = protocolFactory
                .createResponseHandler(AssignPrivateNatGatewayAddressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignPrivateNatGatewayAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                assignPrivateNatGatewayAddressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignPrivateNatGatewayAddress");

            return clientHandler
                    .execute(new ClientExecutionParams<AssignPrivateNatGatewayAddressRequest, AssignPrivateNatGatewayAddressResponse>()
                            .withOperationName("AssignPrivateNatGatewayAddress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(assignPrivateNatGatewayAddressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssignPrivateNatGatewayAddressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * If the Elastic IP address is already associated with a different instance, it is disassociated from that instance
     * and associated with the specified instance. If you associate an Elastic IP address with an instance that has an
     * existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to
     * your account.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     *
     * @param associateAddressRequest
     * @return Result of the AssociateAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateAddressResponse associateAddress(AssociateAddressRequest associateAddressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateAddressResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateAddressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAddress");

            return clientHandler.execute(new ClientExecutionParams<AssociateAddressRequest, AssociateAddressResponse>()
                    .withOperationName("AssociateAddress").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateAddressRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateAddressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates a request to assign billing of the unused capacity of a shared Capacity Reservation to a consumer
     * account that is consolidated under the same Amazon Web Services organizations payer account. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html">Billing
     * assignment for shared Amazon EC2 Capacity Reservations</a>.
     * </p>
     *
     * @param associateCapacityReservationBillingOwnerRequest
     * @return Result of the AssociateCapacityReservationBillingOwner operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateCapacityReservationBillingOwner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateCapacityReservationBillingOwner"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateCapacityReservationBillingOwnerResponse associateCapacityReservationBillingOwner(
            AssociateCapacityReservationBillingOwnerRequest associateCapacityReservationBillingOwnerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateCapacityReservationBillingOwnerResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateCapacityReservationBillingOwnerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                associateCapacityReservationBillingOwnerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateCapacityReservationBillingOwnerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateCapacityReservationBillingOwner");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateCapacityReservationBillingOwnerRequest, AssociateCapacityReservationBillingOwnerResponse>()
                            .withOperationName("AssociateCapacityReservationBillingOwner").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(associateCapacityReservationBillingOwnerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateCapacityReservationBillingOwnerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     *
     * @param associateClientVpnTargetNetworkRequest
     * @return Result of the AssociateClientVpnTargetNetwork operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateClientVpnTargetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateClientVpnTargetNetworkResponse associateClientVpnTargetNetwork(
            AssociateClientVpnTargetNetworkRequest associateClientVpnTargetNetworkRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateClientVpnTargetNetworkResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateClientVpnTargetNetworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateClientVpnTargetNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateClientVpnTargetNetworkRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateClientVpnTargetNetwork");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateClientVpnTargetNetworkRequest, AssociateClientVpnTargetNetworkResponse>()
                            .withOperationName("AssociateClientVpnTargetNetwork").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateClientVpnTargetNetworkRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateClientVpnTargetNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * option sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateDhcpOptionsRequest
     * @return Result of the AssociateDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateDhcpOptionsResponse associateDhcpOptions(AssociateDhcpOptionsRequest associateDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateDhcpOptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateDhcpOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateDhcpOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateDhcpOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateDhcpOptions");

            return clientHandler.execute(new ClientExecutionParams<AssociateDhcpOptionsRequest, AssociateDhcpOptionsResponse>()
                    .withOperationName("AssociateDhcpOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateDhcpOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateDhcpOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     *
     * @param associateEnclaveCertificateIamRoleRequest
     * @return Result of the AssociateEnclaveCertificateIamRole operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateEnclaveCertificateIamRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateEnclaveCertificateIamRoleResponse associateEnclaveCertificateIamRole(
            AssociateEnclaveCertificateIamRoleRequest associateEnclaveCertificateIamRoleRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateEnclaveCertificateIamRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateEnclaveCertificateIamRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateEnclaveCertificateIamRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateEnclaveCertificateIamRoleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateEnclaveCertificateIamRole");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateEnclaveCertificateIamRoleRequest, AssociateEnclaveCertificateIamRoleResponse>()
                            .withOperationName("AssociateEnclaveCertificateIamRole").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateEnclaveCertificateIamRoleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateEnclaveCertificateIamRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     *
     * @param associateIamInstanceProfileRequest
     * @return Result of the AssociateIamInstanceProfile operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIamInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateIamInstanceProfileResponse associateIamInstanceProfile(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateIamInstanceProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateIamInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIamInstanceProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIamInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIamInstanceProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateIamInstanceProfileRequest, AssociateIamInstanceProfileResponse>()
                            .withOperationName("AssociateIamInstanceProfile").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateIamInstanceProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateIamInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param associateInstanceEventWindowRequest
     * @return Result of the AssociateInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateInstanceEventWindowResponse associateInstanceEventWindow(
            AssociateInstanceEventWindowRequest associateInstanceEventWindowRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateInstanceEventWindowResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateInstanceEventWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateInstanceEventWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateInstanceEventWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateInstanceEventWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateInstanceEventWindowRequest, AssociateInstanceEventWindowResponse>()
                            .withOperationName("AssociateInstanceEventWindow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateInstanceEventWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateInstanceEventWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services
     * Region. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * <p>
     * After the association succeeds, the ASN is eligible for advertisement. You can view the association with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html">DescribeByoipCidrs</a>.
     * You can advertise the CIDR with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html">AdvertiseByoipCidr</a>.
     * </p>
     *
     * @param associateIpamByoasnRequest
     * @return Result of the AssociateIpamByoasn operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIpamByoasn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateIpamByoasnResponse associateIpamByoasn(AssociateIpamByoasnRequest associateIpamByoasnRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateIpamByoasnResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateIpamByoasnResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIpamByoasnRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIpamByoasnRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIpamByoasn");

            return clientHandler.execute(new ClientExecutionParams<AssociateIpamByoasnRequest, AssociateIpamByoasnResponse>()
                    .withOperationName("AssociateIpamByoasn").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateIpamByoasnRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateIpamByoasnRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that
     * enables IPAM to manage and monitor resources that belong to the owning account.
     * </p>
     *
     * @param associateIpamResourceDiscoveryRequest
     * @return Result of the AssociateIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateIpamResourceDiscoveryResponse associateIpamResourceDiscovery(
            AssociateIpamResourceDiscoveryRequest associateIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateIpamResourceDiscoveryResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateIpamResourceDiscoveryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIpamResourceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateIpamResourceDiscoveryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIpamResourceDiscovery");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateIpamResourceDiscoveryRequest, AssociateIpamResourceDiscoveryResponse>()
                            .withOperationName("AssociateIpamResourceDiscovery").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateIpamResourceDiscoveryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateIpamResourceDiscoveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Work
     * with NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * By default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can increase the limit by
     * requesting a quota adjustment. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips">Elastic IP address
     * quotas</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you associate an EIP or secondary EIPs with a public NAT gateway, the network border group of the EIPs must
     * match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not the
     * same, the EIP will fail to associate. You can see the network border group for the subnet's AZ by viewing the
     * details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the
     * EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html">Allocate an Elastic IP address</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     *
     * @param associateNatGatewayAddressRequest
     * @return Result of the AssociateNatGatewayAddress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateNatGatewayAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateNatGatewayAddressResponse associateNatGatewayAddress(
            AssociateNatGatewayAddressRequest associateNatGatewayAddressRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<AssociateNatGatewayAddressResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateNatGatewayAddressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateNatGatewayAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateNatGatewayAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateNatGatewayAddress");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateNatGatewayAddressRequest, AssociateNatGatewayAddressResponse>()
                            .withOperationName("AssociateNatGatewayAddress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateNatGatewayAddressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateNatGatewayAddressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a route server with a VPC to enable dynamic route updates.
     * </p>
     * <p>
     * A route server association is the connection established between a route server and a VPC.
     * </p>
     * <p>
     * For more information see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html">Dynamic routing in your
     * VPC with VPC Route Server</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateRouteServerRequest
     * @return Result of the AssociateRouteServer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateRouteServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateRouteServerResponse associateRouteServer(AssociateRouteServerRequest associateRouteServerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateRouteServerResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateRouteServerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateRouteServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateRouteServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateRouteServer");

            return clientHandler.execute(new ClientExecutionParams<AssociateRouteServerRequest, AssociateRouteServerResponse>()
                    .withOperationName("AssociateRouteServer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateRouteServerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateRouteServerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateRouteTableRequest
     * @return Result of the AssociateRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateRouteTableResponse associateRouteTable(AssociateRouteTableRequest associateRouteTableRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateRouteTable");

            return clientHandler.execute(new ClientExecutionParams<AssociateRouteTableRequest, AssociateRouteTableResponse>()
                    .withOperationName("AssociateRouteTable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateRouteTableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a security group with another VPC in the same Region. This enables you to use the same security group
     * with network interfaces and instances in the specified VPC.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The VPC you want to associate the security group with must be in the same Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can associate the security group with another VPC if your account owns the VPC or if the VPC was shared with
     * you.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must own the security group and the VPC that it was created in.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use this feature with default security groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use this feature with the default VPC.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param associateSecurityGroupVpcRequest
     * @return Result of the AssociateSecurityGroupVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateSecurityGroupVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSecurityGroupVpc" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateSecurityGroupVpcResponse associateSecurityGroupVpc(
            AssociateSecurityGroupVpcRequest associateSecurityGroupVpcRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<AssociateSecurityGroupVpcResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateSecurityGroupVpcResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSecurityGroupVpcRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSecurityGroupVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSecurityGroupVpc");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateSecurityGroupVpcRequest, AssociateSecurityGroupVpcResponse>()
                            .withOperationName("AssociateSecurityGroupVpc").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateSecurityGroupVpcRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateSecurityGroupVpcRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.
     * </p>
     *
     * @param associateSubnetCidrBlockRequest
     * @return Result of the AssociateSubnetCidrBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateSubnetCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateSubnetCidrBlockResponse associateSubnetCidrBlock(
            AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<AssociateSubnetCidrBlockResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateSubnetCidrBlockResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSubnetCidrBlockRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSubnetCidrBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSubnetCidrBlock");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateSubnetCidrBlockRequest, AssociateSubnetCidrBlockResponse>()
                            .withOperationName("AssociateSubnetCidrBlock").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateSubnetCidrBlockRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateSubnetCidrBlockRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     *
     * @param associateTransitGatewayMulticastDomainRequest
     * @return Result of the AssociateTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTransitGatewayMulticastDomainResponse associateTransitGatewayMulticastDomain(
            AssociateTransitGatewayMulticastDomainRequest associateTransitGatewayMulticastDomainRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateTransitGatewayMulticastDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTransitGatewayMulticastDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTransitGatewayMulticastDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTransitGatewayMulticastDomain");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayMulticastDomainRequest, AssociateTransitGatewayMulticastDomainResponse>()
                            .withOperationName("AssociateTransitGatewayMulticastDomain").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(associateTransitGatewayMulticastDomainRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTransitGatewayMulticastDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified transit gateway attachment with a transit gateway policy table.
     * </p>
     *
     * @param associateTransitGatewayPolicyTableRequest
     * @return Result of the AssociateTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTransitGatewayPolicyTableResponse associateTransitGatewayPolicyTable(
            AssociateTransitGatewayPolicyTableRequest associateTransitGatewayPolicyTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateTransitGatewayPolicyTableResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateTransitGatewayPolicyTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTransitGatewayPolicyTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTransitGatewayPolicyTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTransitGatewayPolicyTable");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayPolicyTableRequest, AssociateTransitGatewayPolicyTableResponse>()
                            .withOperationName("AssociateTransitGatewayPolicyTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateTransitGatewayPolicyTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTransitGatewayPolicyTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     *
     * @param associateTransitGatewayRouteTableRequest
     * @return Result of the AssociateTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTransitGatewayRouteTableResponse associateTransitGatewayRouteTable(
            AssociateTransitGatewayRouteTableRequest associateTransitGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateTransitGatewayRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTransitGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTransitGatewayRouteTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTransitGatewayRouteTable");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTransitGatewayRouteTableRequest, AssociateTransitGatewayRouteTableResponse>()
                            .withOperationName("AssociateTransitGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateTransitGatewayRouteTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTransitGatewayRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >CreateNetworkInterface</a> command and set the interface type to <code>trunk</code>. You must also create a
     * network interface for each branch network interface that you want to associate with the trunk network interface.
     * </p>
     *
     * @param associateTrunkInterfaceRequest
     * @return Result of the AssociateTrunkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateTrunkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateTrunkInterfaceResponse associateTrunkInterface(AssociateTrunkInterfaceRequest associateTrunkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateTrunkInterfaceResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateTrunkInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTrunkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrunkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrunkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTrunkInterfaceRequest, AssociateTrunkInterfaceResponse>()
                            .withOperationName("AssociateTrunkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateTrunkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTrunkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param associateVpcCidrBlockRequest
     * @return Result of the AssociateVpcCidrBlock operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AssociateVpcCidrBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateVpcCidrBlockResponse associateVpcCidrBlock(AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AssociateVpcCidrBlockResponse> responseHandler = protocolFactory
                .createResponseHandler(AssociateVpcCidrBlockResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateVpcCidrBlockRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateVpcCidrBlockRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateVpcCidrBlock");

            return clientHandler.execute(new ClientExecutionParams<AssociateVpcCidrBlockRequest, AssociateVpcCidrBlockResponse>()
                    .withOperationName("AssociateVpcCidrBlock").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateVpcCidrBlockRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateVpcCidrBlockRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     *
     * @param attachClassicLinkVpcRequest
     * @return Result of the AttachClassicLinkVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachClassicLinkVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachClassicLinkVpcResponse attachClassicLinkVpc(AttachClassicLinkVpcRequest attachClassicLinkVpcRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AttachClassicLinkVpcResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachClassicLinkVpcResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachClassicLinkVpcRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachClassicLinkVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachClassicLinkVpc");

            return clientHandler.execute(new ClientExecutionParams<AttachClassicLinkVpcRequest, AttachClassicLinkVpcResponse>()
                    .withOperationName("AttachClassicLinkVpc").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachClassicLinkVpcRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachClassicLinkVpcRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param attachInternetGatewayRequest
     * @return Result of the AttachInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachInternetGatewayResponse attachInternetGateway(AttachInternetGatewayRequest attachInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AttachInternetGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachInternetGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachInternetGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachInternetGateway");

            return clientHandler.execute(new ClientExecutionParams<AttachInternetGatewayRequest, AttachInternetGatewayResponse>()
                    .withOperationName("AttachInternetGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachInternetGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachInternetGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     *
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @return Result of the AttachNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AttachNetworkInterfaceResponse attachNetworkInterface(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<AttachNetworkInterfaceResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachNetworkInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<AttachNetworkInterfaceRequest, AttachNetworkInterfaceResponse>()
                            .withOperationName("AttachNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(attachNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AttachNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     *
     * @param attachVerifiedAccessTrustProviderRequest
     * @return Result of the AttachVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AttachVerifiedAccessTrustProviderResponse attachVerifiedAccessTrustProvider(
            AttachVerifiedAccessTrustProviderRequest attachVerifiedAccessTrustProviderRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AttachVerifiedAccessTrustProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachVerifiedAccessTrustProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachVerifiedAccessTrustProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachVerifiedAccessTrustProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachVerifiedAccessTrustProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<AttachVerifiedAccessTrustProviderRequest, AttachVerifiedAccessTrustProviderResponse>()
                            .withOperationName("AttachVerifiedAccessTrustProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(attachVerifiedAccessTrustProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AttachVerifiedAccessTrustProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html">Make an EBS volume available for
     * use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html">Attach an Amazon EBS volume to
     * an instance</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param attachVolumeRequest
     * @return Result of the AttachVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachVolumeResponse attachVolume(AttachVolumeRequest attachVolumeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AttachVolumeResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachVolumeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachVolume");

            return clientHandler.execute(new ClientExecutionParams<AttachVolumeRequest, AttachVolumeResponse>()
                    .withOperationName("AttachVolume").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachVolumeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachVolumeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches an available virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at
     * a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @return Result of the AttachVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AttachVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachVpnGatewayResponse attachVpnGateway(AttachVpnGatewayRequest attachVpnGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AttachVpnGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachVpnGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachVpnGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachVpnGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachVpnGateway");

            return clientHandler.execute(new ClientExecutionParams<AttachVpnGatewayRequest, AttachVpnGatewayResponse>()
                    .withOperationName("AttachVpnGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachVpnGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachVpnGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     *
     * @param authorizeClientVpnIngressRequest
     * @return Result of the AuthorizeClientVpnIngress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeClientVpnIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AuthorizeClientVpnIngressResponse authorizeClientVpnIngress(
            AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<AuthorizeClientVpnIngressResponse> responseHandler = protocolFactory
                .createResponseHandler(AuthorizeClientVpnIngressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeClientVpnIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeClientVpnIngressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeClientVpnIngress");

            return clientHandler
                    .execute(new ClientExecutionParams<AuthorizeClientVpnIngressRequest, AuthorizeClientVpnIngressResponse>()
                            .withOperationName("AuthorizeClientVpnIngress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(authorizeClientVpnIngressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AuthorizeClientVpnIngressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified outbound (egress) rules to a security group.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address
     * ranges specified by a prefix list, or the instances that are associated with a source security group. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security
     * group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP type
     * and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param authorizeSecurityGroupEgressRequest
     * @return Result of the AuthorizeSecurityGroupEgress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeSecurityGroupEgress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AuthorizeSecurityGroupEgressResponse authorizeSecurityGroupEgress(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AuthorizeSecurityGroupEgressResponse> responseHandler = protocolFactory
                .createResponseHandler(AuthorizeSecurityGroupEgressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeSecurityGroupEgressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeSecurityGroupEgressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeSecurityGroupEgress");

            return clientHandler
                    .execute(new ClientExecutionParams<AuthorizeSecurityGroupEgressRequest, AuthorizeSecurityGroupEgressResponse>()
                            .withOperationName("AuthorizeSecurityGroupEgress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(authorizeSecurityGroupEgressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AuthorizeSecurityGroupEgressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP
     * address ranges that are specified by a prefix list, or the instances that are associated with a destination
     * security group. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6
     * type and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param authorizeSecurityGroupIngressRequest
     * @return Result of the AuthorizeSecurityGroupIngress operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.AuthorizeSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AuthorizeSecurityGroupIngressResponse authorizeSecurityGroupIngress(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<AuthorizeSecurityGroupIngressResponse> responseHandler = protocolFactory
                .createResponseHandler(AuthorizeSecurityGroupIngressResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                authorizeSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeSecurityGroupIngress");

            return clientHandler
                    .execute(new ClientExecutionParams<AuthorizeSecurityGroupIngressRequest, AuthorizeSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(authorizeSecurityGroupIngressRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AuthorizeSecurityGroupIngressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     *
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @return Result of the BundleInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.BundleInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BundleInstanceResponse bundleInstance(BundleInstanceRequest bundleInstanceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<BundleInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(BundleInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(bundleInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, bundleInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BundleInstance");

            return clientHandler.execute(new ClientExecutionParams<BundleInstanceRequest, BundleInstanceResponse>()
                    .withOperationName("BundleInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(bundleInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BundleInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     *
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @return Result of the CancelBundleTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelBundleTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelBundleTaskResponse cancelBundleTask(CancelBundleTaskRequest cancelBundleTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelBundleTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelBundleTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelBundleTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelBundleTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelBundleTask");

            return clientHandler.execute(new ClientExecutionParams<CancelBundleTaskRequest, CancelBundleTaskResponse>()
                    .withOperationName("CancelBundleTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelBundleTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelBundleTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * You can cancel a Capacity Reservation that is in the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assessing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>active</code> and there is no commitment duration or the commitment duration has elapsed. You can't cancel
     * a future-dated Capacity Reservation during the commitment duration.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You can't modify or cancel a Capacity Block. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-blocks.html">Capacity Blocks for ML</a>.
     * </p>
     * </note>
     * <p>
     * If a future-dated Capacity Reservation enters the <code>delayed</code> state, the commitment duration is waived,
     * and you can cancel it as soon as it enters the <code>active</code> state.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     *
     * @param cancelCapacityReservationRequest
     * @return Result of the CancelCapacityReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelCapacityReservationResponse cancelCapacityReservation(
            CancelCapacityReservationRequest cancelCapacityReservationRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CancelCapacityReservationResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelCapacityReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelCapacityReservationRequest, CancelCapacityReservationResponse>()
                            .withOperationName("CancelCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelCapacityReservationFleetsRequest
     * @return Result of the CancelCapacityReservationFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelCapacityReservationFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelCapacityReservationFleetsResponse cancelCapacityReservationFleets(
            CancelCapacityReservationFleetsRequest cancelCapacityReservationFleetsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelCapacityReservationFleetsResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelCapacityReservationFleetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCapacityReservationFleetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelCapacityReservationFleetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCapacityReservationFleets");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelCapacityReservationFleetsRequest, CancelCapacityReservationFleetsResponse>()
                            .withOperationName("CancelCapacityReservationFleets").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelCapacityReservationFleetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelCapacityReservationFleetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     *
     * @param cancelConversionTaskRequest
     * @return Result of the CancelConversionTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelConversionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelConversionTaskResponse cancelConversionTask(CancelConversionTaskRequest cancelConversionTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelConversionTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelConversionTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelConversionTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelConversionTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelConversionTask");

            return clientHandler.execute(new ClientExecutionParams<CancelConversionTaskRequest, CancelConversionTaskResponse>()
                    .withOperationName("CancelConversionTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelConversionTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelConversionTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the generation of an account status report.
     * </p>
     * <p>
     * You can only cancel a report while it has the <code>running</code> status. Reports with other statuses (
     * <code>complete</code>, <code>cancelled</code>, or <code>error</code>) can't be canceled.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative_status-report.html"
     * >Generating the account status report for declarative policies</a> in the <i>Amazon Web Services Organizations
     * User Guide</i>.
     * </p>
     *
     * @param cancelDeclarativePoliciesReportRequest
     * @return Result of the CancelDeclarativePoliciesReport operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelDeclarativePoliciesReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelDeclarativePoliciesReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelDeclarativePoliciesReportResponse cancelDeclarativePoliciesReport(
            CancelDeclarativePoliciesReportRequest cancelDeclarativePoliciesReportRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelDeclarativePoliciesReportResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelDeclarativePoliciesReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelDeclarativePoliciesReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelDeclarativePoliciesReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelDeclarativePoliciesReport");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelDeclarativePoliciesReportRequest, CancelDeclarativePoliciesReportResponse>()
                            .withOperationName("CancelDeclarativePoliciesReport").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelDeclarativePoliciesReportRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelDeclarativePoliciesReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return Result of the CancelExportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelExportTaskResponse cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelExportTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelExportTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelExportTask");

            return clientHandler.execute(new ClientExecutionParams<CancelExportTaskRequest, CancelExportTaskResponse>()
                    .withOperationName("CancelExportTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelExportTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelExportTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html"> Cancel having an
     * AMI shared with your Amazon Web Services account</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param cancelImageLaunchPermissionRequest
     * @return Result of the CancelImageLaunchPermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelImageLaunchPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelImageLaunchPermissionResponse cancelImageLaunchPermission(
            CancelImageLaunchPermissionRequest cancelImageLaunchPermissionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelImageLaunchPermissionResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelImageLaunchPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelImageLaunchPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImageLaunchPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImageLaunchPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelImageLaunchPermissionRequest, CancelImageLaunchPermissionResponse>()
                            .withOperationName("CancelImageLaunchPermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelImageLaunchPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelImageLaunchPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     *
     * @param cancelImportTaskRequest
     * @return Result of the CancelImportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelImportTaskResponse cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelImportTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelImportTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelImportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelImportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelImportTask");

            return clientHandler.execute(new ClientExecutionParams<CancelImportTaskRequest, CancelImportTaskResponse>()
                    .withOperationName("CancelImportTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelImportTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelImportTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @return Result of the CancelReservedInstancesListing operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelReservedInstancesListingResponse cancelReservedInstancesListing(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelReservedInstancesListingResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelReservedInstancesListingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelReservedInstancesListingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelReservedInstancesListingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelReservedInstancesListing");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelReservedInstancesListingRequest, CancelReservedInstancesListingResponse>()
                            .withOperationName("CancelReservedInstancesListing").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelReservedInstancesListingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelReservedInstancesListingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a canceled Spot Fleet request should terminate its instances. If you choose to
     * terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise,
     * the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until
     * they are interrupted or you terminate them manually.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 100 fleets in a single request. If you exceed the specified number, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     *
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @return Result of the CancelSpotFleetRequests operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelSpotFleetRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelSpotFleetRequestsResponse cancelSpotFleetRequests(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CancelSpotFleetRequestsResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelSpotFleetRequestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSpotFleetRequestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSpotFleetRequestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSpotFleetRequests");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResponse>()
                            .withOperationName("CancelSpotFleetRequests").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelSpotFleetRequestsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelSpotFleetRequestsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important>
     *
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @return Result of the CancelSpotInstanceRequests operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CancelSpotInstanceRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelSpotInstanceRequestsResponse cancelSpotInstanceRequests(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CancelSpotInstanceRequestsResponse> responseHandler = protocolFactory
                .createResponseHandler(CancelSpotInstanceRequestsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSpotInstanceRequestsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSpotInstanceRequestsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSpotInstanceRequests");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResponse>()
                            .withOperationName("CancelSpotInstanceRequests").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelSpotInstanceRequestsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelSpotInstanceRequestsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     *
     * @param confirmProductInstanceRequest
     * @return Result of the ConfirmProductInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.ConfirmProductInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ConfirmProductInstanceResponse confirmProductInstance(ConfirmProductInstanceRequest confirmProductInstanceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<ConfirmProductInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(ConfirmProductInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmProductInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmProductInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmProductInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<ConfirmProductInstanceRequest, ConfirmProductInstanceResponse>()
                            .withOperationName("ConfirmProductInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(confirmProductInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ConfirmProductInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     *
     * @param copyFpgaImageRequest
     * @return Result of the CopyFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopyFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyFpgaImageResponse copyFpgaImage(CopyFpgaImageRequest copyFpgaImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CopyFpgaImageResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyFpgaImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyFpgaImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyFpgaImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyFpgaImage");

            return clientHandler.execute(new ClientExecutionParams<CopyFpgaImageRequest, CopyFpgaImageResponse>()
                    .withOperationName("CopyFpgaImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copyFpgaImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyFpgaImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates an AMI copy operation. You can copy an AMI from one Region to another, or from a Region to an Outpost.
     * You can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To
     * copy an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * When you copy an AMI from one Region to another, the destination Region is the current Region.
     * </p>
     * <p>
     * When you copy an AMI from a Region to an Outpost, specify the ARN of the Outpost as the destination. Backing
     * snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region or the
     * key that you specify. Outposts do not support unencrypted snapshots.
     * </p>
     * <p>
     * For information about the prerequisites when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copy an AMI</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     *
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @return Result of the CopyImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopyImageResponse copyImage(CopyImageRequest copyImageRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CopyImageResponse> responseHandler = protocolFactory
                .createResponseHandler(CopyImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyImage");

            return clientHandler.execute(new ClientExecutionParams<CopyImageRequest, CopyImageResponse>()
                    .withOperationName("CopyImage").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(copyImageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default KMS key; however, you can specify a different KMS key. To copy an encrypted
     * snapshot that has been shared from another account, you must have permissions for the KMS key used to encrypt the
     * snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami">Amazon EBS local snapshots on
     * Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html">Copy
     * an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param copySnapshotRequest
     * @return Result of the CopySnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CopySnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CopySnapshotResponse copySnapshot(CopySnapshotRequest copySnapshotRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CopySnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copySnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copySnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopySnapshot");

            return clientHandler.execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                    .withOperationName("CopySnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copySnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes. Capacity Reservations enable you to reserve
     * capacity for your Amazon EC2 instances in a specific Availability Zone for any duration.
     * </p>
     * <p>
     * You can create a Capacity Reservation at any time, and you can choose when it starts. You can create a Capacity
     * Reservation for immediate use or you can request a Capacity Reservation for a future date.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html"> Reserve compute
     * capacity with On-Demand Capacity Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon EC2 does not have sufficient capacity. In this case, try again at a later time, try in a different
     * Availability Zone, or request a smaller Capacity Reservation. If your workload is flexible across instance types
     * and sizes, try with different instance attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * The requested quantity exceeds your On-Demand Instance quota. In this case, increase your On-Demand Instance
     * quota for the requested instance type and try again. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html"> Amazon EC2 Service
     * Quotas</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     *
     * @param createCapacityReservationRequest
     * @return Result of the CreateCapacityReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateCapacityReservationResponse createCapacityReservation(
            CreateCapacityReservationRequest createCapacityReservationRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateCapacityReservationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCapacityReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationRequest, CreateCapacityReservationResponse>()
                            .withOperationName("CreateCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a new Capacity Reservation by splitting the capacity of the source Capacity Reservation. The new Capacity
     * Reservation will have the same attributes as the source Capacity Reservation except for tags. The source Capacity
     * Reservation must be <code>active</code> and owned by your Amazon Web Services account.
     * </p>
     *
     * @param createCapacityReservationBySplittingRequest
     * @return Result of the CreateCapacityReservationBySplitting operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservationBySplitting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationBySplitting"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCapacityReservationBySplittingResponse createCapacityReservationBySplitting(
            CreateCapacityReservationBySplittingRequest createCapacityReservationBySplittingRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateCapacityReservationBySplittingResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCapacityReservationBySplittingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCapacityReservationBySplittingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCapacityReservationBySplittingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservationBySplitting");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationBySplittingRequest, CreateCapacityReservationBySplittingResponse>()
                            .withOperationName("CreateCapacityReservationBySplitting").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCapacityReservationBySplittingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCapacityReservationBySplittingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createCapacityReservationFleetRequest
     * @return Result of the CreateCapacityReservationFleet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCapacityReservationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCapacityReservationFleetResponse createCapacityReservationFleet(
            CreateCapacityReservationFleetRequest createCapacityReservationFleetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateCapacityReservationFleetResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCapacityReservationFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCapacityReservationFleetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCapacityReservationFleetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCapacityReservationFleet");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCapacityReservationFleetRequest, CreateCapacityReservationFleetResponse>()
                            .withOperationName("CreateCapacityReservationFleet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCapacityReservationFleetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCapacityReservationFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     *
     * @param createCarrierGatewayRequest
     * @return Result of the CreateCarrierGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCarrierGatewayResponse createCarrierGateway(CreateCarrierGatewayRequest createCarrierGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateCarrierGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCarrierGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCarrierGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCarrierGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCarrierGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateCarrierGatewayRequest, CreateCarrierGatewayResponse>()
                    .withOperationName("CreateCarrierGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCarrierGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCarrierGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     *
     * @param createClientVpnEndpointRequest
     * @return Result of the CreateClientVpnEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateClientVpnEndpointResponse createClientVpnEndpoint(CreateClientVpnEndpointRequest createClientVpnEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateClientVpnEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateClientVpnEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClientVpnEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClientVpnEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClientVpnEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateClientVpnEndpointRequest, CreateClientVpnEndpointResponse>()
                            .withOperationName("CreateClientVpnEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createClientVpnEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateClientVpnEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     *
     * @param createClientVpnRouteRequest
     * @return Result of the CreateClientVpnRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateClientVpnRouteResponse createClientVpnRoute(CreateClientVpnRouteRequest createClientVpnRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateClientVpnRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateClientVpnRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClientVpnRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClientVpnRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClientVpnRoute");

            return clientHandler.execute(new ClientExecutionParams<CreateClientVpnRouteRequest, CreateClientVpnRouteResponse>()
                    .withOperationName("CreateClientVpnRoute").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createClientVpnRouteRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateClientVpnRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a range of customer-owned IP addresses.
     * </p>
     *
     * @param createCoipCidrRequest
     * @return Result of the CreateCoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCoipCidrResponse createCoipCidr(CreateCoipCidrRequest createCoipCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateCoipCidrResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCoipCidr");

            return clientHandler.execute(new ClientExecutionParams<CreateCoipCidrRequest, CreateCoipCidrResponse>()
                    .withOperationName("CreateCoipCidr").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a pool of customer-owned IP (CoIP) addresses.
     * </p>
     *
     * @param createCoipPoolRequest
     * @return Result of the CreateCoipPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCoipPoolResponse createCoipPool(CreateCoipPoolRequest createCoipPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateCoipPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCoipPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCoipPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCoipPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCoipPool");

            return clientHandler.execute(new ClientExecutionParams<CreateCoipPoolRequest, CreateCoipPoolResponse>()
                    .withOperationName("CreateCoipPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCoipPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCoipPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is
     * the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     *
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @return Result of the CreateCustomerGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCustomerGatewayResponse createCustomerGateway(CreateCustomerGatewayRequest createCustomerGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateCustomerGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateCustomerGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomerGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomerGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomerGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateCustomerGatewayRequest, CreateCustomerGatewayResponse>()
                    .withOperationName("CreateCustomerGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCustomerGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCustomerGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/work-with-default-vpc.html#create-default-subnet">Create a
     * default subnet</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createDefaultSubnetRequest
     * @return Result of the CreateDefaultSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDefaultSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDefaultSubnetResponse createDefaultSubnet(CreateDefaultSubnetRequest createDefaultSubnetRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateDefaultSubnetResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDefaultSubnetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDefaultSubnetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDefaultSubnetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDefaultSubnet");

            return clientHandler.execute(new ClientExecutionParams<CreateDefaultSubnetRequest, CreateDefaultSubnetResponse>()
                    .withOperationName("CreateDefaultSubnet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDefaultSubnetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDefaultSubnetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC
     * User Guide</i>. You cannot specify the components of the default VPC yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     *
     * @param createDefaultVpcRequest
     * @return Result of the CreateDefaultVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDefaultVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDefaultVpcResponse createDefaultVpc(CreateDefaultVpcRequest createDefaultVpcRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateDefaultVpcResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDefaultVpcResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDefaultVpcRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDefaultVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDefaultVpc");

            return clientHandler.execute(new ClientExecutionParams<CreateDefaultVpcRequest, CreateDefaultVpcResponse>()
                    .withOperationName("CreateDefaultVpc").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDefaultVpcRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDefaultVpcRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delegates ownership of the Amazon EBS root volume for an Apple silicon Mac instance to an administrative user.
     * </p>
     *
     * @param createDelegateMacVolumeOwnershipTaskRequest
     * @return Result of the CreateDelegateMacVolumeOwnershipTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDelegateMacVolumeOwnershipTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDelegateMacVolumeOwnershipTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDelegateMacVolumeOwnershipTaskResponse createDelegateMacVolumeOwnershipTask(
            CreateDelegateMacVolumeOwnershipTaskRequest createDelegateMacVolumeOwnershipTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateDelegateMacVolumeOwnershipTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDelegateMacVolumeOwnershipTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDelegateMacVolumeOwnershipTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDelegateMacVolumeOwnershipTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDelegateMacVolumeOwnershipTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDelegateMacVolumeOwnershipTaskRequest, CreateDelegateMacVolumeOwnershipTaskResponse>()
                            .withOperationName("CreateDelegateMacVolumeOwnershipTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDelegateMacVolumeOwnershipTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDelegateMacVolumeOwnershipTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you
     * associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP
     * options.
     * </p>
     * <p>
     * The following are the individual DHCP options you can specify. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in any other Region, specify
     * <code>region.compute.internal</code>. Otherwise, specify a custom domain name. This value is used to complete
     * unqualified DNS hostnames.
     * </p>
     * <p>
     * Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux
     * operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP option
     * set is associated with a VPC that has instances running operating systems that treat the value as a single
     * domain, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four DNS servers, or AmazonProvidedDNS. To specify
     * multiple domain name servers in a single parameter, separate the IP addresses using commas. To have your
     * instances receive custom DNS hostnames as specified in <code>domain-name</code>, you must specify a custom DNS
     * server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to eight Network Time Protocol (NTP) servers (four IPv4
     * addresses and four IPv6 addresses).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2.
     * Broadcast and multicast are not supported. For more information about NetBIOS node types, see <a
     * href="https://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-address-preferred-lease-time</code> - A value (in seconds, minutes, hours, or years) for how
     * frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values
     * are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time
     * is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid
     * frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     * </p>
     * </li>
     * </ul>
     *
     * @param createDhcpOptionsRequest
     * @return Result of the CreateDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDhcpOptionsResponse createDhcpOptions(CreateDhcpOptionsRequest createDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateDhcpOptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateDhcpOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDhcpOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDhcpOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDhcpOptions");

            return clientHandler.execute(new ClientExecutionParams<CreateDhcpOptionsRequest, CreateDhcpOptionsResponse>()
                    .withOperationName("CreateDhcpOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDhcpOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDhcpOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     *
     * @param createEgressOnlyInternetGatewayRequest
     * @return Result of the CreateEgressOnlyInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEgressOnlyInternetGatewayResponse createEgressOnlyInternetGateway(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateEgressOnlyInternetGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateEgressOnlyInternetGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEgressOnlyInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createEgressOnlyInternetGatewayRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEgressOnlyInternetGateway");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEgressOnlyInternetGatewayRequest, CreateEgressOnlyInternetGatewayResponse>()
                            .withOperationName("CreateEgressOnlyInternetGateway").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createEgressOnlyInternetGatewayRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEgressOnlyInternetGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances.
     * Instances are launched immediately if there is available capacity.
     * </p>
     * <p>
     * A single EC2 Fleet can include multiple launch specifications that vary by instance type, AMI, Availability Zone,
     * or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateFleetResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateFleetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleet");

            return clientHandler.execute(new ClientExecutionParams<CreateFleetRequest, CreateFleetResponse>()
                    .withOperationName("CreateFleet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createFleetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFleetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-log-records.html">Flow log records</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createFlowLogsRequest
     * @return Result of the CreateFlowLogs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFlowLogsResponse createFlowLogs(CreateFlowLogsRequest createFlowLogsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateFlowLogsResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateFlowLogsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFlowLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowLogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlowLogs");

            return clientHandler.execute(new ClientExecutionParams<CreateFlowLogsRequest, CreateFlowLogsResponse>()
                    .withOperationName("CreateFlowLogs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFlowLogsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFlowLogsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     *
     * @param createFpgaImageRequest
     * @return Result of the CreateFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFpgaImageResponse createFpgaImage(CreateFpgaImageRequest createFpgaImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateFpgaImageResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateFpgaImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFpgaImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFpgaImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFpgaImage");

            return clientHandler.execute(new ClientExecutionParams<CreateFpgaImageRequest, CreateFpgaImageResponse>()
                    .withOperationName("CreateFpgaImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFpgaImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFpgaImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Create an Amazon EBS-backed
     * Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createImageRequest
     * @return Result of the CreateImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateImageResponse createImage(CreateImageRequest createImageRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateImageResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImage");

            return clientHandler.execute(new ClientExecutionParams<CreateImageRequest, CreateImageResponse>()
                    .withOperationName("CreateImage").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createImageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an EC2 Instance Connect Endpoint.
     * </p>
     * <p>
     * An EC2 Instance Connect Endpoint allows you to connect to an instance, without requiring the instance to have a
     * public IPv4 address. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html"
     * >Connect to your instances without requiring a public IPv4 address using EC2 Instance Connect Endpoint</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createInstanceConnectEndpointRequest
     * @return Result of the CreateInstanceConnectEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInstanceConnectEndpointResponse createInstanceConnectEndpoint(
            CreateInstanceConnectEndpointRequest createInstanceConnectEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateInstanceConnectEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateInstanceConnectEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceConnectEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createInstanceConnectEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceConnectEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceConnectEndpointRequest, CreateInstanceConnectEndpointResponse>()
                            .withOperationName("CreateInstanceConnectEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createInstanceConnectEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateInstanceConnectEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createInstanceEventWindowRequest
     * @return Result of the CreateInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateInstanceEventWindowResponse createInstanceEventWindow(
            CreateInstanceEventWindowRequest createInstanceEventWindowRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateInstanceEventWindowResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateInstanceEventWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceEventWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceEventWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceEventWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceEventWindowRequest, CreateInstanceEventWindowResponse>()
                            .withOperationName("CreateInstanceEventWindow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createInstanceEventWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateInstanceEventWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the prerequisites for your Amazon S3 bucket, supported operating systems, image formats,
     * and known limitations for the types of instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     *
     * @param createInstanceExportTaskRequest
     * @return Result of the CreateInstanceExportTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInstanceExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateInstanceExportTaskResponse createInstanceExportTask(
            CreateInstanceExportTaskRequest createInstanceExportTaskRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateInstanceExportTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateInstanceExportTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceExportTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceExportTaskRequest, CreateInstanceExportTaskResponse>()
                            .withOperationName("CreateInstanceExportTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createInstanceExportTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateInstanceExportTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createInternetGatewayRequest
     * @return Result of the CreateInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateInternetGatewayResponse createInternetGateway(CreateInternetGatewayRequest createInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateInternetGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateInternetGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInternetGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInternetGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateInternetGatewayRequest, CreateInternetGatewayResponse>()
                    .withOperationName("CreateInternetGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createInternetGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateInternetGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamRequest
     * @return Result of the CreateIpam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIpamResponse createIpam(CreateIpamRequest createIpamRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateIpamResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateIpamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpam");

            return clientHandler.execute(new ClientExecutionParams<CreateIpamRequest, CreateIpamResponse>()
                    .withOperationName("CreateIpam").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createIpamRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIpamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a verification token. A verification token is an Amazon Web Services-generated random value that you can
     * use to prove ownership of an external resource. For example, you can use a verification token to validate that
     * you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
     * </p>
     *
     * @param createIpamExternalResourceVerificationTokenRequest
     * @return Result of the CreateIpamExternalResourceVerificationToken operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamExternalResourceVerificationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamExternalResourceVerificationToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIpamExternalResourceVerificationTokenResponse createIpamExternalResourceVerificationToken(
            CreateIpamExternalResourceVerificationTokenRequest createIpamExternalResourceVerificationTokenRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateIpamExternalResourceVerificationTokenResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateIpamExternalResourceVerificationTokenResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createIpamExternalResourceVerificationTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createIpamExternalResourceVerificationTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpamExternalResourceVerificationToken");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIpamExternalResourceVerificationTokenRequest, CreateIpamExternalResourceVerificationTokenResponse>()
                            .withOperationName("CreateIpamExternalResourceVerificationToken")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(createIpamExternalResourceVerificationTokenRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIpamExternalResourceVerificationTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a
     * top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamPoolRequest
     * @return Result of the CreateIpamPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIpamPoolResponse createIpamPool(CreateIpamPoolRequest createIpamPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateIpamPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateIpamPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpamPool");

            return clientHandler.execute(new ClientExecutionParams<CreateIpamPoolRequest, CreateIpamPoolResponse>()
                    .withOperationName("CreateIpamPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createIpamPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIpamPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     *
     * @param createIpamResourceDiscoveryRequest
     * @return Result of the CreateIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIpamResourceDiscoveryResponse createIpamResourceDiscovery(
            CreateIpamResourceDiscoveryRequest createIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateIpamResourceDiscoveryResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateIpamResourceDiscoveryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamResourceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamResourceDiscoveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpamResourceDiscovery");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIpamResourceDiscoveryRequest, CreateIpamResourceDiscoveryResponse>()
                            .withOperationName("CreateIpamResourceDiscovery").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIpamResourceDiscoveryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIpamResourceDiscoveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param createIpamScopeRequest
     * @return Result of the CreateIpamScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIpamScopeResponse createIpamScope(CreateIpamScopeRequest createIpamScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateIpamScopeResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateIpamScopeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpamScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpamScopeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpamScope");

            return clientHandler.execute(new ClientExecutionParams<CreateIpamScopeRequest, CreateIpamScopeResponse>()
                    .withOperationName("CreateIpamScope").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createIpamScopeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIpamScopeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified format. Amazon EC2
     * stores the public key and displays the private key for you to save to a file. The private key is returned as an
     * unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use with PuTTY. If a
     * key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return Result of the CreateKeyPair operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateKeyPairResponse createKeyPair(CreateKeyPairRequest createKeyPairRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateKeyPairResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeyPair");

            return clientHandler.execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                    .withOperationName("CreateKeyPair").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createKeyPairRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch
     * parameters in Amazon EC2 launch templates</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * To clone an existing launch template as the basis for a new launch template, use the Amazon EC2 console. The API,
     * SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateRequest
     * @return Result of the CreateLaunchTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLaunchTemplateResponse createLaunchTemplate(CreateLaunchTemplateRequest createLaunchTemplateRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLaunchTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLaunchTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLaunchTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLaunchTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLaunchTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateLaunchTemplateRequest, CreateLaunchTemplateResponse>()
                    .withOperationName("CreateLaunchTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLaunchTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLaunchTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of a launch template. You must specify an existing launch template, either by name or ID.
     * You can determine whether the new version inherits parameters from a source version, and add or overwrite
     * parameters as needed.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You can't specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create
     * a new version of the launch template that includes the changes that you require.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html">Modify a launch
     * template (manage launch template versions)</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createLaunchTemplateVersionRequest
     * @return Result of the CreateLaunchTemplateVersion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLaunchTemplateVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLaunchTemplateVersionResponse createLaunchTemplateVersion(
            CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLaunchTemplateVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLaunchTemplateVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLaunchTemplateVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLaunchTemplateVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLaunchTemplateVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchTemplateVersionRequest, CreateLaunchTemplateVersionResponse>()
                            .withOperationName("CreateLaunchTemplateVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createLaunchTemplateVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLaunchTemplateVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a static route for the specified local gateway route table. You must specify one of the following
     * targets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LocalGatewayVirtualInterfaceGroupId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetworkInterfaceId</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param createLocalGatewayRouteRequest
     * @return Result of the CreateLocalGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateLocalGatewayRouteResponse createLocalGatewayRoute(CreateLocalGatewayRouteRequest createLocalGatewayRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLocalGatewayRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLocalGatewayRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLocalGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLocalGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayRoute");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteRequest, CreateLocalGatewayRouteResponse>()
                            .withOperationName("CreateLocalGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createLocalGatewayRouteRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLocalGatewayRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableRequest
     * @return Result of the CreateLocalGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLocalGatewayRouteTableResponse createLocalGatewayRouteTable(
            CreateLocalGatewayRouteTableRequest createLocalGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLocalGatewayRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLocalGatewayRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLocalGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLocalGatewayRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayRouteTable");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteTableRequest, CreateLocalGatewayRouteTableResponse>()
                            .withOperationName("CreateLocalGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createLocalGatewayRouteTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLocalGatewayRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a local gateway route table virtual interface group association.
     * </p>
     *
     * @param createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return Result of the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation returned by the
     *         service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse createLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse>()
                            .withOperationName("CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller(
                                            protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     *
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     * @return Result of the CreateLocalGatewayRouteTableVpcAssociation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLocalGatewayRouteTableVpcAssociationResponse createLocalGatewayRouteTableVpcAssociation(
            CreateLocalGatewayRouteTableVpcAssociationRequest createLocalGatewayRouteTableVpcAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLocalGatewayRouteTableVpcAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLocalGatewayRouteTableVpcAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createLocalGatewayRouteTableVpcAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLocalGatewayRouteTableVpcAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayRouteTableVpcAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayRouteTableVpcAssociationRequest, CreateLocalGatewayRouteTableVpcAssociationResponse>()
                            .withOperationName("CreateLocalGatewayRouteTableVpcAssociation")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(createLocalGatewayRouteTableVpcAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLocalGatewayRouteTableVpcAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a virtual interface for a local gateway.
     * </p>
     *
     * @param createLocalGatewayVirtualInterfaceRequest
     * @return Result of the CreateLocalGatewayVirtualInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLocalGatewayVirtualInterfaceResponse createLocalGatewayVirtualInterface(
            CreateLocalGatewayVirtualInterfaceRequest createLocalGatewayVirtualInterfaceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLocalGatewayVirtualInterfaceResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLocalGatewayVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLocalGatewayVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLocalGatewayVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayVirtualInterfaceRequest, CreateLocalGatewayVirtualInterfaceResponse>()
                            .withOperationName("CreateLocalGatewayVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createLocalGatewayVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLocalGatewayVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a local gateway virtual interface group.
     * </p>
     *
     * @param createLocalGatewayVirtualInterfaceGroupRequest
     * @return Result of the CreateLocalGatewayVirtualInterfaceGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateLocalGatewayVirtualInterfaceGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterfaceGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLocalGatewayVirtualInterfaceGroupResponse createLocalGatewayVirtualInterfaceGroup(
            CreateLocalGatewayVirtualInterfaceGroupRequest createLocalGatewayVirtualInterfaceGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateLocalGatewayVirtualInterfaceGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLocalGatewayVirtualInterfaceGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLocalGatewayVirtualInterfaceGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLocalGatewayVirtualInterfaceGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLocalGatewayVirtualInterfaceGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLocalGatewayVirtualInterfaceGroupRequest, CreateLocalGatewayVirtualInterfaceGroupResponse>()
                            .withOperationName("CreateLocalGatewayVirtualInterfaceGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createLocalGatewayVirtualInterfaceGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLocalGatewayVirtualInterfaceGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a System Integrity Protection (SIP) modification task to configure the SIP settings for an x86 Mac
     * instance or Apple silicon Mac instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mac-sip-settings.html#mac-sip-configure"> Configure SIP
     * for Amazon EC2 instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * When you configure the SIP settings for your instance, you can either enable or disable all SIP settings, or you
     * can specify a custom SIP configuration that selectively enables or disables specific SIP settings.
     * </p>
     * <note>
     * <p>
     * If you implement a custom configuration, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mac-sip-settings.html#mac-sip-check-settings"> connect
     * to the instance and verify the settings</a> to ensure that your requirements are properly implemented and
     * functioning as intended.
     * </p>
     * <p>
     * SIP configurations might change with macOS updates. We recommend that you review custom SIP settings after any
     * macOS version upgrade to ensure continued compatibility and proper functionality of your security configurations.
     * </p>
     * </note>
     * <p>
     * To enable or disable all SIP settings, use the <b>MacSystemIntegrityProtectionStatus</b> parameter only. For
     * example, to enable all SIP settings, specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MacSystemIntegrityProtectionStatus=enabled</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To specify a custom configuration that selectively enables or disables specific SIP settings, use the
     * <b>MacSystemIntegrityProtectionStatus</b> parameter to enable or disable all SIP settings, and then use the
     * <b>MacSystemIntegrityProtectionConfiguration</b> parameter to specify exceptions. In this case, the exceptions
     * you specify for <b>MacSystemIntegrityProtectionConfiguration</b> override the value you specify for
     * <b>MacSystemIntegrityProtectionStatus</b>. For example, to enable all SIP settings, except
     * <code>NvramProtections</code>, specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MacSystemIntegrityProtectionStatus=enabled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MacSystemIntegrityProtectionConfigurationRequest "NvramProtections=disabled"</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param createMacSystemIntegrityProtectionModificationTaskRequest
     * @return Result of the CreateMacSystemIntegrityProtectionModificationTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateMacSystemIntegrityProtectionModificationTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateMacSystemIntegrityProtectionModificationTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMacSystemIntegrityProtectionModificationTaskResponse createMacSystemIntegrityProtectionModificationTask(
            CreateMacSystemIntegrityProtectionModificationTaskRequest createMacSystemIntegrityProtectionModificationTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateMacSystemIntegrityProtectionModificationTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateMacSystemIntegrityProtectionModificationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createMacSystemIntegrityProtectionModificationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMacSystemIntegrityProtectionModificationTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMacSystemIntegrityProtectionModificationTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMacSystemIntegrityProtectionModificationTaskRequest, CreateMacSystemIntegrityProtectionModificationTaskResponse>()
                            .withOperationName("CreateMacSystemIntegrityProtectionModificationTask")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createMacSystemIntegrityProtectionModificationTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new CreateMacSystemIntegrityProtectionModificationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a managed prefix list. You can specify entries for the prefix list. Each entry consists of a CIDR block
     * and an optional description.
     * </p>
     *
     * @param createManagedPrefixListRequest
     * @return Result of the CreateManagedPrefixList operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateManagedPrefixListResponse createManagedPrefixList(CreateManagedPrefixListRequest createManagedPrefixListRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateManagedPrefixListResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateManagedPrefixListResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createManagedPrefixListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createManagedPrefixListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateManagedPrefixList");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateManagedPrefixListRequest, CreateManagedPrefixListResponse>()
                            .withOperationName("CreateManagedPrefixList").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createManagedPrefixListRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateManagedPrefixListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you create a public NAT gateway and assign it an EIP or secondary EIPs, the network border group of the EIPs
     * must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not
     * the same, the NAT gateway will fail to launch. You can see the network border group for the subnet's AZ by
     * viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the
     * details of the EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html">Allocate an Elastic IP address</a> in
     * the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     *
     * @param createNatGatewayRequest
     * @return Result of the CreateNatGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateNatGatewayResponse createNatGateway(CreateNatGatewayRequest createNatGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateNatGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateNatGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNatGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNatGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNatGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateNatGatewayRequest, CreateNatGatewayResponse>()
                    .withOperationName("CreateNatGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNatGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNatGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createNetworkAclRequest
     * @return Result of the CreateNetworkAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateNetworkAclResponse createNetworkAcl(CreateNetworkAclRequest createNetworkAclRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateNetworkAclResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateNetworkAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkAclRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkAcl");

            return clientHandler.execute(new ClientExecutionParams<CreateNetworkAclRequest, CreateNetworkAclResponse>()
                    .withOperationName("CreateNetworkAcl").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNetworkAclRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNetworkAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createNetworkAclEntryRequest
     * @return Result of the CreateNetworkAclEntry operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateNetworkAclEntryResponse createNetworkAclEntry(CreateNetworkAclEntryRequest createNetworkAclEntryRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateNetworkAclEntryResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateNetworkAclEntryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkAclEntryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkAclEntryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkAclEntry");

            return clientHandler.execute(new ClientExecutionParams<CreateNetworkAclEntryRequest, CreateNetworkAclEntryResponse>()
                    .withOperationName("CreateNetworkAclEntry").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNetworkAclEntryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNetworkAclEntryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     *
     * @param createNetworkInsightsAccessScopeRequest
     * @return Result of the CreateNetworkInsightsAccessScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNetworkInsightsAccessScopeResponse createNetworkInsightsAccessScope(
            CreateNetworkInsightsAccessScopeRequest createNetworkInsightsAccessScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateNetworkInsightsAccessScopeResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateNetworkInsightsAccessScopeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInsightsAccessScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNetworkInsightsAccessScopeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInsightsAccessScope");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInsightsAccessScopeRequest, CreateNetworkInsightsAccessScopeResponse>()
                            .withOperationName("CreateNetworkInsightsAccessScope").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createNetworkInsightsAccessScopeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNetworkInsightsAccessScopeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">Reachability Analyzer Guide</a>.
     * </p>
     *
     * @param createNetworkInsightsPathRequest
     * @return Result of the CreateNetworkInsightsPath operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateNetworkInsightsPathResponse createNetworkInsightsPath(
            CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateNetworkInsightsPathResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateNetworkInsightsPathResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInsightsPathRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkInsightsPathRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInsightsPath");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInsightsPathRequest, CreateNetworkInsightsPathResponse>()
                            .withOperationName("CreateNetworkInsightsPath").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createNetworkInsightsPathRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNetworkInsightsPathRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * The number of IP addresses you can assign to a network interface varies by instance type.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createNetworkInterfaceRequest
     * @return Result of the CreateNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateNetworkInterfaceResponse createNetworkInterface(CreateNetworkInterfaceRequest createNetworkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateNetworkInterfaceResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateNetworkInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInterfaceRequest, CreateNetworkInterfaceResponse>()
                            .withOperationName("CreateNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     *
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @return Result of the CreateNetworkInterfacePermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNetworkInterfacePermissionResponse createNetworkInterfacePermission(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateNetworkInterfacePermissionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateNetworkInterfacePermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkInterfacePermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createNetworkInterfacePermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkInterfacePermission");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResponse>()
                            .withOperationName("CreateNetworkInterfacePermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createNetworkInterfacePermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNetworkInterfacePermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createPlacementGroupRequest
     * @return Result of the CreatePlacementGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreatePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePlacementGroupResponse createPlacementGroup(CreatePlacementGroupRequest createPlacementGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreatePlacementGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreatePlacementGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePlacementGroup");

            return clientHandler.execute(new ClientExecutionParams<CreatePlacementGroupRequest, CreatePlacementGroupResponse>()
                    .withOperationName("CreatePlacementGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPlacementGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePlacementGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     *
     * @param createPublicIpv4PoolRequest
     * @return Result of the CreatePublicIpv4Pool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreatePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePublicIpv4PoolResponse createPublicIpv4Pool(CreatePublicIpv4PoolRequest createPublicIpv4PoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreatePublicIpv4PoolResponse> responseHandler = protocolFactory
                .createResponseHandler(CreatePublicIpv4PoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPublicIpv4PoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPublicIpv4PoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePublicIpv4Pool");

            return clientHandler.execute(new ClientExecutionParams<CreatePublicIpv4PoolRequest, CreatePublicIpv4PoolResponse>()
                    .withOperationName("CreatePublicIpv4Pool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPublicIpv4PoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePublicIpv4PoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the EBS-backed root volume for a <code>running</code> instance with a new volume that is restored to the
     * original root volume's launch state, that is restored to a specific snapshot taken from the original root volume,
     * or that is restored from an AMI that has the same key characteristics as that of the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace
     * a root volume</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createReplaceRootVolumeTaskRequest
     * @return Result of the CreateReplaceRootVolumeTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateReplaceRootVolumeTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateReplaceRootVolumeTaskResponse createReplaceRootVolumeTask(
            CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateReplaceRootVolumeTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateReplaceRootVolumeTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReplaceRootVolumeTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplaceRootVolumeTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplaceRootVolumeTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReplaceRootVolumeTaskRequest, CreateReplaceRootVolumeTaskResponse>()
                            .withOperationName("CreateReplaceRootVolumeTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createReplaceRootVolumeTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateReplaceRootVolumeTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Sell in the Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @return Result of the CreateReservedInstancesListing operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateReservedInstancesListing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateReservedInstancesListingResponse createReservedInstancesListing(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateReservedInstancesListingResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateReservedInstancesListingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReservedInstancesListingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createReservedInstancesListingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReservedInstancesListing");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReservedInstancesListingRequest, CreateReservedInstancesListingResponse>()
                            .withOperationName("CreateReservedInstancesListing").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createReservedInstancesListingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateReservedInstancesListingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createRestoreImageTaskRequest
     * @return Result of the CreateRestoreImageTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRestoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRestoreImageTaskResponse createRestoreImageTask(CreateRestoreImageTaskRequest createRestoreImageTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateRestoreImageTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRestoreImageTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRestoreImageTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRestoreImageTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestoreImageTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRestoreImageTaskRequest, CreateRestoreImageTaskResponse>()
                            .withOperationName("CreateRestoreImageTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createRestoreImageTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRestoreImageTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the
     * resources from the parameter list.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     *
     * @param createRouteRequest
     * @return Result of the CreateRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRouteResponse createRoute(CreateRouteRequest createRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoute");

            return clientHandler.execute(new ClientExecutionParams<CreateRouteRequest, CreateRouteResponse>()
                    .withOperationName("CreateRoute").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createRouteRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new route server to manage dynamic routing in a VPC.
     * </p>
     * <p>
     * Amazon VPC Route Server simplifies routing for traffic between workloads that are deployed within a VPC and its
     * internet gateways. With this feature, VPC Route Server dynamically updates VPC and internet gateway route tables
     * with your preferred IPv4 or IPv6 routes to achieve routing fault tolerance for those workloads. This enables you
     * to automatically reroute traffic within a VPC, which increases the manageability of VPC routing and
     * interoperability with third-party workloads.
     * </p>
     * <p>
     * Route server supports the follow route table types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VPC route tables not associated with subnets
     * </p>
     * </li>
     * <li>
     * <p>
     * Subnet route tables
     * </p>
     * </li>
     * <li>
     * <p>
     * Internet gateway route tables
     * </p>
     * </li>
     * </ul>
     * <p>
     * Route server does not support route tables associated with virtual private gateways. To propagate routes into a
     * transit gateway route table, use <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html">Transit
     * Gateway Connect</a>.
     * </p>
     * <p>
     * For more information see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html">Dynamic routing in your
     * VPC with VPC Route Server</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createRouteServerRequest
     * @return Result of the CreateRouteServer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRouteServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRouteServerResponse createRouteServer(CreateRouteServerRequest createRouteServerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateRouteServerResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRouteServerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouteServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouteServer");

            return clientHandler.execute(new ClientExecutionParams<CreateRouteServerRequest, CreateRouteServerResponse>()
                    .withOperationName("CreateRouteServer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRouteServerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouteServerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new endpoint for a route server in a specified subnet.
     * </p>
     * <p>
     * A route server endpoint is an Amazon Web Services-managed component inside a subnet that facilitates <a
     * href="https://en.wikipedia.org/wiki/Border_Gateway_Protocol">BGP (Border Gateway Protocol)</a> connections
     * between your route server and your BGP peers.
     * </p>
     * <p>
     * For more information see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html">Dynamic routing in your
     * VPC with VPC Route Server</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createRouteServerEndpointRequest
     * @return Result of the CreateRouteServerEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRouteServerEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRouteServerEndpointResponse createRouteServerEndpoint(
            CreateRouteServerEndpointRequest createRouteServerEndpointRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateRouteServerEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRouteServerEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouteServerEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteServerEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouteServerEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRouteServerEndpointRequest, CreateRouteServerEndpointResponse>()
                            .withOperationName("CreateRouteServerEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createRouteServerEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRouteServerEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new BGP peer for a specified route server endpoint.
     * </p>
     * <p>
     * A route server peer is a session between a route server endpoint and the device deployed in Amazon Web Services
     * (such as a firewall appliance or other network security function running on an EC2 instance). The device must
     * meet these requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Have an elastic network interface in the VPC
     * </p>
     * </li>
     * <li>
     * <p>
     * Support BGP (Border Gateway Protocol)
     * </p>
     * </li>
     * <li>
     * <p>
     * Can initiate BGP sessions
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html">Dynamic routing in your
     * VPC with VPC Route Server</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createRouteServerPeerRequest
     * @return Result of the CreateRouteServerPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRouteServerPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerPeer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRouteServerPeerResponse createRouteServerPeer(CreateRouteServerPeerRequest createRouteServerPeerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateRouteServerPeerResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRouteServerPeerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouteServerPeerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteServerPeerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouteServerPeer");

            return clientHandler.execute(new ClientExecutionParams<CreateRouteServerPeerRequest, CreateRouteServerPeerResponse>()
                    .withOperationName("CreateRouteServerPeer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRouteServerPeerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouteServerPeerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createRouteTableRequest
     * @return Result of the CreateRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRouteTableResponse createRouteTable(CreateRouteTableRequest createRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRouteTable");

            return clientHandler.execute(new ClientExecutionParams<CreateRouteTableRequest, CreateRouteTableResponse>()
                    .withOperationName("CreateRouteTable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRouteTableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon EC2 User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can't have two security groups
     * for the same VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in your VPC. If you don't specify a security group when you launch an
     * instance, the instance is launched into the appropriate default security group. A default security group includes
     * a default rule that grants instances unrestricted network access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     *
     * @param createSecurityGroupRequest
     * @return Result of the CreateSecurityGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSecurityGroupResponse createSecurityGroup(CreateSecurityGroupRequest createSecurityGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateSecurityGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSecurityGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateSecurityGroupRequest, CreateSecurityGroupResponse>()
                    .withOperationName("CreateSecurityGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSecurityGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * The location of the source EBS volume determines where you can create the snapshot.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source volume is in a Region, you must create the snapshot in the same Region as the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source volume is in a Local Zone, you can create the snapshot in the same Local Zone or in its parent
     * Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source volume is on an Outpost, you can create the snapshot on the same Outpost or in its parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * When you create a snapshot for an EBS volume that serves as a root device, we recommend that you stop the
     * instance before taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param createSnapshotRequest
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                    .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes attached to an Amazon EC2 instance. Volumes are chosen
     * by specifying an instance. Each volume attached to the specified instance will produce one snapshot that is
     * crash-consistent across the instance. You can include all of the volumes currently attached to the instance, or
     * you can exclude the root volume or specific data (non-root) volumes from the multi-volume snapshot set.
     * </p>
     * <p>
     * The location of the source instance determines where you can create the snapshots.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the source instance is in a Region, you must create the snapshots in the same Region as the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source instance is in a Local Zone, you can create the snapshots in the same Local Zone or in its parent
     * Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the source instance is on an Outpost, you can create the snapshots on the same Outpost or in its parent Amazon
     * Web Services Region.
     * </p>
     * </li>
     * </ul>
     *
     * @param createSnapshotsRequest
     * @return Result of the CreateSnapshots operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSnapshotsResponse createSnapshots(CreateSnapshotsRequest createSnapshotsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateSnapshotsResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshots");

            return clientHandler.execute(new ClientExecutionParams<CreateSnapshotsRequest, CreateSnapshotsResponse>()
                    .withOperationName("CreateSnapshots").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSnapshotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @return Result of the CreateSpotDatafeedSubscription operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSpotDatafeedSubscriptionResponse createSpotDatafeedSubscription(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateSpotDatafeedSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSpotDatafeedSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSpotDatafeedSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSpotDatafeedSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSpotDatafeedSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResponse>()
                            .withOperationName("CreateSpotDatafeedSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createSpotDatafeedSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateSpotDatafeedSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createStoreImageTaskRequest
     * @return Result of the CreateStoreImageTask operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateStoreImageTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateStoreImageTaskResponse createStoreImageTask(CreateStoreImageTaskRequest createStoreImageTaskRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateStoreImageTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateStoreImageTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStoreImageTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStoreImageTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStoreImageTask");

            return clientHandler.execute(new ClientExecutionParams<CreateStoreImageTaskRequest, CreateStoreImageTaskResponse>()
                    .withOperationName("CreateStoreImageTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createStoreImageTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStoreImageTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an
     * IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet,
     * specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.
     * </p>
     * <p>
     * A subnet CIDR block must not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet,
     * you can't change its CIDR block.
     * </p>
     * <p>
     * The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses) and a /16 netmask (65,536 IP
     * addresses). Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for your use.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can associate an IPv6 CIDR block with a subnet when
     * you create it.
     * </p>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     *
     * @param createSubnetRequest
     * @return Result of the CreateSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSubnetResponse createSubnet(CreateSubnetRequest createSubnetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateSubnetResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSubnetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSubnetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSubnetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubnet");

            return clientHandler.execute(new ClientExecutionParams<CreateSubnetRequest, CreateSubnetResponse>()
                    .withOperationName("CreateSubnet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSubnetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSubnetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a subnet CIDR reservation. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon VPC User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-prefixes.html">Manage prefixes for your
     * network interfaces</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createSubnetCidrReservationRequest
     * @return Result of the CreateSubnetCidrReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSubnetCidrReservationResponse createSubnetCidrReservation(
            CreateSubnetCidrReservationRequest createSubnetCidrReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateSubnetCidrReservationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSubnetCidrReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSubnetCidrReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSubnetCidrReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubnetCidrReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSubnetCidrReservationRequest, CreateSubnetCidrReservationResponse>()
                            .withOperationName("CreateSubnetCidrReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createSubnetCidrReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateSubnetCidrReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * resource-level permissions for Amazon EC2 API actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTags");

            return clientHandler.execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>()
                    .withOperationName("CreateTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     *
     * @param createTrafficMirrorFilterRequest
     * @return Result of the CreateTrafficMirrorFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTrafficMirrorFilterResponse createTrafficMirrorFilter(
            CreateTrafficMirrorFilterRequest createTrafficMirrorFilterRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateTrafficMirrorFilterResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTrafficMirrorFilterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficMirrorFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorFilter");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorFilterRequest, CreateTrafficMirrorFilterResponse>()
                            .withOperationName("CreateTrafficMirrorFilter").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTrafficMirrorFilterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTrafficMirrorFilterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     *
     * @param createTrafficMirrorFilterRuleRequest
     * @return Result of the CreateTrafficMirrorFilterRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrafficMirrorFilterRuleResponse createTrafficMirrorFilterRule(
            CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTrafficMirrorFilterRuleResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTrafficMirrorFilterRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorFilterRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTrafficMirrorFilterRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorFilterRule");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorFilterRuleRequest, CreateTrafficMirrorFilterRuleResponse>()
                            .withOperationName("CreateTrafficMirrorFilterRule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTrafficMirrorFilterRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTrafficMirrorFilterRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.html"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     *
     * @param createTrafficMirrorSessionRequest
     * @return Result of the CreateTrafficMirrorSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrafficMirrorSessionResponse createTrafficMirrorSession(
            CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateTrafficMirrorSessionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTrafficMirrorSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficMirrorSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorSession");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorSessionRequest, CreateTrafficMirrorSessionResponse>()
                            .withOperationName("CreateTrafficMirrorSession").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTrafficMirrorSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTrafficMirrorSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     *
     * @param createTrafficMirrorTargetRequest
     * @return Result of the CreateTrafficMirrorTarget operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTrafficMirrorTargetResponse createTrafficMirrorTarget(
            CreateTrafficMirrorTargetRequest createTrafficMirrorTargetRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateTrafficMirrorTargetResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTrafficMirrorTargetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficMirrorTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrafficMirrorTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficMirrorTarget");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficMirrorTargetRequest, CreateTrafficMirrorTargetResponse>()
                            .withOperationName("CreateTrafficMirrorTarget").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTrafficMirrorTargetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTrafficMirrorTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRequest
     * @return Result of the CreateTransitGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTransitGatewayResponse createTransitGateway(CreateTransitGatewayRequest createTransitGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransitGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateTransitGatewayRequest, CreateTransitGatewayResponse>()
                    .withOperationName("CreateTransitGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTransitGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     *
     * @param createTransitGatewayConnectRequest
     * @return Result of the CreateTransitGatewayConnect operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayConnectResponse createTransitGatewayConnect(
            CreateTransitGatewayConnectRequest createTransitGatewayConnectRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayConnectResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayConnectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayConnectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransitGatewayConnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayConnect");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayConnectRequest, CreateTransitGatewayConnectResponse>()
                            .withOperationName("CreateTransitGatewayConnect").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayConnectRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayConnectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Amazon Web Services Transit Gateways Guide</i>.
     * </p>
     *
     * @param createTransitGatewayConnectPeerRequest
     * @return Result of the CreateTransitGatewayConnectPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayConnectPeerResponse createTransitGatewayConnectPeer(
            CreateTransitGatewayConnectPeerRequest createTransitGatewayConnectPeerRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayConnectPeerResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayConnectPeerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayConnectPeerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayConnectPeerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayConnectPeer");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayConnectPeerRequest, CreateTransitGatewayConnectPeerResponse>()
                            .withOperationName("CreateTransitGatewayConnectPeer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayConnectPeerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayConnectPeerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     *
     * @param createTransitGatewayMulticastDomainRequest
     * @return Result of the CreateTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayMulticastDomainResponse createTransitGatewayMulticastDomain(
            CreateTransitGatewayMulticastDomainRequest createTransitGatewayMulticastDomainRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayMulticastDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayMulticastDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayMulticastDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayMulticastDomain");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayMulticastDomainRequest, CreateTransitGatewayMulticastDomainResponse>()
                            .withOperationName("CreateTransitGatewayMulticastDomain").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayMulticastDomainRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayMulticastDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     *
     * @param createTransitGatewayPeeringAttachmentRequest
     * @return Result of the CreateTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayPeeringAttachmentResponse createTransitGatewayPeeringAttachment(
            CreateTransitGatewayPeeringAttachmentRequest createTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayPeeringAttachmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayPeeringAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayPeeringAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayPeeringAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayPeeringAttachmentRequest, CreateTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("CreateTransitGatewayPeeringAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createTransitGatewayPeeringAttachmentRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a transit gateway policy table.
     * </p>
     *
     * @param createTransitGatewayPolicyTableRequest
     * @return Result of the CreateTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayPolicyTableResponse createTransitGatewayPolicyTable(
            CreateTransitGatewayPolicyTableRequest createTransitGatewayPolicyTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayPolicyTableResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayPolicyTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayPolicyTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayPolicyTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayPolicyTable");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayPolicyTableRequest, CreateTransitGatewayPolicyTableResponse>()
                            .withOperationName("CreateTransitGatewayPolicyTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayPolicyTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayPolicyTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayPrefixListReferenceRequest
     * @return Result of the CreateTransitGatewayPrefixListReference operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayPrefixListReferenceResponse createTransitGatewayPrefixListReference(
            CreateTransitGatewayPrefixListReferenceRequest createTransitGatewayPrefixListReferenceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayPrefixListReferenceResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayPrefixListReferenceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayPrefixListReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayPrefixListReferenceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayPrefixListReference");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayPrefixListReferenceRequest, CreateTransitGatewayPrefixListReferenceResponse>()
                            .withOperationName("CreateTransitGatewayPrefixListReference").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createTransitGatewayPrefixListReferenceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayPrefixListReferenceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteRequest
     * @return Result of the CreateTransitGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTransitGatewayRouteResponse createTransitGatewayRoute(
            CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTransitGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayRoute");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteRequest, CreateTransitGatewayRouteResponse>()
                            .withOperationName("CreateTransitGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayRouteRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     *
     * @param createTransitGatewayRouteTableRequest
     * @return Result of the CreateTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayRouteTableResponse createTransitGatewayRouteTable(
            CreateTransitGatewayRouteTableRequest createTransitGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayRouteTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayRouteTable");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteTableRequest, CreateTransitGatewayRouteTableResponse>()
                            .withOperationName("CreateTransitGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayRouteTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Advertises a new transit gateway route table.
     * </p>
     *
     * @param createTransitGatewayRouteTableAnnouncementRequest
     * @return Result of the CreateTransitGatewayRouteTableAnnouncement operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayRouteTableAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayRouteTableAnnouncementResponse createTransitGatewayRouteTableAnnouncement(
            CreateTransitGatewayRouteTableAnnouncementRequest createTransitGatewayRouteTableAnnouncementRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayRouteTableAnnouncementResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayRouteTableAnnouncementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createTransitGatewayRouteTableAnnouncementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayRouteTableAnnouncementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayRouteTableAnnouncement");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayRouteTableAnnouncementRequest, CreateTransitGatewayRouteTableAnnouncementResponse>()
                            .withOperationName("CreateTransitGatewayRouteTableAnnouncement")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(createTransitGatewayRouteTableAnnouncementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayRouteTableAnnouncementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     *
     * @param createTransitGatewayVpcAttachmentRequest
     * @return Result of the CreateTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTransitGatewayVpcAttachmentResponse createTransitGatewayVpcAttachment(
            CreateTransitGatewayVpcAttachmentRequest createTransitGatewayVpcAttachmentRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTransitGatewayVpcAttachmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTransitGatewayVpcAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTransitGatewayVpcAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTransitGatewayVpcAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTransitGatewayVpcAttachmentRequest, CreateTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("CreateTransitGatewayVpcAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTransitGatewayVpcAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access endpoint is where you define your application along with an optional
     * endpoint-level access policy.
     * </p>
     *
     * @param createVerifiedAccessEndpointRequest
     * @return Result of the CreateVerifiedAccessEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVerifiedAccessEndpointResponse createVerifiedAccessEndpoint(
            CreateVerifiedAccessEndpointRequest createVerifiedAccessEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVerifiedAccessEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVerifiedAccessEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVerifiedAccessEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessEndpointRequest, CreateVerifiedAccessEndpointResponse>()
                            .withOperationName("CreateVerifiedAccessEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVerifiedAccessEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVerifiedAccessEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints
     * who's associated applications have similar security requirements. Each instance within a Verified Access group
     * shares an Verified Access policy. For example, you can group all Verified Access instances associated with
     * "sales" applications together and use one common Verified Access policy.
     * </p>
     *
     * @param createVerifiedAccessGroupRequest
     * @return Result of the CreateVerifiedAccessGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateVerifiedAccessGroupResponse createVerifiedAccessGroup(
            CreateVerifiedAccessGroupRequest createVerifiedAccessGroupRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateVerifiedAccessGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVerifiedAccessGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVerifiedAccessGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessGroupRequest, CreateVerifiedAccessGroupResponse>()
                            .withOperationName("CreateVerifiedAccessGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVerifiedAccessGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVerifiedAccessGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and
     * grants access only when your security requirements are met.
     * </p>
     *
     * @param createVerifiedAccessInstanceRequest
     * @return Result of the CreateVerifiedAccessInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVerifiedAccessInstanceResponse createVerifiedAccessInstance(
            CreateVerifiedAccessInstanceRequest createVerifiedAccessInstanceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVerifiedAccessInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVerifiedAccessInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVerifiedAccessInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessInstanceRequest, CreateVerifiedAccessInstanceResponse>()
                            .withOperationName("CreateVerifiedAccessInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVerifiedAccessInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVerifiedAccessInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A trust provider is a third-party entity that creates, maintains, and manages identity information for users and
     * devices. When an application request is made, the identity information sent by the trust provider is evaluated by
     * Verified Access before allowing or denying the application request.
     * </p>
     *
     * @param createVerifiedAccessTrustProviderRequest
     * @return Result of the CreateVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVerifiedAccessTrustProviderResponse createVerifiedAccessTrustProvider(
            CreateVerifiedAccessTrustProviderRequest createVerifiedAccessTrustProviderRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVerifiedAccessTrustProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVerifiedAccessTrustProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVerifiedAccessTrustProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVerifiedAccessTrustProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVerifiedAccessTrustProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVerifiedAccessTrustProviderRequest, CreateVerifiedAccessTrustProviderResponse>()
                            .withOperationName("CreateVerifiedAccessTrustProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVerifiedAccessTrustProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVerifiedAccessTrustProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html">Create an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param createVolumeRequest
     * @return Result of the CreateVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVolumeResponse createVolume(CreateVolumeRequest createVolumeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVolumeResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVolumeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVolume");

            return clientHandler.execute(new ClientExecutionParams<CreateVolumeRequest, CreateVolumeResponse>()
                    .withOperationName("CreateVolume").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVolumeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVolumeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a VPC with the specified CIDR blocks. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
     * bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance that you launch in the VPC has the default DHCP options, which include only a default
     * DNS server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param createVpcRequest
     * @return Result of the CreateVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVpcResponse createVpc(CreateVpcRequest createVpcRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateVpcResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpcResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpc");

            return clientHandler.execute(new ClientExecutionParams<CreateVpcRequest, CreateVpcResponse>()
                    .withOperationName("CreateVpc").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createVpcRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpcRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single
     * VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You
     * can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there
     * is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param createVpcBlockPublicAccessExclusionRequest
     * @return Result of the CreateVpcBlockPublicAccessExclusion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcBlockPublicAccessExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcBlockPublicAccessExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpcBlockPublicAccessExclusionResponse createVpcBlockPublicAccessExclusion(
            CreateVpcBlockPublicAccessExclusionRequest createVpcBlockPublicAccessExclusionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVpcBlockPublicAccessExclusionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpcBlockPublicAccessExclusionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcBlockPublicAccessExclusionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVpcBlockPublicAccessExclusionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcBlockPublicAccessExclusion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpcBlockPublicAccessExclusionRequest, CreateVpcBlockPublicAccessExclusionResponse>()
                            .withOperationName("CreateVpcBlockPublicAccessExclusion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVpcBlockPublicAccessExclusionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVpcBlockPublicAccessExclusionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified
     * endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services
     * Marketplace Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink User Guide</a>.
     * </p>
     *
     * @param createVpcEndpointRequest
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVpcEndpointResponse createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVpcEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpcEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpoint");

            return clientHandler.execute(new ClientExecutionParams<CreateVpcEndpointRequest, CreateVpcEndpointResponse>()
                    .withOperationName("CreateVpcEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVpcEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpcEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Creating an Amazon SNS
     * topic</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     *
     * @param createVpcEndpointConnectionNotificationRequest
     * @return Result of the CreateVpcEndpointConnectionNotification operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpointConnectionNotification
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpcEndpointConnectionNotificationResponse createVpcEndpointConnectionNotification(
            CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVpcEndpointConnectionNotificationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpcEndpointConnectionNotificationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointConnectionNotificationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVpcEndpointConnectionNotificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpointConnectionNotification");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointConnectionNotificationRequest, CreateVpcEndpointConnectionNotificationResponse>()
                            .withOperationName("CreateVpcEndpointConnectionNotification").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createVpcEndpointConnectionNotificationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVpcEndpointConnectionNotificationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles)
     * can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     *
     * @param createVpcEndpointServiceConfigurationRequest
     * @return Result of the CreateVpcEndpointServiceConfiguration operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcEndpointServiceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpcEndpointServiceConfigurationResponse createVpcEndpointServiceConfiguration(
            CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVpcEndpointServiceConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpcEndpointServiceConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointServiceConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createVpcEndpointServiceConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpointServiceConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointServiceConfigurationRequest, CreateVpcEndpointServiceConfigurationResponse>()
                            .withOperationName("CreateVpcEndpointServiceConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createVpcEndpointServiceConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVpcEndpointServiceConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations">VPC peering
     * limitations</a> in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return Result of the CreateVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpcPeeringConnectionResponse createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateVpcPeeringConnectionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpcPeeringConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcPeeringConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResponse>()
                            .withOperationName("CreateVpcPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVpcPeeringConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVpcPeeringConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @return Result of the CreateVpnConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVpnConnectionResponse createVpnConnection(CreateVpnConnectionRequest createVpnConnectionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVpnConnectionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpnConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpnConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpnConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpnConnection");

            return clientHandler.execute(new ClientExecutionParams<CreateVpnConnectionRequest, CreateVpnConnectionResponse>()
                    .withOperationName("CreateVpnConnection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVpnConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpnConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @return Result of the CreateVpnConnectionRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateVpnConnectionRouteResponse createVpnConnectionRoute(
            CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<CreateVpnConnectionRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpnConnectionRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpnConnectionRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpnConnectionRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpnConnectionRoute");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVpnConnectionRouteRequest, CreateVpnConnectionRouteResponse>()
                            .withOperationName("CreateVpnConnectionRoute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createVpnConnectionRouteRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVpnConnectionRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     *
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @return Result of the CreateVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.CreateVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVpnGatewayResponse createVpnGateway(CreateVpnGatewayRequest createVpnGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<CreateVpnGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVpnGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpnGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpnGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpnGateway");

            return clientHandler.execute(new ClientExecutionParams<CreateVpnGatewayRequest, CreateVpnGatewayResponse>()
                    .withOperationName("CreateVpnGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVpnGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpnGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important>
     *
     * @param deleteCarrierGatewayRequest
     * @return Result of the DeleteCarrierGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCarrierGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCarrierGatewayResponse deleteCarrierGateway(DeleteCarrierGatewayRequest deleteCarrierGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteCarrierGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCarrierGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCarrierGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCarrierGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCarrierGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteCarrierGatewayRequest, DeleteCarrierGatewayResponse>()
                    .withOperationName("DeleteCarrierGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCarrierGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCarrierGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     *
     * @param deleteClientVpnEndpointRequest
     * @return Result of the DeleteClientVpnEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteClientVpnEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteClientVpnEndpointResponse deleteClientVpnEndpoint(DeleteClientVpnEndpointRequest deleteClientVpnEndpointRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteClientVpnEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteClientVpnEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClientVpnEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientVpnEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientVpnEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteClientVpnEndpointRequest, DeleteClientVpnEndpointResponse>()
                            .withOperationName("DeleteClientVpnEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteClientVpnEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteClientVpnEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     *
     * @param deleteClientVpnRouteRequest
     * @return Result of the DeleteClientVpnRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteClientVpnRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteClientVpnRouteResponse deleteClientVpnRoute(DeleteClientVpnRouteRequest deleteClientVpnRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteClientVpnRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteClientVpnRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClientVpnRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientVpnRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientVpnRoute");

            return clientHandler.execute(new ClientExecutionParams<DeleteClientVpnRouteRequest, DeleteClientVpnRouteResponse>()
                    .withOperationName("DeleteClientVpnRoute").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteClientVpnRouteRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteClientVpnRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a range of customer-owned IP addresses.
     * </p>
     *
     * @param deleteCoipCidrRequest
     * @return Result of the DeleteCoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCoipCidrResponse deleteCoipCidr(DeleteCoipCidrRequest deleteCoipCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteCoipCidrResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCoipCidrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCoipCidr");

            return clientHandler.execute(new ClientExecutionParams<DeleteCoipCidrRequest, DeleteCoipCidrResponse>()
                    .withOperationName("DeleteCoipCidr").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a pool of customer-owned IP (CoIP) addresses.
     * </p>
     *
     * @param deleteCoipPoolRequest
     * @return Result of the DeleteCoipPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCoipPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCoipPoolResponse deleteCoipPool(DeleteCoipPoolRequest deleteCoipPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteCoipPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCoipPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCoipPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCoipPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCoipPool");

            return clientHandler.execute(new ClientExecutionParams<DeleteCoipPoolRequest, DeleteCoipPoolResponse>()
                    .withOperationName("DeleteCoipPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCoipPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCoipPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     *
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @return Result of the DeleteCustomerGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteCustomerGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCustomerGatewayResponse deleteCustomerGateway(DeleteCustomerGatewayRequest deleteCustomerGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteCustomerGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteCustomerGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomerGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomerGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomerGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteCustomerGatewayRequest, DeleteCustomerGatewayResponse>()
                    .withOperationName("DeleteCustomerGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCustomerGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCustomerGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     *
     * @param deleteDhcpOptionsRequest
     * @return Result of the DeleteDhcpOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteDhcpOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDhcpOptionsResponse deleteDhcpOptions(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteDhcpOptionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteDhcpOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDhcpOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDhcpOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDhcpOptions");

            return clientHandler.execute(new ClientExecutionParams<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse>()
                    .withOperationName("DeleteDhcpOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDhcpOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDhcpOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     *
     * @param deleteEgressOnlyInternetGatewayRequest
     * @return Result of the DeleteEgressOnlyInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteEgressOnlyInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEgressOnlyInternetGatewayResponse deleteEgressOnlyInternetGateway(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteEgressOnlyInternetGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteEgressOnlyInternetGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEgressOnlyInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteEgressOnlyInternetGatewayRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEgressOnlyInternetGateway");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEgressOnlyInternetGatewayRequest, DeleteEgressOnlyInternetGatewayResponse>()
                            .withOperationName("DeleteEgressOnlyInternetGateway").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteEgressOnlyInternetGatewayRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEgressOnlyInternetGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified EC2 Fleet request.
     * </p>
     * <p>
     * After you delete an EC2 Fleet request, it launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a deleted EC2 Fleet request should terminate its instances. If you choose to
     * terminate the instances, the EC2 Fleet request enters the <code>deleted_terminating</code> state. Otherwise, it
     * enters the <code>deleted_running</code> state, and the instances continue to run until they are interrupted or
     * you terminate them manually.
     * </p>
     * <p>
     * A deleted <code>instant</code> fleet with running instances is not supported. When you delete an
     * <code>instant</code> fleet, Amazon EC2 automatically terminates all its instances. For fleets with more than 1000
     * instances, the deletion request might fail. If your fleet has more than 1000 instances, first terminate most of
     * the instances manually, leaving 1000 or fewer. Then delete the fleet, and the remaining instances will be
     * terminated automatically.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 fleets of type <code>instant</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 100 fleets of type <code>maintain</code> or <code>request</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 125 fleets in a single request, provided you do not exceed the quota for each fleet type, as
     * specified above.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you exceed the specified number of fleets to delete, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/delete-fleet.html">Delete
     * an EC2 Fleet request and the instances in the fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteFleetsRequest
     * @return Result of the DeleteFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFleetsResponse deleteFleets(DeleteFleetsRequest deleteFleetsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteFleetsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteFleetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleets");

            return clientHandler.execute(new ClientExecutionParams<DeleteFleetsRequest, DeleteFleetsResponse>()
                    .withOperationName("DeleteFleets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFleetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFleetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     *
     * @param deleteFlowLogsRequest
     * @return Result of the DeleteFlowLogs operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFlowLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFlowLogsResponse deleteFlowLogs(DeleteFlowLogsRequest deleteFlowLogsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteFlowLogsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteFlowLogsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFlowLogsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowLogsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlowLogs");

            return clientHandler.execute(new ClientExecutionParams<DeleteFlowLogsRequest, DeleteFlowLogsResponse>()
                    .withOperationName("DeleteFlowLogs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFlowLogsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFlowLogsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     *
     * @param deleteFpgaImageRequest
     * @return Result of the DeleteFpgaImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteFpgaImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFpgaImageResponse deleteFpgaImage(DeleteFpgaImageRequest deleteFpgaImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteFpgaImageResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteFpgaImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFpgaImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFpgaImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFpgaImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteFpgaImageRequest, DeleteFpgaImageResponse>()
                    .withOperationName("DeleteFpgaImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFpgaImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFpgaImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified EC2 Instance Connect Endpoint.
     * </p>
     *
     * @param deleteInstanceConnectEndpointRequest
     * @return Result of the DeleteInstanceConnectEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInstanceConnectEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInstanceConnectEndpointResponse deleteInstanceConnectEndpoint(
            DeleteInstanceConnectEndpointRequest deleteInstanceConnectEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteInstanceConnectEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteInstanceConnectEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceConnectEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInstanceConnectEndpointRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceConnectEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceConnectEndpointRequest, DeleteInstanceConnectEndpointResponse>()
                            .withOperationName("DeleteInstanceConnectEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteInstanceConnectEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInstanceConnectEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteInstanceEventWindowRequest
     * @return Result of the DeleteInstanceEventWindow operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInstanceEventWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteInstanceEventWindowResponse deleteInstanceEventWindow(
            DeleteInstanceEventWindowRequest deleteInstanceEventWindowRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteInstanceEventWindowResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteInstanceEventWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInstanceEventWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceEventWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceEventWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceEventWindowRequest, DeleteInstanceEventWindowResponse>()
                            .withOperationName("DeleteInstanceEventWindow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteInstanceEventWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInstanceEventWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     *
     * @param deleteInternetGatewayRequest
     * @return Result of the DeleteInternetGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteInternetGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteInternetGatewayResponse deleteInternetGateway(DeleteInternetGatewayRequest deleteInternetGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteInternetGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteInternetGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInternetGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInternetGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInternetGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteInternetGatewayRequest, DeleteInternetGatewayResponse>()
                    .withOperationName("DeleteInternetGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteInternetGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInternetGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html">Delete an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamRequest
     * @return Result of the DeleteIpam operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIpamResponse deleteIpam(DeleteIpamRequest deleteIpamRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteIpamResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteIpamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpam");

            return clientHandler.execute(new ClientExecutionParams<DeleteIpamRequest, DeleteIpamResponse>()
                    .withOperationName("DeleteIpam").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteIpamRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIpamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a verification token. A verification token is an Amazon Web Services-generated random value that you can
     * use to prove ownership of an external resource. For example, you can use a verification token to validate that
     * you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).
     * </p>
     *
     * @param deleteIpamExternalResourceVerificationTokenRequest
     * @return Result of the DeleteIpamExternalResourceVerificationToken operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamExternalResourceVerificationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamExternalResourceVerificationToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIpamExternalResourceVerificationTokenResponse deleteIpamExternalResourceVerificationToken(
            DeleteIpamExternalResourceVerificationTokenRequest deleteIpamExternalResourceVerificationTokenRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteIpamExternalResourceVerificationTokenResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteIpamExternalResourceVerificationTokenResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteIpamExternalResourceVerificationTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteIpamExternalResourceVerificationTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpamExternalResourceVerificationToken");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIpamExternalResourceVerificationTokenRequest, DeleteIpamExternalResourceVerificationTokenResponse>()
                            .withOperationName("DeleteIpamExternalResourceVerificationToken")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteIpamExternalResourceVerificationTokenRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIpamExternalResourceVerificationTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a
     * pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamPoolRequest
     * @return Result of the DeleteIpamPool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIpamPoolResponse deleteIpamPool(DeleteIpamPoolRequest deleteIpamPoolRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteIpamPoolResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteIpamPoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpamPool");

            return clientHandler.execute(new ClientExecutionParams<DeleteIpamPoolRequest, DeleteIpamPoolResponse>()
                    .withOperationName("DeleteIpamPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteIpamPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIpamPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     *
     * @param deleteIpamResourceDiscoveryRequest
     * @return Result of the DeleteIpamResourceDiscovery operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamResourceDiscovery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIpamResourceDiscoveryResponse deleteIpamResourceDiscovery(
            DeleteIpamResourceDiscoveryRequest deleteIpamResourceDiscoveryRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteIpamResourceDiscoveryResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteIpamResourceDiscoveryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamResourceDiscoveryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamResourceDiscoveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpamResourceDiscovery");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIpamResourceDiscoveryRequest, DeleteIpamResourceDiscoveryResponse>()
                            .withOperationName("DeleteIpamResourceDiscovery").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteIpamResourceDiscoveryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIpamResourceDiscoveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html">Delete a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deleteIpamScopeRequest
     * @return Result of the DeleteIpamScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteIpamScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIpamScopeResponse deleteIpamScope(DeleteIpamScopeRequest deleteIpamScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteIpamScopeResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteIpamScopeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpamScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpamScopeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpamScope");

            return clientHandler.execute(new ClientExecutionParams<DeleteIpamScopeRequest, DeleteIpamScopeResponse>()
                    .withOperationName("DeleteIpamScope").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteIpamScopeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIpamScopeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return Result of the DeleteKeyPair operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteKeyPair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteKeyPairResponse deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteKeyPairResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKeyPairRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyPair");

            return clientHandler.execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                    .withOperationName("DeleteKeyPair").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteKeyPairRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     *
     * @param deleteLaunchTemplateRequest
     * @return Result of the DeleteLaunchTemplate operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLaunchTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLaunchTemplateResponse deleteLaunchTemplate(DeleteLaunchTemplateRequest deleteLaunchTemplateRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLaunchTemplateResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLaunchTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLaunchTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteLaunchTemplateRequest, DeleteLaunchTemplateResponse>()
                    .withOperationName("DeleteLaunchTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteLaunchTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLaunchTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or more versions of a launch template.
     * </p>
     * <p>
     * You can't delete the default version of a launch template; you must first assign a different version as the
     * default. If the default version is the only version for the launch template, you must delete the entire launch
     * template using <a>DeleteLaunchTemplate</a>.
     * </p>
     * <p>
     * You can delete up to 200 launch template versions in a single request. To delete more than 200 versions in a
     * single request, use <a>DeleteLaunchTemplate</a>, which deletes the launch template and all of its versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/delete-launch-template.html#delete-launch-template-version"
     * >Delete a launch template version</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deleteLaunchTemplateVersionsRequest
     * @return Result of the DeleteLaunchTemplateVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLaunchTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLaunchTemplateVersionsResponse deleteLaunchTemplateVersions(
            DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLaunchTemplateVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLaunchTemplateVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLaunchTemplateVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchTemplateVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchTemplateVersionsRequest, DeleteLaunchTemplateVersionsResponse>()
                            .withOperationName("DeleteLaunchTemplateVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteLaunchTemplateVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLaunchTemplateVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteRequest
     * @return Result of the DeleteLocalGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteLocalGatewayRouteResponse deleteLocalGatewayRoute(DeleteLocalGatewayRouteRequest deleteLocalGatewayRouteRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLocalGatewayRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLocalGatewayRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLocalGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLocalGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayRoute");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteRequest, DeleteLocalGatewayRouteResponse>()
                            .withOperationName("DeleteLocalGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteLocalGatewayRouteRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLocalGatewayRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableRequest
     * @return Result of the DeleteLocalGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLocalGatewayRouteTableResponse deleteLocalGatewayRouteTable(
            DeleteLocalGatewayRouteTableRequest deleteLocalGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLocalGatewayRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLocalGatewayRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLocalGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLocalGatewayRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayRouteTable");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteTableRequest, DeleteLocalGatewayRouteTableResponse>()
                            .withOperationName("DeleteLocalGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteLocalGatewayRouteTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLocalGatewayRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a local gateway route table virtual interface group association.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return Result of the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation returned by the
     *         service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(
            DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse>()
                            .withOperationName("DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequestMarshaller(
                                            protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     *
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     * @return Result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLocalGatewayRouteTableVpcAssociationResponse deleteLocalGatewayRouteTableVpcAssociation(
            DeleteLocalGatewayRouteTableVpcAssociationRequest deleteLocalGatewayRouteTableVpcAssociationRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLocalGatewayRouteTableVpcAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLocalGatewayRouteTableVpcAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteLocalGatewayRouteTableVpcAssociationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLocalGatewayRouteTableVpcAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayRouteTableVpcAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayRouteTableVpcAssociationRequest, DeleteLocalGatewayRouteTableVpcAssociationResponse>()
                            .withOperationName("DeleteLocalGatewayRouteTableVpcAssociation")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteLocalGatewayRouteTableVpcAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLocalGatewayRouteTableVpcAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified local gateway virtual interface.
     * </p>
     *
     * @param deleteLocalGatewayVirtualInterfaceRequest
     * @return Result of the DeleteLocalGatewayVirtualInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayVirtualInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayVirtualInterface"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLocalGatewayVirtualInterfaceResponse deleteLocalGatewayVirtualInterface(
            DeleteLocalGatewayVirtualInterfaceRequest deleteLocalGatewayVirtualInterfaceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLocalGatewayVirtualInterfaceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLocalGatewayVirtualInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLocalGatewayVirtualInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLocalGatewayVirtualInterfaceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayVirtualInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayVirtualInterfaceRequest, DeleteLocalGatewayVirtualInterfaceResponse>()
                            .withOperationName("DeleteLocalGatewayVirtualInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteLocalGatewayVirtualInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLocalGatewayVirtualInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the specified local gateway interface group.
     * </p>
     *
     * @param deleteLocalGatewayVirtualInterfaceGroupRequest
     * @return Result of the DeleteLocalGatewayVirtualInterfaceGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteLocalGatewayVirtualInterfaceGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayVirtualInterfaceGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLocalGatewayVirtualInterfaceGroupResponse deleteLocalGatewayVirtualInterfaceGroup(
            DeleteLocalGatewayVirtualInterfaceGroupRequest deleteLocalGatewayVirtualInterfaceGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteLocalGatewayVirtualInterfaceGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLocalGatewayVirtualInterfaceGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLocalGatewayVirtualInterfaceGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLocalGatewayVirtualInterfaceGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLocalGatewayVirtualInterfaceGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLocalGatewayVirtualInterfaceGroupRequest, DeleteLocalGatewayVirtualInterfaceGroupResponse>()
                            .withOperationName("DeleteLocalGatewayVirtualInterfaceGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteLocalGatewayVirtualInterfaceGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLocalGatewayVirtualInterfaceGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     *
     * @param deleteManagedPrefixListRequest
     * @return Result of the DeleteManagedPrefixList operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteManagedPrefixList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteManagedPrefixListResponse deleteManagedPrefixList(DeleteManagedPrefixListRequest deleteManagedPrefixListRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteManagedPrefixListResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteManagedPrefixListResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteManagedPrefixListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteManagedPrefixListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteManagedPrefixList");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteManagedPrefixListRequest, DeleteManagedPrefixListResponse>()
                            .withOperationName("DeleteManagedPrefixList").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteManagedPrefixListRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteManagedPrefixListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     *
     * @param deleteNatGatewayRequest
     * @return Result of the DeleteNatGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNatGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteNatGatewayResponse deleteNatGateway(DeleteNatGatewayRequest deleteNatGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNatGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNatGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNatGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNatGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNatGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteNatGatewayRequest, DeleteNatGatewayResponse>()
                    .withOperationName("DeleteNatGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNatGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNatGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     *
     * @param deleteNetworkAclRequest
     * @return Result of the DeleteNetworkAcl operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkAcl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteNetworkAclResponse deleteNetworkAcl(DeleteNetworkAclRequest deleteNetworkAclRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNetworkAclResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkAclResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkAclRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkAclRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkAcl");

            return clientHandler.execute(new ClientExecutionParams<DeleteNetworkAclRequest, DeleteNetworkAclResponse>()
                    .withOperationName("DeleteNetworkAcl").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkAclRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNetworkAclRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     *
     * @param deleteNetworkAclEntryRequest
     * @return Result of the DeleteNetworkAclEntry operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkAclEntry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteNetworkAclEntryResponse deleteNetworkAclEntry(DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNetworkAclEntryResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkAclEntryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkAclEntryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkAclEntryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkAclEntry");

            return clientHandler.execute(new ClientExecutionParams<DeleteNetworkAclEntryRequest, DeleteNetworkAclEntryResponse>()
                    .withOperationName("DeleteNetworkAclEntry").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkAclEntryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNetworkAclEntryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeRequest
     * @return Result of the DeleteNetworkInsightsAccessScope operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAccessScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkInsightsAccessScopeResponse deleteNetworkInsightsAccessScope(
            DeleteNetworkInsightsAccessScopeRequest deleteNetworkInsightsAccessScopeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNetworkInsightsAccessScopeResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkInsightsAccessScopeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInsightsAccessScopeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInsightsAccessScopeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsAccessScope");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsAccessScopeRequest, DeleteNetworkInsightsAccessScopeResponse>()
                            .withOperationName("DeleteNetworkInsightsAccessScope").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkInsightsAccessScopeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNetworkInsightsAccessScopeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     * @return Result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkInsightsAccessScopeAnalysisResponse deleteNetworkInsightsAccessScopeAnalysis(
            DeleteNetworkInsightsAccessScopeAnalysisRequest deleteNetworkInsightsAccessScopeAnalysisRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNetworkInsightsAccessScopeAnalysisResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkInsightsAccessScopeAnalysisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteNetworkInsightsAccessScopeAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInsightsAccessScopeAnalysisRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsAccessScopeAnalysis");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsAccessScopeAnalysisRequest, DeleteNetworkInsightsAccessScopeAnalysisResponse>()
                            .withOperationName("DeleteNetworkInsightsAccessScopeAnalysis").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteNetworkInsightsAccessScopeAnalysisRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNetworkInsightsAccessScopeAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     *
     * @param deleteNetworkInsightsAnalysisRequest
     * @return Result of the DeleteNetworkInsightsAnalysis operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkInsightsAnalysisResponse deleteNetworkInsightsAnalysis(
            DeleteNetworkInsightsAnalysisRequest deleteNetworkInsightsAnalysisRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNetworkInsightsAnalysisResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkInsightsAnalysisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInsightsAnalysisRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInsightsAnalysisRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsAnalysis");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsAnalysisRequest, DeleteNetworkInsightsAnalysisResponse>()
                            .withOperationName("DeleteNetworkInsightsAnalysis").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkInsightsAnalysisRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNetworkInsightsAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     *
     * @param deleteNetworkInsightsPathRequest
     * @return Result of the DeleteNetworkInsightsPath operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInsightsPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteNetworkInsightsPathResponse deleteNetworkInsightsPath(
            DeleteNetworkInsightsPathRequest deleteNetworkInsightsPathRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteNetworkInsightsPathResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkInsightsPathResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInsightsPathRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkInsightsPathRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInsightsPath");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInsightsPathRequest, DeleteNetworkInsightsPathResponse>()
                            .withOperationName("DeleteNetworkInsightsPath").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkInsightsPathRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNetworkInsightsPathRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     *
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @return Result of the DeleteNetworkInterface operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInterface
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteNetworkInterfaceResponse deleteNetworkInterface(DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNetworkInterfaceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkInterfaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInterfaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkInterfaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInterface");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInterfaceRequest, DeleteNetworkInterfaceResponse>()
                            .withOperationName("DeleteNetworkInterface").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkInterfaceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNetworkInterfaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     *
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @return Result of the DeleteNetworkInterfacePermission operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteNetworkInterfacePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkInterfacePermissionResponse deleteNetworkInterfacePermission(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteNetworkInterfacePermissionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteNetworkInterfacePermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkInterfacePermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteNetworkInterfacePermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkInterfacePermission");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkInterfacePermissionRequest, DeleteNetworkInterfacePermissionResponse>()
                            .withOperationName("DeleteNetworkInterfacePermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkInterfacePermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteNetworkInterfacePermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deletePlacementGroupRequest
     * @return Result of the DeletePlacementGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeletePlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePlacementGroupResponse deletePlacementGroup(DeletePlacementGroupRequest deletePlacementGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeletePlacementGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeletePlacementGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePlacementGroup");

            return clientHandler.execute(new ClientExecutionParams<DeletePlacementGroupRequest, DeletePlacementGroupResponse>()
                    .withOperationName("DeletePlacementGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePlacementGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePlacementGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     *
     * @param deletePublicIpv4PoolRequest
     * @return Result of the DeletePublicIpv4Pool operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeletePublicIpv4Pool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePublicIpv4PoolResponse deletePublicIpv4Pool(DeletePublicIpv4PoolRequest deletePublicIpv4PoolRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeletePublicIpv4PoolResponse> responseHandler = protocolFactory
                .createResponseHandler(DeletePublicIpv4PoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePublicIpv4PoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePublicIpv4PoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePublicIpv4Pool");

            return clientHandler.execute(new ClientExecutionParams<DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResponse>()
                    .withOperationName("DeletePublicIpv4Pool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePublicIpv4PoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePublicIpv4PoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     *
     * @param deleteQueuedReservedInstancesRequest
     * @return Result of the DeleteQueuedReservedInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteQueuedReservedInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteQueuedReservedInstancesResponse deleteQueuedReservedInstances(
            DeleteQueuedReservedInstancesRequest deleteQueuedReservedInstancesRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteQueuedReservedInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteQueuedReservedInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueuedReservedInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteQueuedReservedInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueuedReservedInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteQueuedReservedInstancesRequest, DeleteQueuedReservedInstancesResponse>()
                            .withOperationName("DeleteQueuedReservedInstances").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteQueuedReservedInstancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteQueuedReservedInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     *
     * @param deleteRouteRequest
     * @return Result of the DeleteRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRouteResponse deleteRoute(DeleteRouteRequest deleteRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoute");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouteRequest, DeleteRouteResponse>()
                    .withOperationName("DeleteRoute").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRouteRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified route server.
     * </p>
     * <p>
     * Amazon VPC Route Server simplifies routing for traffic between workloads that are deployed within a VPC and its
     * internet gateways. With this feature, VPC Route Server dynamically updates VPC and internet gateway route tables
     * with your preferred IPv4 or IPv6 routes to achieve routing fault tolerance for those workloads. This enables you
     * to automatically reroute traffic within a VPC, which increases the manageability of VPC routing and
     * interoperability with third-party workloads.
     * </p>
     * <p>
     * Route server supports the follow route table types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VPC route tables not associated with subnets
     * </p>
     * </li>
     * <li>
     * <p>
     * Subnet route tables
     * </p>
     * </li>
     * <li>
     * <p>
     * Internet gateway route tables
     * </p>
     * </li>
     * </ul>
     * <p>
     * Route server does not support route tables associated with virtual private gateways. To propagate routes into a
     * transit gateway route table, use <a href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html">Transit
     * Gateway Connect</a>.
     * </p>
     * <p>
     * For more information see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html">Dynamic routing in your
     * VPC with VPC Route Server</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param deleteRouteServerRequest
     * @return Result of the DeleteRouteServer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRouteServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRouteServerResponse deleteRouteServer(DeleteRouteServerRequest deleteRouteServerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteRouteServerResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRouteServerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouteServerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteServer");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouteServerRequest, DeleteRouteServerResponse>()
                    .withOperationName("DeleteRouteServer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRouteServerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouteServerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified route server endpoint.
     * </p>
     * <p>
     * A route server endpoint is an Amazon Web Services-managed component inside a subnet that facilitates <a
     * href="https://en.wikipedia.org/wiki/Border_Gateway_Protocol">BGP (Border Gateway Protocol)</a> connections
     * between your route server and your BGP peers.
     * </p>
     *
     * @param deleteRouteServerEndpointRequest
     * @return Result of the DeleteRouteServerEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRouteServerEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRouteServerEndpointResponse deleteRouteServerEndpoint(
            DeleteRouteServerEndpointRequest deleteRouteServerEndpointRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteRouteServerEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRouteServerEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouteServerEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteServerEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteServerEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRouteServerEndpointRequest, DeleteRouteServerEndpointResponse>()
                            .withOperationName("DeleteRouteServerEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRouteServerEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRouteServerEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified BGP peer from a route server.
     * </p>
     * <p>
     * A route server peer is a session between a route server endpoint and the device deployed in Amazon Web Services
     * (such as a firewall appliance or other network security function running on an EC2 instance). The device must
     * meet these requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Have an elastic network interface in the VPC
     * </p>
     * </li>
     * <li>
     * <p>
     * Support BGP (Border Gateway Protocol)
     * </p>
     * </li>
     * <li>
     * <p>
     * Can initiate BGP sessions
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteRouteServerPeerRequest
     * @return Result of the DeleteRouteServerPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRouteServerPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteServerPeer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRouteServerPeerResponse deleteRouteServerPeer(DeleteRouteServerPeerRequest deleteRouteServerPeerRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteRouteServerPeerResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRouteServerPeerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouteServerPeerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteServerPeerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteServerPeer");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouteServerPeerRequest, DeleteRouteServerPeerResponse>()
                    .withOperationName("DeleteRouteServerPeer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRouteServerPeerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouteServerPeerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     *
     * @param deleteRouteTableRequest
     * @return Result of the DeleteRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRouteTableResponse deleteRouteTable(DeleteRouteTableRequest deleteRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRouteTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRouteTable");

            return clientHandler.execute(new ClientExecutionParams<DeleteRouteTableRequest, DeleteRouteTableResponse>()
                    .withOperationName("DeleteRouteTable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRouteTableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance or network interface, is referenced
     * by another security group in the same VPC, or has a VPC association, the operation fails with
     * <code>DependencyViolation</code>.
     * </p>
     *
     * @param deleteSecurityGroupRequest
     * @return Result of the DeleteSecurityGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSecurityGroupResponse deleteSecurityGroup(DeleteSecurityGroupRequest deleteSecurityGroupRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteSecurityGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSecurityGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteSecurityGroupRequest, DeleteSecurityGroupResponse>()
                    .withOperationName("DeleteSecurityGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSecurityGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * deregister the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param deleteSnapshotRequest
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSnapshotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");

            return clientHandler.execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                    .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     *
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return Result of the DeleteSpotDatafeedSubscription operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSpotDatafeedSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSpotDatafeedSubscriptionResponse deleteSpotDatafeedSubscription(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteSpotDatafeedSubscriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSpotDatafeedSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSpotDatafeedSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteSpotDatafeedSubscriptionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSpotDatafeedSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSpotDatafeedSubscriptionRequest, DeleteSpotDatafeedSubscriptionResponse>()
                            .withOperationName("DeleteSpotDatafeedSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteSpotDatafeedSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSpotDatafeedSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     *
     * @param deleteSubnetRequest
     * @return Result of the DeleteSubnet operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSubnet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSubnetResponse deleteSubnet(DeleteSubnetRequest deleteSubnetRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteSubnetResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSubnetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSubnetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSubnetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSubnet");

            return clientHandler.execute(new ClientExecutionParams<DeleteSubnetRequest, DeleteSubnetResponse>()
                    .withOperationName("DeleteSubnet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSubnetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSubnetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     *
     * @param deleteSubnetCidrReservationRequest
     * @return Result of the DeleteSubnetCidrReservation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteSubnetCidrReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSubnetCidrReservationResponse deleteSubnetCidrReservation(
            DeleteSubnetCidrReservationRequest deleteSubnetCidrReservationRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteSubnetCidrReservationResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSubnetCidrReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSubnetCidrReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSubnetCidrReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSubnetCidrReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSubnetCidrReservationRequest, DeleteSubnetCidrReservationResponse>()
                            .withOperationName("DeleteSubnetCidrReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteSubnetCidrReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSubnetCidrReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");

            return clientHandler.execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>()
                    .withOperationName("DeleteTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRequest
     * @return Result of the DeleteTrafficMirrorFilter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteTrafficMirrorFilterResponse deleteTrafficMirrorFilter(
            DeleteTrafficMirrorFilterRequest deleteTrafficMirrorFilterRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteTrafficMirrorFilterResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTrafficMirrorFilterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficMirrorFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorFilter");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorFilterRequest, DeleteTrafficMirrorFilterResponse>()
                            .withOperationName("DeleteTrafficMirrorFilter").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTrafficMirrorFilterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTrafficMirrorFilterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     *
     * @param deleteTrafficMirrorFilterRuleRequest
     * @return Result of the DeleteTrafficMirrorFilterRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorFilterRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrafficMirrorFilterRuleResponse deleteTrafficMirrorFilterRule(
            DeleteTrafficMirrorFilterRuleRequest deleteTrafficMirrorFilterRuleRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTrafficMirrorFilterRuleResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTrafficMirrorFilterRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorFilterRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTrafficMirrorFilterRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorFilterRule");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorFilterRuleRequest, DeleteTrafficMirrorFilterRuleResponse>()
                            .withOperationName("DeleteTrafficMirrorFilterRule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTrafficMirrorFilterRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTrafficMirrorFilterRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorSessionRequest
     * @return Result of the DeleteTrafficMirrorSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrafficMirrorSessionResponse deleteTrafficMirrorSession(
            DeleteTrafficMirrorSessionRequest deleteTrafficMirrorSessionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteTrafficMirrorSessionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTrafficMirrorSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficMirrorSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorSession");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorSessionRequest, DeleteTrafficMirrorSessionResponse>()
                            .withOperationName("DeleteTrafficMirrorSession").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTrafficMirrorSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTrafficMirrorSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     *
     * @param deleteTrafficMirrorTargetRequest
     * @return Result of the DeleteTrafficMirrorTarget operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTrafficMirrorTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteTrafficMirrorTargetResponse deleteTrafficMirrorTarget(
            DeleteTrafficMirrorTargetRequest deleteTrafficMirrorTargetRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteTrafficMirrorTargetResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTrafficMirrorTargetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrafficMirrorTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrafficMirrorTargetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrafficMirrorTarget");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTrafficMirrorTargetRequest, DeleteTrafficMirrorTargetResponse>()
                            .withOperationName("DeleteTrafficMirrorTarget").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTrafficMirrorTargetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTrafficMirrorTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     *
     * @param deleteTransitGatewayRequest
     * @return Result of the DeleteTransitGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTransitGatewayResponse deleteTransitGateway(DeleteTransitGatewayRequest deleteTransitGatewayRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTransitGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteTransitGatewayRequest, DeleteTransitGatewayResponse>()
                    .withOperationName("DeleteTransitGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTransitGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     *
     * @param deleteTransitGatewayConnectRequest
     * @return Result of the DeleteTransitGatewayConnect operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayConnectResponse deleteTransitGatewayConnect(
            DeleteTransitGatewayConnectRequest deleteTransitGatewayConnectRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayConnectResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayConnectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayConnectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTransitGatewayConnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayConnect");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayConnectRequest, DeleteTransitGatewayConnectResponse>()
                            .withOperationName("DeleteTransitGatewayConnect").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayConnectRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayConnectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     *
     * @param deleteTransitGatewayConnectPeerRequest
     * @return Result of the DeleteTransitGatewayConnectPeer operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayConnectPeer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayConnectPeerResponse deleteTransitGatewayConnectPeer(
            DeleteTransitGatewayConnectPeerRequest deleteTransitGatewayConnectPeerRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayConnectPeerResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayConnectPeerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayConnectPeerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayConnectPeerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayConnectPeer");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayConnectPeerRequest, DeleteTransitGatewayConnectPeerResponse>()
                            .withOperationName("DeleteTransitGatewayConnectPeer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayConnectPeerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayConnectPeerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     *
     * @param deleteTransitGatewayMulticastDomainRequest
     * @return Result of the DeleteTransitGatewayMulticastDomain operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayMulticastDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayMulticastDomainResponse deleteTransitGatewayMulticastDomain(
            DeleteTransitGatewayMulticastDomainRequest deleteTransitGatewayMulticastDomainRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayMulticastDomainResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayMulticastDomainResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayMulticastDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayMulticastDomainRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayMulticastDomain");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayMulticastDomainRequest, DeleteTransitGatewayMulticastDomainResponse>()
                            .withOperationName("DeleteTransitGatewayMulticastDomain").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayMulticastDomainRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayMulticastDomainRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     *
     * @param deleteTransitGatewayPeeringAttachmentRequest
     * @return Result of the DeleteTransitGatewayPeeringAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPeeringAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayPeeringAttachmentResponse deleteTransitGatewayPeeringAttachment(
            DeleteTransitGatewayPeeringAttachmentRequest deleteTransitGatewayPeeringAttachmentRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayPeeringAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayPeeringAttachmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayPeeringAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayPeeringAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayPeeringAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayPeeringAttachmentRequest, DeleteTransitGatewayPeeringAttachmentResponse>()
                            .withOperationName("DeleteTransitGatewayPeeringAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteTransitGatewayPeeringAttachmentRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayPeeringAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway policy table.
     * </p>
     *
     * @param deleteTransitGatewayPolicyTableRequest
     * @return Result of the DeleteTransitGatewayPolicyTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPolicyTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayPolicyTableResponse deleteTransitGatewayPolicyTable(
            DeleteTransitGatewayPolicyTableRequest deleteTransitGatewayPolicyTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayPolicyTableResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayPolicyTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayPolicyTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayPolicyTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayPolicyTable");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayPolicyTableRequest, DeleteTransitGatewayPolicyTableResponse>()
                            .withOperationName("DeleteTransitGatewayPolicyTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayPolicyTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayPolicyTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayPrefixListReferenceRequest
     * @return Result of the DeleteTransitGatewayPrefixListReference operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayPrefixListReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayPrefixListReferenceResponse deleteTransitGatewayPrefixListReference(
            DeleteTransitGatewayPrefixListReferenceRequest deleteTransitGatewayPrefixListReferenceRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayPrefixListReferenceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayPrefixListReferenceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayPrefixListReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayPrefixListReferenceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayPrefixListReference");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayPrefixListReferenceRequest, DeleteTransitGatewayPrefixListReferenceResponse>()
                            .withOperationName("DeleteTransitGatewayPrefixListReference").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteTransitGatewayPrefixListReferenceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayPrefixListReferenceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayRouteRequest
     * @return Result of the DeleteTransitGatewayRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayRouteResponse deleteTransitGatewayRoute(
            DeleteTransitGatewayRouteRequest deleteTransitGatewayRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTransitGatewayRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayRoute");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRouteRequest, DeleteTransitGatewayRouteResponse>()
                            .withOperationName("DeleteTransitGatewayRoute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayRouteRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified transit gateway route table. If there are any route tables associated with the transit
     * gateway route table, you must first run <a>DisassociateRouteTable</a> before you can delete the transit gateway
     * route table. This removes any route tables associated with the transit gateway route table.
     * </p>
     *
     * @param deleteTransitGatewayRouteTableRequest
     * @return Result of the DeleteTransitGatewayRouteTable operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRouteTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayRouteTableResponse deleteTransitGatewayRouteTable(
            DeleteTransitGatewayRouteTableRequest deleteTransitGatewayRouteTableRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayRouteTableResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayRouteTableResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayRouteTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayRouteTableRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayRouteTable");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRouteTableRequest, DeleteTransitGatewayRouteTableResponse>()
                            .withOperationName("DeleteTransitGatewayRouteTable").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayRouteTableRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayRouteTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Advertises to the transit gateway that a transit gateway route table is deleted.
     * </p>
     *
     * @param deleteTransitGatewayRouteTableAnnouncementRequest
     * @return Result of the DeleteTransitGatewayRouteTableAnnouncement operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayRouteTableAnnouncement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayRouteTableAnnouncementResponse deleteTransitGatewayRouteTableAnnouncement(
            DeleteTransitGatewayRouteTableAnnouncementRequest deleteTransitGatewayRouteTableAnnouncementRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayRouteTableAnnouncementResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayRouteTableAnnouncementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteTransitGatewayRouteTableAnnouncementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayRouteTableAnnouncementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayRouteTableAnnouncement");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayRouteTableAnnouncementRequest, DeleteTransitGatewayRouteTableAnnouncementResponse>()
                            .withOperationName("DeleteTransitGatewayRouteTableAnnouncement")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteTransitGatewayRouteTableAnnouncementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayRouteTableAnnouncementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     *
     * @param deleteTransitGatewayVpcAttachmentRequest
     * @return Result of the DeleteTransitGatewayVpcAttachment operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteTransitGatewayVpcAttachment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTransitGatewayVpcAttachmentResponse deleteTransitGatewayVpcAttachment(
            DeleteTransitGatewayVpcAttachmentRequest deleteTransitGatewayVpcAttachmentRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteTransitGatewayVpcAttachmentResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTransitGatewayVpcAttachmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransitGatewayVpcAttachmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTransitGatewayVpcAttachmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransitGatewayVpcAttachment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTransitGatewayVpcAttachmentRequest, DeleteTransitGatewayVpcAttachmentResponse>()
                            .withOperationName("DeleteTransitGatewayVpcAttachment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTransitGatewayVpcAttachmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTransitGatewayVpcAttachmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access endpoint.
     * </p>
     *
     * @param deleteVerifiedAccessEndpointRequest
     * @return Result of the DeleteVerifiedAccessEndpoint operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVerifiedAccessEndpointResponse deleteVerifiedAccessEndpoint(
            DeleteVerifiedAccessEndpointRequest deleteVerifiedAccessEndpointRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVerifiedAccessEndpointResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVerifiedAccessEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVerifiedAccessEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVerifiedAccessEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVerifiedAccessEndpoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVerifiedAccessEndpointRequest, DeleteVerifiedAccessEndpointResponse>()
                            .withOperationName("DeleteVerifiedAccessEndpoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVerifiedAccessEndpointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVerifiedAccessEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access group.
     * </p>
     *
     * @param deleteVerifiedAccessGroupRequest
     * @return Result of the DeleteVerifiedAccessGroup operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteVerifiedAccessGroupResponse deleteVerifiedAccessGroup(
            DeleteVerifiedAccessGroupRequest deleteVerifiedAccessGroupRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteVerifiedAccessGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVerifiedAccessGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVerifiedAccessGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVerifiedAccessGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVerifiedAccessGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVerifiedAccessGroupRequest, DeleteVerifiedAccessGroupResponse>()
                            .withOperationName("DeleteVerifiedAccessGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVerifiedAccessGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVerifiedAccessGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access instance.
     * </p>
     *
     * @param deleteVerifiedAccessInstanceRequest
     * @return Result of the DeleteVerifiedAccessInstance operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVerifiedAccessInstanceResponse deleteVerifiedAccessInstance(
            DeleteVerifiedAccessInstanceRequest deleteVerifiedAccessInstanceRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVerifiedAccessInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVerifiedAccessInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVerifiedAccessInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVerifiedAccessInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVerifiedAccessInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVerifiedAccessInstanceRequest, DeleteVerifiedAccessInstanceResponse>()
                            .withOperationName("DeleteVerifiedAccessInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVerifiedAccessInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVerifiedAccessInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access trust provider.
     * </p>
     *
     * @param deleteVerifiedAccessTrustProviderRequest
     * @return Result of the DeleteVerifiedAccessTrustProvider operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVerifiedAccessTrustProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVerifiedAccessTrustProviderResponse deleteVerifiedAccessTrustProvider(
            DeleteVerifiedAccessTrustProviderRequest deleteVerifiedAccessTrustProviderRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVerifiedAccessTrustProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVerifiedAccessTrustProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVerifiedAccessTrustProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVerifiedAccessTrustProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVerifiedAccessTrustProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVerifiedAccessTrustProviderRequest, DeleteVerifiedAccessTrustProviderResponse>()
                            .withOperationName("DeleteVerifiedAccessTrustProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVerifiedAccessTrustProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVerifiedAccessTrustProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-volume.html">Delete an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     *
     * @param deleteVolumeRequest
     * @return Result of the DeleteVolume operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVolumeResponse deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVolumeResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVolumeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVolumeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVolumeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVolume");

            return clientHandler.execute(new ClientExecutionParams<DeleteVolumeRequest, DeleteVolumeResponse>()
                    .withOperationName("DeleteVolume").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVolumeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVolumeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on. When you delete the VPC, it deletes the default security group, network ACL, and
     * route table for the VPC.
     * </p>
     * <p>
     * If you created a flow log for the VPC that you are deleting, note that flow logs for deleted VPCs are eventually
     * automatically removed.
     * </p>
     *
     * @param deleteVpcRequest
     * @return Result of the DeleteVpc operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpc
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVpcResponse deleteVpc(DeleteVpcRequest deleteVpcRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteVpcResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpcResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpc");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpcRequest, DeleteVpcResponse>()
                    .withOperationName("DeleteVpc").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteVpcRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpcRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single
     * VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You
     * can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there
     * is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html">Block public access to VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     *
     * @param deleteVpcBlockPublicAccessExclusionRequest
     * @return Result of the DeleteVpcBlockPublicAccessExclusion operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcBlockPublicAccessExclusion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcBlockPublicAccessExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpcBlockPublicAccessExclusionResponse deleteVpcBlockPublicAccessExclusion(
            DeleteVpcBlockPublicAccessExclusionRequest deleteVpcBlockPublicAccessExclusionRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVpcBlockPublicAccessExclusionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpcBlockPublicAccessExclusionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcBlockPublicAccessExclusionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVpcBlockPublicAccessExclusionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcBlockPublicAccessExclusion");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcBlockPublicAccessExclusionRequest, DeleteVpcBlockPublicAccessExclusionResponse>()
                            .withOperationName("DeleteVpcBlockPublicAccessExclusion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVpcBlockPublicAccessExclusionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVpcBlockPublicAccessExclusionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified VPC endpoint connection notifications.
     * </p>
     *
     * @param deleteVpcEndpointConnectionNotificationsRequest
     * @return Result of the DeleteVpcEndpointConnectionNotifications operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpointConnectionNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpcEndpointConnectionNotificationsResponse deleteVpcEndpointConnectionNotifications(
            DeleteVpcEndpointConnectionNotificationsRequest deleteVpcEndpointConnectionNotificationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVpcEndpointConnectionNotificationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpcEndpointConnectionNotificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteVpcEndpointConnectionNotificationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVpcEndpointConnectionNotificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcEndpointConnectionNotifications");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointConnectionNotificationsRequest, DeleteVpcEndpointConnectionNotificationsResponse>()
                            .withOperationName("DeleteVpcEndpointConnectionNotifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteVpcEndpointConnectionNotificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVpcEndpointConnectionNotificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified VPC endpoint service configurations. Before you can delete an endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     *
     * @param deleteVpcEndpointServiceConfigurationsRequest
     * @return Result of the DeleteVpcEndpointServiceConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpointServiceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpcEndpointServiceConfigurationsResponse deleteVpcEndpointServiceConfigurations(
            DeleteVpcEndpointServiceConfigurationsRequest deleteVpcEndpointServiceConfigurationsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVpcEndpointServiceConfigurationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpcEndpointServiceConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcEndpointServiceConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVpcEndpointServiceConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcEndpointServiceConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointServiceConfigurationsRequest, DeleteVpcEndpointServiceConfigurationsResponse>()
                            .withOperationName("DeleteVpcEndpointServiceConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteVpcEndpointServiceConfigurationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVpcEndpointServiceConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified VPC endpoints.
     * </p>
     * <p>
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables for the endpoint.
     * </p>
     * <p>
     * When you delete a Gateway Load Balancer endpoint, we delete its endpoint network interfaces. You can only delete
     * Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * </p>
     * <p>
     * When you delete an interface endpoint, we delete its endpoint network interfaces.
     * </p>
     *
     * @param deleteVpcEndpointsRequest
     * @return Result of the DeleteVpcEndpoints operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVpcEndpointsResponse deleteVpcEndpoints(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVpcEndpointsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpcEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcEndpoints");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpcEndpointsRequest, DeleteVpcEndpointsResponse>()
                    .withOperationName("DeleteVpcEndpoints").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVpcEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpcEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> or <code>rejected</code> state.
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     * @return Result of the DeleteVpcPeeringConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpcPeeringConnectionResponse deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteVpcPeeringConnectionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpcPeeringConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcPeeringConnection");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResponse>()
                            .withOperationName("DeleteVpcPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVpcPeeringConnectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVpcPeeringConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the
     * Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     *
     * @param deleteVpnConnectionRequest
     *        Contains the parameters for DeleteVpnConnection.
     * @return Result of the DeleteVpnConnection operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVpnConnectionResponse deleteVpnConnection(DeleteVpnConnectionRequest deleteVpnConnectionRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVpnConnectionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpnConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpnConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpnConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpnConnection");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpnConnectionRequest, DeleteVpnConnectionResponse>()
                    .withOperationName("DeleteVpnConnection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVpnConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpnConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     *
     * @param deleteVpnConnectionRouteRequest
     *        Contains the parameters for DeleteVpnConnectionRoute.
     * @return Result of the DeleteVpnConnectionRoute operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnConnectionRoute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteVpnConnectionRouteResponse deleteVpnConnectionRoute(
            DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest) throws AwsServiceException, SdkClientException,
            Ec2Exception {

        HttpResponseHandler<DeleteVpnConnectionRouteResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpnConnectionRouteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpnConnectionRouteRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpnConnectionRouteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpnConnectionRoute");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVpnConnectionRouteRequest, DeleteVpnConnectionRouteResponse>()
                            .withOperationName("DeleteVpnConnectionRoute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteVpnConnectionRouteRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVpnConnectionRouteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     *
     * @param deleteVpnGatewayRequest
     *        Contains the parameters for DeleteVpnGateway.
     * @return Result of the DeleteVpnGateway operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeleteVpnGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVpnGatewayResponse deleteVpnGateway(DeleteVpnGatewayRequest deleteVpnGatewayRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeleteVpnGatewayResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVpnGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpnGatewayRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpnGatewayRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpnGateway");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpnGatewayRequest, DeleteVpnGatewayResponse>()
                    .withOperationName("DeleteVpnGateway").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVpnGatewayRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpnGatewayRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return Result of the DeprovisionByoipCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeprovisionByoipCidrResponse deprovisionByoipCidr(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeprovisionByoipCidrResponse> responseHandler = protocolFactory
                .createResponseHandler(DeprovisionByoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprovisionByoipCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprovisionByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprovisionByoipCidr");

            return clientHandler.execute(new ClientExecutionParams<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResponse>()
                    .withOperationName("DeprovisionByoipCidr").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deprovisionByoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeprovisionByoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account. This action can only be
     * called after any BYOIP CIDR associations are removed from your Amazon Web Services account with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamByoasn.html"
     * >DisassociateIpamByoasn</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     *
     * @param deprovisionIpamByoasnRequest
     * @return Result of the DeprovisionIpamByoasn operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionIpamByoasn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeprovisionIpamByoasnResponse deprovisionIpamByoasn(DeprovisionIpamByoasnRequest deprovisionIpamByoasnRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeprovisionIpamByoasnResponse> responseHandler = protocolFactory
                .createResponseHandler(DeprovisionIpamByoasnResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprovisionIpamByoasnRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprovisionIpamByoasnRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprovisionIpamByoasn");

            return clientHandler.execute(new ClientExecutionParams<DeprovisionIpamByoasnRequest, DeprovisionIpamByoasnResponse>()
                    .withOperationName("DeprovisionIpamByoasn").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deprovisionIpamByoasnRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeprovisionIpamByoasnRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool,
     * the CIDR is recycled back into the source pool. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     *
     * @param deprovisionIpamPoolCidrRequest
     * @return Result of the DeprovisionIpamPoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionIpamPoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeprovisionIpamPoolCidrResponse deprovisionIpamPoolCidr(DeprovisionIpamPoolCidrRequest deprovisionIpamPoolCidrRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeprovisionIpamPoolCidrResponse> responseHandler = protocolFactory
                .createResponseHandler(DeprovisionIpamPoolCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprovisionIpamPoolCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprovisionIpamPoolCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprovisionIpamPoolCidr");

            return clientHandler
                    .execute(new ClientExecutionParams<DeprovisionIpamPoolCidrRequest, DeprovisionIpamPoolCidrResponse>()
                            .withOperationName("DeprovisionIpamPoolCidr").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deprovisionIpamPoolCidrRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeprovisionIpamPoolCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deprovision a CIDR from a public IPv4 pool.
     * </p>
     *
     * @param deprovisionPublicIpv4PoolCidrRequest
     * @return Result of the DeprovisionPublicIpv4PoolCidr operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeprovisionPublicIpv4PoolCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeprovisionPublicIpv4PoolCidrResponse deprovisionPublicIpv4PoolCidr(
            DeprovisionPublicIpv4PoolCidrRequest deprovisionPublicIpv4PoolCidrRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeprovisionPublicIpv4PoolCidrResponse> responseHandler = protocolFactory
                .createResponseHandler(DeprovisionPublicIpv4PoolCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprovisionPublicIpv4PoolCidrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deprovisionPublicIpv4PoolCidrRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprovisionPublicIpv4PoolCidr");

            return clientHandler
                    .execute(new ClientExecutionParams<DeprovisionPublicIpv4PoolCidrRequest, DeprovisionPublicIpv4PoolCidrResponse>()
                            .withOperationName("DeprovisionPublicIpv4PoolCidr").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deprovisionPublicIpv4PoolCidrRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeprovisionPublicIpv4PoolCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters the specified AMI. A deregistered AMI can't be used to launch new instances.
     * </p>
     * <p>
     * If a deregistered EBS-backed AMI matches a Recycle Bin retention rule, it moves to the Recycle Bin for the
     * specified retention period. It can be restored before its retention period expires, after which it is permanently
     * deleted. If the deregistered AMI doesn't match a retention rule, it is permanently deleted immediately. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Deregistering an AMI does not delete the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Instances already launched from the AMI. You'll continue to incur usage costs for the instances until you
     * terminate them.
     * </p>
     * </li>
     * <li>
     * <p>
     * For EBS-backed AMIs: The snapshots that were created of the root and data volumes of the instance during AMI
     * creation. You'll continue to incur snapshot storage costs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For instance store-backed AMIs: The files uploaded to Amazon S3 during AMI creation. You'll continue to incur S3
     * storage costs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister an Amazon EC2 AMI</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param deregisterImageRequest
     *        Contains the parameters for DeregisterImage.
     * @return Result of the DeregisterImage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeregisterImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeregisterImageResponse deregisterImage(DeregisterImageRequest deregisterImageRequest) throws AwsServiceException,
            SdkClientException, Ec2Exception {

        HttpResponseHandler<DeregisterImageResponse> responseHandler = protocolFactory
                .createResponseHandler(DeregisterImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterImage");

            return clientHandler.execute(new ClientExecutionParams<DeregisterImageRequest, DeregisterImageResponse>()
                    .withOperationName("DeregisterImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deregisterImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeregisterImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event
     * notifications for resources in the Region.
     * </p>
     *
     * @param deregisterInstanceEventNotificationAttributesRequest
     * @return Result of the DeregisterInstanceEventNotificationAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeregisterInstanceEventNotificationAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterInstanceEventNotificationAttributesResponse deregisterInstanceEventNotificationAttributes(
            DeregisterInstanceEventNotificationAttributesRequest deregisterInstanceEventNotificationAttributesRequest)
            throws AwsServiceException, SdkClientException, Ec2Exception {

        HttpResponseHandler<DeregisterInstanceEventNotificationAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DeregisterInstanceEventNotificationAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deregisterInstanceEventNotificationAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterInstanceEventNotificationAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "EC2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterInstanceEventNotificationAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterInstanceEventNotificationAttributesRequest, DeregisterInstanceEventNotificationAttributesResponse>()
                            .withOperationName("DeregisterInstanceEventNotificationAttributes")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deregisterInstanceEventNotificationAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterInstanceEventNotificationAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
     * </p>
     *
     * @param deregisterTransitGatewayMulticastGroupMembersRequest
     * @return Result of the DeregisterTransitGatewayMulticastGroupMembers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2Client.DeregisterTransitGatewayMulticastGroupMembers
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Deregi