/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationTenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityBlockOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityBlockOffering> {
    private static final SdkField<String> CAPACITY_BLOCK_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityBlockOfferingId").getter(CapacityBlockOffering.getter(CapacityBlockOffering::capacityBlockOfferingId)).setter(CapacityBlockOffering.setter(Builder::capacityBlockOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockOfferingId").unmarshallLocationName("capacityBlockOfferingId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CapacityBlockOffering.getter(CapacityBlockOffering::instanceType)).setter(CapacityBlockOffering.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CapacityBlockOffering.getter(CapacityBlockOffering::availabilityZone)).setter(CapacityBlockOffering.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(CapacityBlockOffering.getter(CapacityBlockOffering::instanceCount)).setter(CapacityBlockOffering.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(CapacityBlockOffering.getter(CapacityBlockOffering::startDate)).setter(CapacityBlockOffering.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").unmarshallLocationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(CapacityBlockOffering.getter(CapacityBlockOffering::endDate)).setter(CapacityBlockOffering.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("endDate").build()}).build();
    private static final SdkField<Integer> CAPACITY_BLOCK_DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CapacityBlockDurationHours").getter(CapacityBlockOffering.getter(CapacityBlockOffering::capacityBlockDurationHours)).setter(CapacityBlockOffering.setter(Builder::capacityBlockDurationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockDurationHours").unmarshallLocationName("capacityBlockDurationHours").build()}).build();
    private static final SdkField<String> UPFRONT_FEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontFee").getter(CapacityBlockOffering.getter(CapacityBlockOffering::upfrontFee)).setter(CapacityBlockOffering.setter(Builder::upfrontFee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontFee").unmarshallLocationName("upfrontFee").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(CapacityBlockOffering.getter(CapacityBlockOffering::currencyCode)).setter(CapacityBlockOffering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CapacityBlockOffering.getter(CapacityBlockOffering::tenancyAsString)).setter(CapacityBlockOffering.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<Integer> CAPACITY_BLOCK_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CapacityBlockDurationMinutes").getter(CapacityBlockOffering.getter(CapacityBlockOffering::capacityBlockDurationMinutes)).setter(CapacityBlockOffering.setter(Builder::capacityBlockDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockDurationMinutes").unmarshallLocationName("capacityBlockDurationMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_OFFERING_ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_COUNT_FIELD, START_DATE_FIELD, END_DATE_FIELD, CAPACITY_BLOCK_DURATION_HOURS_FIELD, UPFRONT_FEE_FIELD, CURRENCY_CODE_FIELD, TENANCY_FIELD, CAPACITY_BLOCK_DURATION_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityBlockOffering.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityBlockOfferingId;
    private final String instanceType;
    private final String availabilityZone;
    private final Integer instanceCount;
    private final Instant startDate;
    private final Instant endDate;
    private final Integer capacityBlockDurationHours;
    private final String upfrontFee;
    private final String currencyCode;
    private final String tenancy;
    private final Integer capacityBlockDurationMinutes;

    private CapacityBlockOffering(BuilderImpl builder) {
        this.capacityBlockOfferingId = builder.capacityBlockOfferingId;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.instanceCount = builder.instanceCount;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.capacityBlockDurationHours = builder.capacityBlockDurationHours;
        this.upfrontFee = builder.upfrontFee;
        this.currencyCode = builder.currencyCode;
        this.tenancy = builder.tenancy;
        this.capacityBlockDurationMinutes = builder.capacityBlockDurationMinutes;
    }

    public final String capacityBlockOfferingId() {
        return this.capacityBlockOfferingId;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final Integer capacityBlockDurationHours() {
        return this.capacityBlockDurationHours;
    }

    public final String upfrontFee() {
        return this.upfrontFee;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final Integer capacityBlockDurationMinutes() {
        return this.capacityBlockDurationMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockDurationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityBlockDurationMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityBlockOffering)) {
            return false;
        }
        CapacityBlockOffering other = (CapacityBlockOffering)obj;
        return Objects.equals(this.capacityBlockOfferingId(), other.capacityBlockOfferingId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.capacityBlockDurationHours(), other.capacityBlockDurationHours()) && Objects.equals(this.upfrontFee(), other.upfrontFee()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && Objects.equals(this.capacityBlockDurationMinutes(), other.capacityBlockDurationMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityBlockOffering").add("CapacityBlockOfferingId", (Object)this.capacityBlockOfferingId()).add("InstanceType", (Object)this.instanceType()).add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceCount", (Object)this.instanceCount()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("CapacityBlockDurationHours", (Object)this.capacityBlockDurationHours()).add("UpfrontFee", (Object)this.upfrontFee()).add("CurrencyCode", (Object)this.currencyCode()).add("Tenancy", (Object)this.tenancyAsString()).add("CapacityBlockDurationMinutes", (Object)this.capacityBlockDurationMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockOfferingId": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockOfferingId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "CapacityBlockDurationHours": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockDurationHours()));
            }
            case "UpfrontFee": {
                return Optional.ofNullable(clazz.cast(this.upfrontFee()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "CapacityBlockDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockDurationMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockOfferingId", CAPACITY_BLOCK_OFFERING_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("CapacityBlockDurationHours", CAPACITY_BLOCK_DURATION_HOURS_FIELD);
        map.put("UpfrontFee", UPFRONT_FEE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("CapacityBlockDurationMinutes", CAPACITY_BLOCK_DURATION_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityBlockOffering, T> g) {
        return obj -> g.apply((CapacityBlockOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityBlockOfferingId;
        private String instanceType;
        private String availabilityZone;
        private Integer instanceCount;
        private Instant startDate;
        private Instant endDate;
        private Integer capacityBlockDurationHours;
        private String upfrontFee;
        private String currencyCode;
        private String tenancy;
        private Integer capacityBlockDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityBlockOffering model) {
            this.capacityBlockOfferingId(model.capacityBlockOfferingId);
            this.instanceType(model.instanceType);
            this.availabilityZone(model.availabilityZone);
            this.instanceCount(model.instanceCount);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.capacityBlockDurationHours(model.capacityBlockDurationHours);
            this.upfrontFee(model.upfrontFee);
            this.currencyCode(model.currencyCode);
            this.tenancy(model.tenancy);
            this.capacityBlockDurationMinutes(model.capacityBlockDurationMinutes);
        }

        public final String getCapacityBlockOfferingId() {
            return this.capacityBlockOfferingId;
        }

        public final void setCapacityBlockOfferingId(String capacityBlockOfferingId) {
            this.capacityBlockOfferingId = capacityBlockOfferingId;
        }

        @Override
        public final Builder capacityBlockOfferingId(String capacityBlockOfferingId) {
            this.capacityBlockOfferingId = capacityBlockOfferingId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Integer getCapacityBlockDurationHours() {
            return this.capacityBlockDurationHours;
        }

        public final void setCapacityBlockDurationHours(Integer capacityBlockDurationHours) {
            this.capacityBlockDurationHours = capacityBlockDurationHours;
        }

        @Override
        public final Builder capacityBlockDurationHours(Integer capacityBlockDurationHours) {
            this.capacityBlockDurationHours = capacityBlockDurationHours;
            return this;
        }

        public final String getUpfrontFee() {
            return this.upfrontFee;
        }

        public final void setUpfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
        }

        @Override
        public final Builder upfrontFee(String upfrontFee) {
            this.upfrontFee = upfrontFee;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Integer getCapacityBlockDurationMinutes() {
            return this.capacityBlockDurationMinutes;
        }

        public final void setCapacityBlockDurationMinutes(Integer capacityBlockDurationMinutes) {
            this.capacityBlockDurationMinutes = capacityBlockDurationMinutes;
        }

        @Override
        public final Builder capacityBlockDurationMinutes(Integer capacityBlockDurationMinutes) {
            this.capacityBlockDurationMinutes = capacityBlockDurationMinutes;
            return this;
        }

        public CapacityBlockOffering build() {
            return new CapacityBlockOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityBlockOffering> {
        public Builder capacityBlockOfferingId(String var1);

        public Builder instanceType(String var1);

        public Builder availabilityZone(String var1);

        public Builder instanceCount(Integer var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder capacityBlockDurationHours(Integer var1);

        public Builder upfrontFee(String var1);

        public Builder currencyCode(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(CapacityReservationTenancy var1);

        public Builder capacityBlockDurationMinutes(Integer var1);
    }
}

