/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessEndpointRdsOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModifyVerifiedAccessEndpointRdsOptions> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(ModifyVerifiedAccessEndpointRdsOptions.getter(ModifyVerifiedAccessEndpointRdsOptions::subnetIds)).setter(ModifyVerifiedAccessEndpointRdsOptions.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(ModifyVerifiedAccessEndpointRdsOptions.getter(ModifyVerifiedAccessEndpointRdsOptions::port)).setter(ModifyVerifiedAccessEndpointRdsOptions.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").unmarshallLocationName("Port").build()}).build();
    private static final SdkField<String> RDS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsEndpoint").getter(ModifyVerifiedAccessEndpointRdsOptions.getter(ModifyVerifiedAccessEndpointRdsOptions::rdsEndpoint)).setter(ModifyVerifiedAccessEndpointRdsOptions.setter(Builder::rdsEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsEndpoint").unmarshallLocationName("RdsEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD, PORT_FIELD, RDS_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVerifiedAccessEndpointRdsOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> subnetIds;
    private final Integer port;
    private final String rdsEndpoint;

    private ModifyVerifiedAccessEndpointRdsOptions(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.port = builder.port;
        this.rdsEndpoint = builder.rdsEndpoint;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final Integer port() {
        return this.port;
    }

    public final String rdsEndpoint() {
        return this.rdsEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessEndpointRdsOptions)) {
            return false;
        }
        ModifyVerifiedAccessEndpointRdsOptions other = (ModifyVerifiedAccessEndpointRdsOptions)obj;
        return this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.rdsEndpoint(), other.rdsEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessEndpointRdsOptions").add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Port", (Object)this.port()).add("RdsEndpoint", (Object)this.rdsEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "RdsEndpoint": {
                return Optional.ofNullable(clazz.cast(this.rdsEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetId", SUBNET_IDS_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("RdsEndpoint", RDS_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessEndpointRdsOptions, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessEndpointRdsOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Integer port;
        private String rdsEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessEndpointRdsOptions model) {
            this.subnetIds(model.subnetIds);
            this.port(model.port);
            this.rdsEndpoint(model.rdsEndpoint);
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ModifyVerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ModifyVerifiedAccessEndpointSubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getRdsEndpoint() {
            return this.rdsEndpoint;
        }

        public final void setRdsEndpoint(String rdsEndpoint) {
            this.rdsEndpoint = rdsEndpoint;
        }

        @Override
        public final Builder rdsEndpoint(String rdsEndpoint) {
            this.rdsEndpoint = rdsEndpoint;
            return this;
        }

        public ModifyVerifiedAccessEndpointRdsOptions build() {
            return new ModifyVerifiedAccessEndpointRdsOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessEndpointRdsOptions> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder port(Integer var1);

        public Builder rdsEndpoint(String var1);
    }
}

