/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAddressRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateAddressRequest.Builder, AssociateAddressRequest> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(AssociateAddressRequest::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("AllocationId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(AssociateAddressRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(AssociateAddressRequest::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("PublicIp").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(AssociateAddressRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssociateAddressRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(AssociateAddressRequest::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<Boolean> ALLOW_REASSOCIATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowReassociation")
            .getter(getter(AssociateAddressRequest::allowReassociation))
            .setter(setter(Builder::allowReassociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReassociation")
                    .unmarshallLocationName("allowReassociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            INSTANCE_ID_FIELD, PUBLIC_IP_FIELD, DRY_RUN_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD,
            ALLOW_REASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String allocationId;

    private final String instanceId;

    private final String publicIp;

    private final Boolean dryRun;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final Boolean allowReassociation;

    private AssociateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.dryRun = builder.dryRun;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.allowReassociation = builder.allowReassociation;
    }

    /**
     * <p>
     * The allocation ID. This is required.
     * </p>
     * 
     * @return The allocation ID. This is required.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID of the instance. The instance must have exactly one attached network interface. You can specify either the
     * instance ID or the network interface ID, but not both.
     * </p>
     * 
     * @return The ID of the instance. The instance must have exactly one attached network interface. You can specify
     *         either the instance ID or the network interface ID, but not both.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Deprecated.
     * </p>
     * 
     * @return Deprecated.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the network interface. If the instance has more than one network interface, you must specify a network
     * interface ID.
     * </p>
     * <p>
     * You can specify either the instance ID or the network interface ID, but not both.
     * </p>
     * 
     * @return The ID of the network interface. If the instance has more than one network interface, you must specify a
     *         network interface ID.</p>
     *         <p>
     *         You can specify either the instance ID or the network interface ID, but not both.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is
     * specified, the Elastic IP address is associated with the primary private IP address.
     * </p>
     * 
     * @return The primary or secondary private IP address to associate with the Elastic IP address. If no private IP
     *         address is specified, the Elastic IP address is associated with the primary private IP address.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * Reassociation is automatic, but you can specify false to ensure the operation fails if the Elastic IP address is
     * already associated with another resource.
     * </p>
     * 
     * @return Reassociation is automatic, but you can specify false to ensure the operation fails if the Elastic IP
     *         address is already associated with another resource.
     */
    public final Boolean allowReassociation() {
        return allowReassociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(allowReassociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAddressRequest)) {
            return false;
        }
        AssociateAddressRequest other = (AssociateAddressRequest) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(publicIp(), other.publicIp()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(allowReassociation(), other.allowReassociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAddressRequest").add("AllocationId", allocationId()).add("InstanceId", instanceId())
                .add("PublicIp", publicIp()).add("DryRun", dryRun()).add("NetworkInterfaceId", networkInterfaceId())
                .add("PrivateIpAddress", privateIpAddress()).add("AllowReassociation", allowReassociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "AllowReassociation":
            return Optional.ofNullable(clazz.cast(allowReassociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocationId", ALLOCATION_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("PublicIp", PUBLIC_IP_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("AllowReassociation", ALLOW_REASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAddressRequest, T> g) {
        return obj -> g.apply((AssociateAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateAddressRequest> {
        /**
         * <p>
         * The allocation ID. This is required.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID. This is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID of the instance. The instance must have exactly one attached network interface. You can specify either
         * the instance ID or the network interface ID, but not both.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance. The instance must have exactly one attached network interface. You can specify
         *        either the instance ID or the network interface ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Deprecated.
         * </p>
         * 
         * @param publicIp
         *        Deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the network interface. If the instance has more than one network interface, you must specify a
         * network interface ID.
         * </p>
         * <p>
         * You can specify either the instance ID or the network interface ID, but not both.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface. If the instance has more than one network interface, you must specify
         *        a network interface ID.</p>
         *        <p>
         *        You can specify either the instance ID or the network interface ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The primary or secondary private IP address to associate with the Elastic IP address. If no private IP
         * address is specified, the Elastic IP address is associated with the primary private IP address.
         * </p>
         * 
         * @param privateIpAddress
         *        The primary or secondary private IP address to associate with the Elastic IP address. If no private IP
         *        address is specified, the Elastic IP address is associated with the primary private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * Reassociation is automatic, but you can specify false to ensure the operation fails if the Elastic IP address
         * is already associated with another resource.
         * </p>
         * 
         * @param allowReassociation
         *        Reassociation is automatic, but you can specify false to ensure the operation fails if the Elastic IP
         *        address is already associated with another resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowReassociation(Boolean allowReassociation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String allocationId;

        private String instanceId;

        private String publicIp;

        private Boolean dryRun;

        private String networkInterfaceId;

        private String privateIpAddress;

        private Boolean allowReassociation;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAddressRequest model) {
            super(model);
            allocationId(model.allocationId);
            instanceId(model.instanceId);
            publicIp(model.publicIp);
            dryRun(model.dryRun);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
            allowReassociation(model.allowReassociation);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final Boolean getAllowReassociation() {
            return allowReassociation;
        }

        public final void setAllowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
        }

        @Override
        public final Builder allowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAddressRequest build() {
            return new AssociateAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
