/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCapacityReservationBySplittingResponse extends Ec2Response implements
        ToCopyableBuilder<CreateCapacityReservationBySplittingResponse.Builder, CreateCapacityReservationBySplittingResponse> {
    private static final SdkField<CapacityReservation> SOURCE_CAPACITY_RESERVATION_FIELD = SdkField
            .<CapacityReservation> builder(MarshallingType.SDK_POJO)
            .memberName("SourceCapacityReservation")
            .getter(getter(CreateCapacityReservationBySplittingResponse::sourceCapacityReservation))
            .setter(setter(Builder::sourceCapacityReservation))
            .constructor(CapacityReservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCapacityReservation")
                    .unmarshallLocationName("sourceCapacityReservation").build()).build();

    private static final SdkField<CapacityReservation> DESTINATION_CAPACITY_RESERVATION_FIELD = SdkField
            .<CapacityReservation> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationCapacityReservation")
            .getter(getter(CreateCapacityReservationBySplittingResponse::destinationCapacityReservation))
            .setter(setter(Builder::destinationCapacityReservation))
            .constructor(CapacityReservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCapacityReservation")
                    .unmarshallLocationName("destinationCapacityReservation").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(CreateCapacityReservationBySplittingResponse::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("instanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_CAPACITY_RESERVATION_FIELD, DESTINATION_CAPACITY_RESERVATION_FIELD, INSTANCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CapacityReservation sourceCapacityReservation;

    private final CapacityReservation destinationCapacityReservation;

    private final Integer instanceCount;

    private CreateCapacityReservationBySplittingResponse(BuilderImpl builder) {
        super(builder);
        this.sourceCapacityReservation = builder.sourceCapacityReservation;
        this.destinationCapacityReservation = builder.destinationCapacityReservation;
        this.instanceCount = builder.instanceCount;
    }

    /**
     * <p>
     * Information about the source Capacity Reservation.
     * </p>
     * 
     * @return Information about the source Capacity Reservation.
     */
    public final CapacityReservation sourceCapacityReservation() {
        return sourceCapacityReservation;
    }

    /**
     * <p>
     * Information about the destination Capacity Reservation.
     * </p>
     * 
     * @return Information about the destination Capacity Reservation.
     */
    public final CapacityReservation destinationCapacityReservation() {
        return destinationCapacityReservation;
    }

    /**
     * <p>
     * The number of instances in the new Capacity Reservation. The number of instances in the source Capacity
     * Reservation was reduced by this amount.
     * </p>
     * 
     * @return The number of instances in the new Capacity Reservation. The number of instances in the source Capacity
     *         Reservation was reduced by this amount.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceCapacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCapacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationBySplittingResponse)) {
            return false;
        }
        CreateCapacityReservationBySplittingResponse other = (CreateCapacityReservationBySplittingResponse) obj;
        return Objects.equals(sourceCapacityReservation(), other.sourceCapacityReservation())
                && Objects.equals(destinationCapacityReservation(), other.destinationCapacityReservation())
                && Objects.equals(instanceCount(), other.instanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCapacityReservationBySplittingResponse")
                .add("SourceCapacityReservation", sourceCapacityReservation())
                .add("DestinationCapacityReservation", destinationCapacityReservation()).add("InstanceCount", instanceCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceCapacityReservation":
            return Optional.ofNullable(clazz.cast(sourceCapacityReservation()));
        case "DestinationCapacityReservation":
            return Optional.ofNullable(clazz.cast(destinationCapacityReservation()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceCapacityReservation", SOURCE_CAPACITY_RESERVATION_FIELD);
        map.put("DestinationCapacityReservation", DESTINATION_CAPACITY_RESERVATION_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityReservationBySplittingResponse, T> g) {
        return obj -> g.apply((CreateCapacityReservationBySplittingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCapacityReservationBySplittingResponse> {
        /**
         * <p>
         * Information about the source Capacity Reservation.
         * </p>
         * 
         * @param sourceCapacityReservation
         *        Information about the source Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCapacityReservation(CapacityReservation sourceCapacityReservation);

        /**
         * <p>
         * Information about the source Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservation.Builder} avoiding the
         * need to create one manually via {@link CapacityReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservation.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceCapacityReservation(CapacityReservation)}.
         * 
         * @param sourceCapacityReservation
         *        a consumer that will call methods on {@link CapacityReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCapacityReservation(CapacityReservation)
         */
        default Builder sourceCapacityReservation(Consumer<CapacityReservation.Builder> sourceCapacityReservation) {
            return sourceCapacityReservation(CapacityReservation.builder().applyMutation(sourceCapacityReservation).build());
        }

        /**
         * <p>
         * Information about the destination Capacity Reservation.
         * </p>
         * 
         * @param destinationCapacityReservation
         *        Information about the destination Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCapacityReservation(CapacityReservation destinationCapacityReservation);

        /**
         * <p>
         * Information about the destination Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservation.Builder} avoiding the
         * need to create one manually via {@link CapacityReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservation.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationCapacityReservation(CapacityReservation)}.
         * 
         * @param destinationCapacityReservation
         *        a consumer that will call methods on {@link CapacityReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationCapacityReservation(CapacityReservation)
         */
        default Builder destinationCapacityReservation(Consumer<CapacityReservation.Builder> destinationCapacityReservation) {
            return destinationCapacityReservation(CapacityReservation.builder().applyMutation(destinationCapacityReservation)
                    .build());
        }

        /**
         * <p>
         * The number of instances in the new Capacity Reservation. The number of instances in the source Capacity
         * Reservation was reduced by this amount.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances in the new Capacity Reservation. The number of instances in the source
         *        Capacity Reservation was reduced by this amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private CapacityReservation sourceCapacityReservation;

        private CapacityReservation destinationCapacityReservation;

        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityReservationBySplittingResponse model) {
            super(model);
            sourceCapacityReservation(model.sourceCapacityReservation);
            destinationCapacityReservation(model.destinationCapacityReservation);
            instanceCount(model.instanceCount);
        }

        public final CapacityReservation.Builder getSourceCapacityReservation() {
            return sourceCapacityReservation != null ? sourceCapacityReservation.toBuilder() : null;
        }

        public final void setSourceCapacityReservation(CapacityReservation.BuilderImpl sourceCapacityReservation) {
            this.sourceCapacityReservation = sourceCapacityReservation != null ? sourceCapacityReservation.build() : null;
        }

        @Override
        public final Builder sourceCapacityReservation(CapacityReservation sourceCapacityReservation) {
            this.sourceCapacityReservation = sourceCapacityReservation;
            return this;
        }

        public final CapacityReservation.Builder getDestinationCapacityReservation() {
            return destinationCapacityReservation != null ? destinationCapacityReservation.toBuilder() : null;
        }

        public final void setDestinationCapacityReservation(CapacityReservation.BuilderImpl destinationCapacityReservation) {
            this.destinationCapacityReservation = destinationCapacityReservation != null ? destinationCapacityReservation.build()
                    : null;
        }

        @Override
        public final Builder destinationCapacityReservation(CapacityReservation destinationCapacityReservation) {
            this.destinationCapacityReservation = destinationCapacityReservation;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public CreateCapacityReservationBySplittingResponse build() {
            return new CreateCapacityReservationBySplittingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
