/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Tenancy {
    DEFAULT("default"),
    DEDICATED("dedicated"),
    HOST("host"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Tenancy> VALUE_MAP;
    private final String value;

    private Tenancy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Tenancy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Tenancy> knownValues() {
        EnumSet<Tenancy> knownValues = EnumSet.allOf(Tenancy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Tenancy.class, Tenancy::toString);
    }
}

