/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignIpv6AddressesRequest extends Ec2Request implements
        ToCopyableBuilder<AssignIpv6AddressesRequest.Builder, AssignIpv6AddressesRequest> {
    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6PrefixCount")
            .getter(getter(AssignIpv6AddressesRequest::ipv6PrefixCount))
            .setter(setter(Builder::ipv6PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount")
                    .unmarshallLocationName("Ipv6PrefixCount").build()).build();

    private static final SdkField<List<String>> IPV6_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(AssignIpv6AddressesRequest::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix")
                    .unmarshallLocationName("Ipv6Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssignIpv6AddressesRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<String>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(AssignIpv6AddressesRequest::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses")
                    .unmarshallLocationName("ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount")
            .getter(getter(AssignIpv6AddressesRequest::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount")
                    .unmarshallLocationName("ipv6AddressCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_PREFIX_COUNT_FIELD,
            IPV6_PREFIXES_FIELD, NETWORK_INTERFACE_ID_FIELD, IPV6_ADDRESSES_FIELD, IPV6_ADDRESS_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer ipv6PrefixCount;

    private final List<String> ipv6Prefixes;

    private final String networkInterfaceId;

    private final List<String> ipv6Addresses;

    private final Integer ipv6AddressCount;

    private AssignIpv6AddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipv6AddressCount = builder.ipv6AddressCount;
    }

    /**
     * <p>
     * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You cannot
     * use this option if you use the <code>Ipv6Prefixes</code> option.
     * </p>
     * 
     * @return The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You
     *         cannot use this option if you use the <code>Ipv6Prefixes</code> option.
     */
    public final Integer ipv6PrefixCount() {
        return ipv6PrefixCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv6 prefixes assigned to the network interface. You can't use this option if you use the
     * <code>Ipv6PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Prefixes} method.
     * </p>
     * 
     * @return One or more IPv6 prefixes assigned to the network interface. You can't use this option if you use the
     *         <code>Ipv6PrefixCount</code> option.
     */
    public final List<String> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a
     * number of IPv6 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses to be assigned to the network interface. You can't use this option if you're
     *         specifying a number of IPv6 addresses.
     */
    public final List<String> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6
     * addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network
     * interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option
     * if specifying specific IPv6 addresses.
     * </p>
     * 
     * @return The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6
     *         addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the
     *         network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't
     *         use this option if specifying specific IPv6 addresses.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesRequest)) {
            return false;
        }
        AssignIpv6AddressesRequest other = (AssignIpv6AddressesRequest) obj;
        return Objects.equals(ipv6PrefixCount(), other.ipv6PrefixCount()) && hasIpv6Prefixes() == other.hasIpv6Prefixes()
                && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignIpv6AddressesRequest").add("Ipv6PrefixCount", ipv6PrefixCount())
                .add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null).add("NetworkInterfaceId", networkInterfaceId())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null).add("Ipv6AddressCount", ipv6AddressCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv6PrefixCount()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ipv6PrefixCount", IPV6_PREFIX_COUNT_FIELD);
        map.put("Ipv6Prefix", IPV6_PREFIXES_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
        map.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssignIpv6AddressesRequest, T> g) {
        return obj -> g.apply((AssignIpv6AddressesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssignIpv6AddressesRequest> {
        /**
         * <p>
         * The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface. You
         * cannot use this option if you use the <code>Ipv6Prefixes</code> option.
         * </p>
         * 
         * @param ipv6PrefixCount
         *        The number of IPv6 prefixes that Amazon Web Services automatically assigns to the network interface.
         *        You cannot use this option if you use the <code>Ipv6Prefixes</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6PrefixCount(Integer ipv6PrefixCount);

        /**
         * <p>
         * One or more IPv6 prefixes assigned to the network interface. You can't use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 prefixes assigned to the network interface. You can't use this option if you use the
         *        <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<String> ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 prefixes assigned to the network interface. You can't use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 prefixes assigned to the network interface. You can't use this option if you use the
         *        <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(String... ipv6Prefixes);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a
         * number of IPv6 addresses.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses to be assigned to the network interface. You can't use this option if you're
         *        specifying a number of IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<String> ipv6Addresses);

        /**
         * <p>
         * The IPv6 addresses to be assigned to the network interface. You can't use this option if you're specifying a
         * number of IPv6 addresses.
         * </p>
         * 
         * @param ipv6Addresses
         *        The IPv6 addresses to be assigned to the network interface. You can't use this option if you're
         *        specifying a number of IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(String... ipv6Addresses);

        /**
         * <p>
         * The number of additional IPv6 addresses to assign to the network interface. The specified number of IPv6
         * addresses are assigned in addition to the existing IPv6 addresses that are already assigned to the network
         * interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this
         * option if specifying specific IPv6 addresses.
         * </p>
         * 
         * @param ipv6AddressCount
         *        The number of additional IPv6 addresses to assign to the network interface. The specified number of
         *        IPv6 addresses are assigned in addition to the existing IPv6 addresses that are already assigned to
         *        the network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You
         *        can't use this option if specifying specific IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer ipv6PrefixCount;

        private List<String> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private String networkInterfaceId;

        private List<String> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv6AddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesRequest model) {
            super(model);
            ipv6PrefixCount(model.ipv6PrefixCount);
            ipv6Prefixes(model.ipv6Prefixes);
            networkInterfaceId(model.networkInterfaceId);
            ipv6Addresses(model.ipv6Addresses);
            ipv6AddressCount(model.ipv6AddressCount);
        }

        public final Integer getIpv6PrefixCount() {
            return ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final Collection<String> getIpv6Prefixes() {
            if (ipv6Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv6Prefixes;
        }

        public final void setIpv6Prefixes(Collection<String> ipv6Prefixes) {
            this.ipv6Prefixes = IpPrefixListCopier.copy(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<String> ipv6Prefixes) {
            this.ipv6Prefixes = IpPrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(String... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getIpv6Addresses() {
            if (ipv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv6Addresses;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignIpv6AddressesRequest build() {
            return new AssignIpv6AddressesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
