/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportVerifiedAccessInstanceClientConfigurationResponse extends Ec2Response
        implements
        ToCopyableBuilder<ExportVerifiedAccessInstanceClientConfigurationResponse.Builder, ExportVerifiedAccessInstanceClientConfigurationResponse> {
    private static final SdkField<String> VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Version")
            .getter(getter(ExportVerifiedAccessInstanceClientConfigurationResponse::version))
            .setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version")
                    .unmarshallLocationName("version").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessInstanceId")
            .getter(getter(ExportVerifiedAccessInstanceClientConfigurationResponse::verifiedAccessInstanceId))
            .setter(setter(Builder::verifiedAccessInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId")
                    .unmarshallLocationName("verifiedAccessInstanceId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Region")
            .getter(getter(ExportVerifiedAccessInstanceClientConfigurationResponse::region))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region")
                    .unmarshallLocationName("region").build()).build();

    private static final SdkField<List<String>> DEVICE_TRUST_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceTrustProviders")
            .getter(getter(ExportVerifiedAccessInstanceClientConfigurationResponse::deviceTrustProvidersAsStrings))
            .setter(setter(Builder::deviceTrustProvidersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTrustProviderSet")
                    .unmarshallLocationName("deviceTrustProviderSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<VerifiedAccessInstanceUserTrustProviderClientConfiguration> USER_TRUST_PROVIDER_FIELD = SdkField
            .<VerifiedAccessInstanceUserTrustProviderClientConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("UserTrustProvider")
            .getter(getter(ExportVerifiedAccessInstanceClientConfigurationResponse::userTrustProvider))
            .setter(setter(Builder::userTrustProvider))
            .constructor(VerifiedAccessInstanceUserTrustProviderClientConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTrustProvider")
                    .unmarshallLocationName("userTrustProvider").build()).build();

    private static final SdkField<List<VerifiedAccessInstanceOpenVpnClientConfiguration>> OPEN_VPN_CONFIGURATIONS_FIELD = SdkField
            .<List<VerifiedAccessInstanceOpenVpnClientConfiguration>> builder(MarshallingType.LIST)
            .memberName("OpenVpnConfigurations")
            .getter(getter(ExportVerifiedAccessInstanceClientConfigurationResponse::openVpnConfigurations))
            .setter(setter(Builder::openVpnConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenVpnConfigurationSet")
                    .unmarshallLocationName("openVpnConfigurationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VerifiedAccessInstanceOpenVpnClientConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VerifiedAccessInstanceOpenVpnClientConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD,
            VERIFIED_ACCESS_INSTANCE_ID_FIELD, REGION_FIELD, DEVICE_TRUST_PROVIDERS_FIELD, USER_TRUST_PROVIDER_FIELD,
            OPEN_VPN_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String version;

    private final String verifiedAccessInstanceId;

    private final String region;

    private final List<String> deviceTrustProviders;

    private final VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider;

    private final List<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations;

    private ExportVerifiedAccessInstanceClientConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.region = builder.region;
        this.deviceTrustProviders = builder.deviceTrustProviders;
        this.userTrustProvider = builder.userTrustProvider;
        this.openVpnConfigurations = builder.openVpnConfigurations;
    }

    /**
     * <p>
     * The version.
     * </p>
     * 
     * @return The version.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The ID of the Verified Access instance.
     * </p>
     * 
     * @return The ID of the Verified Access instance.
     */
    public final String verifiedAccessInstanceId() {
        return verifiedAccessInstanceId;
    }

    /**
     * <p>
     * The Region.
     * </p>
     * 
     * @return The Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The device trust providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceTrustProviders} method.
     * </p>
     * 
     * @return The device trust providers.
     */
    public final List<DeviceTrustProviderType> deviceTrustProviders() {
        return DeviceTrustProviderTypeListCopier.copyStringToEnum(deviceTrustProviders);
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceTrustProviders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceTrustProviders() {
        return deviceTrustProviders != null && !(deviceTrustProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The device trust providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceTrustProviders} method.
     * </p>
     * 
     * @return The device trust providers.
     */
    public final List<String> deviceTrustProvidersAsStrings() {
        return deviceTrustProviders;
    }

    /**
     * <p>
     * The user identity trust provider.
     * </p>
     * 
     * @return The user identity trust provider.
     */
    public final VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider() {
        return userTrustProvider;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpenVpnConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOpenVpnConfigurations() {
        return openVpnConfigurations != null && !(openVpnConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Open VPN configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpenVpnConfigurations} method.
     * </p>
     * 
     * @return The Open VPN configuration.
     */
    public final List<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations() {
        return openVpnConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceTrustProviders() ? deviceTrustProvidersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userTrustProvider());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpenVpnConfigurations() ? openVpnConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportVerifiedAccessInstanceClientConfigurationResponse)) {
            return false;
        }
        ExportVerifiedAccessInstanceClientConfigurationResponse other = (ExportVerifiedAccessInstanceClientConfigurationResponse) obj;
        return Objects.equals(version(), other.version())
                && Objects.equals(verifiedAccessInstanceId(), other.verifiedAccessInstanceId())
                && Objects.equals(region(), other.region()) && hasDeviceTrustProviders() == other.hasDeviceTrustProviders()
                && Objects.equals(deviceTrustProvidersAsStrings(), other.deviceTrustProvidersAsStrings())
                && Objects.equals(userTrustProvider(), other.userTrustProvider())
                && hasOpenVpnConfigurations() == other.hasOpenVpnConfigurations()
                && Objects.equals(openVpnConfigurations(), other.openVpnConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportVerifiedAccessInstanceClientConfigurationResponse").add("Version", version())
                .add("VerifiedAccessInstanceId", verifiedAccessInstanceId()).add("Region", region())
                .add("DeviceTrustProviders", hasDeviceTrustProviders() ? deviceTrustProvidersAsStrings() : null)
                .add("UserTrustProvider", userTrustProvider())
                .add("OpenVpnConfigurations", hasOpenVpnConfigurations() ? openVpnConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VerifiedAccessInstanceId":
            return Optional.ofNullable(clazz.cast(verifiedAccessInstanceId()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "DeviceTrustProviders":
            return Optional.ofNullable(clazz.cast(deviceTrustProvidersAsStrings()));
        case "UserTrustProvider":
            return Optional.ofNullable(clazz.cast(userTrustProvider()));
        case "OpenVpnConfigurations":
            return Optional.ofNullable(clazz.cast(openVpnConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Version", VERSION_FIELD);
        map.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("DeviceTrustProviderSet", DEVICE_TRUST_PROVIDERS_FIELD);
        map.put("UserTrustProvider", USER_TRUST_PROVIDER_FIELD);
        map.put("OpenVpnConfigurationSet", OPEN_VPN_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportVerifiedAccessInstanceClientConfigurationResponse, T> g) {
        return obj -> g.apply((ExportVerifiedAccessInstanceClientConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportVerifiedAccessInstanceClientConfigurationResponse> {
        /**
         * <p>
         * The version.
         * </p>
         * 
         * @param version
         *        The version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The ID of the Verified Access instance.
         * </p>
         * 
         * @param verifiedAccessInstanceId
         *        The ID of the Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessInstanceId(String verifiedAccessInstanceId);

        /**
         * <p>
         * The Region.
         * </p>
         * 
         * @param region
         *        The Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The device trust providers.
         * </p>
         * 
         * @param deviceTrustProviders
         *        The device trust providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTrustProvidersWithStrings(Collection<String> deviceTrustProviders);

        /**
         * <p>
         * The device trust providers.
         * </p>
         * 
         * @param deviceTrustProviders
         *        The device trust providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTrustProvidersWithStrings(String... deviceTrustProviders);

        /**
         * <p>
         * The device trust providers.
         * </p>
         * 
         * @param deviceTrustProviders
         *        The device trust providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTrustProviders(Collection<DeviceTrustProviderType> deviceTrustProviders);

        /**
         * <p>
         * The device trust providers.
         * </p>
         * 
         * @param deviceTrustProviders
         *        The device trust providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTrustProviders(DeviceTrustProviderType... deviceTrustProviders);

        /**
         * <p>
         * The user identity trust provider.
         * </p>
         * 
         * @param userTrustProvider
         *        The user identity trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider);

        /**
         * <p>
         * The user identity trust provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder} avoiding the need to create one
         * manually via {@link VerifiedAccessInstanceUserTrustProviderClientConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #userTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration)}.
         * 
         * @param userTrustProvider
         *        a consumer that will call methods on
         *        {@link VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration)
         */
        default Builder userTrustProvider(
                Consumer<VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder> userTrustProvider) {
            return userTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration.builder()
                    .applyMutation(userTrustProvider).build());
        }

        /**
         * <p>
         * The Open VPN configuration.
         * </p>
         * 
         * @param openVpnConfigurations
         *        The Open VPN configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openVpnConfigurations(Collection<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations);

        /**
         * <p>
         * The Open VPN configuration.
         * </p>
         * 
         * @param openVpnConfigurations
         *        The Open VPN configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openVpnConfigurations(VerifiedAccessInstanceOpenVpnClientConfiguration... openVpnConfigurations);

        /**
         * <p>
         * The Open VPN configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #openVpnConfigurations(List<VerifiedAccessInstanceOpenVpnClientConfiguration>)}.
         * 
         * @param openVpnConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceOpenVpnClientConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openVpnConfigurations(java.util.Collection<VerifiedAccessInstanceOpenVpnClientConfiguration>)
         */
        Builder openVpnConfigurations(Consumer<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder>... openVpnConfigurations);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String version;

        private String verifiedAccessInstanceId;

        private String region;

        private List<String> deviceTrustProviders = DefaultSdkAutoConstructList.getInstance();

        private VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider;

        private List<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportVerifiedAccessInstanceClientConfigurationResponse model) {
            super(model);
            version(model.version);
            verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            region(model.region);
            deviceTrustProvidersWithStrings(model.deviceTrustProviders);
            userTrustProvider(model.userTrustProvider);
            openVpnConfigurations(model.openVpnConfigurations);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getVerifiedAccessInstanceId() {
            return verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Collection<String> getDeviceTrustProviders() {
            if (deviceTrustProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceTrustProviders;
        }

        public final void setDeviceTrustProviders(Collection<String> deviceTrustProviders) {
            this.deviceTrustProviders = DeviceTrustProviderTypeListCopier.copy(deviceTrustProviders);
        }

        @Override
        public final Builder deviceTrustProvidersWithStrings(Collection<String> deviceTrustProviders) {
            this.deviceTrustProviders = DeviceTrustProviderTypeListCopier.copy(deviceTrustProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTrustProvidersWithStrings(String... deviceTrustProviders) {
            deviceTrustProvidersWithStrings(Arrays.asList(deviceTrustProviders));
            return this;
        }

        @Override
        public final Builder deviceTrustProviders(Collection<DeviceTrustProviderType> deviceTrustProviders) {
            this.deviceTrustProviders = DeviceTrustProviderTypeListCopier.copyEnumToString(deviceTrustProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTrustProviders(DeviceTrustProviderType... deviceTrustProviders) {
            deviceTrustProviders(Arrays.asList(deviceTrustProviders));
            return this;
        }

        public final VerifiedAccessInstanceUserTrustProviderClientConfiguration.Builder getUserTrustProvider() {
            return userTrustProvider != null ? userTrustProvider.toBuilder() : null;
        }

        public final void setUserTrustProvider(
                VerifiedAccessInstanceUserTrustProviderClientConfiguration.BuilderImpl userTrustProvider) {
            this.userTrustProvider = userTrustProvider != null ? userTrustProvider.build() : null;
        }

        @Override
        public final Builder userTrustProvider(VerifiedAccessInstanceUserTrustProviderClientConfiguration userTrustProvider) {
            this.userTrustProvider = userTrustProvider;
            return this;
        }

        public final List<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder> getOpenVpnConfigurations() {
            List<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder> result = VerifiedAccessInstanceOpenVpnClientConfigurationListCopier
                    .copyToBuilder(this.openVpnConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpenVpnConfigurations(
                Collection<VerifiedAccessInstanceOpenVpnClientConfiguration.BuilderImpl> openVpnConfigurations) {
            this.openVpnConfigurations = VerifiedAccessInstanceOpenVpnClientConfigurationListCopier
                    .copyFromBuilder(openVpnConfigurations);
        }

        @Override
        public final Builder openVpnConfigurations(
                Collection<VerifiedAccessInstanceOpenVpnClientConfiguration> openVpnConfigurations) {
            this.openVpnConfigurations = VerifiedAccessInstanceOpenVpnClientConfigurationListCopier.copy(openVpnConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openVpnConfigurations(VerifiedAccessInstanceOpenVpnClientConfiguration... openVpnConfigurations) {
            openVpnConfigurations(Arrays.asList(openVpnConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openVpnConfigurations(
                Consumer<VerifiedAccessInstanceOpenVpnClientConfiguration.Builder>... openVpnConfigurations) {
            openVpnConfigurations(Stream.of(openVpnConfigurations)
                    .map(c -> VerifiedAccessInstanceOpenVpnClientConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExportVerifiedAccessInstanceClientConfigurationResponse build() {
            return new ExportVerifiedAccessInstanceClientConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
