/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Verified Access trust provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessTrustProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessTrustProvider.Builder, VerifiedAccessTrustProvider> {
    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessTrustProviderId")
            .getter(getter(VerifiedAccessTrustProvider::verifiedAccessTrustProviderId))
            .setter(setter(Builder::verifiedAccessTrustProviderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId")
                    .unmarshallLocationName("verifiedAccessTrustProviderId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(VerifiedAccessTrustProvider::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrustProviderType")
            .getter(getter(VerifiedAccessTrustProvider::trustProviderTypeAsString))
            .setter(setter(Builder::trustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustProviderType")
                    .unmarshallLocationName("trustProviderType").build()).build();

    private static final SdkField<String> USER_TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserTrustProviderType")
            .getter(getter(VerifiedAccessTrustProvider::userTrustProviderTypeAsString))
            .setter(setter(Builder::userTrustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTrustProviderType")
                    .unmarshallLocationName("userTrustProviderType").build()).build();

    private static final SdkField<String> DEVICE_TRUST_PROVIDER_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceTrustProviderType")
            .getter(getter(VerifiedAccessTrustProvider::deviceTrustProviderTypeAsString))
            .setter(setter(Builder::deviceTrustProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTrustProviderType")
                    .unmarshallLocationName("deviceTrustProviderType").build()).build();

    private static final SdkField<OidcOptions> OIDC_OPTIONS_FIELD = SdkField
            .<OidcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("OidcOptions")
            .getter(getter(VerifiedAccessTrustProvider::oidcOptions))
            .setter(setter(Builder::oidcOptions))
            .constructor(OidcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcOptions")
                    .unmarshallLocationName("oidcOptions").build()).build();

    private static final SdkField<DeviceOptions> DEVICE_OPTIONS_FIELD = SdkField
            .<DeviceOptions> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceOptions")
            .getter(getter(VerifiedAccessTrustProvider::deviceOptions))
            .setter(setter(Builder::deviceOptions))
            .constructor(DeviceOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOptions")
                    .unmarshallLocationName("deviceOptions").build()).build();

    private static final SdkField<String> POLICY_REFERENCE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyReferenceName")
            .getter(getter(VerifiedAccessTrustProvider::policyReferenceName))
            .setter(setter(Builder::policyReferenceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReferenceName")
                    .unmarshallLocationName("policyReferenceName").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreationTime")
            .getter(getter(VerifiedAccessTrustProvider::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedTime")
            .getter(getter(VerifiedAccessTrustProvider::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime")
                    .unmarshallLocationName("lastUpdatedTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VerifiedAccessTrustProvider::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<VerifiedAccessSseSpecificationResponse> SSE_SPECIFICATION_FIELD = SdkField
            .<VerifiedAccessSseSpecificationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("SseSpecification")
            .getter(getter(VerifiedAccessTrustProvider::sseSpecification))
            .setter(setter(Builder::sseSpecification))
            .constructor(VerifiedAccessSseSpecificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification")
                    .unmarshallLocationName("sseSpecification").build()).build();

    private static final SdkField<NativeApplicationOidcOptions> NATIVE_APPLICATION_OIDC_OPTIONS_FIELD = SdkField
            .<NativeApplicationOidcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("NativeApplicationOidcOptions")
            .getter(getter(VerifiedAccessTrustProvider::nativeApplicationOidcOptions))
            .setter(setter(Builder::nativeApplicationOidcOptions))
            .constructor(NativeApplicationOidcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NativeApplicationOidcOptions")
                    .unmarshallLocationName("nativeApplicationOidcOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, DESCRIPTION_FIELD, TRUST_PROVIDER_TYPE_FIELD,
            USER_TRUST_PROVIDER_TYPE_FIELD, DEVICE_TRUST_PROVIDER_TYPE_FIELD, OIDC_OPTIONS_FIELD, DEVICE_OPTIONS_FIELD,
            POLICY_REFERENCE_NAME_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, TAGS_FIELD, SSE_SPECIFICATION_FIELD,
            NATIVE_APPLICATION_OIDC_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String verifiedAccessTrustProviderId;

    private final String description;

    private final String trustProviderType;

    private final String userTrustProviderType;

    private final String deviceTrustProviderType;

    private final OidcOptions oidcOptions;

    private final DeviceOptions deviceOptions;

    private final String policyReferenceName;

    private final String creationTime;

    private final String lastUpdatedTime;

    private final List<Tag> tags;

    private final VerifiedAccessSseSpecificationResponse sseSpecification;

    private final NativeApplicationOidcOptions nativeApplicationOidcOptions;

    private VerifiedAccessTrustProvider(BuilderImpl builder) {
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.description = builder.description;
        this.trustProviderType = builder.trustProviderType;
        this.userTrustProviderType = builder.userTrustProviderType;
        this.deviceTrustProviderType = builder.deviceTrustProviderType;
        this.oidcOptions = builder.oidcOptions;
        this.deviceOptions = builder.deviceOptions;
        this.policyReferenceName = builder.policyReferenceName;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.tags = builder.tags;
        this.sseSpecification = builder.sseSpecification;
        this.nativeApplicationOidcOptions = builder.nativeApplicationOidcOptions;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Verified Access trust provider.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Verified Access trust provider.
     */
    public final String verifiedAccessTrustProviderId() {
        return verifiedAccessTrustProviderId;
    }

    /**
     * <p>
     * A description for the Amazon Web Services Verified Access trust provider.
     * </p>
     * 
     * @return A description for the Amazon Web Services Verified Access trust provider.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of Verified Access trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustProviderType}
     * will return {@link TrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of Verified Access trust provider.
     * @see TrustProviderType
     */
    public final TrustProviderType trustProviderType() {
        return TrustProviderType.fromValue(trustProviderType);
    }

    /**
     * <p>
     * The type of Verified Access trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustProviderType}
     * will return {@link TrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of Verified Access trust provider.
     * @see TrustProviderType
     */
    public final String trustProviderTypeAsString() {
        return trustProviderType;
    }

    /**
     * <p>
     * The type of user-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userTrustProviderType} will return {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of user-based trust provider.
     * @see UserTrustProviderType
     */
    public final UserTrustProviderType userTrustProviderType() {
        return UserTrustProviderType.fromValue(userTrustProviderType);
    }

    /**
     * <p>
     * The type of user-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userTrustProviderType} will return {@link UserTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #userTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of user-based trust provider.
     * @see UserTrustProviderType
     */
    public final String userTrustProviderTypeAsString() {
        return userTrustProviderType;
    }

    /**
     * <p>
     * The type of device-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTrustProviderType} will return {@link DeviceTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of device-based trust provider.
     * @see DeviceTrustProviderType
     */
    public final DeviceTrustProviderType deviceTrustProviderType() {
        return DeviceTrustProviderType.fromValue(deviceTrustProviderType);
    }

    /**
     * <p>
     * The type of device-based trust provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTrustProviderType} will return {@link DeviceTrustProviderType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTrustProviderTypeAsString}.
     * </p>
     * 
     * @return The type of device-based trust provider.
     * @see DeviceTrustProviderType
     */
    public final String deviceTrustProviderTypeAsString() {
        return deviceTrustProviderType;
    }

    /**
     * <p>
     * The options for an OpenID Connect-compatible user-identity trust provider.
     * </p>
     * 
     * @return The options for an OpenID Connect-compatible user-identity trust provider.
     */
    public final OidcOptions oidcOptions() {
        return oidcOptions;
    }

    /**
     * <p>
     * The options for device-identity trust provider.
     * </p>
     * 
     * @return The options for device-identity trust provider.
     */
    public final DeviceOptions deviceOptions() {
        return deviceOptions;
    }

    /**
     * <p>
     * The identifier to be used when working with policy rules.
     * </p>
     * 
     * @return The identifier to be used when working with policy rules.
     */
    public final String policyReferenceName() {
        return policyReferenceName;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last updated time.
     * </p>
     * 
     * @return The last updated time.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The options in use for server side encryption.
     * </p>
     * 
     * @return The options in use for server side encryption.
     */
    public final VerifiedAccessSseSpecificationResponse sseSpecification() {
        return sseSpecification;
    }

    /**
     * <p>
     * The OpenID Connect (OIDC) options.
     * </p>
     * 
     * @return The OpenID Connect (OIDC) options.
     */
    public final NativeApplicationOidcOptions nativeApplicationOidcOptions() {
        return nativeApplicationOidcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(trustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTrustProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(oidcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(deviceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(policyReferenceName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(nativeApplicationOidcOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessTrustProvider)) {
            return false;
        }
        VerifiedAccessTrustProvider other = (VerifiedAccessTrustProvider) obj;
        return Objects.equals(verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId())
                && Objects.equals(description(), other.description())
                && Objects.equals(trustProviderTypeAsString(), other.trustProviderTypeAsString())
                && Objects.equals(userTrustProviderTypeAsString(), other.userTrustProviderTypeAsString())
                && Objects.equals(deviceTrustProviderTypeAsString(), other.deviceTrustProviderTypeAsString())
                && Objects.equals(oidcOptions(), other.oidcOptions()) && Objects.equals(deviceOptions(), other.deviceOptions())
                && Objects.equals(policyReferenceName(), other.policyReferenceName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(sseSpecification(), other.sseSpecification())
                && Objects.equals(nativeApplicationOidcOptions(), other.nativeApplicationOidcOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessTrustProvider")
                .add("VerifiedAccessTrustProviderId", verifiedAccessTrustProviderId()).add("Description", description())
                .add("TrustProviderType", trustProviderTypeAsString())
                .add("UserTrustProviderType", userTrustProviderTypeAsString())
                .add("DeviceTrustProviderType", deviceTrustProviderTypeAsString()).add("OidcOptions", oidcOptions())
                .add("DeviceOptions", deviceOptions()).add("PolicyReferenceName", policyReferenceName())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("Tags", hasTags() ? tags() : null).add("SseSpecification", sseSpecification())
                .add("NativeApplicationOidcOptions", nativeApplicationOidcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessTrustProviderId":
            return Optional.ofNullable(clazz.cast(verifiedAccessTrustProviderId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TrustProviderType":
            return Optional.ofNullable(clazz.cast(trustProviderTypeAsString()));
        case "UserTrustProviderType":
            return Optional.ofNullable(clazz.cast(userTrustProviderTypeAsString()));
        case "DeviceTrustProviderType":
            return Optional.ofNullable(clazz.cast(deviceTrustProviderTypeAsString()));
        case "OidcOptions":
            return Optional.ofNullable(clazz.cast(oidcOptions()));
        case "DeviceOptions":
            return Optional.ofNullable(clazz.cast(deviceOptions()));
        case "PolicyReferenceName":
            return Optional.ofNullable(clazz.cast(policyReferenceName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SseSpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        case "NativeApplicationOidcOptions":
            return Optional.ofNullable(clazz.cast(nativeApplicationOidcOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedAccessTrustProviderId", VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TrustProviderType", TRUST_PROVIDER_TYPE_FIELD);
        map.put("UserTrustProviderType", USER_TRUST_PROVIDER_TYPE_FIELD);
        map.put("DeviceTrustProviderType", DEVICE_TRUST_PROVIDER_TYPE_FIELD);
        map.put("OidcOptions", OIDC_OPTIONS_FIELD);
        map.put("DeviceOptions", DEVICE_OPTIONS_FIELD);
        map.put("PolicyReferenceName", POLICY_REFERENCE_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("SseSpecification", SSE_SPECIFICATION_FIELD);
        map.put("NativeApplicationOidcOptions", NATIVE_APPLICATION_OIDC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessTrustProvider, T> g) {
        return obj -> g.apply((VerifiedAccessTrustProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessTrustProvider> {
        /**
         * <p>
         * The ID of the Amazon Web Services Verified Access trust provider.
         * </p>
         * 
         * @param verifiedAccessTrustProviderId
         *        The ID of the Amazon Web Services Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId);

        /**
         * <p>
         * A description for the Amazon Web Services Verified Access trust provider.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Web Services Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of Verified Access trust provider.
         * </p>
         * 
         * @param trustProviderType
         *        The type of Verified Access trust provider.
         * @see TrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustProviderType
         */
        Builder trustProviderType(String trustProviderType);

        /**
         * <p>
         * The type of Verified Access trust provider.
         * </p>
         * 
         * @param trustProviderType
         *        The type of Verified Access trust provider.
         * @see TrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustProviderType
         */
        Builder trustProviderType(TrustProviderType trustProviderType);

        /**
         * <p>
         * The type of user-based trust provider.
         * </p>
         * 
         * @param userTrustProviderType
         *        The type of user-based trust provider.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder userTrustProviderType(String userTrustProviderType);

        /**
         * <p>
         * The type of user-based trust provider.
         * </p>
         * 
         * @param userTrustProviderType
         *        The type of user-based trust provider.
         * @see UserTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserTrustProviderType
         */
        Builder userTrustProviderType(UserTrustProviderType userTrustProviderType);

        /**
         * <p>
         * The type of device-based trust provider.
         * </p>
         * 
         * @param deviceTrustProviderType
         *        The type of device-based trust provider.
         * @see DeviceTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceTrustProviderType
         */
        Builder deviceTrustProviderType(String deviceTrustProviderType);

        /**
         * <p>
         * The type of device-based trust provider.
         * </p>
         * 
         * @param deviceTrustProviderType
         *        The type of device-based trust provider.
         * @see DeviceTrustProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceTrustProviderType
         */
        Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType);

        /**
         * <p>
         * The options for an OpenID Connect-compatible user-identity trust provider.
         * </p>
         * 
         * @param oidcOptions
         *        The options for an OpenID Connect-compatible user-identity trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcOptions(OidcOptions oidcOptions);

        /**
         * <p>
         * The options for an OpenID Connect-compatible user-identity trust provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link OidcOptions.Builder} avoiding the need to
         * create one manually via {@link OidcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OidcOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #oidcOptions(OidcOptions)}.
         * 
         * @param oidcOptions
         *        a consumer that will call methods on {@link OidcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcOptions(OidcOptions)
         */
        default Builder oidcOptions(Consumer<OidcOptions.Builder> oidcOptions) {
            return oidcOptions(OidcOptions.builder().applyMutation(oidcOptions).build());
        }

        /**
         * <p>
         * The options for device-identity trust provider.
         * </p>
         * 
         * @param deviceOptions
         *        The options for device-identity trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceOptions(DeviceOptions deviceOptions);

        /**
         * <p>
         * The options for device-identity trust provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceOptions.Builder} avoiding the need
         * to create one manually via {@link DeviceOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceOptions(DeviceOptions)}.
         * 
         * @param deviceOptions
         *        a consumer that will call methods on {@link DeviceOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceOptions(DeviceOptions)
         */
        default Builder deviceOptions(Consumer<DeviceOptions.Builder> deviceOptions) {
            return deviceOptions(DeviceOptions.builder().applyMutation(deviceOptions).build());
        }

        /**
         * <p>
         * The identifier to be used when working with policy rules.
         * </p>
         * 
         * @param policyReferenceName
         *        The identifier to be used when working with policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyReferenceName(String policyReferenceName);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The last updated time.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last updated time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The options in use for server side encryption.
         * </p>
         * 
         * @param sseSpecification
         *        The options in use for server side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification);

        /**
         * <p>
         * The options in use for server side encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessSseSpecificationResponse.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessSseSpecificationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessSseSpecificationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #sseSpecification(VerifiedAccessSseSpecificationResponse)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link VerifiedAccessSseSpecificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(VerifiedAccessSseSpecificationResponse)
         */
        default Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationResponse.Builder> sseSpecification) {
            return sseSpecification(VerifiedAccessSseSpecificationResponse.builder().applyMutation(sseSpecification).build());
        }

        /**
         * <p>
         * The OpenID Connect (OIDC) options.
         * </p>
         * 
         * @param nativeApplicationOidcOptions
         *        The OpenID Connect (OIDC) options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nativeApplicationOidcOptions(NativeApplicationOidcOptions nativeApplicationOidcOptions);

        /**
         * <p>
         * The OpenID Connect (OIDC) options.
         * </p>
         * This is a convenience method that creates an instance of the {@link NativeApplicationOidcOptions.Builder}
         * avoiding the need to create one manually via {@link NativeApplicationOidcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NativeApplicationOidcOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #nativeApplicationOidcOptions(NativeApplicationOidcOptions)}.
         * 
         * @param nativeApplicationOidcOptions
         *        a consumer that will call methods on {@link NativeApplicationOidcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nativeApplicationOidcOptions(NativeApplicationOidcOptions)
         */
        default Builder nativeApplicationOidcOptions(Consumer<NativeApplicationOidcOptions.Builder> nativeApplicationOidcOptions) {
            return nativeApplicationOidcOptions(NativeApplicationOidcOptions.builder()
                    .applyMutation(nativeApplicationOidcOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String verifiedAccessTrustProviderId;

        private String description;

        private String trustProviderType;

        private String userTrustProviderType;

        private String deviceTrustProviderType;

        private OidcOptions oidcOptions;

        private DeviceOptions deviceOptions;

        private String policyReferenceName;

        private String creationTime;

        private String lastUpdatedTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private VerifiedAccessSseSpecificationResponse sseSpecification;

        private NativeApplicationOidcOptions nativeApplicationOidcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessTrustProvider model) {
            verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            description(model.description);
            trustProviderType(model.trustProviderType);
            userTrustProviderType(model.userTrustProviderType);
            deviceTrustProviderType(model.deviceTrustProviderType);
            oidcOptions(model.oidcOptions);
            deviceOptions(model.deviceOptions);
            policyReferenceName(model.policyReferenceName);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            tags(model.tags);
            sseSpecification(model.sseSpecification);
            nativeApplicationOidcOptions(model.nativeApplicationOidcOptions);
        }

        public final String getVerifiedAccessTrustProviderId() {
            return verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTrustProviderType() {
            return trustProviderType;
        }

        public final void setTrustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
        }

        @Override
        public final Builder trustProviderType(String trustProviderType) {
            this.trustProviderType = trustProviderType;
            return this;
        }

        @Override
        public final Builder trustProviderType(TrustProviderType trustProviderType) {
            this.trustProviderType(trustProviderType == null ? null : trustProviderType.toString());
            return this;
        }

        public final String getUserTrustProviderType() {
            return userTrustProviderType;
        }

        public final void setUserTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
        }

        @Override
        public final Builder userTrustProviderType(String userTrustProviderType) {
            this.userTrustProviderType = userTrustProviderType;
            return this;
        }

        @Override
        public final Builder userTrustProviderType(UserTrustProviderType userTrustProviderType) {
            this.userTrustProviderType(userTrustProviderType == null ? null : userTrustProviderType.toString());
            return this;
        }

        public final String getDeviceTrustProviderType() {
            return deviceTrustProviderType;
        }

        public final void setDeviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
        }

        @Override
        public final Builder deviceTrustProviderType(String deviceTrustProviderType) {
            this.deviceTrustProviderType = deviceTrustProviderType;
            return this;
        }

        @Override
        public final Builder deviceTrustProviderType(DeviceTrustProviderType deviceTrustProviderType) {
            this.deviceTrustProviderType(deviceTrustProviderType == null ? null : deviceTrustProviderType.toString());
            return this;
        }

        public final OidcOptions.Builder getOidcOptions() {
            return oidcOptions != null ? oidcOptions.toBuilder() : null;
        }

        public final void setOidcOptions(OidcOptions.BuilderImpl oidcOptions) {
            this.oidcOptions = oidcOptions != null ? oidcOptions.build() : null;
        }

        @Override
        public final Builder oidcOptions(OidcOptions oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        public final DeviceOptions.Builder getDeviceOptions() {
            return deviceOptions != null ? deviceOptions.toBuilder() : null;
        }

        public final void setDeviceOptions(DeviceOptions.BuilderImpl deviceOptions) {
            this.deviceOptions = deviceOptions != null ? deviceOptions.build() : null;
        }

        @Override
        public final Builder deviceOptions(DeviceOptions deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        public final String getPolicyReferenceName() {
            return policyReferenceName;
        }

        public final void setPolicyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
        }

        @Override
        public final Builder policyReferenceName(String policyReferenceName) {
            this.policyReferenceName = policyReferenceName;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final VerifiedAccessSseSpecificationResponse.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationResponse.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationResponse sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final NativeApplicationOidcOptions.Builder getNativeApplicationOidcOptions() {
            return nativeApplicationOidcOptions != null ? nativeApplicationOidcOptions.toBuilder() : null;
        }

        public final void setNativeApplicationOidcOptions(NativeApplicationOidcOptions.BuilderImpl nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions != null ? nativeApplicationOidcOptions.build()
                    : null;
        }

        @Override
        public final Builder nativeApplicationOidcOptions(NativeApplicationOidcOptions nativeApplicationOidcOptions) {
            this.nativeApplicationOidcOptions = nativeApplicationOidcOptions;
            return this;
        }

        @Override
        public VerifiedAccessTrustProvider build() {
            return new VerifiedAccessTrustProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
