/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of customer gateway devices that have a sample configuration file available for use. You can also see the list
 * of device types with sample configuration files available under <a
 * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html">Your customer gateway device</a> in the <i>Amazon
 * Web Services Site-to-Site VPN User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnConnectionDeviceType implements SdkPojo, Serializable,
        ToCopyableBuilder<VpnConnectionDeviceType.Builder, VpnConnectionDeviceType> {
    private static final SdkField<String> VPN_CONNECTION_DEVICE_TYPE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpnConnectionDeviceTypeId")
            .getter(getter(VpnConnectionDeviceType::vpnConnectionDeviceTypeId))
            .setter(setter(Builder::vpnConnectionDeviceTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionDeviceTypeId")
                    .unmarshallLocationName("vpnConnectionDeviceTypeId").build()).build();

    private static final SdkField<String> VENDOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Vendor")
            .getter(getter(VpnConnectionDeviceType::vendor))
            .setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor")
                    .unmarshallLocationName("vendor").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(VpnConnectionDeviceType::platform))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<String> SOFTWARE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Software")
            .getter(getter(VpnConnectionDeviceType::software))
            .setter(setter(Builder::software))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Software")
                    .unmarshallLocationName("software").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPN_CONNECTION_DEVICE_TYPE_ID_FIELD, VENDOR_FIELD, PLATFORM_FIELD, SOFTWARE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpnConnectionDeviceTypeId;

    private final String vendor;

    private final String platform;

    private final String software;

    private VpnConnectionDeviceType(BuilderImpl builder) {
        this.vpnConnectionDeviceTypeId = builder.vpnConnectionDeviceTypeId;
        this.vendor = builder.vendor;
        this.platform = builder.platform;
        this.software = builder.software;
    }

    /**
     * <p>
     * Customer gateway device identifier.
     * </p>
     * 
     * @return Customer gateway device identifier.
     */
    public final String vpnConnectionDeviceTypeId() {
        return vpnConnectionDeviceTypeId;
    }

    /**
     * <p>
     * Customer gateway device vendor.
     * </p>
     * 
     * @return Customer gateway device vendor.
     */
    public final String vendor() {
        return vendor;
    }

    /**
     * <p>
     * Customer gateway device platform.
     * </p>
     * 
     * @return Customer gateway device platform.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * Customer gateway device software version.
     * </p>
     * 
     * @return Customer gateway device software version.
     */
    public final String software() {
        return software;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionDeviceTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(software());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionDeviceType)) {
            return false;
        }
        VpnConnectionDeviceType other = (VpnConnectionDeviceType) obj;
        return Objects.equals(vpnConnectionDeviceTypeId(), other.vpnConnectionDeviceTypeId())
                && Objects.equals(vendor(), other.vendor()) && Objects.equals(platform(), other.platform())
                && Objects.equals(software(), other.software());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpnConnectionDeviceType").add("VpnConnectionDeviceTypeId", vpnConnectionDeviceTypeId())
                .add("Vendor", vendor()).add("Platform", platform()).add("Software", software()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionDeviceTypeId":
            return Optional.ofNullable(clazz.cast(vpnConnectionDeviceTypeId()));
        case "Vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "Software":
            return Optional.ofNullable(clazz.cast(software()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpnConnectionDeviceTypeId", VPN_CONNECTION_DEVICE_TYPE_ID_FIELD);
        map.put("Vendor", VENDOR_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("Software", SOFTWARE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionDeviceType, T> g) {
        return obj -> g.apply((VpnConnectionDeviceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnConnectionDeviceType> {
        /**
         * <p>
         * Customer gateway device identifier.
         * </p>
         * 
         * @param vpnConnectionDeviceTypeId
         *        Customer gateway device identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId);

        /**
         * <p>
         * Customer gateway device vendor.
         * </p>
         * 
         * @param vendor
         *        Customer gateway device vendor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);

        /**
         * <p>
         * Customer gateway device platform.
         * </p>
         * 
         * @param platform
         *        Customer gateway device platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * Customer gateway device software version.
         * </p>
         * 
         * @param software
         *        Customer gateway device software version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder software(String software);
    }

    static final class BuilderImpl implements Builder {
        private String vpnConnectionDeviceTypeId;

        private String vendor;

        private String platform;

        private String software;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionDeviceType model) {
            vpnConnectionDeviceTypeId(model.vpnConnectionDeviceTypeId);
            vendor(model.vendor);
            platform(model.platform);
            software(model.software);
        }

        public final String getVpnConnectionDeviceTypeId() {
            return vpnConnectionDeviceTypeId;
        }

        public final void setVpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId) {
            this.vpnConnectionDeviceTypeId = vpnConnectionDeviceTypeId;
        }

        @Override
        public final Builder vpnConnectionDeviceTypeId(String vpnConnectionDeviceTypeId) {
            this.vpnConnectionDeviceTypeId = vpnConnectionDeviceTypeId;
            return this;
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getSoftware() {
            return software;
        }

        public final void setSoftware(String software) {
            this.software = software;
        }

        @Override
        public final Builder software(String software) {
            this.software = software;
            return this;
        }

        @Override
        public VpnConnectionDeviceType build() {
            return new VpnConnectionDeviceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
