/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityBlock;
import software.amazon.awssdk.services.ec2.model.CapacityBlockSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityBlocksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityBlocksResponse> {
    private static final SdkField<List<CapacityBlock>> CAPACITY_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityBlocks").getter(DescribeCapacityBlocksResponse.getter(DescribeCapacityBlocksResponse::capacityBlocks)).setter(DescribeCapacityBlocksResponse.setter(Builder::capacityBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockSet").unmarshallLocationName("capacityBlockSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityBlocksResponse.getter(DescribeCapacityBlocksResponse::nextToken)).setter(DescribeCapacityBlocksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityBlocksResponse.memberNameToFieldInitializer();
    private final List<CapacityBlock> capacityBlocks;
    private final String nextToken;

    private DescribeCapacityBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.capacityBlocks = builder.capacityBlocks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityBlocks() {
        return this.capacityBlocks != null && !(this.capacityBlocks instanceof SdkAutoConstructList);
    }

    public final List<CapacityBlock> capacityBlocks() {
        return this.capacityBlocks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityBlocks() ? this.capacityBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlocksResponse)) {
            return false;
        }
        DescribeCapacityBlocksResponse other = (DescribeCapacityBlocksResponse)((Object)obj);
        return this.hasCapacityBlocks() == other.hasCapacityBlocks() && Objects.equals(this.capacityBlocks(), other.capacityBlocks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityBlocksResponse").add("CapacityBlocks", this.hasCapacityBlocks() ? this.capacityBlocks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlocks": {
                return Optional.ofNullable(clazz.cast(this.capacityBlocks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockSet", CAPACITY_BLOCKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlocksResponse, T> g) {
        return obj -> g.apply((DescribeCapacityBlocksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityBlock> capacityBlocks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlocksResponse model) {
            super(model);
            this.capacityBlocks(model.capacityBlocks);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityBlock.Builder> getCapacityBlocks() {
            List<CapacityBlock.Builder> result = CapacityBlockSetCopier.copyToBuilder(this.capacityBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlocks(Collection<CapacityBlock.BuilderImpl> capacityBlocks) {
            this.capacityBlocks = CapacityBlockSetCopier.copyFromBuilder(capacityBlocks);
        }

        @Override
        public final Builder capacityBlocks(Collection<CapacityBlock> capacityBlocks) {
            this.capacityBlocks = CapacityBlockSetCopier.copy(capacityBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlocks(CapacityBlock ... capacityBlocks) {
            this.capacityBlocks(Arrays.asList(capacityBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlocks(Consumer<CapacityBlock.Builder> ... capacityBlocks) {
            this.capacityBlocks(Stream.of(capacityBlocks).map(c -> (CapacityBlock)((CapacityBlock.Builder)CapacityBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityBlocksResponse build() {
            return new DescribeCapacityBlocksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityBlocksResponse> {
        public Builder capacityBlocks(Collection<CapacityBlock> var1);

        public Builder capacityBlocks(CapacityBlock ... var1);

        public Builder capacityBlocks(Consumer<CapacityBlock.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

