/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficMirrorFilterResponse extends Ec2Response implements
        ToCopyableBuilder<CreateTrafficMirrorFilterResponse.Builder, CreateTrafficMirrorFilterResponse> {
    private static final SdkField<TrafficMirrorFilter> TRAFFIC_MIRROR_FILTER_FIELD = SdkField
            .<TrafficMirrorFilter> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficMirrorFilter")
            .getter(getter(CreateTrafficMirrorFilterResponse::trafficMirrorFilter))
            .setter(setter(Builder::trafficMirrorFilter))
            .constructor(TrafficMirrorFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilter")
                    .unmarshallLocationName("trafficMirrorFilter").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTrafficMirrorFilterResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TrafficMirrorFilter trafficMirrorFilter;

    private final String clientToken;

    private CreateTrafficMirrorFilterResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilter = builder.trafficMirrorFilter;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the Traffic Mirror filter.
     * </p>
     * 
     * @return Information about the Traffic Mirror filter.
     */
    public final TrafficMirrorFilter trafficMirrorFilter() {
        return trafficMirrorFilter;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How
     *         to ensure idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilter());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorFilterResponse)) {
            return false;
        }
        CreateTrafficMirrorFilterResponse other = (CreateTrafficMirrorFilterResponse) obj;
        return Objects.equals(trafficMirrorFilter(), other.trafficMirrorFilter())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrafficMirrorFilterResponse").add("TrafficMirrorFilter", trafficMirrorFilter())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilter":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilter()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficMirrorFilter", TRAFFIC_MIRROR_FILTER_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorFilterResponse, T> g) {
        return obj -> g.apply((CreateTrafficMirrorFilterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficMirrorFilterResponse> {
        /**
         * <p>
         * Information about the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilter
         *        Information about the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilter(TrafficMirrorFilter trafficMirrorFilter);

        /**
         * <p>
         * Information about the Traffic Mirror filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficMirrorFilter.Builder} avoiding the
         * need to create one manually via {@link TrafficMirrorFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficMirrorFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficMirrorFilter(TrafficMirrorFilter)}.
         * 
         * @param trafficMirrorFilter
         *        a consumer that will call methods on {@link TrafficMirrorFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficMirrorFilter(TrafficMirrorFilter)
         */
        default Builder trafficMirrorFilter(Consumer<TrafficMirrorFilter.Builder> trafficMirrorFilter) {
            return trafficMirrorFilter(TrafficMirrorFilter.builder().applyMutation(trafficMirrorFilter).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to
         * ensure idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TrafficMirrorFilter trafficMirrorFilter;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorFilterResponse model) {
            super(model);
            trafficMirrorFilter(model.trafficMirrorFilter);
            clientToken(model.clientToken);
        }

        public final TrafficMirrorFilter.Builder getTrafficMirrorFilter() {
            return trafficMirrorFilter != null ? trafficMirrorFilter.toBuilder() : null;
        }

        public final void setTrafficMirrorFilter(TrafficMirrorFilter.BuilderImpl trafficMirrorFilter) {
            this.trafficMirrorFilter = trafficMirrorFilter != null ? trafficMirrorFilter.build() : null;
        }

        @Override
        public final Builder trafficMirrorFilter(TrafficMirrorFilter trafficMirrorFilter) {
            this.trafficMirrorFilter = trafficMirrorFilter;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public CreateTrafficMirrorFilterResponse build() {
            return new CreateTrafficMirrorFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
