/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceStatusResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeInstanceStatusResponse.Builder, DescribeInstanceStatusResponse> {
    private static final SdkField<List<InstanceStatus>> INSTANCE_STATUSES_FIELD = SdkField
            .<List<InstanceStatus>> builder(MarshallingType.LIST)
            .memberName("InstanceStatuses")
            .getter(getter(DescribeInstanceStatusResponse::instanceStatuses))
            .setter(setter(Builder::instanceStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatusSet")
                    .unmarshallLocationName("instanceStatusSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInstanceStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_STATUSES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceStatus> instanceStatuses;

    private final String nextToken;

    private DescribeInstanceStatusResponse(BuilderImpl builder) {
        super(builder);
        this.instanceStatuses = builder.instanceStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceStatuses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceStatuses() {
        return instanceStatuses != null && !(instanceStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the status of the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStatuses} method.
     * </p>
     * 
     * @return Information about the status of the instances.
     */
    public final List<InstanceStatus> instanceStatuses() {
        return instanceStatuses;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceStatuses() ? instanceStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusResponse)) {
            return false;
        }
        DescribeInstanceStatusResponse other = (DescribeInstanceStatusResponse) obj;
        return hasInstanceStatuses() == other.hasInstanceStatuses()
                && Objects.equals(instanceStatuses(), other.instanceStatuses()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceStatusResponse")
                .add("InstanceStatuses", hasInstanceStatuses() ? instanceStatuses() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceStatuses":
            return Optional.ofNullable(clazz.cast(instanceStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceStatusSet", INSTANCE_STATUSES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceStatusResponse, T> g) {
        return obj -> g.apply((DescribeInstanceStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceStatusResponse> {
        /**
         * <p>
         * Information about the status of the instances.
         * </p>
         * 
         * @param instanceStatuses
         *        Information about the status of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses);

        /**
         * <p>
         * Information about the status of the instances.
         * </p>
         * 
         * @param instanceStatuses
         *        Information about the status of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatuses(InstanceStatus... instanceStatuses);

        /**
         * <p>
         * Information about the status of the instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceStatus.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.InstanceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceStatuses(List<InstanceStatus>)}.
         * 
         * @param instanceStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStatuses(java.util.Collection<InstanceStatus>)
         */
        Builder instanceStatuses(Consumer<InstanceStatus.Builder>... instanceStatuses);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceStatus> instanceStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStatusResponse model) {
            super(model);
            instanceStatuses(model.instanceStatuses);
            nextToken(model.nextToken);
        }

        public final List<InstanceStatus.Builder> getInstanceStatuses() {
            List<InstanceStatus.Builder> result = InstanceStatusListCopier.copyToBuilder(this.instanceStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceStatuses(Collection<InstanceStatus.BuilderImpl> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copyFromBuilder(instanceStatuses);
        }

        @Override
        public final Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copy(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(InstanceStatus... instanceStatuses) {
            instanceStatuses(Arrays.asList(instanceStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(Consumer<InstanceStatus.Builder>... instanceStatuses) {
            instanceStatuses(Stream.of(instanceStatuses).map(c -> InstanceStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstanceStatusResponse build() {
            return new DescribeInstanceStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
