/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the OpenID Connect (OIDC) options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVerifiedAccessNativeApplicationOidcOptions
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ModifyVerifiedAccessNativeApplicationOidcOptions.Builder, ModifyVerifiedAccessNativeApplicationOidcOptions> {
    private static final SdkField<String> PUBLIC_SIGNING_KEY_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicSigningKeyEndpoint")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::publicSigningKeyEndpoint))
            .setter(setter(Builder::publicSigningKeyEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSigningKeyEndpoint")
                    .unmarshallLocationName("PublicSigningKeyEndpoint").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Issuer")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::issuer))
            .setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer")
                    .unmarshallLocationName("Issuer").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationEndpoint")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::authorizationEndpoint))
            .setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint")
                    .unmarshallLocationName("AuthorizationEndpoint").build()).build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TokenEndpoint")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::tokenEndpoint))
            .setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint")
                    .unmarshallLocationName("TokenEndpoint").build()).build();

    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UserInfoEndpoint")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::userInfoEndpoint))
            .setter(setter(Builder::userInfoEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint")
                    .unmarshallLocationName("UserInfoEndpoint").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientId")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::clientId))
            .setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId")
                    .unmarshallLocationName("ClientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientSecret")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::clientSecret))
            .setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSecret")
                    .unmarshallLocationName("ClientSecret").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Scope")
            .getter(getter(ModifyVerifiedAccessNativeApplicationOidcOptions::scope))
            .setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope")
                    .unmarshallLocationName("Scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PUBLIC_SIGNING_KEY_ENDPOINT_FIELD, ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD,
            USER_INFO_ENDPOINT_FIELD, CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String publicSigningKeyEndpoint;

    private final String issuer;

    private final String authorizationEndpoint;

    private final String tokenEndpoint;

    private final String userInfoEndpoint;

    private final String clientId;

    private final String clientSecret;

    private final String scope;

    private ModifyVerifiedAccessNativeApplicationOidcOptions(BuilderImpl builder) {
        this.publicSigningKeyEndpoint = builder.publicSigningKeyEndpoint;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The public signing key endpoint.
     * </p>
     * 
     * @return The public signing key endpoint.
     */
    public final String publicSigningKeyEndpoint() {
        return publicSigningKeyEndpoint;
    }

    /**
     * <p>
     * The OIDC issuer identifier of the IdP.
     * </p>
     * 
     * @return The OIDC issuer identifier of the IdP.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The authorization endpoint of the IdP.
     * </p>
     * 
     * @return The authorization endpoint of the IdP.
     */
    public final String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The token endpoint of the IdP.
     * </p>
     * 
     * @return The token endpoint of the IdP.
     */
    public final String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * <p>
     * The user info endpoint of the IdP.
     * </p>
     * 
     * @return The user info endpoint of the IdP.
     */
    public final String userInfoEndpoint() {
        return userInfoEndpoint;
    }

    /**
     * <p>
     * The OAuth 2.0 client identifier.
     * </p>
     * 
     * @return The OAuth 2.0 client identifier.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The OAuth 2.0 client secret.
     * </p>
     * 
     * @return The OAuth 2.0 client secret.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The set of user claims to be requested from the IdP.
     * </p>
     * 
     * @return The set of user claims to be requested from the IdP.
     */
    public final String scope() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicSigningKeyEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessNativeApplicationOidcOptions)) {
            return false;
        }
        ModifyVerifiedAccessNativeApplicationOidcOptions other = (ModifyVerifiedAccessNativeApplicationOidcOptions) obj;
        return Objects.equals(publicSigningKeyEndpoint(), other.publicSigningKeyEndpoint())
                && Objects.equals(issuer(), other.issuer())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint())
                && Objects.equals(userInfoEndpoint(), other.userInfoEndpoint()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(clientSecret(), other.clientSecret()) && Objects.equals(scope(), other.scope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVerifiedAccessNativeApplicationOidcOptions")
                .add("PublicSigningKeyEndpoint", publicSigningKeyEndpoint()).add("Issuer", issuer())
                .add("AuthorizationEndpoint", authorizationEndpoint()).add("TokenEndpoint", tokenEndpoint())
                .add("UserInfoEndpoint", userInfoEndpoint()).add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***").add("Scope", scope())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicSigningKeyEndpoint":
            return Optional.ofNullable(clazz.cast(publicSigningKeyEndpoint()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "TokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "UserInfoEndpoint":
            return Optional.ofNullable(clazz.cast(userInfoEndpoint()));
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "ClientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PublicSigningKeyEndpoint", PUBLIC_SIGNING_KEY_ENDPOINT_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("AuthorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("TokenEndpoint", TOKEN_ENDPOINT_FIELD);
        map.put("UserInfoEndpoint", USER_INFO_ENDPOINT_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ClientSecret", CLIENT_SECRET_FIELD);
        map.put("Scope", SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessNativeApplicationOidcOptions, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessNativeApplicationOidcOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyVerifiedAccessNativeApplicationOidcOptions> {
        /**
         * <p>
         * The public signing key endpoint.
         * </p>
         * 
         * @param publicSigningKeyEndpoint
         *        The public signing key endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSigningKeyEndpoint(String publicSigningKeyEndpoint);

        /**
         * <p>
         * The OIDC issuer identifier of the IdP.
         * </p>
         * 
         * @param issuer
         *        The OIDC issuer identifier of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The authorization endpoint of the IdP.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The authorization endpoint of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The token endpoint of the IdP.
         * </p>
         * 
         * @param tokenEndpoint
         *        The token endpoint of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The user info endpoint of the IdP.
         * </p>
         * 
         * @param userInfoEndpoint
         *        The user info endpoint of the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfoEndpoint(String userInfoEndpoint);

        /**
         * <p>
         * The OAuth 2.0 client identifier.
         * </p>
         * 
         * @param clientId
         *        The OAuth 2.0 client identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The OAuth 2.0 client secret.
         * </p>
         * 
         * @param clientSecret
         *        The OAuth 2.0 client secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The set of user claims to be requested from the IdP.
         * </p>
         * 
         * @param scope
         *        The set of user claims to be requested from the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);
    }

    static final class BuilderImpl implements Builder {
        private String publicSigningKeyEndpoint;

        private String issuer;

        private String authorizationEndpoint;

        private String tokenEndpoint;

        private String userInfoEndpoint;

        private String clientId;

        private String clientSecret;

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessNativeApplicationOidcOptions model) {
            publicSigningKeyEndpoint(model.publicSigningKeyEndpoint);
            issuer(model.issuer);
            authorizationEndpoint(model.authorizationEndpoint);
            tokenEndpoint(model.tokenEndpoint);
            userInfoEndpoint(model.userInfoEndpoint);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            scope(model.scope);
        }

        public final String getPublicSigningKeyEndpoint() {
            return publicSigningKeyEndpoint;
        }

        public final void setPublicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
        }

        @Override
        public final Builder publicSigningKeyEndpoint(String publicSigningKeyEndpoint) {
            this.publicSigningKeyEndpoint = publicSigningKeyEndpoint;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final String getUserInfoEndpoint() {
            return userInfoEndpoint;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public ModifyVerifiedAccessNativeApplicationOidcOptions build() {
            return new ModifyVerifiedAccessNativeApplicationOidcOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
