/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that affect the scope of the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTypeOption implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTypeOption.Builder, ResourceTypeOption> {
    private static final SdkField<String> OPTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OptionName")
            .getter(getter(ResourceTypeOption::optionNameAsString))
            .setter(setter(Builder::optionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName")
                    .unmarshallLocationName("OptionName").build()).build();

    private static final SdkField<List<String>> OPTION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OptionValues")
            .getter(getter(ResourceTypeOption::optionValues))
            .setter(setter(Builder::optionValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionValue")
                    .unmarshallLocationName("OptionValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_NAME_FIELD,
            OPTION_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String optionName;

    private final List<String> optionValues;

    private ResourceTypeOption(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.optionValues = builder.optionValues;
    }

    /**
     * <p>
     * The name of the option.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>ec2:Instance</code>:
     * </p>
     * <p>
     * Specify <code>state-name</code> - The current state of the EC2 instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ec2:LaunchTemplate</code>:
     * </p>
     * <p>
     * Specify <code>version-depth</code> - The number of launch template versions to check, starting from the most
     * recent version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optionName} will
     * return {@link ImageReferenceOptionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optionNameAsString}.
     * </p>
     * 
     * @return The name of the option.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>ec2:Instance</code>:
     *         </p>
     *         <p>
     *         Specify <code>state-name</code> - The current state of the EC2 instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>ec2:LaunchTemplate</code>:
     *         </p>
     *         <p>
     *         Specify <code>version-depth</code> - The number of launch template versions to check, starting from the
     *         most recent version.
     *         </p>
     *         </li>
     * @see ImageReferenceOptionName
     */
    public final ImageReferenceOptionName optionName() {
        return ImageReferenceOptionName.fromValue(optionName);
    }

    /**
     * <p>
     * The name of the option.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>ec2:Instance</code>:
     * </p>
     * <p>
     * Specify <code>state-name</code> - The current state of the EC2 instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ec2:LaunchTemplate</code>:
     * </p>
     * <p>
     * Specify <code>version-depth</code> - The number of launch template versions to check, starting from the most
     * recent version.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optionName} will
     * return {@link ImageReferenceOptionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optionNameAsString}.
     * </p>
     * 
     * @return The name of the option.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>ec2:Instance</code>:
     *         </p>
     *         <p>
     *         Specify <code>state-name</code> - The current state of the EC2 instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>ec2:LaunchTemplate</code>:
     *         </p>
     *         <p>
     *         Specify <code>version-depth</code> - The number of launch template versions to check, starting from the
     *         most recent version.
     *         </p>
     *         </li>
     * @see ImageReferenceOptionName
     */
    public final String optionNameAsString() {
        return optionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionValues() {
        return optionValues != null && !(optionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A value for the specified option.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>state-name</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid values: <code>pending</code> | <code>running</code> | <code>shutting-down</code> | <code>terminated</code>
     * | <code>stopping</code> | <code>stopped</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Default: All states
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For <code>version-depth</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Valid values: Integers between <code>1</code> and <code>10000</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Default: <code>10</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionValues} method.
     * </p>
     * 
     * @return A value for the specified option.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>state-name</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid values: <code>pending</code> | <code>running</code> | <code>shutting-down</code> |
     *         <code>terminated</code> | <code>stopping</code> | <code>stopped</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Default: All states
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>version-depth</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Valid values: Integers between <code>1</code> and <code>10000</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Default: <code>10</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<String> optionValues() {
        return optionValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optionNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionValues() ? optionValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTypeOption)) {
            return false;
        }
        ResourceTypeOption other = (ResourceTypeOption) obj;
        return Objects.equals(optionNameAsString(), other.optionNameAsString()) && hasOptionValues() == other.hasOptionValues()
                && Objects.equals(optionValues(), other.optionValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceTypeOption").add("OptionName", optionNameAsString())
                .add("OptionValues", hasOptionValues() ? optionValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionName":
            return Optional.ofNullable(clazz.cast(optionNameAsString()));
        case "OptionValues":
            return Optional.ofNullable(clazz.cast(optionValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptionName", OPTION_NAME_FIELD);
        map.put("OptionValue", OPTION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceTypeOption, T> g) {
        return obj -> g.apply((ResourceTypeOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTypeOption> {
        /**
         * <p>
         * The name of the option.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>ec2:Instance</code>:
         * </p>
         * <p>
         * Specify <code>state-name</code> - The current state of the EC2 instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>ec2:LaunchTemplate</code>:
         * </p>
         * <p>
         * Specify <code>version-depth</code> - The number of launch template versions to check, starting from the most
         * recent version.
         * </p>
         * </li>
         * </ul>
         * 
         * @param optionName
         *        The name of the option.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>ec2:Instance</code>:
         *        </p>
         *        <p>
         *        Specify <code>state-name</code> - The current state of the EC2 instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>ec2:LaunchTemplate</code>:
         *        </p>
         *        <p>
         *        Specify <code>version-depth</code> - The number of launch template versions to check, starting from
         *        the most recent version.
         *        </p>
         *        </li>
         * @see ImageReferenceOptionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageReferenceOptionName
         */
        Builder optionName(String optionName);

        /**
         * <p>
         * The name of the option.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>ec2:Instance</code>:
         * </p>
         * <p>
         * Specify <code>state-name</code> - The current state of the EC2 instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>ec2:LaunchTemplate</code>:
         * </p>
         * <p>
         * Specify <code>version-depth</code> - The number of launch template versions to check, starting from the most
         * recent version.
         * </p>
         * </li>
         * </ul>
         * 
         * @param optionName
         *        The name of the option.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>ec2:Instance</code>:
         *        </p>
         *        <p>
         *        Specify <code>state-name</code> - The current state of the EC2 instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>ec2:LaunchTemplate</code>:
         *        </p>
         *        <p>
         *        Specify <code>version-depth</code> - The number of launch template versions to check, starting from
         *        the most recent version.
         *        </p>
         *        </li>
         * @see ImageReferenceOptionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageReferenceOptionName
         */
        Builder optionName(ImageReferenceOptionName optionName);

        /**
         * <p>
         * A value for the specified option.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>state-name</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values: <code>pending</code> | <code>running</code> | <code>shutting-down</code> |
         * <code>terminated</code> | <code>stopping</code> | <code>stopped</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Default: All states
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For <code>version-depth</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values: Integers between <code>1</code> and <code>10000</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Default: <code>10</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param optionValues
         *        A value for the specified option.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>state-name</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values: <code>pending</code> | <code>running</code> | <code>shutting-down</code> |
         *        <code>terminated</code> | <code>stopping</code> | <code>stopped</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Default: All states
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>version-depth</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values: Integers between <code>1</code> and <code>10000</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Default: <code>10</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionValues(Collection<String> optionValues);

        /**
         * <p>
         * A value for the specified option.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>state-name</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values: <code>pending</code> | <code>running</code> | <code>shutting-down</code> |
         * <code>terminated</code> | <code>stopping</code> | <code>stopped</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Default: All states
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For <code>version-depth</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Valid values: Integers between <code>1</code> and <code>10000</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Default: <code>10</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param optionValues
         *        A value for the specified option.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>state-name</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values: <code>pending</code> | <code>running</code> | <code>shutting-down</code> |
         *        <code>terminated</code> | <code>stopping</code> | <code>stopped</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Default: All states
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>version-depth</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Valid values: Integers between <code>1</code> and <code>10000</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Default: <code>10</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionValues(String... optionValues);
    }

    static final class BuilderImpl implements Builder {
        private String optionName;

        private List<String> optionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTypeOption model) {
            optionName(model.optionName);
            optionValues(model.optionValues);
        }

        public final String getOptionName() {
            return optionName;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        @Override
        public final Builder optionName(ImageReferenceOptionName optionName) {
            this.optionName(optionName == null ? null : optionName.toString());
            return this;
        }

        public final Collection<String> getOptionValues() {
            if (optionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return optionValues;
        }

        public final void setOptionValues(Collection<String> optionValues) {
            this.optionValues = ResourceTypeOptionValuesListCopier.copy(optionValues);
        }

        @Override
        public final Builder optionValues(Collection<String> optionValues) {
            this.optionValues = ResourceTypeOptionValuesListCopier.copy(optionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionValues(String... optionValues) {
            optionValues(Arrays.asList(optionValues));
            return this;
        }

        @Override
        public ResourceTypeOption build() {
            return new ResourceTypeOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
