/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociation;
import software.amazon.awssdk.services.ec2.model.IpamResourceDiscoveryAssociationSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamResourceDiscoveryAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamResourceDiscoveryAssociationsResponse> {
    private static final SdkField<List<IpamResourceDiscoveryAssociation>> IPAM_RESOURCE_DISCOVERY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamResourceDiscoveryAssociations").getter(DescribeIpamResourceDiscoveryAssociationsResponse.getter(DescribeIpamResourceDiscoveryAssociationsResponse::ipamResourceDiscoveryAssociations)).setter(DescribeIpamResourceDiscoveryAssociationsResponse.setter(Builder::ipamResourceDiscoveryAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryAssociationSet").unmarshallLocationName("ipamResourceDiscoveryAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamResourceDiscoveryAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamResourceDiscoveryAssociationsResponse.getter(DescribeIpamResourceDiscoveryAssociationsResponse::nextToken)).setter(DescribeIpamResourceDiscoveryAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_RESOURCE_DISCOVERY_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIpamResourceDiscoveryAssociationsResponse.memberNameToFieldInitializer();
    private final List<IpamResourceDiscoveryAssociation> ipamResourceDiscoveryAssociations;
    private final String nextToken;

    private DescribeIpamResourceDiscoveryAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.ipamResourceDiscoveryAssociations = builder.ipamResourceDiscoveryAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIpamResourceDiscoveryAssociations() {
        return this.ipamResourceDiscoveryAssociations != null && !(this.ipamResourceDiscoveryAssociations instanceof SdkAutoConstructList);
    }

    public final List<IpamResourceDiscoveryAssociation> ipamResourceDiscoveryAssociations() {
        return this.ipamResourceDiscoveryAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamResourceDiscoveryAssociations() ? this.ipamResourceDiscoveryAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamResourceDiscoveryAssociationsResponse)) {
            return false;
        }
        DescribeIpamResourceDiscoveryAssociationsResponse other = (DescribeIpamResourceDiscoveryAssociationsResponse)((Object)obj);
        return this.hasIpamResourceDiscoveryAssociations() == other.hasIpamResourceDiscoveryAssociations() && Objects.equals(this.ipamResourceDiscoveryAssociations(), other.ipamResourceDiscoveryAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamResourceDiscoveryAssociationsResponse").add("IpamResourceDiscoveryAssociations", this.hasIpamResourceDiscoveryAssociations() ? this.ipamResourceDiscoveryAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamResourceDiscoveryAssociations": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamResourceDiscoveryAssociationSet", IPAM_RESOURCE_DISCOVERY_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamResourceDiscoveryAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeIpamResourceDiscoveryAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamResourceDiscoveryAssociation> ipamResourceDiscoveryAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamResourceDiscoveryAssociationsResponse model) {
            super(model);
            this.ipamResourceDiscoveryAssociations(model.ipamResourceDiscoveryAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<IpamResourceDiscoveryAssociation.Builder> getIpamResourceDiscoveryAssociations() {
            List<IpamResourceDiscoveryAssociation.Builder> result = IpamResourceDiscoveryAssociationSetCopier.copyToBuilder(this.ipamResourceDiscoveryAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamResourceDiscoveryAssociations(Collection<IpamResourceDiscoveryAssociation.BuilderImpl> ipamResourceDiscoveryAssociations) {
            this.ipamResourceDiscoveryAssociations = IpamResourceDiscoveryAssociationSetCopier.copyFromBuilder(ipamResourceDiscoveryAssociations);
        }

        @Override
        public final Builder ipamResourceDiscoveryAssociations(Collection<IpamResourceDiscoveryAssociation> ipamResourceDiscoveryAssociations) {
            this.ipamResourceDiscoveryAssociations = IpamResourceDiscoveryAssociationSetCopier.copy(ipamResourceDiscoveryAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceDiscoveryAssociations(IpamResourceDiscoveryAssociation ... ipamResourceDiscoveryAssociations) {
            this.ipamResourceDiscoveryAssociations(Arrays.asList(ipamResourceDiscoveryAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamResourceDiscoveryAssociations(Consumer<IpamResourceDiscoveryAssociation.Builder> ... ipamResourceDiscoveryAssociations) {
            this.ipamResourceDiscoveryAssociations(Stream.of(ipamResourceDiscoveryAssociations).map(c -> (IpamResourceDiscoveryAssociation)((IpamResourceDiscoveryAssociation.Builder)IpamResourceDiscoveryAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIpamResourceDiscoveryAssociationsResponse build() {
            return new DescribeIpamResourceDiscoveryAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamResourceDiscoveryAssociationsResponse> {
        public Builder ipamResourceDiscoveryAssociations(Collection<IpamResourceDiscoveryAssociation> var1);

        public Builder ipamResourceDiscoveryAssociations(IpamResourceDiscoveryAssociation ... var1);

        public Builder ipamResourceDiscoveryAssociations(Consumer<IpamResourceDiscoveryAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

