/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A query used for retrieving network health data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQuery implements SdkPojo, Serializable, ToCopyableBuilder<DataQuery.Builder, DataQuery> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(DataQuery::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Source")
            .getter(getter(DataQuery::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source")
                    .unmarshallLocationName("Source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Destination")
            .getter(getter(DataQuery::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("Destination").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Metric")
            .getter(getter(DataQuery::metricAsString))
            .setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric")
                    .unmarshallLocationName("Metric").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Statistic")
            .getter(getter(DataQuery::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic")
                    .unmarshallLocationName("Statistic").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Period")
            .getter(getter(DataQuery::periodAsString))
            .setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period")
                    .unmarshallLocationName("Period").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SOURCE_FIELD,
            DESTINATION_FIELD, METRIC_FIELD, STATISTIC_FIELD, PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String source;

    private final String destination;

    private final String metric;

    private final String statistic;

    private final String period;

    private DataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.source = builder.source;
        this.destination = builder.destination;
        this.metric = builder.metric;
        this.statistic = builder.statistic;
        this.period = builder.period;
    }

    /**
     * <p>
     * A user-defined ID associated with a data query that's returned in the <code>dataResponse</code> identifying the
     * query. For example, if you set the Id to <code>MyQuery01</code>in the query, the <code>dataResponse</code>
     * identifies the query as <code>MyQuery01</code>.
     * </p>
     * 
     * @return A user-defined ID associated with a data query that's returned in the <code>dataResponse</code>
     *         identifying the query. For example, if you set the Id to <code>MyQuery01</code>in the query, the
     *         <code>dataResponse</code> identifies the query as <code>MyQuery01</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Region or Availability Zone that's the source for the data query. For example, <code>us-east-1</code>.
     * </p>
     * 
     * @return The Region or Availability Zone that's the source for the data query. For example, <code>us-east-1</code>
     *         .
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The Region or Availability Zone that's the target for the data query. For example, <code>eu-north-1</code>.
     * </p>
     * 
     * @return The Region or Availability Zone that's the target for the data query. For example,
     *         <code>eu-north-1</code>.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The metric used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the network performance request.
     * @see MetricType
     */
    public final MetricType metric() {
        return MetricType.fromValue(metric);
    }

    /**
     * <p>
     * The metric used for the network performance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metric} will
     * return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricAsString}.
     * </p>
     * 
     * @return The metric used for the network performance request.
     * @see MetricType
     */
    public final String metricAsString() {
        return metric;
    }

    /**
     * <p>
     * The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
     * <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data points
     * gathered within those five minutes. <code>p50</code> is the only supported metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
     *         <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data
     *         points gathered within those five minutes. <code>p50</code> is the only supported metric.
     * @see StatisticType
     */
    public final StatisticType statistic() {
        return StatisticType.fromValue(statistic);
    }

    /**
     * <p>
     * The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
     * <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data points
     * gathered within those five minutes. <code>p50</code> is the only supported metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link StatisticType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
     *         <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data
     *         points gathered within those five minutes. <code>p50</code> is the only supported metric.
     * @see StatisticType
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The aggregation period used for the data query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link PeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The aggregation period used for the data query.
     * @see PeriodType
     */
    public final PeriodType period() {
        return PeriodType.fromValue(period);
    }

    /**
     * <p>
     * The aggregation period used for the data query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link PeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The aggregation period used for the data query.
     * @see PeriodType
     */
    public final String periodAsString() {
        return period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQuery)) {
            return false;
        }
        DataQuery other = (DataQuery) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(source(), other.source())
                && Objects.equals(destination(), other.destination()) && Objects.equals(metricAsString(), other.metricAsString())
                && Objects.equals(statisticAsString(), other.statisticAsString())
                && Objects.equals(periodAsString(), other.periodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQuery").add("Id", id()).add("Source", source()).add("Destination", destination())
                .add("Metric", metricAsString()).add("Statistic", statisticAsString()).add("Period", periodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metricAsString()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "Period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Metric", METRIC_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("Period", PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQuery, T> g) {
        return obj -> g.apply((DataQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQuery> {
        /**
         * <p>
         * A user-defined ID associated with a data query that's returned in the <code>dataResponse</code> identifying
         * the query. For example, if you set the Id to <code>MyQuery01</code>in the query, the
         * <code>dataResponse</code> identifies the query as <code>MyQuery01</code>.
         * </p>
         * 
         * @param id
         *        A user-defined ID associated with a data query that's returned in the <code>dataResponse</code>
         *        identifying the query. For example, if you set the Id to <code>MyQuery01</code>in the query, the
         *        <code>dataResponse</code> identifies the query as <code>MyQuery01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Region or Availability Zone that's the source for the data query. For example, <code>us-east-1</code>.
         * </p>
         * 
         * @param source
         *        The Region or Availability Zone that's the source for the data query. For example,
         *        <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The Region or Availability Zone that's the target for the data query. For example, <code>eu-north-1</code>.
         * </p>
         * 
         * @param destination
         *        The Region or Availability Zone that's the target for the data query. For example,
         *        <code>eu-north-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The metric used for the network performance request.
         * </p>
         * 
         * @param metric
         *        The metric used for the network performance request.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(String metric);

        /**
         * <p>
         * The metric used for the network performance request.
         * </p>
         * 
         * @param metric
         *        The metric used for the network performance request.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder metric(MetricType metric);

        /**
         * <p>
         * The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
         * <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data points
         * gathered within those five minutes. <code>p50</code> is the only supported metric.
         * </p>
         * 
         * @param statistic
         *        The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
         *        <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data
         *        points gathered within those five minutes. <code>p50</code> is the only supported metric.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
         * <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data points
         * gathered within those five minutes. <code>p50</code> is the only supported metric.
         * </p>
         * 
         * @param statistic
         *        The metric data aggregation period, <code>p50</code>, between the specified <code>startDate</code> and
         *        <code>endDate</code>. For example, a metric of <code>five_minutes</code> is the median of all the data
         *        points gathered within those five minutes. <code>p50</code> is the only supported metric.
         * @see StatisticType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticType
         */
        Builder statistic(StatisticType statistic);

        /**
         * <p>
         * The aggregation period used for the data query.
         * </p>
         * 
         * @param period
         *        The aggregation period used for the data query.
         * @see PeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodType
         */
        Builder period(String period);

        /**
         * <p>
         * The aggregation period used for the data query.
         * </p>
         * 
         * @param period
         *        The aggregation period used for the data query.
         * @see PeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodType
         */
        Builder period(PeriodType period);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String source;

        private String destination;

        private String metric;

        private String statistic;

        private String period;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQuery model) {
            id(model.id);
            source(model.source);
            destination(model.destination);
            metric(model.metric);
            statistic(model.statistic);
            period(model.period);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(MetricType metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(StatisticType statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(PeriodType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        @Override
        public DataQuery build() {
            return new DataQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
