/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the neuron accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NeuronDeviceInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<NeuronDeviceInfo.Builder, NeuronDeviceInfo> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Count")
            .getter(getter(NeuronDeviceInfo::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(NeuronDeviceInfo::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<NeuronDeviceCoreInfo> CORE_INFO_FIELD = SdkField
            .<NeuronDeviceCoreInfo> builder(MarshallingType.SDK_POJO)
            .memberName("CoreInfo")
            .getter(getter(NeuronDeviceInfo::coreInfo))
            .setter(setter(Builder::coreInfo))
            .constructor(NeuronDeviceCoreInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreInfo")
                    .unmarshallLocationName("coreInfo").build()).build();

    private static final SdkField<NeuronDeviceMemoryInfo> MEMORY_INFO_FIELD = SdkField
            .<NeuronDeviceMemoryInfo> builder(MarshallingType.SDK_POJO)
            .memberName("MemoryInfo")
            .getter(getter(NeuronDeviceInfo::memoryInfo))
            .setter(setter(Builder::memoryInfo))
            .constructor(NeuronDeviceMemoryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInfo")
                    .unmarshallLocationName("memoryInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NAME_FIELD,
            CORE_INFO_FIELD, MEMORY_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final String name;

    private final NeuronDeviceCoreInfo coreInfo;

    private final NeuronDeviceMemoryInfo memoryInfo;

    private NeuronDeviceInfo(BuilderImpl builder) {
        this.count = builder.count;
        this.name = builder.name;
        this.coreInfo = builder.coreInfo;
        this.memoryInfo = builder.memoryInfo;
    }

    /**
     * <p>
     * The number of neuron accelerators for the instance type.
     * </p>
     * 
     * @return The number of neuron accelerators for the instance type.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The name of the neuron accelerator.
     * </p>
     * 
     * @return The name of the neuron accelerator.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes the cores available to each neuron accelerator.
     * </p>
     * 
     * @return Describes the cores available to each neuron accelerator.
     */
    public final NeuronDeviceCoreInfo coreInfo() {
        return coreInfo;
    }

    /**
     * <p>
     * Describes the memory available to each neuron accelerator.
     * </p>
     * 
     * @return Describes the memory available to each neuron accelerator.
     */
    public final NeuronDeviceMemoryInfo memoryInfo() {
        return memoryInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(coreInfo());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeuronDeviceInfo)) {
            return false;
        }
        NeuronDeviceInfo other = (NeuronDeviceInfo) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(name(), other.name())
                && Objects.equals(coreInfo(), other.coreInfo()) && Objects.equals(memoryInfo(), other.memoryInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NeuronDeviceInfo").add("Count", count()).add("Name", name()).add("CoreInfo", coreInfo())
                .add("MemoryInfo", memoryInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CoreInfo":
            return Optional.ofNullable(clazz.cast(coreInfo()));
        case "MemoryInfo":
            return Optional.ofNullable(clazz.cast(memoryInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Count", COUNT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CoreInfo", CORE_INFO_FIELD);
        map.put("MemoryInfo", MEMORY_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NeuronDeviceInfo, T> g) {
        return obj -> g.apply((NeuronDeviceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NeuronDeviceInfo> {
        /**
         * <p>
         * The number of neuron accelerators for the instance type.
         * </p>
         * 
         * @param count
         *        The number of neuron accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The name of the neuron accelerator.
         * </p>
         * 
         * @param name
         *        The name of the neuron accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes the cores available to each neuron accelerator.
         * </p>
         * 
         * @param coreInfo
         *        Describes the cores available to each neuron accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreInfo(NeuronDeviceCoreInfo coreInfo);

        /**
         * <p>
         * Describes the cores available to each neuron accelerator.
         * </p>
         * This is a convenience method that creates an instance of the {@link NeuronDeviceCoreInfo.Builder} avoiding
         * the need to create one manually via {@link NeuronDeviceCoreInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NeuronDeviceCoreInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #coreInfo(NeuronDeviceCoreInfo)}.
         * 
         * @param coreInfo
         *        a consumer that will call methods on {@link NeuronDeviceCoreInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreInfo(NeuronDeviceCoreInfo)
         */
        default Builder coreInfo(Consumer<NeuronDeviceCoreInfo.Builder> coreInfo) {
            return coreInfo(NeuronDeviceCoreInfo.builder().applyMutation(coreInfo).build());
        }

        /**
         * <p>
         * Describes the memory available to each neuron accelerator.
         * </p>
         * 
         * @param memoryInfo
         *        Describes the memory available to each neuron accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInfo(NeuronDeviceMemoryInfo memoryInfo);

        /**
         * <p>
         * Describes the memory available to each neuron accelerator.
         * </p>
         * This is a convenience method that creates an instance of the {@link NeuronDeviceMemoryInfo.Builder} avoiding
         * the need to create one manually via {@link NeuronDeviceMemoryInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NeuronDeviceMemoryInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #memoryInfo(NeuronDeviceMemoryInfo)}.
         * 
         * @param memoryInfo
         *        a consumer that will call methods on {@link NeuronDeviceMemoryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryInfo(NeuronDeviceMemoryInfo)
         */
        default Builder memoryInfo(Consumer<NeuronDeviceMemoryInfo.Builder> memoryInfo) {
            return memoryInfo(NeuronDeviceMemoryInfo.builder().applyMutation(memoryInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private String name;

        private NeuronDeviceCoreInfo coreInfo;

        private NeuronDeviceMemoryInfo memoryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(NeuronDeviceInfo model) {
            count(model.count);
            name(model.name);
            coreInfo(model.coreInfo);
            memoryInfo(model.memoryInfo);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NeuronDeviceCoreInfo.Builder getCoreInfo() {
            return coreInfo != null ? coreInfo.toBuilder() : null;
        }

        public final void setCoreInfo(NeuronDeviceCoreInfo.BuilderImpl coreInfo) {
            this.coreInfo = coreInfo != null ? coreInfo.build() : null;
        }

        @Override
        public final Builder coreInfo(NeuronDeviceCoreInfo coreInfo) {
            this.coreInfo = coreInfo;
            return this;
        }

        public final NeuronDeviceMemoryInfo.Builder getMemoryInfo() {
            return memoryInfo != null ? memoryInfo.toBuilder() : null;
        }

        public final void setMemoryInfo(NeuronDeviceMemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        @Override
        public final Builder memoryInfo(NeuronDeviceMemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        @Override
        public NeuronDeviceInfo build() {
            return new NeuronDeviceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
