/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlacementGroupRequest extends Ec2Request implements
        ToCopyableBuilder<CreatePlacementGroupRequest.Builder, CreatePlacementGroupRequest> {
    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionCount")
            .getter(getter(CreatePlacementGroupRequest::partitionCount))
            .setter(setter(Builder::partitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionCount")
                    .unmarshallLocationName("PartitionCount").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreatePlacementGroupRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SPREAD_LEVEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpreadLevel")
            .getter(getter(CreatePlacementGroupRequest::spreadLevelAsString))
            .setter(setter(Builder::spreadLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadLevel")
                    .unmarshallLocationName("SpreadLevel").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreatePlacementGroupRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(CreatePlacementGroupRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Strategy")
            .getter(getter(CreatePlacementGroupRequest::strategyAsString))
            .setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy")
                    .unmarshallLocationName("strategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_COUNT_FIELD,
            TAG_SPECIFICATIONS_FIELD, SPREAD_LEVEL_FIELD, DRY_RUN_FIELD, GROUP_NAME_FIELD, STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer partitionCount;

    private final List<TagSpecification> tagSpecifications;

    private final String spreadLevel;

    private final Boolean dryRun;

    private final String groupName;

    private final String strategy;

    private CreatePlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.partitionCount = builder.partitionCount;
        this.tagSpecifications = builder.tagSpecifications;
        this.spreadLevel = builder.spreadLevel;
        this.dryRun = builder.dryRun;
        this.groupName = builder.groupName;
        this.strategy = builder.strategy;
    }

    /**
     * <p>
     * The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
     * </p>
     * 
     * @return The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
     */
    public final Integer partitionCount() {
        return partitionCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the new placement group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the new placement group.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Determines how placement groups spread instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Host – You can use <code>host</code> only with Outpost placement groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * Rack – No usage restrictions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spreadLevel} will
     * return {@link SpreadLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spreadLevelAsString}.
     * </p>
     * 
     * @return Determines how placement groups spread instances. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Host – You can use <code>host</code> only with Outpost placement groups.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rack – No usage restrictions.
     *         </p>
     *         </li>
     * @see SpreadLevel
     */
    public final SpreadLevel spreadLevel() {
        return SpreadLevel.fromValue(spreadLevel);
    }

    /**
     * <p>
     * Determines how placement groups spread instances.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Host – You can use <code>host</code> only with Outpost placement groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * Rack – No usage restrictions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spreadLevel} will
     * return {@link SpreadLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spreadLevelAsString}.
     * </p>
     * 
     * @return Determines how placement groups spread instances. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Host – You can use <code>host</code> only with Outpost placement groups.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rack – No usage restrictions.
     *         </p>
     *         </li>
     * @see SpreadLevel
     */
    public final String spreadLevelAsString() {
        return spreadLevel;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the operation, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the operation, without actually making the request,
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A name for the placement group. Must be unique within the scope of your account for the Region.
     * </p>
     * <p>
     * Constraints: Up to 255 ASCII characters
     * </p>
     * 
     * @return A name for the placement group. Must be unique within the scope of your account for the Region.</p>
     *         <p>
     *         Constraints: Up to 255 ASCII characters
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public final PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(spreadLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest) obj;
        return Objects.equals(partitionCount(), other.partitionCount()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(spreadLevelAsString(), other.spreadLevelAsString()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(strategyAsString(), other.strategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlacementGroupRequest").add("PartitionCount", partitionCount())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("SpreadLevel", spreadLevelAsString()).add("DryRun", dryRun()).add("GroupName", groupName())
                .add("Strategy", strategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionCount":
            return Optional.ofNullable(clazz.cast(partitionCount()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "SpreadLevel":
            return Optional.ofNullable(clazz.cast(spreadLevelAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PartitionCount", PARTITION_COUNT_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("SpreadLevel", SPREAD_LEVEL_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("Strategy", STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePlacementGroupRequest, T> g) {
        return obj -> g.apply((CreatePlacementGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlacementGroupRequest> {
        /**
         * <p>
         * The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
         * </p>
         * 
         * @param partitionCount
         *        The number of partitions. Valid only when <b>Strategy</b> is set to <code>partition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionCount(Integer partitionCount);

        /**
         * <p>
         * The tags to apply to the new placement group.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new placement group.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new placement group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Determines how placement groups spread instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Host – You can use <code>host</code> only with Outpost placement groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * Rack – No usage restrictions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param spreadLevel
         *        Determines how placement groups spread instances. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Host – You can use <code>host</code> only with Outpost placement groups.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rack – No usage restrictions.
         *        </p>
         *        </li>
         * @see SpreadLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpreadLevel
         */
        Builder spreadLevel(String spreadLevel);

        /**
         * <p>
         * Determines how placement groups spread instances.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Host – You can use <code>host</code> only with Outpost placement groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * Rack – No usage restrictions.
         * </p>
         * </li>
         * </ul>
         * 
         * @param spreadLevel
         *        Determines how placement groups spread instances. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Host – You can use <code>host</code> only with Outpost placement groups.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rack – No usage restrictions.
         *        </p>
         *        </li>
         * @see SpreadLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpreadLevel
         */
        Builder spreadLevel(SpreadLevel spreadLevel);

        /**
         * <p>
         * Checks whether you have the required permissions for the operation, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the operation, without actually making the
         *        request, and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A name for the placement group. Must be unique within the scope of your account for the Region.
         * </p>
         * <p>
         * Constraints: Up to 255 ASCII characters
         * </p>
         * 
         * @param groupName
         *        A name for the placement group. Must be unique within the scope of your account for the Region.</p>
         *        <p>
         *        Constraints: Up to 255 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(PlacementStrategy strategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer partitionCount;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String spreadLevel;

        private Boolean dryRun;

        private String groupName;

        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlacementGroupRequest model) {
            super(model);
            partitionCount(model.partitionCount);
            tagSpecifications(model.tagSpecifications);
            spreadLevel(model.spreadLevel);
            dryRun(model.dryRun);
            groupName(model.groupName);
            strategy(model.strategy);
        }

        public final Integer getPartitionCount() {
            return partitionCount;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSpreadLevel() {
            return spreadLevel;
        }

        public final void setSpreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
        }

        @Override
        public final Builder spreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
            return this;
        }

        @Override
        public final Builder spreadLevel(SpreadLevel spreadLevel) {
            this.spreadLevel(spreadLevel == null ? null : spreadLevel.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlacementGroupRequest build() {
            return new CreatePlacementGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
