/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ImageCriterion;
import software.amazon.awssdk.services.ec2.model.ImageCriterionListCopier;
import software.amazon.awssdk.services.ec2.model.ManagedBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAllowedImagesSettingsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetAllowedImagesSettingsResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetAllowedImagesSettingsResponse.getter(GetAllowedImagesSettingsResponse::state)).setter(GetAllowedImagesSettingsResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<ImageCriterion>> IMAGE_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageCriteria").getter(GetAllowedImagesSettingsResponse.getter(GetAllowedImagesSettingsResponse::imageCriteria)).setter(GetAllowedImagesSettingsResponse.setter(Builder::imageCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageCriterionSet").unmarshallLocationName("imageCriterionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageCriterion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedBy").getter(GetAllowedImagesSettingsResponse.getter(GetAllowedImagesSettingsResponse::managedByAsString)).setter(GetAllowedImagesSettingsResponse.setter(Builder::managedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").unmarshallLocationName("managedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, IMAGE_CRITERIA_FIELD, MANAGED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAllowedImagesSettingsResponse.memberNameToFieldInitializer();
    private final String state;
    private final List<ImageCriterion> imageCriteria;
    private final String managedBy;

    private GetAllowedImagesSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.imageCriteria = builder.imageCriteria;
        this.managedBy = builder.managedBy;
    }

    public final String state() {
        return this.state;
    }

    public final boolean hasImageCriteria() {
        return this.imageCriteria != null && !(this.imageCriteria instanceof SdkAutoConstructList);
    }

    public final List<ImageCriterion> imageCriteria() {
        return this.imageCriteria;
    }

    public final ManagedBy managedBy() {
        return ManagedBy.fromValue(this.managedBy);
    }

    public final String managedByAsString() {
        return this.managedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageCriteria() ? this.imageCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAllowedImagesSettingsResponse)) {
            return false;
        }
        GetAllowedImagesSettingsResponse other = (GetAllowedImagesSettingsResponse)((Object)obj);
        return Objects.equals(this.state(), other.state()) && this.hasImageCriteria() == other.hasImageCriteria() && Objects.equals(this.imageCriteria(), other.imageCriteria()) && Objects.equals(this.managedByAsString(), other.managedByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAllowedImagesSettingsResponse").add("State", (Object)this.state()).add("ImageCriteria", this.hasImageCriteria() ? this.imageCriteria() : null).add("ManagedBy", (Object)this.managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "ImageCriteria": {
                return Optional.ofNullable(clazz.cast(this.imageCriteria()));
            }
            case "ManagedBy": {
                return Optional.ofNullable(clazz.cast(this.managedByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("State", STATE_FIELD);
        map.put("ImageCriterionSet", IMAGE_CRITERIA_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAllowedImagesSettingsResponse, T> g) {
        return obj -> g.apply((GetAllowedImagesSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String state;
        private List<ImageCriterion> imageCriteria = DefaultSdkAutoConstructList.getInstance();
        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAllowedImagesSettingsResponse model) {
            super(model);
            this.state(model.state);
            this.imageCriteria(model.imageCriteria);
            this.managedBy(model.managedBy);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final List<ImageCriterion.Builder> getImageCriteria() {
            List<ImageCriterion.Builder> result = ImageCriterionListCopier.copyToBuilder(this.imageCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageCriteria(Collection<ImageCriterion.BuilderImpl> imageCriteria) {
            this.imageCriteria = ImageCriterionListCopier.copyFromBuilder(imageCriteria);
        }

        @Override
        public final Builder imageCriteria(Collection<ImageCriterion> imageCriteria) {
            this.imageCriteria = ImageCriterionListCopier.copy(imageCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageCriteria(ImageCriterion ... imageCriteria) {
            this.imageCriteria(Arrays.asList(imageCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageCriteria(Consumer<ImageCriterion.Builder> ... imageCriteria) {
            this.imageCriteria(Stream.of(imageCriteria).map(c -> (ImageCriterion)((ImageCriterion.Builder)ImageCriterion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getManagedBy() {
            return this.managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(ManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        @Override
        public GetAllowedImagesSettingsResponse build() {
            return new GetAllowedImagesSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAllowedImagesSettingsResponse> {
        public Builder state(String var1);

        public Builder imageCriteria(Collection<ImageCriterion> var1);

        public Builder imageCriteria(ImageCriterion ... var1);

        public Builder imageCriteria(Consumer<ImageCriterion.Builder> ... var1);

        public Builder managedBy(String var1);

        public Builder managedBy(ManagedBy var1);
    }
}

