/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImportSnapshotTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeImportSnapshotTasksResponse.Builder, DescribeImportSnapshotTasksResponse> {
    private static final SdkField<List<ImportSnapshotTask>> IMPORT_SNAPSHOT_TASKS_FIELD = SdkField
            .<List<ImportSnapshotTask>> builder(MarshallingType.LIST)
            .memberName("ImportSnapshotTasks")
            .getter(getter(DescribeImportSnapshotTasksResponse::importSnapshotTasks))
            .setter(setter(Builder::importSnapshotTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSnapshotTaskSet")
                    .unmarshallLocationName("importSnapshotTaskSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImportSnapshotTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportSnapshotTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeImportSnapshotTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_SNAPSHOT_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ImportSnapshotTask> importSnapshotTasks;

    private final String nextToken;

    private DescribeImportSnapshotTasksResponse(BuilderImpl builder) {
        super(builder);
        this.importSnapshotTasks = builder.importSnapshotTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportSnapshotTasks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImportSnapshotTasks() {
        return importSnapshotTasks != null && !(importSnapshotTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
     * previous 7 days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportSnapshotTasks} method.
     * </p>
     * 
     * @return A list of zero or more import snapshot tasks that are currently active or were completed or canceled in
     *         the previous 7 days.
     */
    public final List<ImportSnapshotTask> importSnapshotTasks() {
        return importSnapshotTasks;
    }

    /**
     * <p>
     * The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     * to return.
     * </p>
     * 
     * @return The token to use to get the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImportSnapshotTasks() ? importSnapshotTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportSnapshotTasksResponse)) {
            return false;
        }
        DescribeImportSnapshotTasksResponse other = (DescribeImportSnapshotTasksResponse) obj;
        return hasImportSnapshotTasks() == other.hasImportSnapshotTasks()
                && Objects.equals(importSnapshotTasks(), other.importSnapshotTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImportSnapshotTasksResponse")
                .add("ImportSnapshotTasks", hasImportSnapshotTasks() ? importSnapshotTasks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportSnapshotTasks":
            return Optional.ofNullable(clazz.cast(importSnapshotTasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImportSnapshotTaskSet", IMPORT_SNAPSHOT_TASKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportSnapshotTasksResponse, T> g) {
        return obj -> g.apply((DescribeImportSnapshotTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImportSnapshotTasksResponse> {
        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importSnapshotTasks
         *        A list of zero or more import snapshot tasks that are currently active or were completed or canceled
         *        in the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks);

        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importSnapshotTasks
         *        A list of zero or more import snapshot tasks that are currently active or were completed or canceled
         *        in the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSnapshotTasks(ImportSnapshotTask... importSnapshotTasks);

        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImportSnapshotTask.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ImportSnapshotTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImportSnapshotTask.Builder#build()} is called immediately
         * and its result is passed to {@link #importSnapshotTasks(List<ImportSnapshotTask>)}.
         * 
         * @param importSnapshotTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImportSnapshotTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importSnapshotTasks(java.util.Collection<ImportSnapshotTask>)
         */
        Builder importSnapshotTasks(Consumer<ImportSnapshotTask.Builder>... importSnapshotTasks);

        /**
         * <p>
         * The token to use to get the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ImportSnapshotTask> importSnapshotTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportSnapshotTasksResponse model) {
            super(model);
            importSnapshotTasks(model.importSnapshotTasks);
            nextToken(model.nextToken);
        }

        public final List<ImportSnapshotTask.Builder> getImportSnapshotTasks() {
            List<ImportSnapshotTask.Builder> result = ImportSnapshotTaskListCopier.copyToBuilder(this.importSnapshotTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportSnapshotTasks(Collection<ImportSnapshotTask.BuilderImpl> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copyFromBuilder(importSnapshotTasks);
        }

        @Override
        public final Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copy(importSnapshotTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(ImportSnapshotTask... importSnapshotTasks) {
            importSnapshotTasks(Arrays.asList(importSnapshotTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(Consumer<ImportSnapshotTask.Builder>... importSnapshotTasks) {
            importSnapshotTasks(Stream.of(importSnapshotTasks).map(c -> ImportSnapshotTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImportSnapshotTasksResponse build() {
            return new DescribeImportSnapshotTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
