/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRule;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSecurityGroupRulesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSecurityGroupRulesResponse> {
    private static final SdkField<List<SecurityGroupRule>> SECURITY_GROUP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupRules").getter(DescribeSecurityGroupRulesResponse.getter(DescribeSecurityGroupRulesResponse::securityGroupRules)).setter(DescribeSecurityGroupRulesResponse.setter(Builder::securityGroupRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleSet").unmarshallLocationName("securityGroupRuleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSecurityGroupRulesResponse.getter(DescribeSecurityGroupRulesResponse::nextToken)).setter(DescribeSecurityGroupRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSecurityGroupRulesResponse.memberNameToFieldInitializer();
    private final List<SecurityGroupRule> securityGroupRules;
    private final String nextToken;

    private DescribeSecurityGroupRulesResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupRules = builder.securityGroupRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSecurityGroupRules() {
        return this.securityGroupRules != null && !(this.securityGroupRules instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupRule> securityGroupRules() {
        return this.securityGroupRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupRules() ? this.securityGroupRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupRulesResponse)) {
            return false;
        }
        DescribeSecurityGroupRulesResponse other = (DescribeSecurityGroupRulesResponse)((Object)obj);
        return this.hasSecurityGroupRules() == other.hasSecurityGroupRules() && Objects.equals(this.securityGroupRules(), other.securityGroupRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSecurityGroupRulesResponse").add("SecurityGroupRules", this.hasSecurityGroupRules() ? this.securityGroupRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupRules": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecurityGroupRuleSet", SECURITY_GROUP_RULES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityGroupRulesResponse, T> g) {
        return obj -> g.apply((DescribeSecurityGroupRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SecurityGroupRule> securityGroupRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupRulesResponse model) {
            super(model);
            this.securityGroupRules(model.securityGroupRules);
            this.nextToken(model.nextToken);
        }

        public final List<SecurityGroupRule.Builder> getSecurityGroupRules() {
            List<SecurityGroupRule.Builder> result = SecurityGroupRuleListCopier.copyToBuilder(this.securityGroupRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupRules(Collection<SecurityGroupRule.BuilderImpl> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copyFromBuilder(securityGroupRules);
        }

        @Override
        public final Builder securityGroupRules(Collection<SecurityGroupRule> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleListCopier.copy(securityGroupRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRules(SecurityGroupRule ... securityGroupRules) {
            this.securityGroupRules(Arrays.asList(securityGroupRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRules(Consumer<SecurityGroupRule.Builder> ... securityGroupRules) {
            this.securityGroupRules(Stream.of(securityGroupRules).map(c -> (SecurityGroupRule)((SecurityGroupRule.Builder)SecurityGroupRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSecurityGroupRulesResponse build() {
            return new DescribeSecurityGroupRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSecurityGroupRulesResponse> {
        public Builder securityGroupRules(Collection<SecurityGroupRule> var1);

        public Builder securityGroupRules(SecurityGroupRule ... var1);

        public Builder securityGroupRules(Consumer<SecurityGroupRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

