/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceOptions> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantId").getter(DeviceOptions.getter(DeviceOptions::tenantId)).setter(DeviceOptions.setter(Builder::tenantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").unmarshallLocationName("tenantId").build()}).build();
    private static final SdkField<String> PUBLIC_SIGNING_KEY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicSigningKeyUrl").getter(DeviceOptions.getter(DeviceOptions::publicSigningKeyUrl)).setter(DeviceOptions.setter(Builder::publicSigningKeyUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSigningKeyUrl").unmarshallLocationName("publicSigningKeyUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD, PUBLIC_SIGNING_KEY_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tenantId;
    private final String publicSigningKeyUrl;

    private DeviceOptions(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.publicSigningKeyUrl = builder.publicSigningKeyUrl;
    }

    public final String tenantId() {
        return this.tenantId;
    }

    public final String publicSigningKeyUrl() {
        return this.publicSigningKeyUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicSigningKeyUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceOptions)) {
            return false;
        }
        DeviceOptions other = (DeviceOptions)obj;
        return Objects.equals(this.tenantId(), other.tenantId()) && Objects.equals(this.publicSigningKeyUrl(), other.publicSigningKeyUrl());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceOptions").add("TenantId", (Object)this.tenantId()).add("PublicSigningKeyUrl", (Object)this.publicSigningKeyUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantId": {
                return Optional.ofNullable(clazz.cast(this.tenantId()));
            }
            case "PublicSigningKeyUrl": {
                return Optional.ofNullable(clazz.cast(this.publicSigningKeyUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("PublicSigningKeyUrl", PUBLIC_SIGNING_KEY_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceOptions, T> g) {
        return obj -> g.apply((DeviceOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tenantId;
        private String publicSigningKeyUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceOptions model) {
            this.tenantId(model.tenantId);
            this.publicSigningKeyUrl(model.publicSigningKeyUrl);
        }

        public final String getTenantId() {
            return this.tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getPublicSigningKeyUrl() {
            return this.publicSigningKeyUrl;
        }

        public final void setPublicSigningKeyUrl(String publicSigningKeyUrl) {
            this.publicSigningKeyUrl = publicSigningKeyUrl;
        }

        @Override
        public final Builder publicSigningKeyUrl(String publicSigningKeyUrl) {
            this.publicSigningKeyUrl = publicSigningKeyUrl;
            return this;
        }

        public DeviceOptions build() {
            return new DeviceOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceOptions> {
        public Builder tenantId(String var1);

        public Builder publicSigningKeyUrl(String var1);
    }
}

