/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDataExportResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityManagerDataExportsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityManagerDataExportsResponse;

public class DescribeCapacityManagerDataExportsPublisher
implements SdkPublisher<DescribeCapacityManagerDataExportsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityManagerDataExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityManagerDataExportsPublisher(Ec2AsyncClient client, DescribeCapacityManagerDataExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityManagerDataExportsPublisher(Ec2AsyncClient client, DescribeCapacityManagerDataExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityManagerDataExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityManagerDataExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityManagerDataExportResponse> capacityManagerDataExports() {
        Function<DescribeCapacityManagerDataExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityManagerDataExports() != null) {
                return response.capacityManagerDataExports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCapacityManagerDataExportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCapacityManagerDataExportsResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityManagerDataExportsResponse> {
        private DescribeCapacityManagerDataExportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityManagerDataExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityManagerDataExportsResponse> nextPage(DescribeCapacityManagerDataExportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityManagerDataExportsPublisher.this.client.describeCapacityManagerDataExports(DescribeCapacityManagerDataExportsPublisher.this.firstRequest);
            }
            return DescribeCapacityManagerDataExportsPublisher.this.client.describeCapacityManagerDataExports((DescribeCapacityManagerDataExportsRequest)((Object)DescribeCapacityManagerDataExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

