/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CapacityBlockResourceState {
    ACTIVE("active"),

    EXPIRED("expired"),

    UNAVAILABLE("unavailable"),

    CANCELLED("cancelled"),

    FAILED("failed"),

    SCHEDULED("scheduled"),

    PAYMENT_PENDING("payment-pending"),

    PAYMENT_FAILED("payment-failed"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapacityBlockResourceState> VALUE_MAP = EnumUtils.uniqueIndex(
            CapacityBlockResourceState.class, CapacityBlockResourceState::toString);

    private final String value;

    private CapacityBlockResourceState(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CapacityBlockResourceState corresponding to the value
     */
    public static CapacityBlockResourceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CapacityBlockResourceState}s
     */
    public static Set<CapacityBlockResourceState> knownValues() {
        Set<CapacityBlockResourceState> knownValues = EnumSet.allOf(CapacityBlockResourceState.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
