/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstancesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeInstancesRequest.Builder, DescribeInstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(DescribeInstancesRequest::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstanceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstanceId").unmarshallLocationName("InstanceId").build())
                                            .build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeInstancesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeInstancesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeInstancesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeInstancesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD,
            DRY_RUN_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> instanceIds;

    private final Boolean dryRun;

    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance IDs.
     * </p>
     * <p>
     * Default: Describes all your instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return The instance IDs.</p>
     *         <p>
     *         Default: Describes all your instances.
     */
    public final List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the operation, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the operation, without actually making the request,
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> |
     * <code>host</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
     * <code>arm64</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone-id</code> - The ID of the Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
     * example, <code>2022-09-15T17:15:20.000Z</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
     * deleted on instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
     * example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
     * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> |
     * <code>uefi</code> | <code>uefi-preferred</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance's Capacity
     * Reservation preference (<code>open</code> | <code>none</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> - The ID of
     * the targeted Capacity Reservation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code>
     * - The ARN of the targeted Capacity Reservation group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client-token</code> - The idempotency token you provided when you launched the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch or start (
     * <code>legacy-bios</code> | <code>uefi</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dns-name</code> - The public DNS name of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS I/O.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced networking with
     * ENA.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for Amazon Web
     * Services Nitro Enclaves.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
     * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The value
     * <code>xen</code> is used for both Xen and Nitro hypervisors.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as an ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-id</code> - The ID of the image used to launch the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or a Capacity
     * Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is used
     * for internal purposes and should be ignored. The low byte is set based on the state represented. The valid values
     * are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
     * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance.group-id</code> - The ID of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance.group-name</code> - The name of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-address</code> - The public IPv4 address of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-address</code> - The IPv6 address of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key-name</code> - The name of the key pair used when the instance was launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch
     * group (for example, 0, 1, 2, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC time zone
     * (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
     * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the instance (
     * <code>disabled</code> | <code>default</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on your instance
     * (<code>enabled</code> | <code>disabled</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (
     * <code>disabled</code> | <code>enabled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (
     * <code>disabled</code> | <code>enabled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop limit
     * (integer, possible values <code>1</code> to <code>64</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
     * <code>required</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the instance
     * metadata (<code>enabled</code> | <code>disabled</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> |
     * <code>applied</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
     * <code>enabled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.association-id</code> - The association ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
     * associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
     * address (IPv4) with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network interface is
     * the primary private IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.private-dns-name</code> - The private DNS name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
     * Elastic IP address (IPv4) for your network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.association-id</code> - The association ID returned when the network
     * interface was associated with an IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated
     * with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.public-dns-name</code> - The public DNS name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
     * when an instance is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network
     * interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.network-card-index</code> - The index of the network card.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
     * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network interface with
     * an IPv6 address is unreachable from the public internet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.description</code> - The description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-name</code> - The name of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this is the
     * primary IPv6 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.mac-address</code> - The MAC address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.operator.managed</code> - A Boolean that indicates whether the instance has a managed
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.operator.principal</code> - The principal that manages the network interface. Only valid
     * for instances with managed network interfaces, where <code>managed</code> is <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.outpost-arn</code> - The ARN of the Outpost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.private-ip-address</code> - The private IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.public-dns-name</code> - The public DNS name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.requester-id</code> - The requester ID for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by
     * Amazon Web Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
     * <code>in-use</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
     * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking
     * is disabled. The value must be <code>false</code> for the network interface to perform network address
     * translation (NAT) in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-performance-options.bandwidth-weighting</code> - Where the performance boost is applied, if
     * applicable. Valid values: <code>default</code>, <code>vpc-1</code>, <code>ebs-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>operator.managed</code> - A Boolean that indicates whether this is a managed instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>operator.principal</code> - The principal that manages the instance. Only valid for managed instances,
     * where <code>managed</code> is <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>placement-group-name</code> - The name of the placement group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>placement-partition-number</code> - The partition in which the instance is located.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform-details</code> - The platform (<code>Linux/UNIX</code> | <code>Red Hat BYOL Linux</code> |
     * <code> Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> |
     * <code>Red Hat Enterprise Linux with High Availability</code> |
     * <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> |
     * <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> |
     * <code>Red Hat Enterprise Linux with SQL Server Standard</code> |
     * <code>Red Hat Enterprise Linux with SQL Server Web</code> |
     * <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code> |
     * <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> |
     * <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> |
     * <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> |
     * <code>Windows with SQL Server Web</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates whether to
     * respond to DNS queries for instance hostnames with DNS A records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates whether to
     * respond to DNS queries for instance hostnames with DNS AAAA records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> |
     * <code>resource-name</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to filter by
     * the primary IP address of the network interface attached to the instance. To filter by additional IP addresses
     * assigned to the network interface, use the filter <code>network-interface.addresses.private-ip-address</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ramdisk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reason</code> - The reason for the current state of the instance (for example, shows
     * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, Amazon
     * Web Services Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
     * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be
     * associated with more than one instance if you launch multiple instances using the same launch request. For
     * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
     * launch request, you also get one reservation ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-name</code> - The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     * <code>instance-store</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of
     * <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled. The
     * value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-code</code> - The reason code for the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-message</code> - A message that describes the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that have
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
     * <code>host</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (<code>v2.0</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> |
     * <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> |
     * <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> |
     * <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> |
     * <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> |
     * <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> |
     * <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for example,
     * <code>2022-09-15T17:15:20.000Z</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
     * <code>hvm</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
     *         <code>default</code> | <code>host</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
     *         <code>arm64</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone-id</code> - The ID of the Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance,
     *         for example, <code>2022-09-15T17:15:20.000Z</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume
     *         is deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
     *         (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> |
     *         <code>uefi</code> | <code>uefi-preferred</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was
     *         launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance's Capacity
     *         Reservation preference (<code>open</code> | <code>none</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> - The
     *         ID of the targeted Capacity Reservation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code>
     *         - The ARN of the targeted Capacity Reservation group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client-token</code> - The idempotency token you provided when you launched the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch or
     *         start (<code>legacy-bios</code> | <code>uefi</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dns-name</code> - The public DNS name of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS
     *         I/O.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced
     *         networking with ENA.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for
     *         Amazon Web Services Nitro Enclaves.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled
     *         for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The
     *         value <code>xen</code> is used for both Xen and Nitro hypervisors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as
     *         an ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as an
     *         ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-id</code> - The ID of the image used to launch the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or a
     *         Capacity Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte
     *         is used for internal purposes and should be ignored. The low byte is set based on the state represented.
     *         The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and
     *         80 (stopped).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code>
     *         | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance.group-id</code> - The ID of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance.group-name</code> - The name of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-address</code> - The public IPv4 address of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-address</code> - The IPv6 address of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key-name</code> - The name of the key pair used when the instance was launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
     *         launch group (for example, 0, 1, 2, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC
     *         time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a
     *         wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the instance
     *         (<code>disabled</code> | <code>default</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on your
     *         instance (<code>enabled</code> | <code>disabled</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (
     *         <code>disabled</code> | <code>enabled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (
     *         <code>disabled</code> | <code>enabled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop
     *         limit (integer, possible values <code>1</code> to <code>64</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.http-tokens</code> - The metadata request authorization state (
     *         <code>optional</code> | <code>required</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the
     *         instance metadata (<code>enabled</code> | <code>disabled</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> |
     *         <code>applied</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
     *         <code>enabled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.association-id</code> - The association ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
     *         address associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic
     *         IP address (IPv4) with a network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
     *         interface is the primary private IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.private-dns-name</code> - The private DNS name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
     *         the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated
     *         the Elastic IP address (IPv4) for your network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.association-id</code> - The association ID returned when the network
     *         interface was associated with an IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
     *         associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.public-dns-name</code> - The public DNS name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound
     *         to the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached
     *         to an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
     *         deleted when an instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.device-index</code> - The device index to which the network interface
     *         is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
     *         interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
     *         network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.network-card-index</code> - The index of the network card.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network
     *         interface with an IPv6 address is unreachable from the public internet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.description</code> - The description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-id</code> - The ID of a security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-name</code> - The name of a security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the
     *         network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this is
     *         the primary IPv6 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only
     *         network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.mac-address</code> - The MAC address of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.operator.managed</code> - A Boolean that indicates whether the instance has a
     *         managed network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.operator.principal</code> - The principal that manages the network interface.
     *         Only valid for instances with managed network interfaces, where <code>managed</code> is <code>true</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.outpost-arn</code> - The ARN of the Outpost.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.private-ip-address</code> - The private IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.public-dns-name</code> - The public DNS name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.requester-id</code> - The requester ID for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
     *         managed by Amazon Web Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
     *         <code>in-use</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.source-dest-check</code> - Whether the network interface performs
     *         source/destination checking. A value of <code>true</code> means that checking is enabled, and
     *         <code>false</code> means that checking is disabled. The value must be <code>false</code> for the network
     *         interface to perform network address translation (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-performance-options.bandwidth-weighting</code> - Where the performance boost is applied, if
     *         applicable. Valid values: <code>default</code>, <code>vpc-1</code>, <code>ebs-1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>operator.managed</code> - A Boolean that indicates whether this is a managed instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>operator.principal</code> - The principal that manages the instance. Only valid for managed
     *         instances, where <code>managed</code> is <code>true</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placement-group-name</code> - The name of the placement group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placement-partition-number</code> - The partition in which the instance is located.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform-details</code> - The platform (<code>Linux/UNIX</code> | <code>Red Hat BYOL Linux</code> |
     *         <code> Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> |
     *         <code>Red Hat Enterprise Linux with High Availability</code> |
     *         <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> |
     *         <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> |
     *         <code>Red Hat Enterprise Linux with SQL Server Standard</code> |
     *         <code>Red Hat Enterprise Linux with SQL Server Web</code> |
     *         <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code> |
     *         <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> |
     *         <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> |
     *         <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> |
     *         <code>Windows with SQL Server Web</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates
     *         whether to respond to DNS queries for instance hostnames with DNS A records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates
     *         whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> |
     *         <code>resource-name</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to
     *         filter by the primary IP address of the network interface attached to the instance. To filter by
     *         additional IP addresses assigned to the network interface, use the filter
     *         <code>network-interface.addresses.private-ip-address</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code</code> - The product code associated with the AMI used to launch the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>
     *         ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ramdisk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reason</code> - The reason for the current state of the instance (for example, shows
     *         "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
     *         filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
     *         Amazon Web Services Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time
     *         you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request,
     *         but can be associated with more than one instance if you launch multiple instances using the same launch
     *         request. For example, if you launch one instance, you get one reservation ID. If you launch ten instances
     *         using the same launch request, you also get one reservation ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-name</code> - The device name of the root device volume (for example,
     *         <code>/dev/sda1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
     *         <code>instance-store</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A
     *         value of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is
     *         disabled. The value must be <code>false</code> for the instance to perform network address translation
     *         (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-code</code> - The reason code for the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-message</code> - A message that describes the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         that have a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
     *         <code>host</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (
     *         <code>v2.0</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> |
     *         <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> |
     *         <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> |
     *         <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> |
     *         <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> |
     *         <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> |
     *         <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for
     *         example, <code>2022-09-15T17:15:20.000Z</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
     *         <code>hvm</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC that the instance is running in.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * <p>
     * You cannot specify this parameter and the instance IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.</p>
     *         <p>
     *         You cannot specify this parameter and the instance IDs parameter in the same request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesRequest)) {
            return false;
        }
        DescribeInstancesRequest other = (DescribeInstancesRequest) obj;
        return hasInstanceIds() == other.hasInstanceIds() && Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(dryRun(), other.dryRun()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstancesRequest").add("InstanceIds", hasInstanceIds() ? instanceIds() : null)
                .add("DryRun", dryRun()).add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_IDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Filter", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancesRequest, T> g) {
        return obj -> g.apply((DescribeInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstancesRequest> {
        /**
         * <p>
         * The instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the operation, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the operation, without actually making the
         *        request, and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone-id</code> - The ID of the Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2022-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> |
         * <code>uefi</code> | <code>uefi-preferred</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was
         * launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance's Capacity
         * Reservation preference (<code>open</code> | <code>none</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> - The ID
         * of the targeted Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code>
         * - The ARN of the targeted Capacity Reservation group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch or
         * start (<code>legacy-bios</code> | <code>uefi</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced networking
         * with ENA.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for Amazon
         * Web Services Nitro Enclaves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
         * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The
         * value <code>xen</code> is used for both Xen and Nitro hypervisors.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as an ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or a
         * Capacity Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * used for internal purposes and should be ignored. The low byte is set based on the state represented. The
         * valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-address</code> - The IPv6 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC time
         * zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
         * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the instance (
         * <code>disabled</code> | <code>default</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on your
         * instance (<code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (
         * <code>disabled</code> | <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (
         * <code>disabled</code> | <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop limit
         * (integer, possible values <code>1</code> to <code>64</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
         * <code>required</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the
         * instance metadata (<code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> |
         * <code>applied</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.association-id</code> - The association ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-dns-name</code> - The private DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.network-card-index</code> - The index of the network card.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network interface
         * with an IPv6 address is unreachable from the public internet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this is the
         * primary IPv6 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.operator.managed</code> - A Boolean that indicates whether the instance has a managed
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.operator.principal</code> - The principal that manages the network interface. Only
         * valid for instances with managed network interfaces, where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.outpost-arn</code> - The ARN of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by Amazon Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         * checking is disabled. The value must be <code>false</code> for the network interface to perform network
         * address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-performance-options.bandwidth-weighting</code> - Where the performance boost is applied, if
         * applicable. Valid values: <code>default</code>, <code>vpc-1</code>, <code>ebs-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.managed</code> - A Boolean that indicates whether this is a managed instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.principal</code> - The principal that manages the instance. Only valid for managed instances,
         * where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-partition-number</code> - The partition in which the instance is located.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform-details</code> - The platform (<code>Linux/UNIX</code> | <code>Red Hat BYOL Linux</code> |
         * <code> Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> |
         * <code>Red Hat Enterprise Linux with High Availability</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Standard</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Web</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code> |
         * <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> |
         * <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> |
         * <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> |
         * <code>Windows with SQL Server Web</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates whether to
         * respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates whether
         * to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> |
         * <code>resource-name</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to filter
         * by the primary IP address of the network interface attached to the instance. To filter by additional IP
         * addresses assigned to the network interface, use the filter
         * <code>network-interface.addresses.private-ip-address</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
         * Amazon Web Services Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
         * launch request, you also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled.
         * The value must be <code>false</code> for the instance to perform network address translation (NAT) in your
         * VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that
         * have a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (<code>v2.0</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> |
         * <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> |
         * <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> |
         * <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> |
         * <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> |
         * <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> |
         * <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for example,
         * <code>2022-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         *        <code>default</code> | <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         *        <code>arm64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone-id</code> - The ID of the Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the
         *        instance, for example, <code>2022-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS
         *        volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
         *        (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> |
         *        <code>uefi</code> | <code>uefi-preferred</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was
         *        launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance's
         *        Capacity Reservation preference (<code>open</code> | <code>none</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> -
         *        The ID of the targeted Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code>
         *        - The ARN of the targeted Capacity Reservation group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch
         *        or start (<code>legacy-bios</code> | <code>uefi</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dns-name</code> - The public DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS
         *        I/O.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced
         *        networking with ENA.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for
         *        Amazon Web Services Nitro Enclaves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled
         *        for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         *        The value <code>xen</code> is used for both Xen and Nitro hypervisors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified
         *        as an ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as
         *        an ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or
         *        a Capacity Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high
         *        byte is used for internal purposes and should be ignored. The low byte is set based on the state
         *        represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The public IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-address</code> - The IPv6 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair used when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-index</code> - When launching multiple instances, this is the index for the instance in
         *        the launch group (for example, 0, 1, 2, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC
         *        time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use
         *        a wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the
         *        instance (<code>disabled</code> | <code>default</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on
         *        your instance (<code>enabled</code> | <code>disabled</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop
         *        limit (integer, possible values <code>1</code> to <code>64</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-tokens</code> - The metadata request authorization state (
         *        <code>optional</code> | <code>required</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the
         *        instance metadata (<code>enabled</code> | <code>disabled</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> |
         *        <code>applied</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.association-id</code> - The association ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP
         *        address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
         *        address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an
         *        Elastic IP address (IPv4) with a network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         *        interface is the primary private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-dns-name</code> - The private DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
         *        the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.allocation-id</code> - The allocation ID returned when you
         *        allocated the Elastic IP address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.association-id</code> - The association ID returned when the
         *        network interface was associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         *        associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-dns-name</code> - The public DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4)
         *        bound to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attach-time</code> - The time that the network interface was
         *        attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
         *        deleted when an instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.device-index</code> - The device index to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which
         *        the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.network-card-index</code> - The index of the network card.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.status</code> - The status of the attachment (
         *        <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network
         *        interface with an IPv6 address is unreachable from the public internet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-name</code> - The name of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this
         *        is the primary IPv6 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.operator.managed</code> - A Boolean that indicates whether the instance has a
         *        managed network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.operator.principal</code> - The principal that manages the network interface.
         *        Only valid for instances with managed network interfaces, where <code>managed</code> is
         *        <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.outpost-arn</code> - The ARN of the Outpost.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-ip-address</code> - The private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.public-dns-name</code> - The public DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-id</code> - The requester ID for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
         *        managed by Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         *        <code>in-use</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.source-dest-check</code> - Whether the network interface performs
         *        source/destination checking. A value of <code>true</code> means that checking is enabled, and
         *        <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
         *        network interface to perform network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-performance-options.bandwidth-weighting</code> - Where the performance boost is applied,
         *        if applicable. Valid values: <code>default</code>, <code>vpc-1</code>, <code>ebs-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.managed</code> - A Boolean that indicates whether this is a managed instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.principal</code> - The principal that manages the instance. Only valid for managed
         *        instances, where <code>managed</code> is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-name</code> - The name of the placement group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-partition-number</code> - The partition in which the instance is located.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform-details</code> - The platform (<code>Linux/UNIX</code> |
         *        <code>Red Hat BYOL Linux</code> | <code> Red Hat Enterprise Linux</code> |
         *        <code>Red Hat Enterprise Linux with HA</code> |
         *        <code>Red Hat Enterprise Linux with High Availability</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Standard</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Web</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code>
         *        | <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> |
         *        <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> |
         *        <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Web</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates
         *        whether to respond to DNS queries for instance hostnames with DNS A records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates
         *        whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> |
         *        <code>resource-name</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to
         *        filter by the primary IP address of the network interface attached to the instance. To filter by
         *        additional IP addresses assigned to the network interface, use the filter
         *        <code>network-interface.addresses.private-ip-address</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reason</code> - The reason for the current state of the instance (for example, shows
         *        "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
         *        filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, Amazon Web Services Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any
         *        time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch
         *        request, but can be associated with more than one instance if you launch multiple instances using the
         *        same launch request. For example, if you launch one instance, you get one reservation ID. If you
         *        launch ten instances using the same launch request, you also get one reservation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The device name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking.
         *        A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         *        checking is disabled. The value must be <code>false</code> for the instance to perform network address
         *        translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - A message that describes the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources that have a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         *        <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (
         *        <code>v2.0</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> |
         *        <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> |
         *        <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> |
         *        <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> |
         *        <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> |
         *        <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> |
         *        <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for
         *        example, <code>2022-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone-id</code> - The ID of the Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2022-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> |
         * <code>uefi</code> | <code>uefi-preferred</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was
         * launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance's Capacity
         * Reservation preference (<code>open</code> | <code>none</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> - The ID
         * of the targeted Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code>
         * - The ARN of the targeted Capacity Reservation group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch or
         * start (<code>legacy-bios</code> | <code>uefi</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced networking
         * with ENA.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for Amazon
         * Web Services Nitro Enclaves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
         * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The
         * value <code>xen</code> is used for both Xen and Nitro hypervisors.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as an ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or a
         * Capacity Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * used for internal purposes and should be ignored. The low byte is set based on the state represented. The
         * valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-address</code> - The IPv6 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC time
         * zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
         * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the instance (
         * <code>disabled</code> | <code>default</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on your
         * instance (<code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (
         * <code>disabled</code> | <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (
         * <code>disabled</code> | <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop limit
         * (integer, possible values <code>1</code> to <code>64</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
         * <code>required</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the
         * instance metadata (<code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> |
         * <code>applied</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.association-id</code> - The association ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-dns-name</code> - The private DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.network-card-index</code> - The index of the network card.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network interface
         * with an IPv6 address is unreachable from the public internet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this is the
         * primary IPv6 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.operator.managed</code> - A Boolean that indicates whether the instance has a managed
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.operator.principal</code> - The principal that manages the network interface. Only
         * valid for instances with managed network interfaces, where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.outpost-arn</code> - The ARN of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by Amazon Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         * checking is disabled. The value must be <code>false</code> for the network interface to perform network
         * address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-performance-options.bandwidth-weighting</code> - Where the performance boost is applied, if
         * applicable. Valid values: <code>default</code>, <code>vpc-1</code>, <code>ebs-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.managed</code> - A Boolean that indicates whether this is a managed instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.principal</code> - The principal that manages the instance. Only valid for managed instances,
         * where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-partition-number</code> - The partition in which the instance is located.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform-details</code> - The platform (<code>Linux/UNIX</code> | <code>Red Hat BYOL Linux</code> |
         * <code> Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> |
         * <code>Red Hat Enterprise Linux with High Availability</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Standard</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Web</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code> |
         * <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> |
         * <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> |
         * <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> |
         * <code>Windows with SQL Server Web</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates whether to
         * respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates whether
         * to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> |
         * <code>resource-name</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to filter
         * by the primary IP address of the network interface attached to the instance. To filter by additional IP
         * addresses assigned to the network interface, use the filter
         * <code>network-interface.addresses.private-ip-address</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
         * Amazon Web Services Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
         * launch request, you also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled.
         * The value must be <code>false</code> for the instance to perform network address translation (NAT) in your
         * VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that
         * have a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (<code>v2.0</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> |
         * <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> |
         * <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> |
         * <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> |
         * <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> |
         * <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> |
         * <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for example,
         * <code>2022-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         *        <code>default</code> | <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         *        <code>arm64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone-id</code> - The ID of the Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the
         *        instance, for example, <code>2022-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS
         *        volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping
         *        (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> |
         *        <code>uefi</code> | <code>uefi-preferred</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was
         *        launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance's
         *        Capacity Reservation preference (<code>open</code> | <code>none</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> -
         *        The ID of the targeted Capacity Reservation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code>
         *        - The ARN of the targeted Capacity Reservation group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch
         *        or start (<code>legacy-bios</code> | <code>uefi</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dns-name</code> - The public DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS
         *        I/O.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced
         *        networking with ENA.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for
         *        Amazon Web Services Nitro Enclaves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled
         *        for hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         *        The value <code>xen</code> is used for both Xen and Nitro hypervisors.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified
         *        as an ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as
         *        an ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or
         *        a Capacity Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high
         *        byte is used for internal purposes and should be ignored. The low byte is set based on the state
         *        represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The public IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-address</code> - The IPv6 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair used when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-index</code> - When launching multiple instances, this is the index for the instance in
         *        the launch group (for example, 0, 1, 2, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC
         *        time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use
         *        a wildcard (<code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the
         *        instance (<code>disabled</code> | <code>default</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on
         *        your instance (<code>enabled</code> | <code>disabled</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop
         *        limit (integer, possible values <code>1</code> to <code>64</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.http-tokens</code> - The metadata request authorization state (
         *        <code>optional</code> | <code>required</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the
         *        instance metadata (<code>enabled</code> | <code>disabled</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> |
         *        <code>applied</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.association-id</code> - The association ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP
         *        address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
         *        address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an
         *        Elastic IP address (IPv4) with a network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         *        interface is the primary private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-dns-name</code> - The private DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
         *        the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.allocation-id</code> - The allocation ID returned when you
         *        allocated the Elastic IP address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.association-id</code> - The association ID returned when the
         *        network interface was associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         *        associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-dns-name</code> - The public DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4)
         *        bound to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attach-time</code> - The time that the network interface was
         *        attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
         *        deleted when an instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.device-index</code> - The device index to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which
         *        the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.network-card-index</code> - The index of the network card.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.status</code> - The status of the attachment (
         *        <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network
         *        interface with an IPv6 address is unreachable from the public internet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-name</code> - The name of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this
         *        is the primary IPv6 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.operator.managed</code> - A Boolean that indicates whether the instance has a
         *        managed network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.operator.principal</code> - The principal that manages the network interface.
         *        Only valid for instances with managed network interfaces, where <code>managed</code> is
         *        <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.outpost-arn</code> - The ARN of the Outpost.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-ip-address</code> - The private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.public-dns-name</code> - The public DNS name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-id</code> - The requester ID for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
         *        managed by Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         *        <code>in-use</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.source-dest-check</code> - Whether the network interface performs
         *        source/destination checking. A value of <code>true</code> means that checking is enabled, and
         *        <code>false</code> means that checking is disabled. The value must be <code>false</code> for the
         *        network interface to perform network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-performance-options.bandwidth-weighting</code> - Where the performance boost is applied,
         *        if applicable. Valid values: <code>default</code>, <code>vpc-1</code>, <code>ebs-1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.managed</code> - A Boolean that indicates whether this is a managed instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>operator.principal</code> - The principal that manages the instance. Only valid for managed
         *        instances, where <code>managed</code> is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-name</code> - The name of the placement group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-partition-number</code> - The partition in which the instance is located.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform-details</code> - The platform (<code>Linux/UNIX</code> |
         *        <code>Red Hat BYOL Linux</code> | <code> Red Hat Enterprise Linux</code> |
         *        <code>Red Hat Enterprise Linux with HA</code> |
         *        <code>Red Hat Enterprise Linux with High Availability</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Standard</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Web</code> |
         *        <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code>
         *        | <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> |
         *        <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> |
         *        <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> |
         *        <code>Windows with SQL Server Web</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates
         *        whether to respond to DNS queries for instance hostnames with DNS A records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates
         *        whether to respond to DNS queries for instance hostnames with DNS AAAA records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> |
         *        <code>resource-name</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to
         *        filter by the primary IP address of the network interface attached to the instance. To filter by
         *        additional IP addresses assigned to the network interface, use the filter
         *        <code>network-interface.addresses.private-ip-address</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reason</code> - The reason for the current state of the instance (for example, shows
         *        "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
         *        filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, Amazon Web Services Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any
         *        time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch
         *        request, but can be associated with more than one instance if you launch multiple instances using the
         *        same launch request. For example, if you launch one instance, you get one reservation ID. If you
         *        launch ten instances using the same launch request, you also get one reservation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The device name of the root device volume (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking.
         *        A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         *        checking is disabled. The value must be <code>false</code> for the instance to perform network address
         *        translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - A message that describes the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources that have a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         *        <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (
         *        <code>v2.0</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> |
         *        <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> |
         *        <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> |
         *        <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> |
         *        <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> |
         *        <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> |
         *        <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for
         *        example, <code>2022-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code> |
         * <code>arm64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone-id</code> - The ID of the Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2022-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name specified in the block device mapping (for
         * example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>boot-mode</code> - The boot mode that was specified by the AMI (<code>legacy-bios</code> |
         * <code>uefi</code> | <code>uefi-preferred</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-id</code> - The ID of the Capacity Reservation into which the instance was
         * launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-preference</code> - The instance's Capacity
         * Reservation preference (<code>open</code> | <code>none</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id</code> - The ID
         * of the targeted Capacity Reservation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource-group-arn</code>
         * - The ARN of the targeted Capacity Reservation group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>current-instance-boot-mode</code> - The boot mode that is used to launch the instance at launch or
         * start (<code>legacy-bios</code> | <code>uefi</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ebs-optimized</code> - A Boolean that indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ena-support</code> - A Boolean that indicates whether the instance is enabled for enhanced networking
         * with ENA.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enclave-options.enabled</code> - A Boolean that indicates whether the instance is enabled for Amazon
         * Web Services Nitro Enclaves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hibernation-options.configured</code> - A Boolean that indicates whether the instance is enabled for
         * hibernation. A value of <code>true</code> means that the instance is enabled for hibernation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>). The
         * value <code>xen</code> is used for both Xen and Nitro hypervisors.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.id</code> - The instance profile associated with the instance. Specified as an ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance, a Scheduled Instance, or a
         * Capacity Block (<code>spot</code> | <code>scheduled</code> | <code>capacity-block</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * used for internal purposes and should be ignored. The low byte is set based on the state represented. The
         * valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-address</code> - The IPv6 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched, in the ISO 8601 format in the UTC time
         * zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, <code>2021-09-29T11:04:43.305Z</code>. You can use a wildcard (
         * <code>*</code>), for example, <code>2021-09-29T*</code>, which matches an entire day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>maintenance-options.auto-recovery</code> - The current automatic recovery behavior of the instance (
         * <code>disabled</code> | <code>default</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-endpoint</code> - The status of access to the HTTP metadata endpoint on your
         * instance (<code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-protocol-ipv4</code> - Indicates whether the IPv4 endpoint is enabled (
         * <code>disabled</code> | <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-protocol-ipv6</code> - Indicates whether the IPv6 endpoint is enabled (
         * <code>disabled</code> | <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-put-response-hop-limit</code> - The HTTP metadata request put response hop limit
         * (integer, possible values <code>1</code> to <code>64</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.http-tokens</code> - The metadata request authorization state (<code>optional</code> |
         * <code>required</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.instance-metadata-tags</code> - The status of access to instance tags from the
         * instance metadata (<code>enabled</code> | <code>disabled</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>metadata-options.state</code> - The state of the metadata option changes (<code>pending</code> |
         * <code>applied</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.allocation-id</code> - The allocation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.association-id</code> - The association ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.carrier-ip</code> - The carrier IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.customer-owned-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-dns-name</code> - The private DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.carrier-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.customer-owned-ip</code> - The customer-owned IP address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.network-card-index</code> - The index of the network card.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.deny-all-igw-traffic</code> - A Boolean that indicates whether a network interface
         * with an IPv6 address is unreachable from the public internet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv4-prefixes.ipv4-prefix</code> - The IPv4 prefixes that are assigned to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-address</code> - The IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.is-primary-ipv6</code> - A Boolean that indicates whether this is the
         * primary IPv6 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-native</code> - A Boolean that indicates whether this is an IPv6 only network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-prefixes.ipv6-prefix</code> - The IPv6 prefix assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.operator.managed</code> - A Boolean that indicates whether the instance has a managed
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.operator.principal</code> - The principal that manages the network interface. Only
         * valid for instances with managed network interfaces, where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.outpost-arn</code> - The ARN of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-ip-address</code> - The private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.public-dns-name</code> - The public DNS name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by Amazon Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means that checking is enabled, and <code>false</code> means that
         * checking is disabled. The value must be <code>false</code> for the network interface to perform network
         * address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.tag-key</code> - The key of a tag assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.tag-value</code> - The value of a tag assigned to the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-performance-options.bandwidth-weighting</code> - Where the performance boost is applied, if
         * applicable. Valid values: <code>default</code>, <code>vpc-1</code>, <code>ebs-1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.managed</code> - A Boolean that indicates whether this is a managed instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>operator.principal</code> - The principal that manages the instance. Only valid for managed instances,
         * where <code>managed</code> is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-partition-number</code> - The partition in which the instance is located.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. To list only Windows instances, use <code>windows</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform-details</code> - The platform (<code>Linux/UNIX</code> | <code>Red Hat BYOL Linux</code> |
         * <code> Red Hat Enterprise Linux</code> | <code>Red Hat Enterprise Linux with HA</code> |
         * <code>Red Hat Enterprise Linux with High Availability</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Standard and HA</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Enterprise and HA</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Standard</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Web</code> |
         * <code>Red Hat Enterprise Linux with SQL Server Enterprise</code> | <code>SQL Server Enterprise</code> |
         * <code>SQL Server Standard</code> | <code>SQL Server Web</code> | <code>SUSE Linux</code> |
         * <code>Ubuntu Pro</code> | <code>Windows</code> | <code>Windows BYOL</code> |
         * <code>Windows with SQL Server Enterprise</code> | <code>Windows with SQL Server Standard</code> |
         * <code>Windows with SQL Server Web</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.enable-resource-name-dns-a-record</code> - A Boolean that indicates whether to
         * respond to DNS queries for instance hostnames with DNS A records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.enable-resource-name-dns-aaaa-record</code> - A Boolean that indicates whether
         * to respond to DNS queries for instance hostnames with DNS AAAA records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name-options.hostname-type</code> - The type of hostname (<code>ip-name</code> |
         * <code>resource-name</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance. This can only be used to filter
         * by the primary IP address of the network interface attached to the instance. To filter by additional IP
         * addresses assigned to the network interface, use the filter
         * <code>network-interface.addresses.private-ip-address</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
         * Amazon Web Services Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you get one reservation ID. If you launch ten instances using the same
         * launch request, you also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The device name of the root device volume (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of the root device volume (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means that checking is disabled.
         * The value must be <code>false</code> for the instance to perform network address translation (NAT) in your
         * VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot Instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources that
         * have a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tpm-support</code> - Indicates if the instance is configured for NitroTPM support (<code>v2.0</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-operation</code> - The usage operation value for the instance (<code>RunInstances</code> |
         * <code>RunInstances:00g0</code> | <code>RunInstances:0010</code> | <code>RunInstances:1010</code> |
         * <code>RunInstances:1014</code> | <code>RunInstances:1110</code> | <code>RunInstances:0014</code> |
         * <code>RunInstances:0210</code> | <code>RunInstances:0110</code> | <code>RunInstances:0100</code> |
         * <code>RunInstances:0004</code> | <code>RunInstances:0200</code> | <code>RunInstances:000g</code> |
         * <code>RunInstances:0g00</code> | <code>RunInstances:0002</code> | <code>RunInstances:0800</code> |
         * <code>RunInstances:0102</code> | <code>RunInstances:0006</code> | <code>RunInstances:0202</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>usage-operation-update-time</code> - The time that the usage operation was last updated, for example,
         * <code>2022-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * <p>
         * You cannot specify this parameter and the instance IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.</p>
         *        <p>
         *        You cannot specify this parameter and the instance IDs parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesRequest model) {
            super(model);
            instanceIds(model.instanceIds);
            dryRun(model.dryRun);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getInstanceIds() {
            if (instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstancesRequest build() {
            return new DescribeInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
