/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a condition for filtering capacity data based on dimension values. Used to create precise filters for
 * metric queries and dimension lookups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionCondition.Builder, DimensionCondition> {
    private static final SdkField<String> DIMENSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Dimension")
            .getter(getter(DimensionCondition::dimensionAsString))
            .setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension")
                    .unmarshallLocationName("Dimension").build()).build();

    private static final SdkField<String> COMPARISON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comparison")
            .getter(getter(DimensionCondition::comparisonAsString))
            .setter(setter(Builder::comparison))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison")
                    .unmarshallLocationName("Comparison").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(DimensionCondition::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("Value").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD,
            COMPARISON_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dimension;

    private final String comparison;

    private final List<String> values;

    private DimensionCondition(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.comparison = builder.comparison;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the dimension to filter by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimension} will
     * return {@link FilterByDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionAsString}.
     * </p>
     * 
     * @return The name of the dimension to filter by.
     * @see FilterByDimension
     */
    public final FilterByDimension dimension() {
        return FilterByDimension.fromValue(dimension);
    }

    /**
     * <p>
     * The name of the dimension to filter by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimension} will
     * return {@link FilterByDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionAsString}.
     * </p>
     * 
     * @return The name of the dimension to filter by.
     * @see FilterByDimension
     */
    public final String dimensionAsString() {
        return dimension;
    }

    /**
     * <p>
     * The comparison operator to use for the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link Comparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparisonAsString}.
     * </p>
     * 
     * @return The comparison operator to use for the filter.
     * @see Comparison
     */
    public final Comparison comparison() {
        return Comparison.fromValue(comparison);
    }

    /**
     * <p>
     * The comparison operator to use for the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link Comparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparisonAsString}.
     * </p>
     * 
     * @return The comparison operator to use for the filter.
     * @see Comparison
     */
    public final String comparisonAsString() {
        return comparison;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of values to match against the specified dimension. For 'equals' comparison, only the first value is
     * used. For 'in' comparison, any matching value will satisfy the condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The list of values to match against the specified dimension. For 'equals' comparison, only the first
     *         value is used. For 'in' comparison, any matching value will satisfy the condition.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionCondition)) {
            return false;
        }
        DimensionCondition other = (DimensionCondition) obj;
        return Objects.equals(dimensionAsString(), other.dimensionAsString())
                && Objects.equals(comparisonAsString(), other.comparisonAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionCondition").add("Dimension", dimensionAsString())
                .add("Comparison", comparisonAsString()).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimension":
            return Optional.ofNullable(clazz.cast(dimensionAsString()));
        case "Comparison":
            return Optional.ofNullable(clazz.cast(comparisonAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dimension", DIMENSION_FIELD);
        map.put("Comparison", COMPARISON_FIELD);
        map.put("Value", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionCondition, T> g) {
        return obj -> g.apply((DimensionCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionCondition> {
        /**
         * <p>
         * The name of the dimension to filter by.
         * </p>
         * 
         * @param dimension
         *        The name of the dimension to filter by.
         * @see FilterByDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterByDimension
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * The name of the dimension to filter by.
         * </p>
         * 
         * @param dimension
         *        The name of the dimension to filter by.
         * @see FilterByDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterByDimension
         */
        Builder dimension(FilterByDimension dimension);

        /**
         * <p>
         * The comparison operator to use for the filter.
         * </p>
         * 
         * @param comparison
         *        The comparison operator to use for the filter.
         * @see Comparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Comparison
         */
        Builder comparison(String comparison);

        /**
         * <p>
         * The comparison operator to use for the filter.
         * </p>
         * 
         * @param comparison
         *        The comparison operator to use for the filter.
         * @see Comparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Comparison
         */
        Builder comparison(Comparison comparison);

        /**
         * <p>
         * The list of values to match against the specified dimension. For 'equals' comparison, only the first value is
         * used. For 'in' comparison, any matching value will satisfy the condition.
         * </p>
         * 
         * @param values
         *        The list of values to match against the specified dimension. For 'equals' comparison, only the first
         *        value is used. For 'in' comparison, any matching value will satisfy the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The list of values to match against the specified dimension. For 'equals' comparison, only the first value is
         * used. For 'in' comparison, any matching value will satisfy the condition.
         * </p>
         * 
         * @param values
         *        The list of values to match against the specified dimension. For 'equals' comparison, only the first
         *        value is used. For 'in' comparison, any matching value will satisfy the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String dimension;

        private String comparison;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionCondition model) {
            dimension(model.dimension);
            comparison(model.comparison);
            values(model.values);
        }

        public final String getDimension() {
            return dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        @Override
        public final Builder dimension(FilterByDimension dimension) {
            this.dimension(dimension == null ? null : dimension.toString());
            return this;
        }

        public final String getComparison() {
            return comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        @Override
        public final Builder comparison(Comparison comparison) {
            this.comparison(comparison == null ? null : comparison.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ConditionValueListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ConditionValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public DimensionCondition build() {
            return new DimensionCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
