/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamPolicyState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPolicy> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(IpamPolicy.getter(IpamPolicy::ownerId)).setter(IpamPolicy.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPolicyId").getter(IpamPolicy.getter(IpamPolicy::ipamPolicyId)).setter(IpamPolicy.setter(Builder::ipamPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId").unmarshallLocationName("ipamPolicyId").build()}).build();
    private static final SdkField<String> IPAM_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPolicyArn").getter(IpamPolicy.getter(IpamPolicy::ipamPolicyArn)).setter(IpamPolicy.setter(Builder::ipamPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyArn").unmarshallLocationName("ipamPolicyArn").build()}).build();
    private static final SdkField<String> IPAM_POLICY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPolicyRegion").getter(IpamPolicy.getter(IpamPolicy::ipamPolicyRegion)).setter(IpamPolicy.setter(Builder::ipamPolicyRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyRegion").unmarshallLocationName("ipamPolicyRegion").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamPolicy.getter(IpamPolicy::stateAsString)).setter(IpamPolicy.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(IpamPolicy.getter(IpamPolicy::stateMessage)).setter(IpamPolicy.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamPolicy.getter(IpamPolicy::tags)).setter(IpamPolicy.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(IpamPolicy.getter(IpamPolicy::ipamId)).setter(IpamPolicy.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("ipamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, IPAM_POLICY_ID_FIELD, IPAM_POLICY_ARN_FIELD, IPAM_POLICY_REGION_FIELD, STATE_FIELD, STATE_MESSAGE_FIELD, TAGS_FIELD, IPAM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String ipamPolicyId;
    private final String ipamPolicyArn;
    private final String ipamPolicyRegion;
    private final String state;
    private final String stateMessage;
    private final List<Tag> tags;
    private final String ipamId;

    private IpamPolicy(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.ipamPolicyId = builder.ipamPolicyId;
        this.ipamPolicyArn = builder.ipamPolicyArn;
        this.ipamPolicyRegion = builder.ipamPolicyRegion;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.tags = builder.tags;
        this.ipamId = builder.ipamId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String ipamPolicyId() {
        return this.ipamPolicyId;
    }

    public final String ipamPolicyArn() {
        return this.ipamPolicyArn;
    }

    public final String ipamPolicyRegion() {
        return this.ipamPolicyRegion;
    }

    public final IpamPolicyState state() {
        return IpamPolicyState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPolicy)) {
            return false;
        }
        IpamPolicy other = (IpamPolicy)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.ipamPolicyId(), other.ipamPolicyId()) && Objects.equals(this.ipamPolicyArn(), other.ipamPolicyArn()) && Objects.equals(this.ipamPolicyRegion(), other.ipamPolicyRegion()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.ipamId(), other.ipamId());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPolicy").add("OwnerId", (Object)this.ownerId()).add("IpamPolicyId", (Object)this.ipamPolicyId()).add("IpamPolicyArn", (Object)this.ipamPolicyArn()).add("IpamPolicyRegion", (Object)this.ipamPolicyRegion()).add("State", (Object)this.stateAsString()).add("StateMessage", (Object)this.stateMessage()).add("Tags", this.hasTags() ? this.tags() : null).add("IpamId", (Object)this.ipamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "IpamPolicyId": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyId()));
            }
            case "IpamPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyArn()));
            }
            case "IpamPolicyRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyRegion()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("IpamPolicyArn", IPAM_POLICY_ARN_FIELD);
        map.put("IpamPolicyRegion", IPAM_POLICY_REGION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("IpamId", IPAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPolicy, T> g) {
        return obj -> g.apply((IpamPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String ipamPolicyId;
        private String ipamPolicyArn;
        private String ipamPolicyRegion;
        private String state;
        private String stateMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String ipamId;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPolicy model) {
            this.ownerId(model.ownerId);
            this.ipamPolicyId(model.ipamPolicyId);
            this.ipamPolicyArn(model.ipamPolicyArn);
            this.ipamPolicyRegion(model.ipamPolicyRegion);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.tags(model.tags);
            this.ipamId(model.ipamId);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getIpamPolicyId() {
            return this.ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getIpamPolicyArn() {
            return this.ipamPolicyArn;
        }

        public final void setIpamPolicyArn(String ipamPolicyArn) {
            this.ipamPolicyArn = ipamPolicyArn;
        }

        @Override
        public final Builder ipamPolicyArn(String ipamPolicyArn) {
            this.ipamPolicyArn = ipamPolicyArn;
            return this;
        }

        public final String getIpamPolicyRegion() {
            return this.ipamPolicyRegion;
        }

        public final void setIpamPolicyRegion(String ipamPolicyRegion) {
            this.ipamPolicyRegion = ipamPolicyRegion;
        }

        @Override
        public final Builder ipamPolicyRegion(String ipamPolicyRegion) {
            this.ipamPolicyRegion = ipamPolicyRegion;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamPolicyState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public IpamPolicy build() {
            return new IpamPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPolicy> {
        public Builder ownerId(String var1);

        public Builder ipamPolicyId(String var1);

        public Builder ipamPolicyArn(String var1);

        public Builder ipamPolicyRegion(String var1);

        public Builder state(String var1);

        public Builder state(IpamPolicyState var1);

        public Builder stateMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder ipamId(String var1);
    }
}

