/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEgressOnlyInternetGatewaysResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeEgressOnlyInternetGatewaysResponse.Builder, DescribeEgressOnlyInternetGatewaysResponse> {
    private static final SdkField<List<EgressOnlyInternetGateway>> EGRESS_ONLY_INTERNET_GATEWAYS_FIELD = SdkField
            .<List<EgressOnlyInternetGateway>> builder(MarshallingType.LIST)
            .getter(getter(DescribeEgressOnlyInternetGatewaysResponse::egressOnlyInternetGateways))
            .setter(setter(Builder::egressOnlyInternetGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewaySet")
                    .unmarshallLocationName("egressOnlyInternetGatewaySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<EgressOnlyInternetGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(EgressOnlyInternetGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEgressOnlyInternetGatewaysResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EGRESS_ONLY_INTERNET_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));

    private final List<EgressOnlyInternetGateway> egressOnlyInternetGateways;

    private final String nextToken;

    private DescribeEgressOnlyInternetGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.egressOnlyInternetGateways = builder.egressOnlyInternetGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the egress-only internet gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the egress-only internet gateways.
     */
    public List<EgressOnlyInternetGateway> egressOnlyInternetGateways() {
        return egressOnlyInternetGateways;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGateways());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEgressOnlyInternetGatewaysResponse)) {
            return false;
        }
        DescribeEgressOnlyInternetGatewaysResponse other = (DescribeEgressOnlyInternetGatewaysResponse) obj;
        return Objects.equals(egressOnlyInternetGateways(), other.egressOnlyInternetGateways())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEgressOnlyInternetGatewaysResponse")
                .add("EgressOnlyInternetGateways", egressOnlyInternetGateways()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressOnlyInternetGateways":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGateways()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEgressOnlyInternetGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeEgressOnlyInternetGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysResponse> {
        /**
         * <p>
         * Information about the egress-only internet gateways.
         * </p>
         * 
         * @param egressOnlyInternetGateways
         *        Information about the egress-only internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> egressOnlyInternetGateways);

        /**
         * <p>
         * Information about the egress-only internet gateways.
         * </p>
         * 
         * @param egressOnlyInternetGateways
         *        Information about the egress-only internet gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGateways(EgressOnlyInternetGateway... egressOnlyInternetGateways);

        /**
         * <p>
         * Information about the egress-only internet gateways.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EgressOnlyInternetGateway>.Builder}
         * avoiding the need to create one manually via {@link List<EgressOnlyInternetGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EgressOnlyInternetGateway>.Builder#build()} is called
         * immediately and its result is passed to {@link #egressOnlyInternetGateways(List<EgressOnlyInternetGateway>)}.
         * 
         * @param egressOnlyInternetGateways
         *        a consumer that will call methods on {@link List<EgressOnlyInternetGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressOnlyInternetGateways(List<EgressOnlyInternetGateway>)
         */
        Builder egressOnlyInternetGateways(Consumer<EgressOnlyInternetGateway.Builder>... egressOnlyInternetGateways);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<EgressOnlyInternetGateway> egressOnlyInternetGateways = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEgressOnlyInternetGatewaysResponse model) {
            super(model);
            egressOnlyInternetGateways(model.egressOnlyInternetGateways);
            nextToken(model.nextToken);
        }

        public final Collection<EgressOnlyInternetGateway.Builder> getEgressOnlyInternetGateways() {
            return egressOnlyInternetGateways != null ? egressOnlyInternetGateways.stream()
                    .map(EgressOnlyInternetGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copy(egressOnlyInternetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGateways(EgressOnlyInternetGateway... egressOnlyInternetGateways) {
            egressOnlyInternetGateways(Arrays.asList(egressOnlyInternetGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGateways(Consumer<EgressOnlyInternetGateway.Builder>... egressOnlyInternetGateways) {
            egressOnlyInternetGateways(Stream.of(egressOnlyInternetGateways)
                    .map(c -> EgressOnlyInternetGateway.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEgressOnlyInternetGateways(
                Collection<EgressOnlyInternetGateway.BuilderImpl> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copyFromBuilder(egressOnlyInternetGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEgressOnlyInternetGatewaysResponse build() {
            return new DescribeEgressOnlyInternetGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
