/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdFormatRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeIdFormatRequest.Builder, DescribeIdFormatRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIdFormatRequest::resource))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource")
                    .unmarshallLocationName("Resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD));

    private final String resource;

    private DescribeIdFormatRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
    }

    /**
     * <p>
     * The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> |
     * <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     * <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
     * <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>
     * </p>
     * 
     * @return The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code>
     *         | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
     *         <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
     *         <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     *         <code>network-acl-association</code> | <code>network-interface</code> |
     *         <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> |
     *         <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
     *         <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> |
     *         <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> |
     *         <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> |
     *         <code>vpn-gateway</code>
     */
    public String resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdFormatRequest)) {
            return false;
        }
        DescribeIdFormatRequest other = (DescribeIdFormatRequest) obj;
        return Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeIdFormatRequest").add("Resource", resource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdFormatRequest, T> g) {
        return obj -> g.apply((DescribeIdFormatRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIdFormatRequest> {
        /**
         * <p>
         * The type of resource: <code>bundle</code> | <code>conversion-task</code> | <code>customer-gateway</code> |
         * <code>dhcp-options</code> | <code>elastic-ip-allocation</code> | <code>elastic-ip-association</code> |
         * <code>export-task</code> | <code>flow-log</code> | <code>image</code> | <code>import-task</code> |
         * <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
         * <code>network-acl-association</code> | <code>network-interface</code> |
         * <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> |
         * <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
         * <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> |
         * <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code>
         * | <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>
         * </p>
         * 
         * @param resource
         *        The type of resource: <code>bundle</code> | <code>conversion-task</code> |
         *        <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
         *        <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> |
         *        <code>image</code> | <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code>
         *        | <code>network-acl</code> | <code>network-acl-association</code> | <code>network-interface</code> |
         *        <code>network-interface-attachment</code> | <code>prefix-list</code> | <code>reservation</code> |
         *        <code>route-table</code> | <code>route-table-association</code> | <code>security-group</code> |
         *        <code>snapshot</code> | <code>subnet</code> | <code>subnet-cidr-block-association</code> |
         *        <code>volume</code> | <code>vpc</code> | <code>vpc-cidr-block-association</code> |
         *        <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> |
         *        <code>vpn-gateway</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdFormatRequest model) {
            super(model);
            resource(model.resource);
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIdFormatRequest build() {
            return new DescribeIdFormatRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
