/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the authentication method to be used by a Client VPN endpoint. Client VPN supports Active Directory and
 * mutual authentication. For more information, see <a
 * href="vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication">Authentication</a> in the
 * <i>AWS Client VPN Admin Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientVpnAuthenticationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientVpnAuthenticationRequest.Builder, ClientVpnAuthenticationRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ClientVpnAuthenticationRequest::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<DirectoryServiceAuthenticationRequest> ACTIVE_DIRECTORY_FIELD = SdkField
            .<DirectoryServiceAuthenticationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(ClientVpnAuthenticationRequest::activeDirectory))
            .setter(setter(Builder::activeDirectory))
            .constructor(DirectoryServiceAuthenticationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectory")
                    .unmarshallLocationName("ActiveDirectory").build()).build();

    private static final SdkField<CertificateAuthenticationRequest> MUTUAL_AUTHENTICATION_FIELD = SdkField
            .<CertificateAuthenticationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(ClientVpnAuthenticationRequest::mutualAuthentication))
            .setter(setter(Builder::mutualAuthentication))
            .constructor(CertificateAuthenticationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutualAuthentication")
                    .unmarshallLocationName("MutualAuthentication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            ACTIVE_DIRECTORY_FIELD, MUTUAL_AUTHENTICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final DirectoryServiceAuthenticationRequest activeDirectory;

    private final CertificateAuthenticationRequest mutualAuthentication;

    private ClientVpnAuthenticationRequest(BuilderImpl builder) {
        this.type = builder.type;
        this.activeDirectory = builder.activeDirectory;
        this.mutualAuthentication = builder.mutualAuthentication;
    }

    /**
     * <p>
     * The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
     * certificate-based authentication, or <code>directory-service-authentication</code> to use Active Directory
     * authentication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientVpnAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
     *         certificate-based authentication, or <code>directory-service-authentication</code> to use Active
     *         Directory authentication.
     * @see ClientVpnAuthenticationType
     */
    public ClientVpnAuthenticationType type() {
        return ClientVpnAuthenticationType.fromValue(type);
    }

    /**
     * <p>
     * The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
     * certificate-based authentication, or <code>directory-service-authentication</code> to use Active Directory
     * authentication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientVpnAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
     *         certificate-based authentication, or <code>directory-service-authentication</code> to use Active
     *         Directory authentication.
     * @see ClientVpnAuthenticationType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the Active Directory to be used, if applicable. You must provide this information if
     * <b>Type</b> is <code>directory-service-authentication</code>.
     * </p>
     * 
     * @return Information about the Active Directory to be used, if applicable. You must provide this information if
     *         <b>Type</b> is <code>directory-service-authentication</code>.
     */
    public DirectoryServiceAuthenticationRequest activeDirectory() {
        return activeDirectory;
    }

    /**
     * <p>
     * Information about the authentication certificates to be used, if applicable. You must provide this information if
     * <b>Type</b> is <code>certificate-authentication</code>.
     * </p>
     * 
     * @return Information about the authentication certificates to be used, if applicable. You must provide this
     *         information if <b>Type</b> is <code>certificate-authentication</code>.
     */
    public CertificateAuthenticationRequest mutualAuthentication() {
        return mutualAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(mutualAuthentication());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpnAuthenticationRequest)) {
            return false;
        }
        ClientVpnAuthenticationRequest other = (ClientVpnAuthenticationRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(activeDirectory(), other.activeDirectory())
                && Objects.equals(mutualAuthentication(), other.mutualAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClientVpnAuthenticationRequest").add("Type", typeAsString())
                .add("ActiveDirectory", activeDirectory()).add("MutualAuthentication", mutualAuthentication()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ActiveDirectory":
            return Optional.ofNullable(clazz.cast(activeDirectory()));
        case "MutualAuthentication":
            return Optional.ofNullable(clazz.cast(mutualAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpnAuthenticationRequest, T> g) {
        return obj -> g.apply((ClientVpnAuthenticationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientVpnAuthenticationRequest> {
        /**
         * <p>
         * The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
         * certificate-based authentication, or <code>directory-service-authentication</code> to use Active Directory
         * authentication.
         * </p>
         * 
         * @param type
         *        The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
         *        certificate-based authentication, or <code>directory-service-authentication</code> to use Active
         *        Directory authentication.
         * @see ClientVpnAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnAuthenticationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
         * certificate-based authentication, or <code>directory-service-authentication</code> to use Active Directory
         * authentication.
         * </p>
         * 
         * @param type
         *        The type of client authentication to be used. Specify <code>certificate-authentication</code> to use
         *        certificate-based authentication, or <code>directory-service-authentication</code> to use Active
         *        Directory authentication.
         * @see ClientVpnAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientVpnAuthenticationType
         */
        Builder type(ClientVpnAuthenticationType type);

        /**
         * <p>
         * Information about the Active Directory to be used, if applicable. You must provide this information if
         * <b>Type</b> is <code>directory-service-authentication</code>.
         * </p>
         * 
         * @param activeDirectory
         *        Information about the Active Directory to be used, if applicable. You must provide this information if
         *        <b>Type</b> is <code>directory-service-authentication</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectory(DirectoryServiceAuthenticationRequest activeDirectory);

        /**
         * <p>
         * Information about the Active Directory to be used, if applicable. You must provide this information if
         * <b>Type</b> is <code>directory-service-authentication</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DirectoryServiceAuthenticationRequest.Builder}
         * avoiding the need to create one manually via {@link DirectoryServiceAuthenticationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectoryServiceAuthenticationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #activeDirectory(DirectoryServiceAuthenticationRequest)}.
         * 
         * @param activeDirectory
         *        a consumer that will call methods on {@link DirectoryServiceAuthenticationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectory(DirectoryServiceAuthenticationRequest)
         */
        default Builder activeDirectory(Consumer<DirectoryServiceAuthenticationRequest.Builder> activeDirectory) {
            return activeDirectory(DirectoryServiceAuthenticationRequest.builder().applyMutation(activeDirectory).build());
        }

        /**
         * <p>
         * Information about the authentication certificates to be used, if applicable. You must provide this
         * information if <b>Type</b> is <code>certificate-authentication</code>.
         * </p>
         * 
         * @param mutualAuthentication
         *        Information about the authentication certificates to be used, if applicable. You must provide this
         *        information if <b>Type</b> is <code>certificate-authentication</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualAuthentication(CertificateAuthenticationRequest mutualAuthentication);

        /**
         * <p>
         * Information about the authentication certificates to be used, if applicable. You must provide this
         * information if <b>Type</b> is <code>certificate-authentication</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link CertificateAuthenticationRequest.Builder}
         * avoiding the need to create one manually via {@link CertificateAuthenticationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateAuthenticationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #mutualAuthentication(CertificateAuthenticationRequest)}.
         * 
         * @param mutualAuthentication
         *        a consumer that will call methods on {@link CertificateAuthenticationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualAuthentication(CertificateAuthenticationRequest)
         */
        default Builder mutualAuthentication(Consumer<CertificateAuthenticationRequest.Builder> mutualAuthentication) {
            return mutualAuthentication(CertificateAuthenticationRequest.builder().applyMutation(mutualAuthentication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private DirectoryServiceAuthenticationRequest activeDirectory;

        private CertificateAuthenticationRequest mutualAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpnAuthenticationRequest model) {
            type(model.type);
            activeDirectory(model.activeDirectory);
            mutualAuthentication(model.mutualAuthentication);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ClientVpnAuthenticationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final DirectoryServiceAuthenticationRequest.Builder getActiveDirectory() {
            return activeDirectory != null ? activeDirectory.toBuilder() : null;
        }

        @Override
        public final Builder activeDirectory(DirectoryServiceAuthenticationRequest activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final void setActiveDirectory(DirectoryServiceAuthenticationRequest.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        public final CertificateAuthenticationRequest.Builder getMutualAuthentication() {
            return mutualAuthentication != null ? mutualAuthentication.toBuilder() : null;
        }

        @Override
        public final Builder mutualAuthentication(CertificateAuthenticationRequest mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication;
            return this;
        }

        public final void setMutualAuthentication(CertificateAuthenticationRequest.BuilderImpl mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication != null ? mutualAuthentication.build() : null;
        }

        @Override
        public ClientVpnAuthenticationRequest build() {
            return new ClientVpnAuthenticationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
