/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeConversionTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConversionTasksRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeConversionTasksRequest.Builder, DescribeConversionTasksRequest> {
    private static final SdkField<List<String>> CONVERSION_TASK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeConversionTasksRequest::conversionTaskIds))
            .setter(setter(Builder::conversionTaskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversionTaskId")
                    .unmarshallLocationName("conversionTaskId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSION_TASK_IDS_FIELD));

    private final List<String> conversionTaskIds;

    private DescribeConversionTasksRequest(BuilderImpl builder) {
        super(builder);
        this.conversionTaskIds = builder.conversionTaskIds;
    }

    /**
     * <p>
     * One or more conversion task IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more conversion task IDs.
     */
    public List<String> conversionTaskIds() {
        return conversionTaskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversionTaskIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksRequest)) {
            return false;
        }
        DescribeConversionTasksRequest other = (DescribeConversionTasksRequest) obj;
        return Objects.equals(conversionTaskIds(), other.conversionTaskIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConversionTasksRequest").add("ConversionTaskIds", conversionTaskIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConversionTaskIds":
            return Optional.ofNullable(clazz.cast(conversionTaskIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConversionTasksRequest, T> g) {
        return obj -> g.apply((DescribeConversionTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConversionTasksRequest> {
        /**
         * <p>
         * One or more conversion task IDs.
         * </p>
         * 
         * @param conversionTaskIds
         *        One or more conversion task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTaskIds(Collection<String> conversionTaskIds);

        /**
         * <p>
         * One or more conversion task IDs.
         * </p>
         * 
         * @param conversionTaskIds
         *        One or more conversion task IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTaskIds(String... conversionTaskIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> conversionTaskIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionTasksRequest model) {
            super(model);
            conversionTaskIds(model.conversionTaskIds);
        }

        public final Collection<String> getConversionTaskIds() {
            return conversionTaskIds;
        }

        @Override
        public final Builder conversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTaskIds(String... conversionTaskIds) {
            conversionTaskIds(Arrays.asList(conversionTaskIds));
            return this;
        }

        public final void setConversionTaskIds(Collection<String> conversionTaskIds) {
            this.conversionTaskIds = ConversionIdStringListCopier.copy(conversionTaskIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConversionTasksRequest build() {
            return new DescribeConversionTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
