/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMeteringPolicy;
import software.amazon.awssdk.services.ec2.model.TransitGatewayMeteringPolicyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayMeteringPoliciesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayMeteringPoliciesResponse> {
    private static final SdkField<List<TransitGatewayMeteringPolicy>> TRANSIT_GATEWAY_METERING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayMeteringPolicies").getter(DescribeTransitGatewayMeteringPoliciesResponse.getter(DescribeTransitGatewayMeteringPoliciesResponse::transitGatewayMeteringPolicies)).setter(DescribeTransitGatewayMeteringPoliciesResponse.setter(Builder::transitGatewayMeteringPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMeteringPolicies").unmarshallLocationName("transitGatewayMeteringPolicies").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayMeteringPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayMeteringPoliciesResponse.getter(DescribeTransitGatewayMeteringPoliciesResponse::nextToken)).setter(DescribeTransitGatewayMeteringPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_METERING_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTransitGatewayMeteringPoliciesResponse.memberNameToFieldInitializer();
    private final List<TransitGatewayMeteringPolicy> transitGatewayMeteringPolicies;
    private final String nextToken;

    private DescribeTransitGatewayMeteringPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMeteringPolicies = builder.transitGatewayMeteringPolicies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayMeteringPolicies() {
        return this.transitGatewayMeteringPolicies != null && !(this.transitGatewayMeteringPolicies instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayMeteringPolicy> transitGatewayMeteringPolicies() {
        return this.transitGatewayMeteringPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayMeteringPolicies() ? this.transitGatewayMeteringPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayMeteringPoliciesResponse)) {
            return false;
        }
        DescribeTransitGatewayMeteringPoliciesResponse other = (DescribeTransitGatewayMeteringPoliciesResponse)((Object)obj);
        return this.hasTransitGatewayMeteringPolicies() == other.hasTransitGatewayMeteringPolicies() && Objects.equals(this.transitGatewayMeteringPolicies(), other.transitGatewayMeteringPolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTransitGatewayMeteringPoliciesResponse").add("TransitGatewayMeteringPolicies", this.hasTransitGatewayMeteringPolicies() ? this.transitGatewayMeteringPolicies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayMeteringPolicies": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMeteringPolicies()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayMeteringPolicies", TRANSIT_GATEWAY_METERING_POLICIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayMeteringPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayMeteringPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayMeteringPolicy> transitGatewayMeteringPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayMeteringPoliciesResponse model) {
            super(model);
            this.transitGatewayMeteringPolicies(model.transitGatewayMeteringPolicies);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayMeteringPolicy.Builder> getTransitGatewayMeteringPolicies() {
            List<TransitGatewayMeteringPolicy.Builder> result = TransitGatewayMeteringPolicyListCopier.copyToBuilder(this.transitGatewayMeteringPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayMeteringPolicies(Collection<TransitGatewayMeteringPolicy.BuilderImpl> transitGatewayMeteringPolicies) {
            this.transitGatewayMeteringPolicies = TransitGatewayMeteringPolicyListCopier.copyFromBuilder(transitGatewayMeteringPolicies);
        }

        @Override
        public final Builder transitGatewayMeteringPolicies(Collection<TransitGatewayMeteringPolicy> transitGatewayMeteringPolicies) {
            this.transitGatewayMeteringPolicies = TransitGatewayMeteringPolicyListCopier.copy(transitGatewayMeteringPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayMeteringPolicies(TransitGatewayMeteringPolicy ... transitGatewayMeteringPolicies) {
            this.transitGatewayMeteringPolicies(Arrays.asList(transitGatewayMeteringPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayMeteringPolicies(Consumer<TransitGatewayMeteringPolicy.Builder> ... transitGatewayMeteringPolicies) {
            this.transitGatewayMeteringPolicies(Stream.of(transitGatewayMeteringPolicies).map(c -> (TransitGatewayMeteringPolicy)((TransitGatewayMeteringPolicy.Builder)TransitGatewayMeteringPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewayMeteringPoliciesResponse build() {
            return new DescribeTransitGatewayMeteringPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayMeteringPoliciesResponse> {
        public Builder transitGatewayMeteringPolicies(Collection<TransitGatewayMeteringPolicy> var1);

        public Builder transitGatewayMeteringPolicies(TransitGatewayMeteringPolicy ... var1);

        public Builder transitGatewayMeteringPolicies(Consumer<TransitGatewayMeteringPolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

