/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcEndpointConnectionNotificationsResponse extends Ec2Response
        implements
        ToCopyableBuilder<DescribeVpcEndpointConnectionNotificationsResponse.Builder, DescribeVpcEndpointConnectionNotificationsResponse> {
    private static final SdkField<List<ConnectionNotification>> CONNECTION_NOTIFICATION_SET_FIELD = SdkField
            .<List<ConnectionNotification>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVpcEndpointConnectionNotificationsResponse::connectionNotificationSet))
            .setter(setter(Builder::connectionNotificationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationSet")
                    .unmarshallLocationName("connectionNotificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ConnectionNotification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConnectionNotification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeVpcEndpointConnectionNotificationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTION_NOTIFICATION_SET_FIELD, NEXT_TOKEN_FIELD));

    private final List<ConnectionNotification> connectionNotificationSet;

    private final String nextToken;

    private DescribeVpcEndpointConnectionNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationSet = builder.connectionNotificationSet;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more notifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more notifications.
     */
    public List<ConnectionNotification> connectionNotificationSet() {
        return connectionNotificationSet;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationSet());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointConnectionNotificationsResponse)) {
            return false;
        }
        DescribeVpcEndpointConnectionNotificationsResponse other = (DescribeVpcEndpointConnectionNotificationsResponse) obj;
        return Objects.equals(connectionNotificationSet(), other.connectionNotificationSet())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVpcEndpointConnectionNotificationsResponse")
                .add("ConnectionNotificationSet", connectionNotificationSet()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionNotificationSet":
            return Optional.ofNullable(clazz.cast(connectionNotificationSet()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointConnectionNotificationsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointConnectionNotificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVpcEndpointConnectionNotificationsResponse> {
        /**
         * <p>
         * One or more notifications.
         * </p>
         * 
         * @param connectionNotificationSet
         *        One or more notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationSet(Collection<ConnectionNotification> connectionNotificationSet);

        /**
         * <p>
         * One or more notifications.
         * </p>
         * 
         * @param connectionNotificationSet
         *        One or more notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationSet(ConnectionNotification... connectionNotificationSet);

        /**
         * <p>
         * One or more notifications.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConnectionNotification>.Builder} avoiding
         * the need to create one manually via {@link List<ConnectionNotification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConnectionNotification>.Builder#build()} is called
         * immediately and its result is passed to {@link #connectionNotificationSet(List<ConnectionNotification>)}.
         * 
         * @param connectionNotificationSet
         *        a consumer that will call methods on {@link List<ConnectionNotification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionNotificationSet(List<ConnectionNotification>)
         */
        Builder connectionNotificationSet(Consumer<ConnectionNotification.Builder>... connectionNotificationSet);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ConnectionNotification> connectionNotificationSet = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointConnectionNotificationsResponse model) {
            super(model);
            connectionNotificationSet(model.connectionNotificationSet);
            nextToken(model.nextToken);
        }

        public final Collection<ConnectionNotification.Builder> getConnectionNotificationSet() {
            return connectionNotificationSet != null ? connectionNotificationSet.stream().map(ConnectionNotification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectionNotificationSet(Collection<ConnectionNotification> connectionNotificationSet) {
            this.connectionNotificationSet = ConnectionNotificationSetCopier.copy(connectionNotificationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationSet(ConnectionNotification... connectionNotificationSet) {
            connectionNotificationSet(Arrays.asList(connectionNotificationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationSet(Consumer<ConnectionNotification.Builder>... connectionNotificationSet) {
            connectionNotificationSet(Stream.of(connectionNotificationSet)
                    .map(c -> ConnectionNotification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectionNotificationSet(Collection<ConnectionNotification.BuilderImpl> connectionNotificationSet) {
            this.connectionNotificationSet = ConnectionNotificationSetCopier.copyFromBuilder(connectionNotificationSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointConnectionNotificationsResponse build() {
            return new DescribeVpcEndpointConnectionNotificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
