/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Host implements SdkPojo, Serializable, ToCopyableBuilder<Host.Builder, Host> {
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Host::autoPlacementAsString))
            .setter(setter(Builder::autoPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement")
                    .unmarshallLocationName("autoPlacement").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Host::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<AvailableCapacity> AVAILABLE_CAPACITY_FIELD = SdkField
            .<AvailableCapacity> builder(MarshallingType.SDK_POJO)
            .getter(getter(Host::availableCapacity))
            .setter(setter(Builder::availableCapacity))
            .constructor(AvailableCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableCapacity")
                    .unmarshallLocationName("availableCapacity").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Host::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<String> HOST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Host::hostId))
            .setter(setter(Builder::hostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostId")
                    .unmarshallLocationName("hostId").build()).build();

    private static final SdkField<HostProperties> HOST_PROPERTIES_FIELD = SdkField
            .<HostProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(Host::hostProperties))
            .setter(setter(Builder::hostProperties))
            .constructor(HostProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostProperties")
                    .unmarshallLocationName("hostProperties").build()).build();

    private static final SdkField<String> HOST_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Host::hostReservationId))
            .setter(setter(Builder::hostReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostReservationId")
                    .unmarshallLocationName("hostReservationId").build()).build();

    private static final SdkField<List<HostInstance>> INSTANCES_FIELD = SdkField
            .<List<HostInstance>> builder(MarshallingType.LIST)
            .getter(getter(Host::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances")
                    .unmarshallLocationName("instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<HostInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(HostInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Host::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> ALLOCATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Host::allocationTime))
            .setter(setter(Builder::allocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationTime")
                    .unmarshallLocationName("allocationTime").build()).build();

    private static final SdkField<Instant> RELEASE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Host::releaseTime))
            .setter(setter(Builder::releaseTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseTime")
                    .unmarshallLocationName("releaseTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Host::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_PLACEMENT_FIELD,
            AVAILABILITY_ZONE_FIELD, AVAILABLE_CAPACITY_FIELD, CLIENT_TOKEN_FIELD, HOST_ID_FIELD, HOST_PROPERTIES_FIELD,
            HOST_RESERVATION_ID_FIELD, INSTANCES_FIELD, STATE_FIELD, ALLOCATION_TIME_FIELD, RELEASE_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoPlacement;

    private final String availabilityZone;

    private final AvailableCapacity availableCapacity;

    private final String clientToken;

    private final String hostId;

    private final HostProperties hostProperties;

    private final String hostReservationId;

    private final List<HostInstance> instances;

    private final String state;

    private final Instant allocationTime;

    private final Instant releaseTime;

    private final List<Tag> tags;

    private Host(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.availableCapacity = builder.availableCapacity;
        this.clientToken = builder.clientToken;
        this.hostId = builder.hostId;
        this.hostProperties = builder.hostProperties;
        this.hostReservationId = builder.hostReservationId;
        this.instances = builder.instances;
        this.state = builder.state;
        this.allocationTime = builder.allocationTime;
        this.releaseTime = builder.releaseTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Whether auto-placement is on or off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return Whether auto-placement is on or off.
     * @see AutoPlacement
     */
    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(autoPlacement);
    }

    /**
     * <p>
     * Whether auto-placement is on or off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return Whether auto-placement is on or off.
     * @see AutoPlacement
     */
    public String autoPlacementAsString() {
        return autoPlacement;
    }

    /**
     * <p>
     * The Availability Zone of the Dedicated Host.
     * </p>
     * 
     * @return The Availability Zone of the Dedicated Host.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of new instances that can be launched onto the Dedicated Host.
     * </p>
     * 
     * @return The number of new instances that can be launched onto the Dedicated Host.
     */
    public AvailableCapacity availableCapacity() {
        return availableCapacity;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure idempotency of the request. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Dedicated Host.
     * </p>
     * 
     * @return The ID of the Dedicated Host.
     */
    public String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The hardware specifications of the Dedicated Host.
     * </p>
     * 
     * @return The hardware specifications of the Dedicated Host.
     */
    public HostProperties hostProperties() {
        return hostProperties;
    }

    /**
     * <p>
     * The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated Host doesn't
     * have an associated reservation.
     * </p>
     * 
     * @return The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated Host
     *         doesn't have an associated reservation.
     */
    public String hostReservationId() {
        return hostReservationId;
    }

    /**
     * <p>
     * The IDs and instance type that are currently running on the Dedicated Host.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs and instance type that are currently running on the Dedicated Host.
     */
    public List<HostInstance> instances() {
        return instances;
    }

    /**
     * <p>
     * The Dedicated Host's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AllocationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The Dedicated Host's state.
     * @see AllocationState
     */
    public AllocationState state() {
        return AllocationState.fromValue(state);
    }

    /**
     * <p>
     * The Dedicated Host's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AllocationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The Dedicated Host's state.
     * @see AllocationState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time that the Dedicated Host was allocated.
     * </p>
     * 
     * @return The time that the Dedicated Host was allocated.
     */
    public Instant allocationTime() {
        return allocationTime;
    }

    /**
     * <p>
     * The time that the Dedicated Host was released.
     * </p>
     * 
     * @return The time that the Dedicated Host was released.
     */
    public Instant releaseTime() {
        return releaseTime;
    }

    /**
     * <p>
     * Any tags assigned to the Dedicated Host.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the Dedicated Host.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(releaseTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host) obj;
        return Objects.equals(autoPlacementAsString(), other.autoPlacementAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availableCapacity(), other.availableCapacity())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(hostId(), other.hostId())
                && Objects.equals(hostProperties(), other.hostProperties())
                && Objects.equals(hostReservationId(), other.hostReservationId())
                && Objects.equals(instances(), other.instances()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(allocationTime(), other.allocationTime()) && Objects.equals(releaseTime(), other.releaseTime())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Host").add("AutoPlacement", autoPlacementAsString()).add("AvailabilityZone", availabilityZone())
                .add("AvailableCapacity", availableCapacity()).add("ClientToken", clientToken()).add("HostId", hostId())
                .add("HostProperties", hostProperties()).add("HostReservationId", hostReservationId())
                .add("Instances", instances()).add("State", stateAsString()).add("AllocationTime", allocationTime())
                .add("ReleaseTime", releaseTime()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoPlacement":
            return Optional.ofNullable(clazz.cast(autoPlacementAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailableCapacity":
            return Optional.ofNullable(clazz.cast(availableCapacity()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "HostId":
            return Optional.ofNullable(clazz.cast(hostId()));
        case "HostProperties":
            return Optional.ofNullable(clazz.cast(hostProperties()));
        case "HostReservationId":
            return Optional.ofNullable(clazz.cast(hostReservationId()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "AllocationTime":
            return Optional.ofNullable(clazz.cast(allocationTime()));
        case "ReleaseTime":
            return Optional.ofNullable(clazz.cast(releaseTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Host> {
        /**
         * <p>
         * Whether auto-placement is on or off.
         * </p>
         * 
         * @param autoPlacement
         *        Whether auto-placement is on or off.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * Whether auto-placement is on or off.
         * </p>
         * 
         * @param autoPlacement
         *        Whether auto-placement is on or off.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The Availability Zone of the Dedicated Host.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of new instances that can be launched onto the Dedicated Host.
         * </p>
         * 
         * @param availableCapacity
         *        The number of new instances that can be launched onto the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCapacity(AvailableCapacity availableCapacity);

        /**
         * <p>
         * The number of new instances that can be launched onto the Dedicated Host.
         * </p>
         * This is a convenience that creates an instance of the {@link AvailableCapacity.Builder} avoiding the need to
         * create one manually via {@link AvailableCapacity#builder()}.
         *
         * When the {@link Consumer} completes, {@link AvailableCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #availableCapacity(AvailableCapacity)}.
         * 
         * @param availableCapacity
         *        a consumer that will call methods on {@link AvailableCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availableCapacity(AvailableCapacity)
         */
        default Builder availableCapacity(Consumer<AvailableCapacity.Builder> availableCapacity) {
            return availableCapacity(AvailableCapacity.builder().applyMutation(availableCapacity).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Dedicated Host.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The hardware specifications of the Dedicated Host.
         * </p>
         * 
         * @param hostProperties
         *        The hardware specifications of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostProperties(HostProperties hostProperties);

        /**
         * <p>
         * The hardware specifications of the Dedicated Host.
         * </p>
         * This is a convenience that creates an instance of the {@link HostProperties.Builder} avoiding the need to
         * create one manually via {@link HostProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #hostProperties(HostProperties)}.
         * 
         * @param hostProperties
         *        a consumer that will call methods on {@link HostProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostProperties(HostProperties)
         */
        default Builder hostProperties(Consumer<HostProperties.Builder> hostProperties) {
            return hostProperties(HostProperties.builder().applyMutation(hostProperties).build());
        }

        /**
         * <p>
         * The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated Host
         * doesn't have an associated reservation.
         * </p>
         * 
         * @param hostReservationId
         *        The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated
         *        Host doesn't have an associated reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationId(String hostReservationId);

        /**
         * <p>
         * The IDs and instance type that are currently running on the Dedicated Host.
         * </p>
         * 
         * @param instances
         *        The IDs and instance type that are currently running on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<HostInstance> instances);

        /**
         * <p>
         * The IDs and instance type that are currently running on the Dedicated Host.
         * </p>
         * 
         * @param instances
         *        The IDs and instance type that are currently running on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(HostInstance... instances);

        /**
         * <p>
         * The IDs and instance type that are currently running on the Dedicated Host.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HostInstance>.Builder} avoiding the need to
         * create one manually via {@link List<HostInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HostInstance>.Builder#build()} is called immediately and its
         * result is passed to {@link #instances(List<HostInstance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<HostInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<HostInstance>)
         */
        Builder instances(Consumer<HostInstance.Builder>... instances);

        /**
         * <p>
         * The Dedicated Host's state.
         * </p>
         * 
         * @param state
         *        The Dedicated Host's state.
         * @see AllocationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationState
         */
        Builder state(String state);

        /**
         * <p>
         * The Dedicated Host's state.
         * </p>
         * 
         * @param state
         *        The Dedicated Host's state.
         * @see AllocationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationState
         */
        Builder state(AllocationState state);

        /**
         * <p>
         * The time that the Dedicated Host was allocated.
         * </p>
         * 
         * @param allocationTime
         *        The time that the Dedicated Host was allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationTime(Instant allocationTime);

        /**
         * <p>
         * The time that the Dedicated Host was released.
         * </p>
         * 
         * @param releaseTime
         *        The time that the Dedicated Host was released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseTime(Instant releaseTime);

        /**
         * <p>
         * Any tags assigned to the Dedicated Host.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the Dedicated Host.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the Dedicated Host.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String autoPlacement;

        private String availabilityZone;

        private AvailableCapacity availableCapacity;

        private String clientToken;

        private String hostId;

        private HostProperties hostProperties;

        private String hostReservationId;

        private List<HostInstance> instances = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private Instant allocationTime;

        private Instant releaseTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            autoPlacement(model.autoPlacement);
            availabilityZone(model.availabilityZone);
            availableCapacity(model.availableCapacity);
            clientToken(model.clientToken);
            hostId(model.hostId);
            hostProperties(model.hostProperties);
            hostReservationId(model.hostReservationId);
            instances(model.instances);
            state(model.state);
            allocationTime(model.allocationTime);
            releaseTime(model.releaseTime);
            tags(model.tags);
        }

        public final String getAutoPlacementAsString() {
            return autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final AvailableCapacity.Builder getAvailableCapacity() {
            return availableCapacity != null ? availableCapacity.toBuilder() : null;
        }

        @Override
        public final Builder availableCapacity(AvailableCapacity availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(AvailableCapacity.BuilderImpl availableCapacity) {
            this.availableCapacity = availableCapacity != null ? availableCapacity.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getHostId() {
            return hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final HostProperties.Builder getHostProperties() {
            return hostProperties != null ? hostProperties.toBuilder() : null;
        }

        @Override
        public final Builder hostProperties(HostProperties hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final void setHostProperties(HostProperties.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        public final String getHostReservationId() {
            return hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final Collection<HostInstance.Builder> getInstances() {
            return instances != null ? instances.stream().map(HostInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<HostInstance> instances) {
            this.instances = HostInstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HostInstance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<HostInstance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> HostInstance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<HostInstance.BuilderImpl> instances) {
            this.instances = HostInstanceListCopier.copyFromBuilder(instances);
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AllocationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getAllocationTime() {
            return allocationTime;
        }

        @Override
        public final Builder allocationTime(Instant allocationTime) {
            this.allocationTime = allocationTime;
            return this;
        }

        public final void setAllocationTime(Instant allocationTime) {
            this.allocationTime = allocationTime;
        }

        public final Instant getReleaseTime() {
            return releaseTime;
        }

        @Override
        public final Builder releaseTime(Instant releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        public final void setReleaseTime(Instant releaseTime) {
            this.releaseTime = releaseTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Host build() {
            return new Host(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
