/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CreateFleetInstancesSetCopier {
    static List<CreateFleetInstance> copy(Collection<CreateFleetInstance> createFleetInstancesSetParam) {
        if (createFleetInstancesSetParam == null || createFleetInstancesSetParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<CreateFleetInstance> createFleetInstancesSetParamCopy = new ArrayList<>(createFleetInstancesSetParam);
        return Collections.unmodifiableList(createFleetInstancesSetParamCopy);
    }

    static List<CreateFleetInstance> copyFromBuilder(
            Collection<? extends CreateFleetInstance.Builder> createFleetInstancesSetParam) {
        if (createFleetInstancesSetParam == null) {
            return null;
        }
        return copy(createFleetInstancesSetParam.stream().map(CreateFleetInstance.Builder::build).collect(toList()));
    }
}
