/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReleaseHostsResponse extends Ec2Response implements
        ToCopyableBuilder<ReleaseHostsResponse.Builder, ReleaseHostsResponse> {
    private static final SdkField<List<String>> SUCCESSFUL_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ReleaseHostsResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful")
                    .unmarshallLocationName("successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<UnsuccessfulItem>> UNSUCCESSFUL_FIELD = SdkField
            .<List<UnsuccessfulItem>> builder(MarshallingType.LIST)
            .getter(getter(ReleaseHostsResponse::unsuccessful))
            .setter(setter(Builder::unsuccessful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful")
                    .unmarshallLocationName("unsuccessful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD,
            UNSUCCESSFUL_FIELD));

    private final List<String> successful;

    private final List<UnsuccessfulItem> unsuccessful;

    private ReleaseHostsResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts that were successfully released.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts that were successfully released.
     */
    public List<String> successful() {
        return successful;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts that could not be released, including an error message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts that could not be released, including an error message.
     */
    public List<UnsuccessfulItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successful());
        hashCode = 31 * hashCode + Objects.hashCode(unsuccessful());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseHostsResponse)) {
            return false;
        }
        ReleaseHostsResponse other = (ReleaseHostsResponse) obj;
        return Objects.equals(successful(), other.successful()) && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReleaseHostsResponse").add("Successful", successful()).add("Unsuccessful", unsuccessful())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Unsuccessful":
            return Optional.ofNullable(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReleaseHostsResponse, T> g) {
        return obj -> g.apply((ReleaseHostsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ReleaseHostsResponse> {
        /**
         * <p>
         * The IDs of the Dedicated Hosts that were successfully released.
         * </p>
         * 
         * @param successful
         *        The IDs of the Dedicated Hosts that were successfully released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<String> successful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that were successfully released.
         * </p>
         * 
         * @param successful
         *        The IDs of the Dedicated Hosts that were successfully released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(String... successful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be released, including an error message.
         * </p>
         * 
         * @param unsuccessful
         *        The IDs of the Dedicated Hosts that could not be released, including an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be released, including an error message.
         * </p>
         * 
         * @param unsuccessful
         *        The IDs of the Dedicated Hosts that could not be released, including an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(UnsuccessfulItem... unsuccessful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be released, including an error message.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnsuccessfulItem>.Builder} avoiding the
         * need to create one manually via {@link List<UnsuccessfulItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnsuccessfulItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #unsuccessful(List<UnsuccessfulItem>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on {@link List<UnsuccessfulItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(List<UnsuccessfulItem>)
         */
        Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<String> successful = DefaultSdkAutoConstructList.getInstance();

        private List<UnsuccessfulItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseHostsResponse model) {
            super(model);
            successful(model.successful);
            unsuccessful(model.unsuccessful);
        }

        public final Collection<String> getSuccessful() {
            return successful;
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
        }

        public final Collection<UnsuccessfulItem.Builder> getUnsuccessful() {
            return unsuccessful != null ? unsuccessful.stream().map(UnsuccessfulItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> UnsuccessfulItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public ReleaseHostsResponse build() {
            return new ReleaseHostsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
