/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticGpusRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeElasticGpusRequest.Builder, DescribeElasticGpusRequest> {
    private static final SdkField<List<String>> ELASTIC_GPU_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeElasticGpusRequest::elasticGpuIds))
            .setter(setter(Builder::elasticGpuIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuId")
                    .unmarshallLocationName("ElasticGpuId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeElasticGpusRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeElasticGpusRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeElasticGpusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_GPU_IDS_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> elasticGpuIds;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeElasticGpusRequest(BuilderImpl builder) {
        super(builder);
        this.elasticGpuIds = builder.elasticGpuIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more Elastic Graphics accelerator IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Elastic Graphics accelerator IDs.
     */
    public List<String> elasticGpuIds() {
        return elasticGpuIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
     * <code>IMPAIRED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example, <code>eg1.medium</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
     *         <code>IMPAIRED</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
     *         <code>eg1.medium</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is
     *         associated.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticGpusRequest)) {
            return false;
        }
        DescribeElasticGpusRequest other = (DescribeElasticGpusRequest) obj;
        return Objects.equals(elasticGpuIds(), other.elasticGpuIds()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeElasticGpusRequest").add("ElasticGpuIds", elasticGpuIds()).add("Filters", filters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuIds":
            return Optional.ofNullable(clazz.cast(elasticGpuIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticGpusRequest, T> g) {
        return obj -> g.apply((DescribeElasticGpusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeElasticGpusRequest> {
        /**
         * <p>
         * One or more Elastic Graphics accelerator IDs.
         * </p>
         * 
         * @param elasticGpuIds
         *        One or more Elastic Graphics accelerator IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuIds(Collection<String> elasticGpuIds);

        /**
         * <p>
         * One or more Elastic Graphics accelerator IDs.
         * </p>
         * 
         * @param elasticGpuIds
         *        One or more Elastic Graphics accelerator IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuIds(String... elasticGpuIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         * <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         * <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator
         *        resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         *        <code>IMPAIRED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         *        <code>eg1.medium</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is
         *        associated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         * <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         * <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator
         *        resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         *        <code>IMPAIRED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         *        <code>eg1.medium</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is
         *        associated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         * <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         * <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> elasticGpuIds = DefaultSdkAutoConstructList.getInstance();

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticGpusRequest model) {
            super(model);
            elasticGpuIds(model.elasticGpuIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getElasticGpuIds() {
            return elasticGpuIds;
        }

        @Override
        public final Builder elasticGpuIds(Collection<String> elasticGpuIds) {
            this.elasticGpuIds = ElasticGpuIdSetCopier.copy(elasticGpuIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuIds(String... elasticGpuIds) {
            elasticGpuIds(Arrays.asList(elasticGpuIds));
            return this;
        }

        public final void setElasticGpuIds(Collection<String> elasticGpuIds) {
            this.elasticGpuIds = ElasticGpuIdSetCopier.copy(elasticGpuIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticGpusRequest build() {
            return new DescribeElasticGpusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
