/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointConnectionNotificationRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpcEndpointConnectionNotificationRequest.Builder, ModifyVpcEndpointConnectionNotificationRequest> {
    private static final SdkField<String> CONNECTION_NOTIFICATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpcEndpointConnectionNotificationRequest::connectionNotificationId))
            .setter(setter(Builder::connectionNotificationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationId")
                    .unmarshallLocationName("ConnectionNotificationId").build()).build();

    private static final SdkField<String> CONNECTION_NOTIFICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpcEndpointConnectionNotificationRequest::connectionNotificationArn))
            .setter(setter(Builder::connectionNotificationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationArn")
                    .unmarshallLocationName("ConnectionNotificationArn").build()).build();

    private static final SdkField<List<String>> CONNECTION_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyVpcEndpointConnectionNotificationRequest::connectionEvents))
            .setter(setter(Builder::connectionEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEvents")
                    .unmarshallLocationName("ConnectionEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTION_NOTIFICATION_ID_FIELD, CONNECTION_NOTIFICATION_ARN_FIELD, CONNECTION_EVENTS_FIELD));

    private final String connectionNotificationId;

    private final String connectionNotificationArn;

    private final List<String> connectionEvents;

    private ModifyVpcEndpointConnectionNotificationRequest(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationId = builder.connectionNotificationId;
        this.connectionNotificationArn = builder.connectionNotificationArn;
        this.connectionEvents = builder.connectionEvents;
    }

    /**
     * <p>
     * The ID of the notification.
     * </p>
     * 
     * @return The ID of the notification.
     */
    public String connectionNotificationId() {
        return connectionNotificationId;
    }

    /**
     * <p>
     * The ARN for the SNS topic for the notification.
     * </p>
     * 
     * @return The ARN for the SNS topic for the notification.
     */
    public String connectionNotificationArn() {
        return connectionNotificationArn;
    }

    /**
     * <p>
     * One or more events for the endpoint. Valid values are <code>Accept</code>, <code>Connect</code>,
     * <code>Delete</code>, and <code>Reject</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more events for the endpoint. Valid values are <code>Accept</code>, <code>Connect</code>,
     *         <code>Delete</code>, and <code>Reject</code>.
     */
    public List<String> connectionEvents() {
        return connectionEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionEvents());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointConnectionNotificationRequest)) {
            return false;
        }
        ModifyVpcEndpointConnectionNotificationRequest other = (ModifyVpcEndpointConnectionNotificationRequest) obj;
        return Objects.equals(connectionNotificationId(), other.connectionNotificationId())
                && Objects.equals(connectionNotificationArn(), other.connectionNotificationArn())
                && Objects.equals(connectionEvents(), other.connectionEvents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyVpcEndpointConnectionNotificationRequest")
                .add("ConnectionNotificationId", connectionNotificationId())
                .add("ConnectionNotificationArn", connectionNotificationArn()).add("ConnectionEvents", connectionEvents())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionNotificationId":
            return Optional.ofNullable(clazz.cast(connectionNotificationId()));
        case "ConnectionNotificationArn":
            return Optional.ofNullable(clazz.cast(connectionNotificationArn()));
        case "ConnectionEvents":
            return Optional.ofNullable(clazz.cast(connectionEvents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointConnectionNotificationRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointConnectionNotificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcEndpointConnectionNotificationRequest> {
        /**
         * <p>
         * The ID of the notification.
         * </p>
         * 
         * @param connectionNotificationId
         *        The ID of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationId(String connectionNotificationId);

        /**
         * <p>
         * The ARN for the SNS topic for the notification.
         * </p>
         * 
         * @param connectionNotificationArn
         *        The ARN for the SNS topic for the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationArn(String connectionNotificationArn);

        /**
         * <p>
         * One or more events for the endpoint. Valid values are <code>Accept</code>, <code>Connect</code>,
         * <code>Delete</code>, and <code>Reject</code>.
         * </p>
         * 
         * @param connectionEvents
         *        One or more events for the endpoint. Valid values are <code>Accept</code>, <code>Connect</code>,
         *        <code>Delete</code>, and <code>Reject</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEvents(Collection<String> connectionEvents);

        /**
         * <p>
         * One or more events for the endpoint. Valid values are <code>Accept</code>, <code>Connect</code>,
         * <code>Delete</code>, and <code>Reject</code>.
         * </p>
         * 
         * @param connectionEvents
         *        One or more events for the endpoint. Valid values are <code>Accept</code>, <code>Connect</code>,
         *        <code>Delete</code>, and <code>Reject</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEvents(String... connectionEvents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String connectionNotificationId;

        private String connectionNotificationArn;

        private List<String> connectionEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointConnectionNotificationRequest model) {
            super(model);
            connectionNotificationId(model.connectionNotificationId);
            connectionNotificationArn(model.connectionNotificationArn);
            connectionEvents(model.connectionEvents);
        }

        public final String getConnectionNotificationId() {
            return connectionNotificationId;
        }

        @Override
        public final Builder connectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
            return this;
        }

        public final void setConnectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
        }

        public final String getConnectionNotificationArn() {
            return connectionNotificationArn;
        }

        @Override
        public final Builder connectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        public final void setConnectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
        }

        public final Collection<String> getConnectionEvents() {
            return connectionEvents;
        }

        @Override
        public final Builder connectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionEvents(String... connectionEvents) {
            connectionEvents(Arrays.asList(connectionEvents));
            return this;
        }

        public final void setConnectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointConnectionNotificationRequest build() {
            return new ModifyVpcEndpointConnectionNotificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
