/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume status operation code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeStatusAction implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeStatusAction.Builder, VolumeStatusAction> {
    private static final SdkField<String> CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeStatusAction::code))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeStatusAction::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeStatusAction::eventId))
            .setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId")
                    .unmarshallLocationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(VolumeStatusAction::eventType))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType")
                    .unmarshallLocationName("eventType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, DESCRIPTION_FIELD,
            EVENT_ID_FIELD, EVENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String description;

    private final String eventId;

    private final String eventType;

    private VolumeStatusAction(BuilderImpl builder) {
        this.code = builder.code;
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
    }

    /**
     * <p>
     * The code identifying the operation, for example, <code>enable-volume-io</code>.
     * </p>
     * 
     * @return The code identifying the operation, for example, <code>enable-volume-io</code>.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * A description of the operation.
     * </p>
     * 
     * @return A description of the operation.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the event associated with this operation.
     * </p>
     * 
     * @return The ID of the event associated with this operation.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type associated with this operation.
     * </p>
     * 
     * @return The event type associated with this operation.
     */
    public String eventType() {
        return eventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusAction)) {
            return false;
        }
        VolumeStatusAction other = (VolumeStatusAction) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(description(), other.description())
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(eventType(), other.eventType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VolumeStatusAction").add("Code", code()).add("Description", description())
                .add("EventId", eventId()).add("EventType", eventType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatusAction, T> g) {
        return obj -> g.apply((VolumeStatusAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeStatusAction> {
        /**
         * <p>
         * The code identifying the operation, for example, <code>enable-volume-io</code>.
         * </p>
         * 
         * @param code
         *        The code identifying the operation, for example, <code>enable-volume-io</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * A description of the operation.
         * </p>
         * 
         * @param description
         *        A description of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the event associated with this operation.
         * </p>
         * 
         * @param eventId
         *        The ID of the event associated with this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type associated with this operation.
         * </p>
         * 
         * @param eventType
         *        The event type associated with this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String description;

        private String eventId;

        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusAction model) {
            code(model.code);
            description(model.description);
            eventId(model.eventId);
            eventType(model.eventType);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public VolumeStatusAction build() {
            return new VolumeStatusAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
