/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateHostsRequest extends Ec2Request implements
        ToCopyableBuilder<AllocateHostsRequest.Builder, AllocateHostsRequest> {
    private static final SdkField<String> AUTO_PLACEMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateHostsRequest::autoPlacementAsString))
            .setter(setter(Builder::autoPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPlacement")
                    .unmarshallLocationName("autoPlacement").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateHostsRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateHostsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateHostsRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AllocateHostsRequest::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("quantity").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(AllocateHostsRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_PLACEMENT_FIELD,
            AVAILABILITY_ZONE_FIELD, CLIENT_TOKEN_FIELD, INSTANCE_TYPE_FIELD, QUANTITY_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String autoPlacement;

    private final String availabilityZone;

    private final String clientToken;

    private final String instanceType;

    private final Integer quantity;

    private final List<TagSpecification> tagSpecifications;

    private AllocateHostsRequest(BuilderImpl builder) {
        super(builder);
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.quantity = builder.quantity;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * This is enabled by default. This property allows instances to be automatically placed onto available Dedicated
     * Hosts, when you are launching instances without specifying a host ID.
     * </p>
     * <p>
     * Default: Enabled
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return This is enabled by default. This property allows instances to be automatically placed onto available
     *         Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
     *         <p>
     *         Default: Enabled
     * @see AutoPlacement
     */
    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(autoPlacement);
    }

    /**
     * <p>
     * This is enabled by default. This property allows instances to be automatically placed onto available Dedicated
     * Hosts, when you are launching instances without specifying a host ID.
     * </p>
     * <p>
     * Default: Enabled
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementAsString}.
     * </p>
     * 
     * @return This is enabled by default. This property allows instances to be automatically placed onto available
     *         Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
     *         <p>
     *         Default: Enabled
     * @see AutoPlacement
     */
    public String autoPlacementAsString() {
        return autoPlacement;
    }

    /**
     * <p>
     * The Availability Zone for the Dedicated Hosts.
     * </p>
     * 
     * @return The Availability Zone for the Dedicated Hosts.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How
     * to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specify the instance type for which to configure your Dedicated Hosts. When you specify the instance type, that
     * is the only instance type that you can launch onto that host.
     * </p>
     * 
     * @return Specify the instance type for which to configure your Dedicated Hosts. When you specify the instance
     *         type, that is the only instance type that you can launch onto that host.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of Dedicated Hosts to allocate to your account with these parameters.
     * </p>
     * 
     * @return The number of Dedicated Hosts to allocate to your account with these parameters.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * The tags to apply to the Dedicated Host during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to apply to the Dedicated Host during creation.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsRequest)) {
            return false;
        }
        AllocateHostsRequest other = (AllocateHostsRequest) obj;
        return Objects.equals(autoPlacementAsString(), other.autoPlacementAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AllocateHostsRequest").add("AutoPlacement", autoPlacementAsString())
                .add("AvailabilityZone", availabilityZone()).add("ClientToken", clientToken())
                .add("InstanceType", instanceType()).add("Quantity", quantity()).add("TagSpecifications", tagSpecifications())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoPlacement":
            return Optional.ofNullable(clazz.cast(autoPlacementAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateHostsRequest, T> g) {
        return obj -> g.apply((AllocateHostsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AllocateHostsRequest> {
        /**
         * <p>
         * This is enabled by default. This property allows instances to be automatically placed onto available
         * Dedicated Hosts, when you are launching instances without specifying a host ID.
         * </p>
         * <p>
         * Default: Enabled
         * </p>
         * 
         * @param autoPlacement
         *        This is enabled by default. This property allows instances to be automatically placed onto available
         *        Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
         *        <p>
         *        Default: Enabled
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * This is enabled by default. This property allows instances to be automatically placed onto available
         * Dedicated Hosts, when you are launching instances without specifying a host ID.
         * </p>
         * <p>
         * Default: Enabled
         * </p>
         * 
         * @param autoPlacement
         *        This is enabled by default. This property allows instances to be automatically placed onto available
         *        Dedicated Hosts, when you are launching instances without specifying a host ID.</p>
         *        <p>
         *        Default: Enabled
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The Availability Zone for the Dedicated Hosts.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specify the instance type for which to configure your Dedicated Hosts. When you specify the instance type,
         * that is the only instance type that you can launch onto that host.
         * </p>
         * 
         * @param instanceType
         *        Specify the instance type for which to configure your Dedicated Hosts. When you specify the instance
         *        type, that is the only instance type that you can launch onto that host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of Dedicated Hosts to allocate to your account with these parameters.
         * </p>
         * 
         * @param quantity
         *        The number of Dedicated Hosts to allocate to your account with these parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * The tags to apply to the Dedicated Host during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Dedicated Host during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Dedicated Host during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Dedicated Host during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Dedicated Host during creation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String autoPlacement;

        private String availabilityZone;

        private String clientToken;

        private String instanceType;

        private Integer quantity;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsRequest model) {
            super(model);
            autoPlacement(model.autoPlacement);
            availabilityZone(model.availabilityZone);
            clientToken(model.clientToken);
            instanceType(model.instanceType);
            quantity(model.quantity);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getAutoPlacementAsString() {
            return autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateHostsRequest build() {
            return new AllocateHostsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
