/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to cancel a Spot Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelledSpotInstanceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CancelledSpotInstanceRequest.Builder, CancelledSpotInstanceRequest> {
    private static final SdkField<String> SPOT_INSTANCE_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CancelledSpotInstanceRequest::spotInstanceRequestId))
            .setter(setter(Builder::spotInstanceRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestId")
                    .unmarshallLocationName("spotInstanceRequestId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CancelledSpotInstanceRequest::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SPOT_INSTANCE_REQUEST_ID_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String spotInstanceRequestId;

    private final String state;

    private CancelledSpotInstanceRequest(BuilderImpl builder) {
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the Spot Instance request.
     * </p>
     * 
     * @return The ID of the Spot Instance request.
     */
    public String spotInstanceRequestId() {
        return spotInstanceRequestId;
    }

    /**
     * <p>
     * The state of the Spot Instance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CancelSpotInstanceRequestState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Spot Instance request.
     * @see CancelSpotInstanceRequestState
     */
    public CancelSpotInstanceRequestState state() {
        return CancelSpotInstanceRequestState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Spot Instance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CancelSpotInstanceRequestState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Spot Instance request.
     * @see CancelSpotInstanceRequestState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelledSpotInstanceRequest)) {
            return false;
        }
        CancelledSpotInstanceRequest other = (CancelledSpotInstanceRequest) obj;
        return Objects.equals(spotInstanceRequestId(), other.spotInstanceRequestId())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CancelledSpotInstanceRequest").add("SpotInstanceRequestId", spotInstanceRequestId())
                .add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotInstanceRequestId":
            return Optional.ofNullable(clazz.cast(spotInstanceRequestId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelledSpotInstanceRequest, T> g) {
        return obj -> g.apply((CancelledSpotInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CancelledSpotInstanceRequest> {
        /**
         * <p>
         * The ID of the Spot Instance request.
         * </p>
         * 
         * @param spotInstanceRequestId
         *        The ID of the Spot Instance request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotInstanceRequestId(String spotInstanceRequestId);

        /**
         * <p>
         * The state of the Spot Instance request.
         * </p>
         * 
         * @param state
         *        The state of the Spot Instance request.
         * @see CancelSpotInstanceRequestState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancelSpotInstanceRequestState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Spot Instance request.
         * </p>
         * 
         * @param state
         *        The state of the Spot Instance request.
         * @see CancelSpotInstanceRequestState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CancelSpotInstanceRequestState
         */
        Builder state(CancelSpotInstanceRequestState state);
    }

    static final class BuilderImpl implements Builder {
        private String spotInstanceRequestId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelledSpotInstanceRequest model) {
            spotInstanceRequestId(model.spotInstanceRequestId);
            state(model.state);
        }

        public final String getSpotInstanceRequestId() {
            return spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CancelSpotInstanceRequestState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public CancelledSpotInstanceRequest build() {
            return new CancelledSpotInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
