/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSnapshotsRequest.Builder, DescribeSnapshotsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSnapshotsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<String>> OWNER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotsRequest::ownerIds))
            .setter(setter(Builder::ownerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Owner")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Owner").unmarshallLocationName("Owner").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> RESTORABLE_BY_USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotsRequest::restorableByUserIds))
            .setter(setter(Builder::restorableByUserIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorableBy")
                    .unmarshallLocationName("RestorableBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SNAPSHOT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotsRequest::snapshotIds))
            .setter(setter(Builder::snapshotIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotId").unmarshallLocationName("SnapshotId").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNER_IDS_FIELD, RESTORABLE_BY_USER_IDS_FIELD, SNAPSHOT_IDS_FIELD));

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> ownerIds;

    private final List<String> restorableByUserIds;

    private final List<String> snapshotIds;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerIds = builder.ownerIds;
        this.restorableByUserIds = builder.restorableByUserIds;
        this.snapshotIds = builder.snapshotIds;
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>description</code> - A description of the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> | <code>self</code> |
     * <code>all</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be confused
     * with the user-configured AWS account alias, which is set from the IAM console.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>snapshot-id</code> - The snapshot ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start-time</code> - The time stamp when the snapshot was initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
     * <code>error</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-id</code> - The ID of the volume the snapshot is for.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-size</code> - The size of the volume, in GiB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>description</code> - A description of the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> | <code>self</code>
     *         | <code>all</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be
     *         confused with the user-configured AWS account alias, which is set from the IAM console.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>snapshot-id</code> - The snapshot ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-time</code> - The time stamp when the snapshot was initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
     *         <code>error</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-id</code> - The ID of the volume the snapshot is for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-size</code> - The size of the volume, in GiB.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output. When this
     * parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results in a single page
     * along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>DescribeSnapshots</code> request with the returned <code>NextToken</code> value. This value
     * can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are
     * returned. If this parameter is not used, then <code>DescribeSnapshots</code> returns all results. You cannot
     * specify this parameter and the snapshot IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output.
     *         When this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results
     *         in a single page along with a <code>NextToken</code> response element. The remaining results of the
     *         initial request can be seen by sending another <code>DescribeSnapshots</code> request with the returned
     *         <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a
     *         value larger than 1000, only 1000 results are returned. If this parameter is not used, then
     *         <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and the snapshot
     *         IDs parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code> request where
     * <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code>
     *         request where <code>MaxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>NextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Describes the snapshots owned by these owners.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Describes the snapshots owned by these owners.
     */
    public List<String> ownerIds() {
        return ownerIds;
    }

    /**
     * <p>
     * The IDs of the AWS accounts that can create volumes from the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the AWS accounts that can create volumes from the snapshot.
     */
    public List<String> restorableByUserIds() {
        return restorableByUserIds;
    }

    /**
     * <p>
     * The snapshot IDs.
     * </p>
     * <p>
     * Default: Describes the snapshots for which you have create volume permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The snapshot IDs.</p>
     *         <p>
     *         Default: Describes the snapshots for which you have create volume permissions.
     */
    public List<String> snapshotIds() {
        return snapshotIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(ownerIds());
        hashCode = 31 * hashCode + Objects.hashCode(restorableByUserIds());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(ownerIds(), other.ownerIds())
                && Objects.equals(restorableByUserIds(), other.restorableByUserIds())
                && Objects.equals(snapshotIds(), other.snapshotIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotsRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OwnerIds", ownerIds()).add("RestorableByUserIds", restorableByUserIds())
                .add("SnapshotIds", snapshotIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OwnerIds":
            return Optional.ofNullable(clazz.cast(ownerIds()));
        case "RestorableByUserIds":
            return Optional.ofNullable(clazz.cast(restorableByUserIds()));
        case "SnapshotIds":
            return Optional.ofNullable(clazz.cast(snapshotIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> | <code>self</code> |
         * <code>all</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be
         * confused with the user-configured AWS account alias, which is set from the IAM console.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - A description of the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
         *        <code>self</code> | <code>all</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of
         *        snapshot owners. Not to be confused with the user-configured AWS account alias, which is set from the
         *        IAM console.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time stamp when the snapshot was initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         *        <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume the snapshot is for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> | <code>self</code> |
         * <code>all</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be
         * confused with the user-configured AWS account alias, which is set from the IAM console.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - A description of the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> |
         *        <code>self</code> | <code>all</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of
         *        snapshot owners. Not to be confused with the user-configured AWS account alias, which is set from the
         *        IAM console.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time stamp when the snapshot was initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         *        <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume the snapshot is for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - Value from an Amazon-maintained list (<code>amazon</code> | <code>self</code> |
         * <code>all</code> | <code>aws-marketplace</code> | <code>microsoft</code>) of snapshot owners. Not to be
         * confused with the user-configured AWS account alias, which is set from the IAM console.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The ID of the AWS account that owns the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output. When
         * this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code> results in a
         * single page along with a <code>NextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>DescribeSnapshots</code> request with the returned
         * <code>NextToken</code> value. This value can be between 5 and 1000; if <code>MaxResults</code> is given a
         * value larger than 1000, only 1000 results are returned. If this parameter is not used, then
         * <code>DescribeSnapshots</code> returns all results. You cannot specify this parameter and the snapshot IDs
         * parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of snapshot results returned by <code>DescribeSnapshots</code> in paginated output.
         *        When this parameter is used, <code>DescribeSnapshots</code> only returns <code>MaxResults</code>
         *        results in a single page along with a <code>NextToken</code> response element. The remaining results
         *        of the initial request can be seen by sending another <code>DescribeSnapshots</code> request with the
         *        returned <code>NextToken</code> value. This value can be between 5 and 1000; if
         *        <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this
         *        parameter is not used, then <code>DescribeSnapshots</code> returns all results. You cannot specify
         *        this parameter and the snapshot IDs parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code> request
         * where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>NextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value returned from a previous paginated <code>DescribeSnapshots</code>
         *        request where <code>MaxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>NextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Describes the snapshots owned by these owners.
         * </p>
         * 
         * @param ownerIds
         *        Describes the snapshots owned by these owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIds(Collection<String> ownerIds);

        /**
         * <p>
         * Describes the snapshots owned by these owners.
         * </p>
         * 
         * @param ownerIds
         *        Describes the snapshots owned by these owners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIds(String... ownerIds);

        /**
         * <p>
         * The IDs of the AWS accounts that can create volumes from the snapshot.
         * </p>
         * 
         * @param restorableByUserIds
         *        The IDs of the AWS accounts that can create volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableByUserIds(Collection<String> restorableByUserIds);

        /**
         * <p>
         * The IDs of the AWS accounts that can create volumes from the snapshot.
         * </p>
         * 
         * @param restorableByUserIds
         *        The IDs of the AWS accounts that can create volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableByUserIds(String... restorableByUserIds);

        /**
         * <p>
         * The snapshot IDs.
         * </p>
         * <p>
         * Default: Describes the snapshots for which you have create volume permissions.
         * </p>
         * 
         * @param snapshotIds
         *        The snapshot IDs.</p>
         *        <p>
         *        Default: Describes the snapshots for which you have create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(Collection<String> snapshotIds);

        /**
         * <p>
         * The snapshot IDs.
         * </p>
         * <p>
         * Default: Describes the snapshots for which you have create volume permissions.
         * </p>
         * 
         * @param snapshotIds
         *        The snapshot IDs.</p>
         *        <p>
         *        Default: Describes the snapshots for which you have create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(String... snapshotIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<String> ownerIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> restorableByUserIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> snapshotIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            ownerIds(model.ownerIds);
            restorableByUserIds(model.restorableByUserIds);
            snapshotIds(model.snapshotIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getOwnerIds() {
            return ownerIds;
        }

        @Override
        public final Builder ownerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ownerIds(String... ownerIds) {
            ownerIds(Arrays.asList(ownerIds));
            return this;
        }

        public final void setOwnerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
        }

        public final Collection<String> getRestorableByUserIds() {
            return restorableByUserIds;
        }

        @Override
        public final Builder restorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableByUserIds(String... restorableByUserIds) {
            restorableByUserIds(Arrays.asList(restorableByUserIds));
            return this;
        }

        public final void setRestorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
        }

        public final Collection<String> getSnapshotIds() {
            return snapshotIds;
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String... snapshotIds) {
            snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
