/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVolumesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeVolumesRequest.Builder, DescribeVolumesRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVolumesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> VOLUME_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVolumesRequest::volumeIds))
            .setter(setter(Builder::volumeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("VolumeId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VolumeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VolumeId").unmarshallLocationName("VolumeId").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeVolumesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeVolumesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            VOLUME_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Filter> filters;

    private final List<String> volumeIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeVolumesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.volumeIds = builder.volumeIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.device</code> - The device name specified in the block device mapping (for example,
     * <code>/dev/sda1</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
     * <code>detaching</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone in which the volume was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>create-time</code> - The time stamp when the volume was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>encrypted</code> - The encryption status of the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>size</code> - The size of the volume, in GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>snapshot-id</code> - The snapshot from which the volume was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
     * <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-id</code> - The volume ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD,
     * <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for
     * Cold HDD, or <code>standard</code> for Magnetic volumes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.device</code> - The device name specified in the block device mapping (for example,
     *         <code>/dev/sda1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
     *         <code>detaching</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone in which the volume was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>create-time</code> - The time stamp when the volume was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>encrypted</code> - The encryption status of the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>size</code> - The size of the volume, in GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>snapshot-id</code> - The snapshot from which the volume was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
     *         <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-id</code> - The volume ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose
     *         SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
     *         <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The volume IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The volume IDs.
     */
    public List<String> volumeIds() {
        return volumeIds;
    }

    /**
     * <p>
     * The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When this
     * parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a single page
     * along with a <code>NextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value. This value
     * can be between 5 and 500; if <code>MaxResults</code> is given a value larger than 500, only 500 results are
     * returned. If this parameter is not used, then <code>DescribeVolumes</code> returns all results. You cannot
     * specify this parameter and the volume IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When
     *         this parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a
     *         single page along with a <code>NextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>DescribeVolumes</code> request with the returned
     *         <code>NextToken</code> value. This value can be between 5 and 500; if <code>MaxResults</code> is given a
     *         value larger than 500, only 500 results are returned. If this parameter is not used, then
     *         <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the volume IDs
     *         parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request where
     * <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>NextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request
     *         where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>NextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(volumeIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesRequest)) {
            return false;
        }
        DescribeVolumesRequest other = (DescribeVolumesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(volumeIds(), other.volumeIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVolumesRequest").add("Filters", filters()).add("VolumeIds", volumeIds())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "VolumeIds":
            return Optional.ofNullable(clazz.cast(volumeIds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVolumesRequest, T> g) {
        return obj -> g.apply((DescribeVolumesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVolumesRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device</code> - The device name specified in the block device mapping (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
         * <code>detaching</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - The encryption status of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot from which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         * <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The volume ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD,
         * <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>
         * for Cold HDD, or <code>standard</code> for Magnetic volumes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device</code> - The device name specified in the block device mapping (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code>
         *        | <code>detaching</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>encrypted</code> - The encryption status of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot from which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         *        <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The volume ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General
         *        Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
         *        <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device</code> - The device name specified in the block device mapping (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
         * <code>detaching</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - The encryption status of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot from which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         * <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The volume ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD,
         * <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>
         * for Cold HDD, or <code>standard</code> for Magnetic volumes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device</code> - The device name specified in the block device mapping (for example,
         *        <code>/dev/sda1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code>
         *        | <code>detaching</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>create-time</code> - The time stamp when the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>encrypted</code> - The encryption status of the volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot from which the volume was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         *        <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The volume ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General
         *        Purpose SSD, <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD,
         *        <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attachment.attach-time</code> - The time stamp when the attachment initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Whether the volume is deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device</code> - The device name specified in the block device mapping (for example,
         * <code>/dev/sda1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance the volume is attached to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The attachment state (<code>attaching</code> | <code>attached</code> |
         * <code>detaching</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>create-time</code> - The time stamp when the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - The encryption status of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot from which the volume was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the volume (<code>creating</code> | <code>available</code> |
         * <code>in-use</code> | <code>deleting</code> | <code>deleted</code> | <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The volume ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-type</code> - The Amazon EBS volume type. This can be <code>gp2</code> for General Purpose SSD,
         * <code>io1</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code>
         * for Cold HDD, or <code>standard</code> for Magnetic volumes.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The volume IDs.
         * </p>
         * 
         * @param volumeIds
         *        The volume IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * The volume IDs.
         * </p>
         * 
         * @param volumeIds
         *        The volume IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        /**
         * <p>
         * The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output. When this
         * parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results in a single page
         * along with a <code>NextToken</code> response element. The remaining results of the initial request can be
         * seen by sending another <code>DescribeVolumes</code> request with the returned <code>NextToken</code> value.
         * This value can be between 5 and 500; if <code>MaxResults</code> is given a value larger than 500, only 500
         * results are returned. If this parameter is not used, then <code>DescribeVolumes</code> returns all results.
         * You cannot specify this parameter and the volume IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of volume results returned by <code>DescribeVolumes</code> in paginated output.
         *        When this parameter is used, <code>DescribeVolumes</code> only returns <code>MaxResults</code> results
         *        in a single page along with a <code>NextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>DescribeVolumes</code> request with the returned
         *        <code>NextToken</code> value. This value can be between 5 and 500; if <code>MaxResults</code> is given
         *        a value larger than 500, only 500 results are returned. If this parameter is not used, then
         *        <code>DescribeVolumes</code> returns all results. You cannot specify this parameter and the volume IDs
         *        parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code> request
         * where <code>MaxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>NextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value returned from a previous paginated <code>DescribeVolumes</code>
         *        request where <code>MaxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>NextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> volumeIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesRequest model) {
            super(model);
            filters(model.filters);
            volumeIds(model.volumeIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVolumeIds() {
            return volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumesRequest build() {
            return new DescribeVolumesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
