/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the association between an instance and an Elastic Graphics accelerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticGpuAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticGpuAssociation.Builder, ElasticGpuAssociation> {
    private static final SdkField<String> ELASTIC_GPU_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpuAssociation::elasticGpuId))
            .setter(setter(Builder::elasticGpuId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuId")
                    .unmarshallLocationName("elasticGpuId").build()).build();

    private static final SdkField<String> ELASTIC_GPU_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpuAssociation::elasticGpuAssociationId))
            .setter(setter(Builder::elasticGpuAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuAssociationId")
                    .unmarshallLocationName("elasticGpuAssociationId").build()).build();

    private static final SdkField<String> ELASTIC_GPU_ASSOCIATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpuAssociation::elasticGpuAssociationState))
            .setter(setter(Builder::elasticGpuAssociationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuAssociationState")
                    .unmarshallLocationName("elasticGpuAssociationState").build()).build();

    private static final SdkField<String> ELASTIC_GPU_ASSOCIATION_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ElasticGpuAssociation::elasticGpuAssociationTime))
            .setter(setter(Builder::elasticGpuAssociationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuAssociationTime")
                    .unmarshallLocationName("elasticGpuAssociationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_GPU_ID_FIELD,
            ELASTIC_GPU_ASSOCIATION_ID_FIELD, ELASTIC_GPU_ASSOCIATION_STATE_FIELD, ELASTIC_GPU_ASSOCIATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String elasticGpuId;

    private final String elasticGpuAssociationId;

    private final String elasticGpuAssociationState;

    private final String elasticGpuAssociationTime;

    private ElasticGpuAssociation(BuilderImpl builder) {
        this.elasticGpuId = builder.elasticGpuId;
        this.elasticGpuAssociationId = builder.elasticGpuAssociationId;
        this.elasticGpuAssociationState = builder.elasticGpuAssociationState;
        this.elasticGpuAssociationTime = builder.elasticGpuAssociationTime;
    }

    /**
     * <p>
     * The ID of the Elastic Graphics accelerator.
     * </p>
     * 
     * @return The ID of the Elastic Graphics accelerator.
     */
    public String elasticGpuId() {
        return elasticGpuId;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public String elasticGpuAssociationId() {
        return elasticGpuAssociationId;
    }

    /**
     * <p>
     * The state of the association between the instance and the Elastic Graphics accelerator.
     * </p>
     * 
     * @return The state of the association between the instance and the Elastic Graphics accelerator.
     */
    public String elasticGpuAssociationState() {
        return elasticGpuAssociationState;
    }

    /**
     * <p>
     * The time the Elastic Graphics accelerator was associated with the instance.
     * </p>
     * 
     * @return The time the Elastic Graphics accelerator was associated with the instance.
     */
    public String elasticGpuAssociationTime() {
        return elasticGpuAssociationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuId());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociationState());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticGpuAssociation)) {
            return false;
        }
        ElasticGpuAssociation other = (ElasticGpuAssociation) obj;
        return Objects.equals(elasticGpuId(), other.elasticGpuId())
                && Objects.equals(elasticGpuAssociationId(), other.elasticGpuAssociationId())
                && Objects.equals(elasticGpuAssociationState(), other.elasticGpuAssociationState())
                && Objects.equals(elasticGpuAssociationTime(), other.elasticGpuAssociationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ElasticGpuAssociation").add("ElasticGpuId", elasticGpuId())
                .add("ElasticGpuAssociationId", elasticGpuAssociationId())
                .add("ElasticGpuAssociationState", elasticGpuAssociationState())
                .add("ElasticGpuAssociationTime", elasticGpuAssociationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuId":
            return Optional.ofNullable(clazz.cast(elasticGpuId()));
        case "ElasticGpuAssociationId":
            return Optional.ofNullable(clazz.cast(elasticGpuAssociationId()));
        case "ElasticGpuAssociationState":
            return Optional.ofNullable(clazz.cast(elasticGpuAssociationState()));
        case "ElasticGpuAssociationTime":
            return Optional.ofNullable(clazz.cast(elasticGpuAssociationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticGpuAssociation, T> g) {
        return obj -> g.apply((ElasticGpuAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticGpuAssociation> {
        /**
         * <p>
         * The ID of the Elastic Graphics accelerator.
         * </p>
         * 
         * @param elasticGpuId
         *        The ID of the Elastic Graphics accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuId(String elasticGpuId);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param elasticGpuAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociationId(String elasticGpuAssociationId);

        /**
         * <p>
         * The state of the association between the instance and the Elastic Graphics accelerator.
         * </p>
         * 
         * @param elasticGpuAssociationState
         *        The state of the association between the instance and the Elastic Graphics accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociationState(String elasticGpuAssociationState);

        /**
         * <p>
         * The time the Elastic Graphics accelerator was associated with the instance.
         * </p>
         * 
         * @param elasticGpuAssociationTime
         *        The time the Elastic Graphics accelerator was associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociationTime(String elasticGpuAssociationTime);
    }

    static final class BuilderImpl implements Builder {
        private String elasticGpuId;

        private String elasticGpuAssociationId;

        private String elasticGpuAssociationState;

        private String elasticGpuAssociationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticGpuAssociation model) {
            elasticGpuId(model.elasticGpuId);
            elasticGpuAssociationId(model.elasticGpuAssociationId);
            elasticGpuAssociationState(model.elasticGpuAssociationState);
            elasticGpuAssociationTime(model.elasticGpuAssociationTime);
        }

        public final String getElasticGpuId() {
            return elasticGpuId;
        }

        @Override
        public final Builder elasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
            return this;
        }

        public final void setElasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
        }

        public final String getElasticGpuAssociationId() {
            return elasticGpuAssociationId;
        }

        @Override
        public final Builder elasticGpuAssociationId(String elasticGpuAssociationId) {
            this.elasticGpuAssociationId = elasticGpuAssociationId;
            return this;
        }

        public final void setElasticGpuAssociationId(String elasticGpuAssociationId) {
            this.elasticGpuAssociationId = elasticGpuAssociationId;
        }

        public final String getElasticGpuAssociationState() {
            return elasticGpuAssociationState;
        }

        @Override
        public final Builder elasticGpuAssociationState(String elasticGpuAssociationState) {
            this.elasticGpuAssociationState = elasticGpuAssociationState;
            return this;
        }

        public final void setElasticGpuAssociationState(String elasticGpuAssociationState) {
            this.elasticGpuAssociationState = elasticGpuAssociationState;
        }

        public final String getElasticGpuAssociationTime() {
            return elasticGpuAssociationTime;
        }

        @Override
        public final Builder elasticGpuAssociationTime(String elasticGpuAssociationTime) {
            this.elasticGpuAssociationTime = elasticGpuAssociationTime;
            return this;
        }

        public final void setElasticGpuAssociationTime(String elasticGpuAssociationTime) {
            this.elasticGpuAssociationTime = elasticGpuAssociationTime;
        }

        @Override
        public ElasticGpuAssociation build() {
            return new ElasticGpuAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
