/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyImageAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyImageAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyImageAttributeRequest.Builder, ModifyImageAttributeRequest> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyImageAttributeRequest::attribute))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<AttributeValue> DESCRIPTION_FIELD = SdkField
            .<AttributeValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyImageAttributeRequest::description))
            .setter(setter(Builder::description))
            .constructor(AttributeValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyImageAttributeRequest::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("ImageId").build()).build();

    private static final SdkField<LaunchPermissionModifications> LAUNCH_PERMISSION_FIELD = SdkField
            .<LaunchPermissionModifications> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyImageAttributeRequest::launchPermission))
            .setter(setter(Builder::launchPermission))
            .constructor(LaunchPermissionModifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPermission")
                    .unmarshallLocationName("LaunchPermission").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyImageAttributeRequest::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType")
                    .unmarshallLocationName("OperationType").build()).build();

    private static final SdkField<List<String>> PRODUCT_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyImageAttributeRequest::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode")
                    .unmarshallLocationName("ProductCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProductCode")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProductCode").unmarshallLocationName("ProductCode").build())
                                            .build()).build()).build();

    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyImageAttributeRequest::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup")
                    .unmarshallLocationName("UserGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UserGroup")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UserGroup").unmarshallLocationName("UserGroup").build())
                                            .build()).build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyImageAttributeRequest::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId")
                    .unmarshallLocationName("UserId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UserId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UserId").unmarshallLocationName("UserId").build()).build())
                            .build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyImageAttributeRequest::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            DESCRIPTION_FIELD, IMAGE_ID_FIELD, LAUNCH_PERMISSION_FIELD, OPERATION_TYPE_FIELD, PRODUCT_CODES_FIELD,
            USER_GROUPS_FIELD, USER_IDS_FIELD, VALUE_FIELD));

    private final String attribute;

    private final AttributeValue description;

    private final String imageId;

    private final LaunchPermissionModifications launchPermission;

    private final String operationType;

    private final List<String> productCodes;

    private final List<String> userGroups;

    private final List<String> userIds;

    private final String value;

    private ModifyImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.description = builder.description;
        this.imageId = builder.imageId;
        this.launchPermission = builder.launchPermission;
        this.operationType = builder.operationType;
        this.productCodes = builder.productCodes;
        this.userGroups = builder.userGroups;
        this.userIds = builder.userIds;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute to modify. The valid values are <code>description</code>, <code>launchPermission</code>
     * , and <code>productCodes</code>.
     * </p>
     * 
     * @return The name of the attribute to modify. The valid values are <code>description</code>,
     *         <code>launchPermission</code>, and <code>productCodes</code>.
     */
    public String attribute() {
        return attribute;
    }

    /**
     * <p>
     * A new description for the AMI.
     * </p>
     * 
     * @return A new description for the AMI.
     */
    public AttributeValue description() {
        return description;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * A new launch permission for the AMI.
     * </p>
     * 
     * @return A new launch permission for the AMI.
     */
    public LaunchPermissionModifications launchPermission() {
        return launchPermission;
    }

    /**
     * <p>
     * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     *         <code>launchPermission</code>.
     * @see OperationType
     */
    public OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
     *         <code>launchPermission</code>.
     * @see OperationType
     */
    public String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The DevPay product codes. After you add a product code to an AMI, it can't be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The DevPay product codes. After you add a product code to an AMI, it can't be removed.
     */
    public List<String> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
     *         <code>launchPermission</code>.
     */
    public List<String> userGroups() {
        return userGroups;
    }

    /**
     * <p>
     * The AWS account IDs. This parameter can be used only when the <code>Attribute</code> parameter is
     * <code>launchPermission</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account IDs. This parameter can be used only when the <code>Attribute</code> parameter is
     *         <code>launchPermission</code>.
     */
    public List<String> userIds() {
        return userIds;
    }

    /**
     * <p>
     * The value of the attribute being modified. This parameter can be used only when the <code>Attribute</code>
     * parameter is <code>description</code> or <code>productCodes</code>.
     * </p>
     * 
     * @return The value of the attribute being modified. This parameter can be used only when the
     *         <code>Attribute</code> parameter is <code>description</code> or <code>productCodes</code>.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(launchPermission());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(userGroups());
        hashCode = 31 * hashCode + Objects.hashCode(userIds());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyImageAttributeRequest)) {
            return false;
        }
        ModifyImageAttributeRequest other = (ModifyImageAttributeRequest) obj;
        return Objects.equals(attribute(), other.attribute()) && Objects.equals(description(), other.description())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(launchPermission(), other.launchPermission())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(userGroups(), other.userGroups())
                && Objects.equals(userIds(), other.userIds()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyImageAttributeRequest").add("Attribute", attribute()).add("Description", description())
                .add("ImageId", imageId()).add("LaunchPermission", launchPermission())
                .add("OperationType", operationTypeAsString()).add("ProductCodes", productCodes())
                .add("UserGroups", userGroups()).add("UserIds", userIds()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "LaunchPermission":
            return Optional.ofNullable(clazz.cast(launchPermission()));
        case "OperationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "UserGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyImageAttributeRequest, T> g) {
        return obj -> g.apply((ModifyImageAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyImageAttributeRequest> {
        /**
         * <p>
         * The name of the attribute to modify. The valid values are <code>description</code>,
         * <code>launchPermission</code>, and <code>productCodes</code>.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute to modify. The valid values are <code>description</code>,
         *        <code>launchPermission</code>, and <code>productCodes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * A new description for the AMI.
         * </p>
         * 
         * @param description
         *        A new description for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(AttributeValue description);

        /**
         * <p>
         * A new description for the AMI.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeValue.Builder} avoiding the need to
         * create one manually via {@link AttributeValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeValue.Builder#build()} is called immediately and its
         * result is passed to {@link #description(AttributeValue)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link AttributeValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(AttributeValue)
         */
        default Builder description(Consumer<AttributeValue.Builder> description) {
            return description(AttributeValue.builder().applyMutation(description).build());
        }

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * A new launch permission for the AMI.
         * </p>
         * 
         * @param launchPermission
         *        A new launch permission for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermission(LaunchPermissionModifications launchPermission);

        /**
         * <p>
         * A new launch permission for the AMI.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchPermissionModifications.Builder} avoiding
         * the need to create one manually via {@link LaunchPermissionModifications#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchPermissionModifications.Builder#build()} is called
         * immediately and its result is passed to {@link #launchPermission(LaunchPermissionModifications)}.
         * 
         * @param launchPermission
         *        a consumer that will call methods on {@link LaunchPermissionModifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchPermission(LaunchPermissionModifications)
         */
        default Builder launchPermission(Consumer<LaunchPermissionModifications.Builder> launchPermission) {
            return launchPermission(LaunchPermissionModifications.builder().applyMutation(launchPermission).build());
        }

        /**
         * <p>
         * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param operationType
         *        The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param operationType
         *        The operation type. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The DevPay product codes. After you add a product code to an AMI, it can't be removed.
         * </p>
         * 
         * @param productCodes
         *        The DevPay product codes. After you add a product code to an AMI, it can't be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<String> productCodes);

        /**
         * <p>
         * The DevPay product codes. After you add a product code to an AMI, it can't be removed.
         * </p>
         * 
         * @param productCodes
         *        The DevPay product codes. After you add a product code to an AMI, it can't be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(String... productCodes);

        /**
         * <p>
         * The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param userGroups
         *        The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param userGroups
         *        The user groups. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);

        /**
         * <p>
         * The AWS account IDs. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param userIds
         *        The AWS account IDs. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The AWS account IDs. This parameter can be used only when the <code>Attribute</code> parameter is
         * <code>launchPermission</code>.
         * </p>
         * 
         * @param userIds
         *        The AWS account IDs. This parameter can be used only when the <code>Attribute</code> parameter is
         *        <code>launchPermission</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * The value of the attribute being modified. This parameter can be used only when the <code>Attribute</code>
         * parameter is <code>description</code> or <code>productCodes</code>.
         * </p>
         * 
         * @param value
         *        The value of the attribute being modified. This parameter can be used only when the
         *        <code>Attribute</code> parameter is <code>description</code> or <code>productCodes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String attribute;

        private AttributeValue description;

        private String imageId;

        private LaunchPermissionModifications launchPermission;

        private String operationType;

        private List<String> productCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyImageAttributeRequest model) {
            super(model);
            attribute(model.attribute);
            description(model.description);
            imageId(model.imageId);
            launchPermission(model.launchPermission);
            operationType(model.operationType);
            productCodes(model.productCodes);
            userGroups(model.userGroups);
            userIds(model.userIds);
            value(model.value);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final AttributeValue.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        @Override
        public final Builder description(AttributeValue description) {
            this.description = description;
            return this;
        }

        public final void setDescription(AttributeValue.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final LaunchPermissionModifications.Builder getLaunchPermission() {
            return launchPermission != null ? launchPermission.toBuilder() : null;
        }

        @Override
        public final Builder launchPermission(LaunchPermissionModifications launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        public final void setLaunchPermission(LaunchPermissionModifications.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        public final String getOperationTypeAsString() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final Collection<String> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        public final Collection<String> getUserGroups() {
            return userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        public final Collection<String> getUserIds() {
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyImageAttributeRequest build() {
            return new ModifyImageAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
