/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a Spot Fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotFleetRequestConfigData implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotFleetRequestConfigData.Builder, SpotFleetRequestConfigData> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy")
                    .unmarshallLocationName("allocationStrategy").build()).build();

    private static final SdkField<String> ON_DEMAND_ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::onDemandAllocationStrategyAsString))
            .setter(setter(Builder::onDemandAllocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandAllocationStrategy")
                    .unmarshallLocationName("onDemandAllocationStrategy").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::excessCapacityTerminationPolicyAsString))
            .setter(setter(Builder::excessCapacityTerminationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy")
                    .unmarshallLocationName("excessCapacityTerminationPolicy").build()).build();

    private static final SdkField<Double> FULFILLED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SpotFleetRequestConfigData::fulfilledCapacity))
            .setter(setter(Builder::fulfilledCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledCapacity")
                    .unmarshallLocationName("fulfilledCapacity").build()).build();

    private static final SdkField<Double> ON_DEMAND_FULFILLED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(SpotFleetRequestConfigData::onDemandFulfilledCapacity))
            .setter(setter(Builder::onDemandFulfilledCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandFulfilledCapacity")
                    .unmarshallLocationName("onDemandFulfilledCapacity").build()).build();

    private static final SdkField<String> IAM_FLEET_ROLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::iamFleetRole))
            .setter(setter(Builder::iamFleetRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamFleetRole")
                    .unmarshallLocationName("iamFleetRole").build()).build();

    private static final SdkField<List<SpotFleetLaunchSpecification>> LAUNCH_SPECIFICATIONS_FIELD = SdkField
            .<List<SpotFleetLaunchSpecification>> builder(MarshallingType.LIST)
            .getter(getter(SpotFleetRequestConfigData::launchSpecifications))
            .setter(setter(Builder::launchSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchSpecifications")
                    .unmarshallLocationName("launchSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SpotFleetLaunchSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpotFleetLaunchSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<LaunchTemplateConfig>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField
            .<List<LaunchTemplateConfig>> builder(MarshallingType.LIST)
            .getter(getter(SpotFleetRequestConfigData::launchTemplateConfigs))
            .setter(setter(Builder::launchTemplateConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfigs")
                    .unmarshallLocationName("launchTemplateConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SPOT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::spotPrice))
            .setter(setter(Builder::spotPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotPrice")
                    .unmarshallLocationName("spotPrice").build()).build();

    private static final SdkField<Integer> TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SpotFleetRequestConfigData::targetCapacity))
            .setter(setter(Builder::targetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacity")
                    .unmarshallLocationName("targetCapacity").build()).build();

    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SpotFleetRequestConfigData::onDemandTargetCapacity))
            .setter(setter(Builder::onDemandTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity")
                    .unmarshallLocationName("onDemandTargetCapacity").build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SpotFleetRequestConfigData::terminateInstancesWithExpiration))
            .setter(setter(Builder::terminateInstancesWithExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstancesWithExpiration")
                    .unmarshallLocationName("terminateInstancesWithExpiration").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SpotFleetRequestConfigData::validFrom))
            .setter(setter(Builder::validFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom")
                    .unmarshallLocationName("validFrom").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SpotFleetRequestConfigData::validUntil))
            .setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil")
                    .unmarshallLocationName("validUntil").build()).build();

    private static final SdkField<Boolean> REPLACE_UNHEALTHY_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SpotFleetRequestConfigData::replaceUnhealthyInstances))
            .setter(setter(Builder::replaceUnhealthyInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceUnhealthyInstances")
                    .unmarshallLocationName("replaceUnhealthyInstances").build()).build();

    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotFleetRequestConfigData::instanceInterruptionBehaviorAsString))
            .setter(setter(Builder::instanceInterruptionBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior")
                    .unmarshallLocationName("instanceInterruptionBehavior").build()).build();

    private static final SdkField<LoadBalancersConfig> LOAD_BALANCERS_CONFIG_FIELD = SdkField
            .<LoadBalancersConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(SpotFleetRequestConfigData::loadBalancersConfig))
            .setter(setter(Builder::loadBalancersConfig))
            .constructor(LoadBalancersConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancersConfig")
                    .unmarshallLocationName("loadBalancersConfig").build()).build();

    private static final SdkField<Integer> INSTANCE_POOLS_TO_USE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SpotFleetRequestConfigData::instancePoolsToUseCount))
            .setter(setter(Builder::instancePoolsToUseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePoolsToUseCount")
                    .unmarshallLocationName("instancePoolsToUseCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD,
            ON_DEMAND_ALLOCATION_STRATEGY_FIELD, CLIENT_TOKEN_FIELD, EXCESS_CAPACITY_TERMINATION_POLICY_FIELD,
            FULFILLED_CAPACITY_FIELD, ON_DEMAND_FULFILLED_CAPACITY_FIELD, IAM_FLEET_ROLE_FIELD, LAUNCH_SPECIFICATIONS_FIELD,
            LAUNCH_TEMPLATE_CONFIGS_FIELD, SPOT_PRICE_FIELD, TARGET_CAPACITY_FIELD, ON_DEMAND_TARGET_CAPACITY_FIELD,
            TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD, TYPE_FIELD, VALID_FROM_FIELD, VALID_UNTIL_FIELD,
            REPLACE_UNHEALTHY_INSTANCES_FIELD, INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, LOAD_BALANCERS_CONFIG_FIELD,
            INSTANCE_POOLS_TO_USE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationStrategy;

    private final String onDemandAllocationStrategy;

    private final String clientToken;

    private final String excessCapacityTerminationPolicy;

    private final Double fulfilledCapacity;

    private final Double onDemandFulfilledCapacity;

    private final String iamFleetRole;

    private final List<SpotFleetLaunchSpecification> launchSpecifications;

    private final List<LaunchTemplateConfig> launchTemplateConfigs;

    private final String spotPrice;

    private final Integer targetCapacity;

    private final Integer onDemandTargetCapacity;

    private final Boolean terminateInstancesWithExpiration;

    private final String type;

    private final Instant validFrom;

    private final Instant validUntil;

    private final Boolean replaceUnhealthyInstances;

    private final String instanceInterruptionBehavior;

    private final LoadBalancersConfig loadBalancersConfig;

    private final Integer instancePoolsToUseCount;

    private SpotFleetRequestConfigData(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.onDemandAllocationStrategy = builder.onDemandAllocationStrategy;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.onDemandFulfilledCapacity = builder.onDemandFulfilledCapacity;
        this.iamFleetRole = builder.iamFleetRole;
        this.launchSpecifications = builder.launchSpecifications;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.spotPrice = builder.spotPrice;
        this.targetCapacity = builder.targetCapacity;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.loadBalancersConfig = builder.loadBalancersConfig;
        this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
    }

    /**
     * <p>
     * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
     * default is <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request.
     *         The default is <code>lowestPrice</code>.
     * @see AllocationStrategy
     */
    public AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
     * default is <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link AllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request.
     *         The default is <code>lowestPrice</code>.
     * @see AllocationStrategy
     */
    public String allocationStrategyAsString() {
        return allocationStrategy;
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch template
     * override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults to
     * <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onDemandAllocationStrategy} will return {@link OnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #onDemandAllocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet
     *         launch template override, launching the highest priority first. If you do not specify a value, Spot Fleet
     *         defaults to <code>lowestPrice</code>.
     * @see OnDemandAllocationStrategy
     */
    public OnDemandAllocationStrategy onDemandAllocationStrategy() {
        return OnDemandAllocationStrategy.fromValue(onDemandAllocationStrategy);
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch template
     * override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults to
     * <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #onDemandAllocationStrategy} will return {@link OnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #onDemandAllocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet
     *         launch template override, launching the highest priority first. If you do not specify a value, Spot Fleet
     *         defaults to <code>lowestPrice</code>.
     * @see OnDemandAllocationStrategy
     */
    public String onDemandAllocationStrategyAsString() {
        return onDemandAllocationStrategy;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This helps to
     * avoid duplicate listings. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This
     *         helps to avoid duplicate listings. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet request is
     * decreased below the current size of the Spot Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet
     *         request is decreased below the current size of the Spot Fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet request is
     * decreased below the current size of the Spot Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link ExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet
     *         request is decreased below the current size of the Spot Fleet.
     * @see ExcessCapacityTerminationPolicy
     */
    public String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * <p>
     * The number of units fulfilled by this request compared to the set target capacity. You cannot set this value.
     * </p>
     * 
     * @return The number of units fulfilled by this request compared to the set target capacity. You cannot set this
     *         value.
     */
    public Double fulfilledCapacity() {
        return fulfilledCapacity;
    }

    /**
     * <p>
     * The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
     * </p>
     * 
     * @return The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
     */
    public Double onDemandFulfilledCapacity() {
        return onDemandFulfilledCapacity;
    }

    /**
     * <p>
     * Grants the Spot Fleet permission to terminate Spot Instances on your behalf when you cancel its Spot Fleet
     * request using <a>CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
     * <code>terminateInstancesWithExpiration</code>.
     * </p>
     * 
     * @return Grants the Spot Fleet permission to terminate Spot Instances on your behalf when you cancel its Spot
     *         Fleet request using <a>CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
     *         <code>terminateInstancesWithExpiration</code>.
     */
    public String iamFleetRole() {
        return iamFleetRole;
    }

    /**
     * <p>
     * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you can't
     * specify <code>LaunchTemplateConfigs</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>,
     *         you can't specify <code>LaunchTemplateConfigs</code>.
     */
    public List<SpotFleetLaunchSpecification> launchSpecifications() {
        return launchSpecifications;
    }

    /**
     * <p>
     * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
     * <code>LaunchSpecifications</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
     *         <code>LaunchSpecifications</code>.
     */
    public List<LaunchTemplateConfig> launchTemplateConfigs() {
        return launchTemplateConfigs;
    }

    /**
     * <p>
     * The maximum price per unit hour that you are willing to pay for a Spot Instance. The default is the On-Demand
     * price.
     * </p>
     * 
     * @return The maximum price per unit hour that you are willing to pay for a Spot Instance. The default is the
     *         On-Demand price.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The number of units to request. You can choose to set the target capacity in terms of instances or a performance
     * characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type
     * is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
     * </p>
     * 
     * @return The number of units to request. You can choose to set the target capacity in terms of instances or a
     *         performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O.
     *         If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity
     *         later.
     */
    public Integer targetCapacity() {
        return targetCapacity;
    }

    /**
     * <p>
     * The number of On-Demand units to request. You can choose to set the target capacity in terms of instances or a
     * performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the
     * request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
     * </p>
     * 
     * @return The number of On-Demand units to request. You can choose to set the target capacity in terms of instances
     *         or a performance characteristic that is important to your application workload, such as vCPUs, memory, or
     *         I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add
     *         capacity later.
     */
    public Integer onDemandTargetCapacity() {
        return onDemandTargetCapacity;
    }

    /**
     * <p>
     * Indicates whether running Spot Instances should be terminated when the Spot Fleet request expires.
     * </p>
     * 
     * @return Indicates whether running Spot Instances should be terminated when the Spot Fleet request expires.
     */
    public Boolean terminateInstancesWithExpiration() {
        return terminateInstancesWithExpiration;
    }

    /**
     * <p>
     * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
     * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It does
     * not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in alternative
     * Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet maintains the
     * target capacity. The Spot Fleet places the required requests to meet capacity and automatically replenishes any
     * interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is not used by Spot
     * Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts
     *         to maintain it. When this value is <code>request</code>, the Spot Fleet only places the required
     *         requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit
     *         requests in alternative Spot pools if capacity is not available. When this value is <code>maintain</code>
     *         , the Spot Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
     *         capacity and automatically replenishes any interrupted instances. Default: <code>maintain</code>.
     *         <code>instant</code> is listed but is not used by Spot Fleet.
     * @see FleetType
     */
    public FleetType type() {
        return FleetType.fromValue(type);
    }

    /**
     * <p>
     * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
     * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It does
     * not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in alternative
     * Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet maintains the
     * target capacity. The Spot Fleet places the required requests to meet capacity and automatically replenishes any
     * interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is not used by Spot
     * Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts
     *         to maintain it. When this value is <code>request</code>, the Spot Fleet only places the required
     *         requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit
     *         requests in alternative Spot pools if capacity is not available. When this value is <code>maintain</code>
     *         , the Spot Fleet maintains the target capacity. The Spot Fleet places the required requests to meet
     *         capacity and automatically replenishes any interrupted instances. Default: <code>maintain</code>.
     *         <code>instant</code> is listed but is not used by Spot Fleet.
     * @see FleetType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The start date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request
     * immediately.
     * </p>
     * 
     * @return The start date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
     *         request immediately.
     */
    public Instant validFrom() {
        return validFrom;
    }

    /**
     * <p>
     * The end date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot Instance requests are
     * placed or able to fulfill the request. If no value is specified, the Spot Fleet request remains until you cancel
     * it.
     * </p>
     * 
     * @return The end date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot Instance
     *         requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request
     *         remains until you cancel it.
     */
    public Instant validUntil() {
        return validUntil;
    }

    /**
     * <p>
     * Indicates whether Spot Fleet should replace unhealthy instances.
     * </p>
     * 
     * @return Indicates whether Spot Fleet should replace unhealthy instances.
     */
    public Boolean replaceUnhealthyInstances() {
        return replaceUnhealthyInstances;
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see InstanceInterruptionBehavior
     */
    public InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(instanceInterruptionBehavior);
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see InstanceInterruptionBehavior
     */
    public String instanceInterruptionBehaviorAsString() {
        return instanceInterruptionBehavior;
    }

    /**
     * <p>
     * One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet registers
     * the running Spot Instances with the specified Classic Load Balancers and target groups.
     * </p>
     * <p>
     * With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1,
     * CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
     * </p>
     * 
     * @return One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
     *         registers the running Spot Instances with the specified Classic Load Balancers and target groups.</p>
     *         <p>
     *         With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types:
     *         C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
     */
    public LoadBalancersConfig loadBalancersConfig() {
        return loadBalancersConfig;
    }

    /**
     * <p>
     * The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
     * <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools and
     * evenly allocates your target Spot capacity across the number of Spot pools that you specify.
     * </p>
     * 
     * @return The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
     *         <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools
     *         and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
     */
    public Integer instancePoolsToUseCount() {
        return instancePoolsToUseCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandAllocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandFulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(iamFleetRole());
        hashCode = 31 * hashCode + Objects.hashCode(launchSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(instancePoolsToUseCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData) obj;
        return Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString())
                && Objects.equals(onDemandAllocationStrategyAsString(), other.onDemandAllocationStrategyAsString())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString())
                && Objects.equals(fulfilledCapacity(), other.fulfilledCapacity())
                && Objects.equals(onDemandFulfilledCapacity(), other.onDemandFulfilledCapacity())
                && Objects.equals(iamFleetRole(), other.iamFleetRole())
                && Objects.equals(launchSpecifications(), other.launchSpecifications())
                && Objects.equals(launchTemplateConfigs(), other.launchTemplateConfigs())
                && Objects.equals(spotPrice(), other.spotPrice()) && Objects.equals(targetCapacity(), other.targetCapacity())
                && Objects.equals(onDemandTargetCapacity(), other.onDemandTargetCapacity())
                && Objects.equals(terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(validFrom(), other.validFrom())
                && Objects.equals(validUntil(), other.validUntil())
                && Objects.equals(replaceUnhealthyInstances(), other.replaceUnhealthyInstances())
                && Objects.equals(instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString())
                && Objects.equals(loadBalancersConfig(), other.loadBalancersConfig())
                && Objects.equals(instancePoolsToUseCount(), other.instancePoolsToUseCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SpotFleetRequestConfigData").add("AllocationStrategy", allocationStrategyAsString())
                .add("OnDemandAllocationStrategy", onDemandAllocationStrategyAsString()).add("ClientToken", clientToken())
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString())
                .add("FulfilledCapacity", fulfilledCapacity()).add("OnDemandFulfilledCapacity", onDemandFulfilledCapacity())
                .add("IamFleetRole", iamFleetRole()).add("LaunchSpecifications", launchSpecifications())
                .add("LaunchTemplateConfigs", launchTemplateConfigs()).add("SpotPrice", spotPrice())
                .add("TargetCapacity", targetCapacity()).add("OnDemandTargetCapacity", onDemandTargetCapacity())
                .add("TerminateInstancesWithExpiration", terminateInstancesWithExpiration()).add("Type", typeAsString())
                .add("ValidFrom", validFrom()).add("ValidUntil", validUntil())
                .add("ReplaceUnhealthyInstances", replaceUnhealthyInstances())
                .add("InstanceInterruptionBehavior", instanceInterruptionBehaviorAsString())
                .add("LoadBalancersConfig", loadBalancersConfig()).add("InstancePoolsToUseCount", instancePoolsToUseCount())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        case "OnDemandAllocationStrategy":
            return Optional.ofNullable(clazz.cast(onDemandAllocationStrategyAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ExcessCapacityTerminationPolicy":
            return Optional.ofNullable(clazz.cast(excessCapacityTerminationPolicyAsString()));
        case "FulfilledCapacity":
            return Optional.ofNullable(clazz.cast(fulfilledCapacity()));
        case "OnDemandFulfilledCapacity":
            return Optional.ofNullable(clazz.cast(onDemandFulfilledCapacity()));
        case "IamFleetRole":
            return Optional.ofNullable(clazz.cast(iamFleetRole()));
        case "LaunchSpecifications":
            return Optional.ofNullable(clazz.cast(launchSpecifications()));
        case "LaunchTemplateConfigs":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigs()));
        case "SpotPrice":
            return Optional.ofNullable(clazz.cast(spotPrice()));
        case "TargetCapacity":
            return Optional.ofNullable(clazz.cast(targetCapacity()));
        case "OnDemandTargetCapacity":
            return Optional.ofNullable(clazz.cast(onDemandTargetCapacity()));
        case "TerminateInstancesWithExpiration":
            return Optional.ofNullable(clazz.cast(terminateInstancesWithExpiration()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ValidFrom":
            return Optional.ofNullable(clazz.cast(validFrom()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        case "ReplaceUnhealthyInstances":
            return Optional.ofNullable(clazz.cast(replaceUnhealthyInstances()));
        case "InstanceInterruptionBehavior":
            return Optional.ofNullable(clazz.cast(instanceInterruptionBehaviorAsString()));
        case "LoadBalancersConfig":
            return Optional.ofNullable(clazz.cast(loadBalancersConfig()));
        case "InstancePoolsToUseCount":
            return Optional.ofNullable(clazz.cast(instancePoolsToUseCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotFleetRequestConfigData, T> g) {
        return obj -> g.apply((SpotFleetRequestConfigData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotFleetRequestConfigData> {
        /**
         * <p>
         * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
         * default is <code>lowestPrice</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet
         *        request. The default is <code>lowestPrice</code>.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
         * default is <code>lowestPrice</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet
         *        request. The default is <code>lowestPrice</code>.
         * @see AllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationStrategy
         */
        Builder allocationStrategy(AllocationStrategy allocationStrategy);

        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch
         * template override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults
         * to <code>lowestPrice</code>.
         * </p>
         * 
         * @param onDemandAllocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each
         *        Spot Fleet launch template override, launching the highest priority first. If you do not specify a
         *        value, Spot Fleet defaults to <code>lowestPrice</code>.
         * @see OnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandAllocationStrategy
         */
        Builder onDemandAllocationStrategy(String onDemandAllocationStrategy);

        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each Spot Fleet launch
         * template override, launching the highest priority first. If you do not specify a value, Spot Fleet defaults
         * to <code>lowestPrice</code>.
         * </p>
         * 
         * @param onDemandAllocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowestPrice</code>, Spot Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, Spot Fleet uses the priority that you assign to each
         *        Spot Fleet launch template override, launching the highest priority first. If you do not specify a
         *        value, Spot Fleet defaults to <code>lowestPrice</code>.
         * @see OnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OnDemandAllocationStrategy
         */
        Builder onDemandAllocationStrategy(OnDemandAllocationStrategy onDemandAllocationStrategy);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This helps
         * to avoid duplicate listings. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of your listings. This
         *        helps to avoid duplicate listings. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet
         * request is decreased below the current size of the Spot Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet
         *        request is decreased below the current size of the Spot Fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet
         * request is decreased below the current size of the Spot Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet
         *        request is decreased below the current size of the Spot Fleet.
         * @see ExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The number of units fulfilled by this request compared to the set target capacity. You cannot set this value.
         * </p>
         * 
         * @param fulfilledCapacity
         *        The number of units fulfilled by this request compared to the set target capacity. You cannot set this
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfilledCapacity(Double fulfilledCapacity);

        /**
         * <p>
         * The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
         * </p>
         * 
         * @param onDemandFulfilledCapacity
         *        The number of On-Demand units fulfilled by this request compared to the set target On-Demand capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandFulfilledCapacity(Double onDemandFulfilledCapacity);

        /**
         * <p>
         * Grants the Spot Fleet permission to terminate Spot Instances on your behalf when you cancel its Spot Fleet
         * request using <a>CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
         * <code>terminateInstancesWithExpiration</code>.
         * </p>
         * 
         * @param iamFleetRole
         *        Grants the Spot Fleet permission to terminate Spot Instances on your behalf when you cancel its Spot
         *        Fleet request using <a>CancelSpotFleetRequests</a> or when the Spot Fleet request expires, if you set
         *        <code>terminateInstancesWithExpiration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamFleetRole(String iamFleetRole);

        /**
         * <p>
         * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you
         * can't specify <code>LaunchTemplateConfigs</code>.
         * </p>
         * 
         * @param launchSpecifications
         *        The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>
         *        , you can't specify <code>LaunchTemplateConfigs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications);

        /**
         * <p>
         * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you
         * can't specify <code>LaunchTemplateConfigs</code>.
         * </p>
         * 
         * @param launchSpecifications
         *        The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>
         *        , you can't specify <code>LaunchTemplateConfigs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecifications(SpotFleetLaunchSpecification... launchSpecifications);

        /**
         * <p>
         * The launch specifications for the Spot Fleet request. If you specify <code>LaunchSpecifications</code>, you
         * can't specify <code>LaunchTemplateConfigs</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SpotFleetLaunchSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<SpotFleetLaunchSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SpotFleetLaunchSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #launchSpecifications(List<SpotFleetLaunchSpecification>)}.
         * 
         * @param launchSpecifications
         *        a consumer that will call methods on {@link List<SpotFleetLaunchSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchSpecifications(List<SpotFleetLaunchSpecification>)
         */
        Builder launchSpecifications(Consumer<SpotFleetLaunchSpecification.Builder>... launchSpecifications);

        /**
         * <p>
         * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
         * <code>LaunchSpecifications</code>.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't
         *        specify <code>LaunchSpecifications</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
         * <code>LaunchSpecifications</code>.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't
         *        specify <code>LaunchSpecifications</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(LaunchTemplateConfig... launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides. If you specify <code>LaunchTemplateConfigs</code>, you can't specify
         * <code>LaunchSpecifications</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchTemplateConfig>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchTemplateConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #launchTemplateConfigs(List<LaunchTemplateConfig>)}.
         * 
         * @param launchTemplateConfigs
         *        a consumer that will call methods on {@link List<LaunchTemplateConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigs(List<LaunchTemplateConfig>)
         */
        Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder>... launchTemplateConfigs);

        /**
         * <p>
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. The default is the On-Demand
         * price.
         * </p>
         * 
         * @param spotPrice
         *        The maximum price per unit hour that you are willing to pay for a Spot Instance. The default is the
         *        On-Demand price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The number of units to request. You can choose to set the target capacity in terms of instances or a
         * performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If
         * the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
         * </p>
         * 
         * @param targetCapacity
         *        The number of units to request. You can choose to set the target capacity in terms of instances or a
         *        performance characteristic that is important to your application workload, such as vCPUs, memory, or
         *        I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add
         *        capacity later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacity(Integer targetCapacity);

        /**
         * <p>
         * The number of On-Demand units to request. You can choose to set the target capacity in terms of instances or
         * a performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O.
         * If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
         * </p>
         * 
         * @param onDemandTargetCapacity
         *        The number of On-Demand units to request. You can choose to set the target capacity in terms of
         *        instances or a performance characteristic that is important to your application workload, such as
         *        vCPUs, memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity
         *        of 0 and add capacity later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandTargetCapacity(Integer onDemandTargetCapacity);

        /**
         * <p>
         * Indicates whether running Spot Instances should be terminated when the Spot Fleet request expires.
         * </p>
         * 
         * @param terminateInstancesWithExpiration
         *        Indicates whether running Spot Instances should be terminated when the Spot Fleet request expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration);

        /**
         * <p>
         * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
         * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It
         * does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in
         * alternative Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet
         * maintains the target capacity. The Spot Fleet places the required requests to meet capacity and automatically
         * replenishes any interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is
         * not used by Spot Fleet.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the Spot Fleet only requests the target capacity or also
         *        attempts to maintain it. When this value is <code>request</code>, the Spot Fleet only places the
         *        required requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does
         *        it submit requests in alternative Spot pools if capacity is not available. When this value is
         *        <code>maintain</code>, the Spot Fleet maintains the target capacity. The Spot Fleet places the
         *        required requests to meet capacity and automatically replenishes any interrupted instances. Default:
         *        <code>maintain</code>. <code>instant</code> is listed but is not used by Spot Fleet.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of request. Indicates whether the Spot Fleet only requests the target capacity or also attempts to
         * maintain it. When this value is <code>request</code>, the Spot Fleet only places the required requests. It
         * does not attempt to replenish Spot Instances if capacity is diminished, nor does it submit requests in
         * alternative Spot pools if capacity is not available. When this value is <code>maintain</code>, the Spot Fleet
         * maintains the target capacity. The Spot Fleet places the required requests to meet capacity and automatically
         * replenishes any interrupted instances. Default: <code>maintain</code>. <code>instant</code> is listed but is
         * not used by Spot Fleet.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the Spot Fleet only requests the target capacity or also
         *        attempts to maintain it. When this value is <code>request</code>, the Spot Fleet only places the
         *        required requests. It does not attempt to replenish Spot Instances if capacity is diminished, nor does
         *        it submit requests in alternative Spot pools if capacity is not available. When this value is
         *        <code>maintain</code>, the Spot Fleet maintains the target capacity. The Spot Fleet places the
         *        required requests to meet capacity and automatically replenishes any interrupted instances. Default:
         *        <code>maintain</code>. <code>instant</code> is listed but is not used by Spot Fleet.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(FleetType type);

        /**
         * <p>
         * The start date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
         * request immediately.
         * </p>
         * 
         * @param validFrom
         *        The start date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling
         *        the request immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFrom(Instant validFrom);

        /**
         * <p>
         * The end date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot Instance requests
         * are placed or able to fulfill the request. If no value is specified, the Spot Fleet request remains until you
         * cancel it.
         * </p>
         * 
         * @param validUntil
         *        The end date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new Spot Instance
         *        requests are placed or able to fulfill the request. If no value is specified, the Spot Fleet request
         *        remains until you cancel it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * Indicates whether Spot Fleet should replace unhealthy instances.
         * </p>
         * 
         * @param replaceUnhealthyInstances
         *        Indicates whether Spot Fleet should replace unhealthy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(String instanceInterruptionBehavior);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior);

        /**
         * <p>
         * One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
         * registers the running Spot Instances with the specified Classic Load Balancers and target groups.
         * </p>
         * <p>
         * With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1,
         * CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
         * </p>
         * 
         * @param loadBalancersConfig
         *        One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
         *        registers the running Spot Instances with the specified Classic Load Balancers and target groups.</p>
         *        <p>
         *        With Network Load Balancers, Spot Fleet cannot register instances that have the following instance
         *        types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancersConfig(LoadBalancersConfig loadBalancersConfig);

        /**
         * <p>
         * One or more Classic Load Balancers and target groups to attach to the Spot Fleet request. Spot Fleet
         * registers the running Spot Instances with the specified Classic Load Balancers and target groups.
         * </p>
         * <p>
         * With Network Load Balancers, Spot Fleet cannot register instances that have the following instance types: C1,
         * CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadBalancersConfig.Builder} avoiding the need
         * to create one manually via {@link LoadBalancersConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancersConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #loadBalancersConfig(LoadBalancersConfig)}.
         * 
         * @param loadBalancersConfig
         *        a consumer that will call methods on {@link LoadBalancersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancersConfig(LoadBalancersConfig)
         */
        default Builder loadBalancersConfig(Consumer<LoadBalancersConfig.Builder> loadBalancersConfig) {
            return loadBalancersConfig(LoadBalancersConfig.builder().applyMutation(loadBalancersConfig).build());
        }

        /**
         * <p>
         * The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
         * <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot pools and
         * evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * </p>
         * 
         * @param instancePoolsToUseCount
         *        The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
         *        <b>AllocationStrategy</b> is set to <code>lowest-price</code>. Spot Fleet selects the cheapest Spot
         *        pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePoolsToUseCount(Integer instancePoolsToUseCount);
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private String onDemandAllocationStrategy;

        private String clientToken;

        private String excessCapacityTerminationPolicy;

        private Double fulfilledCapacity;

        private Double onDemandFulfilledCapacity;

        private String iamFleetRole;

        private List<SpotFleetLaunchSpecification> launchSpecifications = DefaultSdkAutoConstructList.getInstance();

        private List<LaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();

        private String spotPrice;

        private Integer targetCapacity;

        private Integer onDemandTargetCapacity;

        private Boolean terminateInstancesWithExpiration;

        private String type;

        private Instant validFrom;

        private Instant validUntil;

        private Boolean replaceUnhealthyInstances;

        private String instanceInterruptionBehavior;

        private LoadBalancersConfig loadBalancersConfig;

        private Integer instancePoolsToUseCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfigData model) {
            allocationStrategy(model.allocationStrategy);
            onDemandAllocationStrategy(model.onDemandAllocationStrategy);
            clientToken(model.clientToken);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            fulfilledCapacity(model.fulfilledCapacity);
            onDemandFulfilledCapacity(model.onDemandFulfilledCapacity);
            iamFleetRole(model.iamFleetRole);
            launchSpecifications(model.launchSpecifications);
            launchTemplateConfigs(model.launchTemplateConfigs);
            spotPrice(model.spotPrice);
            targetCapacity(model.targetCapacity);
            onDemandTargetCapacity(model.onDemandTargetCapacity);
            terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            type(model.type);
            validFrom(model.validFrom);
            validUntil(model.validUntil);
            replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            loadBalancersConfig(model.loadBalancersConfig);
            instancePoolsToUseCount(model.instancePoolsToUseCount);
        }

        public final String getAllocationStrategyAsString() {
            return allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getOnDemandAllocationStrategyAsString() {
            return onDemandAllocationStrategy;
        }

        @Override
        public final Builder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            return this;
        }

        @Override
        public final Builder onDemandAllocationStrategy(OnDemandAllocationStrategy onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy(onDemandAllocationStrategy.toString());
            return this;
        }

        public final void setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicyAsString() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final Double getOnDemandFulfilledCapacity() {
            return onDemandFulfilledCapacity;
        }

        @Override
        public final Builder onDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
            this.onDemandFulfilledCapacity = onDemandFulfilledCapacity;
            return this;
        }

        public final void setOnDemandFulfilledCapacity(Double onDemandFulfilledCapacity) {
            this.onDemandFulfilledCapacity = onDemandFulfilledCapacity;
        }

        public final String getIamFleetRole() {
            return iamFleetRole;
        }

        @Override
        public final Builder iamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
            return this;
        }

        public final void setIamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
        }

        public final Collection<SpotFleetLaunchSpecification.Builder> getLaunchSpecifications() {
            return launchSpecifications != null ? launchSpecifications.stream().map(SpotFleetLaunchSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copy(launchSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(SpotFleetLaunchSpecification... launchSpecifications) {
            launchSpecifications(Arrays.asList(launchSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(Consumer<SpotFleetLaunchSpecification.Builder>... launchSpecifications) {
            launchSpecifications(Stream.of(launchSpecifications)
                    .map(c -> SpotFleetLaunchSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification.BuilderImpl> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copyFromBuilder(launchSpecifications);
        }

        public final Collection<LaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            return launchTemplateConfigs != null ? launchTemplateConfigs.stream().map(LaunchTemplateConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<LaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(LaunchTemplateConfig... launchTemplateConfigs) {
            launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<LaunchTemplateConfig.Builder>... launchTemplateConfigs) {
            launchTemplateConfigs(Stream.of(launchTemplateConfigs)
                    .map(c -> LaunchTemplateConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<LaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = LaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final Integer getTargetCapacity() {
            return targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        public final Integer getOnDemandTargetCapacity() {
            return onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public final String getInstanceInterruptionBehaviorAsString() {
            return instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public final LoadBalancersConfig.Builder getLoadBalancersConfig() {
            return loadBalancersConfig != null ? loadBalancersConfig.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancersConfig(LoadBalancersConfig loadBalancersConfig) {
            this.loadBalancersConfig = loadBalancersConfig;
            return this;
        }

        public final void setLoadBalancersConfig(LoadBalancersConfig.BuilderImpl loadBalancersConfig) {
            this.loadBalancersConfig = loadBalancersConfig != null ? loadBalancersConfig.build() : null;
        }

        public final Integer getInstancePoolsToUseCount() {
            return instancePoolsToUseCount;
        }

        @Override
        public final Builder instancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        public final void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
        }

        @Override
        public SpotFleetRequestConfigData build() {
            return new SpotFleetRequestConfigData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
