/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpnConnectionRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVpnConnectionRequest.Builder, ModifyVpnConnectionRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpnConnectionRequest::vpnConnectionId))
            .setter(setter(Builder::vpnConnectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId")
                    .unmarshallLocationName("VpnConnectionId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpnConnectionRequest::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("TransitGatewayId").build()).build();

    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyVpnConnectionRequest::vpnGatewayId))
            .setter(setter(Builder::vpnGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId")
                    .unmarshallLocationName("VpnGatewayId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD,
            TRANSIT_GATEWAY_ID_FIELD, VPN_GATEWAY_ID_FIELD));

    private final String vpnConnectionId;

    private final String transitGatewayId;

    private final String vpnGatewayId;

    private ModifyVpnConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.transitGatewayId = builder.transitGatewayId;
        this.vpnGatewayId = builder.vpnGatewayId;
    }

    /**
     * Returns the value of the VpnConnectionId property for this object.
     * 
     * @return The value of the VpnConnectionId property for this object.
     */
    public String vpnConnectionId() {
        return vpnConnectionId;
    }

    /**
     * Returns the value of the TransitGatewayId property for this object.
     * 
     * @return The value of the TransitGatewayId property for this object.
     */
    public String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * Returns the value of the VpnGatewayId property for this object.
     * 
     * @return The value of the VpnGatewayId property for this object.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnConnectionRequest)) {
            return false;
        }
        ModifyVpnConnectionRequest other = (ModifyVpnConnectionRequest) obj;
        return Objects.equals(vpnConnectionId(), other.vpnConnectionId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(vpnGatewayId(), other.vpnGatewayId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyVpnConnectionRequest").add("VpnConnectionId", vpnConnectionId())
                .add("TransitGatewayId", transitGatewayId()).add("VpnGatewayId", vpnGatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnConnectionId":
            return Optional.ofNullable(clazz.cast(vpnConnectionId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "VpnGatewayId":
            return Optional.ofNullable(clazz.cast(vpnGatewayId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnConnectionRequest, T> g) {
        return obj -> g.apply((ModifyVpnConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVpnConnectionRequest> {
        /**
         * Sets the value of the VpnConnectionId property for this object.
         *
         * @param vpnConnectionId
         *        The new value for the VpnConnectionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        /**
         * Sets the value of the TransitGatewayId property for this object.
         *
         * @param transitGatewayId
         *        The new value for the TransitGatewayId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * Sets the value of the VpnGatewayId property for this object.
         *
         * @param vpnGatewayId
         *        The new value for the VpnGatewayId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String vpnConnectionId;

        private String transitGatewayId;

        private String vpnGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnConnectionRequest model) {
            super(model);
            vpnConnectionId(model.vpnConnectionId);
            transitGatewayId(model.transitGatewayId);
            vpnGatewayId(model.vpnGatewayId);
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpnConnectionRequest build() {
            return new ModifyVpnConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
