/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcEndpointConnectionNotificationResponse extends Ec2Response
        implements
        ToCopyableBuilder<CreateVpcEndpointConnectionNotificationResponse.Builder, CreateVpcEndpointConnectionNotificationResponse> {
    private static final SdkField<ConnectionNotification> CONNECTION_NOTIFICATION_FIELD = SdkField
            .<ConnectionNotification> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVpcEndpointConnectionNotificationResponse::connectionNotification))
            .setter(setter(Builder::connectionNotification))
            .constructor(ConnectionNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotification")
                    .unmarshallLocationName("connectionNotification").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpcEndpointConnectionNotificationResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NOTIFICATION_FIELD,
            CLIENT_TOKEN_FIELD));

    private final ConnectionNotification connectionNotification;

    private final String clientToken;

    private CreateVpcEndpointConnectionNotificationResponse(BuilderImpl builder) {
        super(builder);
        this.connectionNotification = builder.connectionNotification;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the notification.
     * </p>
     * 
     * @return Information about the notification.
     */
    public ConnectionNotification connectionNotification() {
        return connectionNotification;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotification());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointConnectionNotificationResponse)) {
            return false;
        }
        CreateVpcEndpointConnectionNotificationResponse other = (CreateVpcEndpointConnectionNotificationResponse) obj;
        return Objects.equals(connectionNotification(), other.connectionNotification())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVpcEndpointConnectionNotificationResponse")
                .add("ConnectionNotification", connectionNotification()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionNotification":
            return Optional.ofNullable(clazz.cast(connectionNotification()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcEndpointConnectionNotificationResponse, T> g) {
        return obj -> g.apply((CreateVpcEndpointConnectionNotificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateVpcEndpointConnectionNotificationResponse> {
        /**
         * <p>
         * Information about the notification.
         * </p>
         * 
         * @param connectionNotification
         *        Information about the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotification(ConnectionNotification connectionNotification);

        /**
         * <p>
         * Information about the notification.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionNotification.Builder} avoiding the
         * need to create one manually via {@link ConnectionNotification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionNotification.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionNotification(ConnectionNotification)}.
         * 
         * @param connectionNotification
         *        a consumer that will call methods on {@link ConnectionNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionNotification(ConnectionNotification)
         */
        default Builder connectionNotification(Consumer<ConnectionNotification.Builder> connectionNotification) {
            return connectionNotification(ConnectionNotification.builder().applyMutation(connectionNotification).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ConnectionNotification connectionNotification;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointConnectionNotificationResponse model) {
            super(model);
            connectionNotification(model.connectionNotification);
            clientToken(model.clientToken);
        }

        public final ConnectionNotification.Builder getConnectionNotification() {
            return connectionNotification != null ? connectionNotification.toBuilder() : null;
        }

        @Override
        public final Builder connectionNotification(ConnectionNotification connectionNotification) {
            this.connectionNotification = connectionNotification;
            return this;
        }

        public final void setConnectionNotification(ConnectionNotification.BuilderImpl connectionNotification) {
            this.connectionNotification = connectionNotification != null ? connectionNotification.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateVpcEndpointConnectionNotificationResponse build() {
            return new CreateVpcEndpointConnectionNotificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
