/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeFleetInstancesResponse.Builder, DescribeFleetInstancesResponse> {
    private static final SdkField<List<ActiveInstance>> ACTIVE_INSTANCES_FIELD = SdkField
            .<List<ActiveInstance>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFleetInstancesResponse::activeInstances))
            .setter(setter(Builder::activeInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveInstanceSet")
                    .unmarshallLocationName("activeInstanceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ActiveInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFleetInstancesResponse::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("fleetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD, FLEET_ID_FIELD));

    private final List<ActiveInstance> activeInstances;

    private final String nextToken;

    private final String fleetId;

    private DescribeFleetInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.activeInstances = builder.activeInstances;
        this.nextToken = builder.nextToken;
        this.fleetId = builder.fleetId;
    }

    /**
     * <p>
     * The running instances. This list is refreshed periodically and might be out of date.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The running instances. This list is refreshed periodically and might be out of date.
     */
    public List<ActiveInstance> activeInstances() {
        return activeInstances;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the EC2 Fleet.
     * </p>
     * 
     * @return The ID of the EC2 Fleet.
     */
    public String fleetId() {
        return fleetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeInstances());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetInstancesResponse)) {
            return false;
        }
        DescribeFleetInstancesResponse other = (DescribeFleetInstancesResponse) obj;
        return Objects.equals(activeInstances(), other.activeInstances()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(fleetId(), other.fleetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFleetInstancesResponse").add("ActiveInstances", activeInstances())
                .add("NextToken", nextToken()).add("FleetId", fleetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveInstances":
            return Optional.ofNullable(clazz.cast(activeInstances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetInstancesResponse, T> g) {
        return obj -> g.apply((DescribeFleetInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFleetInstancesResponse> {
        /**
         * <p>
         * The running instances. This list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. This list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(Collection<ActiveInstance> activeInstances);

        /**
         * <p>
         * The running instances. This list is refreshed periodically and might be out of date.
         * </p>
         * 
         * @param activeInstances
         *        The running instances. This list is refreshed periodically and might be out of date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeInstances(ActiveInstance... activeInstances);

        /**
         * <p>
         * The running instances. This list is refreshed periodically and might be out of date.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActiveInstance>.Builder} avoiding the need
         * to create one manually via {@link List<ActiveInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActiveInstance>.Builder#build()} is called immediately and
         * its result is passed to {@link #activeInstances(List<ActiveInstance>)}.
         * 
         * @param activeInstances
         *        a consumer that will call methods on {@link List<ActiveInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeInstances(List<ActiveInstance>)
         */
        Builder activeInstances(Consumer<ActiveInstance.Builder>... activeInstances);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the EC2 Fleet.
         * </p>
         * 
         * @param fleetId
         *        The ID of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ActiveInstance> activeInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String fleetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetInstancesResponse model) {
            super(model);
            activeInstances(model.activeInstances);
            nextToken(model.nextToken);
            fleetId(model.fleetId);
        }

        public final Collection<ActiveInstance.Builder> getActiveInstances() {
            return activeInstances != null ? activeInstances.stream().map(ActiveInstance::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder activeInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(ActiveInstance... activeInstances) {
            activeInstances(Arrays.asList(activeInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(Consumer<ActiveInstance.Builder>... activeInstances) {
            activeInstances(Stream.of(activeInstances).map(c -> ActiveInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActiveInstances(Collection<ActiveInstance.BuilderImpl> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copyFromBuilder(activeInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public DescribeFleetInstancesResponse build() {
            return new DescribeFleetInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
